/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.prioritization;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldSelector;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.RulesUtils;
import com.tandbergtv.cms.rules.ui.client.UiActionService;
import com.tandbergtv.cms.rules.ui.client.UiActionServiceAsync;
import com.tandbergtv.cms.rules.ui.client.common.Permissions;
import com.tandbergtv.cms.rules.ui.client.common.RuleNamePanel;
import com.tandbergtv.cms.rules.ui.client.common.RulePanel;
import com.tandbergtv.cms.rules.ui.client.common.TabItem;
import com.tandbergtv.cms.rules.ui.client.common.TabbedWizard;
import com.tandbergtv.cms.rules.ui.client.common.TitleFilterPanel;
import com.tandbergtv.cms.rules.ui.client.common.site.SiteSelectionPanel;
import com.tandbergtv.cms.rules.ui.client.common.site.UiRuleSetsAssocWJobExpception;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.cms.rules.ui.client.prioritization.PrioritizationRulePanel;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.ErrorMessageBuilder;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.RuleServiceException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IMessageListener;
import java.util.List;

public class PrioritizationRuleSetPanel
extends RulePanel {
    private TabbedWizard tabbedWizard;
    private RuleNamePanel ruleNamePanel;
    private TitleFilterPanel panelTitleFilter;
    private PrioritizationRulePanel prioritizationPanel;
    private BusyIndicator busyIndicator = new BusyIndicator();
    private SiteSelectionPanel siteSelectionPanel;

    @Override
    protected void createPanel() {
        this.busyIndicator.center();
        if (!PrioritizationRulePanel.cachedLoaded()) {
            this.getAvailableActions();
        } else {
            this.populateUi();
        }
    }

    private void populateUi() {
        this.setStyleName("rule-panel");
        this.resetMessagePanel();
        this.setHeaderLabel();
        this.ruleNamePanel = new RuleNamePanel(this.ruleSet.getName(), this.ruleSet.isEnabled());
        this.panelTitleFilter = new TitleFilterPanel(this.ruleSet);
        this.prioritizationPanel = new PrioritizationRulePanel(this.ruleSet.getRules());
        TabItem titleFilterTabItem = new TabItem(this.myConstants.wizFilterInstruct(), (Widget)this.panelTitleFilter);
        TabItem prioritizationRuleTabItem = new TabItem(this.myConstants.priorRuleInstruct(), (Widget)this.prioritizationPanel);
        TabItem ruleNameTabItem = new TabItem(this.myConstants.ruleNameInstructions(), (Widget)this.ruleNamePanel);
        if (RulesUtils.isFeatureAvailable("Sites")) {
            this.siteSelectionPanel = this.ruleSet.isNew() && this.ruleSet.getSites().isEmpty() ? new SiteSelectionPanel() : new SiteSelectionPanel(this.ruleSet.getSites(), this.ruleSet.isRunOnGlobal());
            TabItem siteSelectionTabItem = new TabItem(this.myConstants.siteSelectInstructions(), (Widget)this.siteSelectionPanel);
            this.tabbedWizard = new TabbedWizard((Widget)siteSelectionTabItem, this.myConstants.sitesLabel(), "");
            this.tabbedWizard.addTab((Widget)titleFilterTabItem, this.myConstants.wizardTitleFilter());
        } else {
            this.tabbedWizard = new TabbedWizard((Widget)titleFilterTabItem, this.myConstants.wizardTitleFilter(), "");
        }
        this.tabbedWizard.addTab((Widget)prioritizationRuleTabItem, this.myConstants.wizardPrioritization());
        this.tabbedWizard.addTab((Widget)ruleNameTabItem, this.myConstants.wizardRuleName());
        this.tabbedWizard.addHeightOffsettingWidget((Widget)this.headerPanel);
        this.add((Widget)this.tabbedWizard);
        ButtonWidget cancelButton = this.createCancelButton();
        cancelButton.addClickHandler(this.getDefaultCancelHandler());
        cancelButton.setVisible(false);
        NeptuneSecurity security = RulesComponent.getInstance().getSecurity();
        if (security.isUserInRole(Permissions.MODIFY) || this.ruleSet.isNew() && security.isUserInRole(Permissions.CREATE)) {
            ButtonWidget saveButton = this.createSaveButton();
            saveButton.addClickHandler(this.getSaveHandler());
            saveButton.setVisible(false);
            this.tabbedWizard.addCommonBottomWidget((Widget)saveButton);
            ButtonWidget copyButton = this.createCopyButton();
            copyButton.addClickHandler(this.getCopyHandler());
            copyButton.setVisible(false);
            this.tabbedWizard.addCommonBottomWidget((Widget)copyButton);
            if (this.ruleSet.isNew()) {
                copyButton.setEnabled(false);
            }
        }
        this.tabbedWizard.addCommonBottomWidget((Widget)cancelButton);
        this.tabbedWizard.show(this.ruleSet.isNew(), this.isCopy());
        this.registerMessageListener((IMessageListener)this.tabbedWizard);
        FieldSelector.getTree((CriteriaType)CriteriaType.SEARCH_CONDITION_LHS, (UiCriteriaMode)UiCriteriaMode.EPISODE);
        this.busyIndicator.hide();
    }

    private ClickHandler getSaveHandler() {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!PrioritizationRuleSetPanel.this.tabbedWizard.validateAllItems()) {
                    return;
                }
                final ButtonWidget button = (ButtonWidget)event.getSource();
                UIRuleSet ruleset = new UIRuleSet();
                ruleset.setId(PrioritizationRuleSetPanel.this.ruleSet.getId());
                ruleset.setEnabled(PrioritizationRuleSetPanel.this.ruleNamePanel.isEnabled());
                ruleset.setName(PrioritizationRuleSetPanel.this.ruleNamePanel.getRuleName());
                if (PrioritizationRuleSetPanel.this.siteSelectionPanel != null) {
                    ruleset.setRunOnGlobal(PrioritizationRuleSetPanel.this.siteSelectionPanel.isRunOnGlobal());
                    ruleset.setSites(PrioritizationRuleSetPanel.this.siteSelectionPanel.getSites());
                }
                ruleset.setPackageId(Packages.PRIORITIZATION);
                ruleset.setRules(PrioritizationRuleSetPanel.this.prioritizationPanel.getRules());
                ruleset.setTitleFilter(PrioritizationRuleSetPanel.this.panelTitleFilter.getTitleFilter());
                button.setEnabled(false);
                PrioritizationRuleSetPanel.this.rulesService.saveRuleSet(ruleset, (AsyncCallback<Integer>)new NeptuneAsyncCallback<Integer>(){

                    public void onNeptuneFailure(Throwable caught) {
                        button.setEnabled(true);
                        if (caught instanceof RuleServiceException) {
                            List<String> messages = ErrorMessageBuilder.getErrorMessages((RuleServiceException)((Object)caught));
                            PrioritizationRuleSetPanel.this.showErrorMessages(messages);
                        } else if (caught instanceof UiRuleSetsAssocWJobExpception) {
                            PrioritizationRuleSetPanel.this.handleSiteJobAssoc((UiRuleSetsAssocWJobExpception)((Object)caught));
                        } else {
                            Window.alert((String)(caught == null ? "" : caught.getMessage()));
                        }
                    }

                    public void onNeptuneSuccess(Integer result) {
                        PrioritizationRuleSetPanel.this.resetMessagePanel();
                        button.setEnabled(true);
                        RulesComponent.getInstance().setRuleListingAnchor(PrioritizationRuleSetPanel.this.ruleSet.getPackageId());
                    }
                });
            }
        };
    }

    private ClickHandler getCopyHandler() {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                PrioritizationRuleSetPanel.this.setCopy(true);
                if (!PrioritizationRuleSetPanel.this.tabbedWizard.validateAllItems()) {
                    return;
                }
                ButtonWidget button = (ButtonWidget)event.getSource();
                UIRuleSet copyRuleSet = new UIRuleSet();
                copyRuleSet.setId(-1);
                String oldName = PrioritizationRuleSetPanel.this.ruleNamePanel.getRuleName();
                copyRuleSet.setName(PrioritizationRuleSetPanel.this.updateRuleCopyName(oldName));
                copyRuleSet.setEnabled(PrioritizationRuleSetPanel.this.ruleNamePanel.isEnabled());
                if (PrioritizationRuleSetPanel.this.siteSelectionPanel != null) {
                    copyRuleSet.setRunOnGlobal(PrioritizationRuleSetPanel.this.siteSelectionPanel.isRunOnGlobal());
                    copyRuleSet.setSites(PrioritizationRuleSetPanel.this.copyCurrentUISites(PrioritizationRuleSetPanel.this.ruleSet, PrioritizationRuleSetPanel.this.siteSelectionPanel.getSites()));
                }
                copyRuleSet.setPackageId(PrioritizationRuleSetPanel.this.ruleSet.getPackageId());
                copyRuleSet.setRules(PrioritizationRuleSetPanel.this.prioritizationPanel.getRules());
                copyRuleSet.setTitleFilter(PrioritizationRuleSetPanel.this.panelTitleFilter.getTitleFilter());
                button.setEnabled(false);
                RulesComponent.getInstance().setNewRuleAnchor(copyRuleSet.getPackageId(), false);
                PrioritizationRuleSetPanel.this.loadedFlagReset();
                PrioritizationRuleSetPanel.this.setRule(copyRuleSet);
            }
        };
    }

    private void setHeaderLabel() {
        String newRule = this.myConstants.newPrioritizationRule();
        String oldRule = String.valueOf(this.myConstants.prioritizationRuleDetails()) + " " + this.ruleSet.getName();
        String headerString = this.ruleSet.getName().equals("") ? newRule : oldRule;
        this.setHeaderLabel(headerString);
    }

    private void notifyDoneWithAsync() {
        if (PrioritizationRulePanel.cachedLoaded()) {
            this.populateUi();
        }
    }

    private void getAvailableActions() {
        UiActionServiceAsync actionService = (UiActionServiceAsync)GWT.create(UiActionService.class);
        actionService.getActions(Packages.PRIORITIZATION, (AsyncCallback<List<UIAction>>)new NeptuneAsyncCallback<List<UIAction>>(){

            public void onNeptuneFailure(Throwable caught) {
                PrioritizationRuleSetPanel.this.busyIndicator.hide();
                Window.alert((String)(caught == null ? "" : caught.getMessage()));
            }

            public void onNeptuneSuccess(List<UIAction> result) {
                if (result != null && result.size() == 1) {
                    PrioritizationRulePanel.setCachedBlankAction(result.get(0));
                    PrioritizationRuleSetPanel.this.notifyDoneWithAsync();
                } else {
                    Window.alert((String)"ERROR: There should only be one action available for Prioritization.");
                    PrioritizationRuleSetPanel.this.busyIndicator.hide();
                }
            }
        });
    }

    protected void onUnload() {
        super.onUnload();
        this.busyIndicator.hide();
    }
}

