/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling;

import com.google.gwt.core.client.GWT;
import com.tandbergtv.cms.rules.ui.client.common.UiInvalidScheduleException;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.RuleServiceErrorMessages;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.RuleServiceException;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.UIRuleServiceErrorMessage;
import java.util.ArrayList;
import java.util.List;

public class ErrorMessageBuilder {
    private static RuleServiceErrorMessages messages = (RuleServiceErrorMessages)GWT.create(RuleServiceErrorMessages.class);

    public static List<String> getErrorMessages(UiInvalidScheduleException e) {
        ArrayList<String> result = new ArrayList<String>();
        for (String reasonCode : e.getReasons().keySet()) {
            if ("errInvalidSchedule".equals(reasonCode)) {
                result.add(messages.errInvalidSchedule());
                continue;
            }
            result.add(messages.defaultErrorMessage());
        }
        return result;
    }

    public static List<String> getErrorMessages(RuleServiceException e) {
        ArrayList<String> result = new ArrayList<String>();
        for (UIRuleServiceErrorMessage reason : e.getReason()) {
            result.add(ErrorMessageBuilder.getInternationalizedString(reason));
        }
        return result;
    }

    private static String getInternationalizedString(UIRuleServiceErrorMessage reason) {
        List<String> parameters = reason.getParameters();
        String errorCode = reason.getErrorCode();
        if (parameters == null) {
            return messages.defaultErrorMessage();
        }
        if (errorCode.equals("errJobIsSecheduledNeedSchedulable") && parameters.size() == 1) {
            return messages.errJobIsSecheduledNeedSchedulable(parameters.get(0));
        }
        if (errorCode.equals("errJobIsSecheduledCantDelete") && parameters.size() == 2) {
            return messages.errJobIsSecheduledCantDelete(parameters.get(0), parameters.get(1));
        }
        if (errorCode.equals("errScheduleDeleteNotPermitted") && parameters.size() == 1) {
            return messages.errScheduleDeleteNotPermitted(parameters.get(0));
        }
        if (errorCode.equals("errScheduleModifyNotAuthorized") && parameters.size() == 1) {
            return messages.errScheduleModifyNotAuthorized(parameters.get(0));
        }
        if (errorCode.equals("errSiteModifyNotAuthorized") && parameters.size() == 1) {
            return messages.errSiteModifyNotAuthorized(parameters.get(0));
        }
        return messages.defaultErrorMessage();
    }
}

