/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.targeting;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldSelector;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.RulesUtils;
import com.tandbergtv.cms.rules.ui.client.common.Permissions;
import com.tandbergtv.cms.rules.ui.client.common.RuleNamePanel;
import com.tandbergtv.cms.rules.ui.client.common.RulePanel;
import com.tandbergtv.cms.rules.ui.client.common.TabItem;
import com.tandbergtv.cms.rules.ui.client.common.TabbedWizard;
import com.tandbergtv.cms.rules.ui.client.common.TitleFilterPanel;
import com.tandbergtv.cms.rules.ui.client.common.site.SiteSelector;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.ErrorMessageBuilder;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.RuleServiceException;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.RuleTargetingDoesntHaveAllDependencySites;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IMessageListener;
import java.util.List;

public class TargetingRuleSetPanel
extends RulePanel {
    private TabbedWizard tabbedWizard;
    private RuleNamePanel ruleNamePanel;
    private TitleFilterPanel panelTitleFilter;
    private RulesConstants myConstants = (RulesConstants)GWT.create(RulesConstants.class);
    private BusyIndicator busyIndicator = new BusyIndicator();
    private SiteSelector siteSelector;
    private Boolean skipCheck;

    protected void onUnload() {
        super.onUnload();
        this.busyIndicator.hide();
    }

    @Override
    public void createPanel() {
        this.busyIndicator.center();
        this.populateUi();
    }

    private void populateUi() {
        this.setStyleName("rule-panel");
        this.resetMessagePanel();
        this.setHeaderLabel();
        this.ruleNamePanel = new RuleNamePanel(this.ruleSet.getName(), this.ruleSet.isEnabled());
        this.panelTitleFilter = new TitleFilterPanel(this.ruleSet);
        TabItem titleFilterTabItem = new TabItem(this.myConstants.wizFilterInstruct(), (Widget)this.panelTitleFilter);
        TabItem ruleNameTabItem = new TabItem(this.myConstants.ruleNameInstructions(), (Widget)this.ruleNamePanel);
        this.tabbedWizard = new TabbedWizard((Widget)titleFilterTabItem, this.myConstants.wizardTitleFilter(), "");
        if (RulesUtils.isFeatureAvailable("Sites")) {
            this.siteSelector = this.ruleSet.isNew() && this.ruleSet.getSites().isEmpty() ? new SiteSelector() : new SiteSelector(this.ruleSet.getSites());
            TabItem siteSelectorTabItem = new TabItem(this.myConstants.targetSiteSelectInstructions(), (Widget)this.siteSelector);
            this.tabbedWizard.addTab((Widget)siteSelectorTabItem, this.myConstants.sitesLabel());
        }
        this.tabbedWizard.addTab((Widget)ruleNameTabItem, this.myConstants.wizardRuleName());
        this.tabbedWizard.addHeightOffsettingWidget((Widget)this.headerPanel);
        this.add((Widget)this.tabbedWizard);
        ButtonWidget cancelButton = this.createCancelButton();
        cancelButton.addClickHandler(this.getDefaultCancelHandler());
        cancelButton.setVisible(false);
        NeptuneSecurity security = RulesComponent.getInstance().getSecurity();
        if (security.isUserInRole(Permissions.MODIFY) || this.ruleSet.isNew() && security.isUserInRole(Permissions.CREATE)) {
            ButtonWidget saveButton = this.createSaveButton();
            saveButton.addClickHandler(this.getSaveHandler());
            saveButton.setVisible(false);
            this.tabbedWizard.addCommonBottomWidget((Widget)saveButton);
            ButtonWidget copyButton = this.createCopyButton();
            copyButton.addClickHandler(this.getCopyHandler());
            copyButton.setVisible(false);
            this.tabbedWizard.addCommonBottomWidget((Widget)copyButton);
            if (this.ruleSet.isNew()) {
                copyButton.setEnabled(false);
            }
        }
        this.tabbedWizard.addCommonBottomWidget((Widget)cancelButton);
        this.tabbedWizard.show(this.ruleSet.isNew(), this.isCopy());
        this.registerMessageListener((IMessageListener)this.tabbedWizard);
        FieldSelector.getTree((CriteriaType)CriteriaType.SEARCH_CONDITION_LHS, (UiCriteriaMode)UiCriteriaMode.EPISODE);
        this.busyIndicator.hide();
    }

    private ClickHandler getSaveHandler() {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!TargetingRuleSetPanel.this.tabbedWizard.validateAllItems()) {
                    return;
                }
                ButtonWidget button = (ButtonWidget)event.getSource();
                button.setEnabled(false);
                UIRuleSet ruleset = TargetingRuleSetPanel.this.buildRuleSet();
                TargetingRuleSetPanel.this.setSkipCheck(false);
                TargetingRuleSetPanel.this.ruleSaveExecute(button, ruleset, TargetingRuleSetPanel.this.getSkipCheck());
            }
        };
    }

    private void ruleSaveExecute(final ButtonWidget button, final UIRuleSet ruleset, boolean skipCheck) {
        this.busyIndicator.center();
        this.rulesService.saveRuleSet(ruleset, skipCheck, (AsyncCallback<Integer>)new NeptuneAsyncCallback<Integer>(){

            public void onNeptuneFailure(Throwable caught) {
                TargetingRuleSetPanel.this.busyIndicator.hide();
                button.setEnabled(true);
                if (caught instanceof RuleServiceException) {
                    List<String> messages = ErrorMessageBuilder.getErrorMessages((RuleServiceException)((Object)caught));
                    TargetingRuleSetPanel.this.showErrorMessages(messages);
                } else if (caught instanceof RuleTargetingDoesntHaveAllDependencySites) {
                    if (Window.confirm((String)TargetingRuleSetPanel.this.myConstants.warningNotAllDependentSitesAreSelected())) {
                        TargetingRuleSetPanel.this.setSkipCheck(true);
                        TargetingRuleSetPanel.this.ruleSaveExecute(button, ruleset, TargetingRuleSetPanel.this.getSkipCheck());
                    }
                } else {
                    Window.alert((String)(caught == null ? "" : caught.getMessage()));
                }
            }

            public void onNeptuneSuccess(Integer result) {
                TargetingRuleSetPanel.this.busyIndicator.hide();
                TargetingRuleSetPanel.this.resetMessagePanel();
                button.setEnabled(true);
                RulesComponent.getInstance().setRuleListingAnchor(TargetingRuleSetPanel.this.ruleSet.getPackageId());
            }
        });
    }

    private ClickHandler getCopyHandler() {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                TargetingRuleSetPanel.this.setCopy(true);
                if (!TargetingRuleSetPanel.this.tabbedWizard.validateAllItems()) {
                    return;
                }
                ButtonWidget button = (ButtonWidget)event.getSource();
                UIRuleSet copyRuleSet = new UIRuleSet();
                copyRuleSet.setId(-1);
                String oldName = TargetingRuleSetPanel.this.ruleNamePanel.getRuleName();
                copyRuleSet.setName(TargetingRuleSetPanel.this.updateRuleCopyName(oldName));
                copyRuleSet.setEnabled(TargetingRuleSetPanel.this.ruleNamePanel.isEnabled());
                if (TargetingRuleSetPanel.this.siteSelector != null) {
                    copyRuleSet.setSites(TargetingRuleSetPanel.this.copyCurrentUISites(TargetingRuleSetPanel.this.ruleSet, TargetingRuleSetPanel.this.siteSelector.getSelectedSites()));
                }
                copyRuleSet.setPackageId(TargetingRuleSetPanel.this.ruleSet.getPackageId());
                copyRuleSet.setTitleFilter(TargetingRuleSetPanel.this.panelTitleFilter.getTitleFilter());
                button.setEnabled(false);
                RulesComponent.getInstance().setNewRuleAnchor(copyRuleSet.getPackageId(), false);
                TargetingRuleSetPanel.this.loadedFlagReset();
                TargetingRuleSetPanel.this.setRule(copyRuleSet);
            }
        };
    }

    private UIRuleSet buildRuleSet() {
        UIRuleSet ruleset = new UIRuleSet();
        ruleset.setId(this.ruleSet.getId());
        ruleset.setEnabled(this.ruleNamePanel.isEnabled());
        ruleset.setName(this.ruleNamePanel.getRuleName());
        if (this.siteSelector != null) {
            ruleset.setSites(this.siteSelector.getSelectedSites());
        }
        ruleset.setPackageId(Packages.TARGETING);
        ruleset.setTitleFilter(this.panelTitleFilter.getTitleFilter());
        return ruleset;
    }

    private void setHeaderLabel() {
        String newRule = this.myConstants.newTargetingRule();
        String ruleName = String.valueOf(this.myConstants.targetingRuleDetails()) + " " + this.ruleSet.getName();
        String headerString = this.ruleSet.getName().isEmpty() ? newRule : ruleName;
        this.setHeaderLabel(headerString);
    }

    public Boolean getSkipCheck() {
        return this.skipCheck;
    }

    public void setSkipCheck(Boolean skipCheck) {
        this.skipCheck = skipCheck;
    }
}

