/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.validation;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.UiRulesService;
import com.tandbergtv.cms.rules.ui.client.UiRulesServiceAsync;
import com.tandbergtv.cms.rules.ui.client.common.IRuleForm;
import com.tandbergtv.cms.rules.ui.client.common.customrules.CustomRuleBox;
import com.tandbergtv.cms.rules.ui.client.common.events.RuleDeleteEvent;
import com.tandbergtv.cms.rules.ui.client.common.events.RuleDeleteHandler;
import com.tandbergtv.cms.rules.ui.client.data.ActionParams;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import com.tandbergtv.cms.rules.ui.client.data.UIActionParam;
import com.tandbergtv.cms.rules.ui.client.data.UiRule;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiCustomRule;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiCustomRuleParameter;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiCustomRuleTree;
import com.tandbergtv.cms.rules.ui.client.validation.ValidationRule;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.List;

public class CustomValidationRule
extends SimplePanel
implements IRuleForm {
    private static final String MESSAGE_STYLE = "big-txt-box";
    private static final String SMALL_TEXT = "small-txt";
    private static final String RULES_DELETE_BUTTON_STYLE = "rules-delete-button-style";
    private VerticalPanel mainPanel = new VerticalPanel();
    private RulesConstants myConstants = (RulesConstants)GWT.create(RulesConstants.class);
    private VerticalContainer warningMessages = new VerticalContainer();
    private TextBoxWidget actionText = new TextBoxWidget();
    private UiCustomRule rule;
    private static UiRulesServiceAsync rulesService = (UiRulesServiceAsync)GWT.create(UiRulesService.class);
    private static UiCustomRuleTree customValidationRules;
    private ListBoxWidget<UIAction> actionsList;
    private CustomRuleBox ruleBox;

    public CustomValidationRule() {
        this(null);
    }

    public CustomValidationRule(UiCustomRule rule) {
        this.rule = rule;
        if (customValidationRules == null) {
            this.loadCustomValidationRules();
        } else {
            this.putTheUiTogether();
        }
    }

    public void loadCustomValidationRules() {
        try {
            rulesService.getCustomRules(Packages.VALIDATION.toString(), (AsyncCallback<UiCustomRuleTree>)new NeptuneAsyncCallback<UiCustomRuleTree>(){

                public void onNeptuneFailure(Throwable caught) {
                    RulesComponent.getInstance().getCurrentTab().setPanelInError("Error loading custom rules");
                }

                public void onNeptuneSuccess(UiCustomRuleTree result) {
                    customValidationRules = result;
                    CustomValidationRule.this.putTheUiTogether();
                }
            });
        }
        catch (NeptuneException neptuneException) {
            RulesComponent.getInstance().getCurrentTab().setPanelInError("Error loading custom rules");
        }
    }

    private void putTheUiTogether() {
        this.setWidget((Widget)this.mainPanel);
        this.initializeActionDropDown();
        this.mainPanel.add((Widget)this.warningMessages);
        this.mainPanel.add((Widget)new LabelWidget(this.myConstants.validationActionLabel()));
        if (this.rule == null) {
            this.ruleBox = new CustomRuleBox(customValidationRules);
        } else {
            this.ruleBox = new CustomRuleBox(customValidationRules, this.rule);
            this.setActionSelected();
        }
        this.mainPanel.add((Widget)this.ruleBox);
        HorizontalContainer messageRow = new HorizontalContainer();
        messageRow.addStyleName(RULES_DELETE_BUTTON_STYLE);
        messageRow.add((Widget)new LabelWidget(String.valueOf(this.myConstants.returnThis()) + " "));
        messageRow.add(this.actionsList);
        this.actionsList.addStyleName(SMALL_TEXT);
        Label message = new Label(String.valueOf(this.myConstants.message()) + " ");
        message.setStyleName("message-label");
        messageRow.add((Widget)message);
        messageRow.add((Widget)this.actionText);
        this.actionText.addStyleName(MESSAGE_STYLE);
        this.actionText.addStyleName(SMALL_TEXT);
        ButtonWidget delButton = this.deleteButton();
        delButton.addStyleName(RULES_DELETE_BUTTON_STYLE);
        this.mainPanel.add((Widget)messageRow);
        this.mainPanel.add((Widget)delButton);
        this.mainPanel.setStyleName("criteria-panel-container");
        this.setStyleName("criteria-panel");
    }

    private void setActionSelected() {
        if (this.rule.getActions().size() == 1) {
            UIAction action = this.rule.getActions().get(0);
            UIActionParam param = action.getParam(ActionParams.MESSAGE);
            this.actionText.setText(param.getValue());
            this.actionsList.setSelectedItem((Object)action);
        } else {
            String msg = "Unexpected error: validation can only have 1 action.";
            RulesComponent.getInstance().getCurrentTab().setPanelInError(msg);
        }
    }

    private void initializeActionDropDown() {
        this.actionsList = new ListBoxWidget();
        for (UIAction action : ValidationRule.getCachedActions()) {
            String label = this.myConstants.getString(action.getLabelKey());
            this.actionsList.addItem(label, (Object)action);
        }
    }

    private ButtonWidget deleteButton() {
        ButtonWidget button = new ButtonWidget(this.myConstants.delete(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                CustomValidationRule.this.fireEvent(new RuleDeleteEvent(CustomValidationRule.this));
            }
        });
        button.removeStyleName("gwt-Button");
        button.addStyleName("ebBtn");
        button.addStyleName("delete_button_icon");
        return button;
    }

    @Override
    public HandlerRegistration addDeleteHandler(RuleDeleteHandler handler) {
        return this.addHandler(handler, RuleDeleteEvent.TYPE);
    }

    @Override
    public UiRule getRule() {
        UIAction action = ((UIAction)this.actionsList.getSelectedItem()).clone();
        if (action.containsParam(ActionParams.MESSAGE)) {
            UIActionParam param = action.getParam(ActionParams.MESSAGE);
            param.setValue(this.actionText.getText());
        }
        ArrayList<UIAction> actions = new ArrayList<UIAction>();
        actions.add(action);
        String className = this.ruleBox.getClassName();
        List<UiCustomRuleParameter> params = this.ruleBox.getParameters();
        if (this.rule != null) {
            this.rule.setClassName(className);
            this.rule.setParameters(params);
            this.rule.setActions(actions);
            return this.rule;
        }
        return new UiCustomRule(actions, className, params);
    }

    @Override
    public boolean validate() {
        boolean result = this.ruleBox.validate();
        if (this.actionText.getText().isEmpty()) {
            this.actionText.addStyleName("pinkbox");
            this.actionText.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    if (CustomValidationRule.this.actionText.getText().equals("")) {
                        CustomValidationRule.this.actionText.addStyleName("pinkbox");
                    } else {
                        CustomValidationRule.this.actionText.removeStyleName("pinkbox");
                    }
                }
            });
            result = false;
        }
        return result;
    }
}

