/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.validation;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaListingPanel;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaPanelType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.IUITitleFilterNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.RulesOperatorFull;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterListNode;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.common.IRuleForm;
import com.tandbergtv.cms.rules.ui.client.common.events.RuleDeleteEvent;
import com.tandbergtv.cms.rules.ui.client.common.events.RuleDeleteHandler;
import com.tandbergtv.cms.rules.ui.client.data.ActionParams;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import com.tandbergtv.cms.rules.ui.client.data.UIActionParam;
import com.tandbergtv.cms.rules.ui.client.data.UiRule;
import com.tandbergtv.cms.rules.ui.client.data.UiStandardRule;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import java.util.ArrayList;
import java.util.List;

public class ValidationRule
extends CriteriaListingPanel
implements IRuleForm {
    private static final String MESSAGE_STYLE = "big-txt-box";
    private static final String SMALL_TEXT = "small-txt";
    private RulesConstants myConstants = (RulesConstants)GWT.create(RulesConstants.class);
    private TextBox actionText;
    private ListBoxWidget<UIAction> actionsList;
    private int ruleId = -1;
    private static List<UIAction> actions;

    public ValidationRule(UiCriteriaMode critMode) {
        super(critMode);
        this.operatorProvider = new RulesOperatorFull();
        this.actionText = new TextBox();
        this.actionText.addStyleName(MESSAGE_STYLE);
        this.actionText.addStyleName(SMALL_TEXT);
        this.putTheUiTogether(null);
    }

    public ValidationRule(UiCriteriaMode critMode, UiStandardRule rule) {
        super(critMode);
        this.ruleId = rule.getId();
        this.operatorProvider = new RulesOperatorFull();
        this.actionText = new TextBox();
        this.actionText.addStyleName(MESSAGE_STYLE);
        this.actionText.addStyleName(SMALL_TEXT);
        if (rule.getActions().size() == 1) {
            UIAction action = rule.getActions().get(0);
            this.putTheUiTogether(rule.getUiTitleFilterNode());
            this.setActionSelected(action);
        } else {
            String msg = "Unexpected error: validation can only have 1 action.";
            RulesComponent.getInstance().getCurrentTab().setPanelInError(msg);
        }
    }

    private void putTheUiTogether(IUITitleFilterNode condition) {
        this.initializeActionDropDown();
        this.getContainer().add((Widget)super.getWarningMessageBox());
        this.getContainer().add((Widget)new Label(this.myConstants.validationActionLabel()));
        this.initializeTree(condition);
        HorizontalPanel messageRow = new HorizontalPanel();
        messageRow.add((Widget)new Label(String.valueOf(this.myConstants.returnThis()) + " "));
        messageRow.add(this.actionsList);
        Label message = new Label(String.valueOf(this.myConstants.message()) + " ");
        message.setStyleName("message-label");
        messageRow.add((Widget)message);
        messageRow.add((Widget)this.actionText);
        Button delButton = this.deleteButton();
        this.getContainer().add((Widget)messageRow);
        this.getContainer().add((Widget)delButton);
        this.getContainer().setStyleName("criteria-panel-container");
        this.setStyleName("criteria-panel");
    }

    private void initializeActionDropDown() {
        this.actionsList = new ListBoxWidget();
        this.actionsList.addStyleName(SMALL_TEXT);
        for (UIAction action : actions) {
            String label = this.myConstants.getString(action.getLabelKey());
            this.actionsList.addItem(label, (Object)action);
        }
    }

    private void setActionSelected(UIAction action) {
        if (action.containsParam(ActionParams.MESSAGE)) {
            UIActionParam param = action.getParam(ActionParams.MESSAGE);
            this.actionText.setText(param.getValue());
        }
        this.actionsList.setSelectedItem((Object)action);
    }

    @Override
    public UiRule getRule() {
        UITitleFilterListNode tree = this.getCriteria();
        UIAction action = ((UIAction)this.actionsList.getSelectedItem()).clone();
        if (action.containsParam(ActionParams.MESSAGE)) {
            UIActionParam param = action.getParam(ActionParams.MESSAGE);
            param.setValue(this.actionText.getText());
        }
        ArrayList<UIAction> actions = new ArrayList<UIAction>();
        actions.add(action);
        return new UiStandardRule(this.ruleId, tree, actions);
    }

    private Button deleteButton() {
        Button button = new Button(this.myConstants.delete(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ValidationRule.this.fireEvent(new RuleDeleteEvent(ValidationRule.this));
            }
        });
        button.removeStyleName("gwt-Button");
        button.addStyleName("ebBtn");
        button.addStyleName("delete_button_icon");
        return button;
    }

    @Override
    public HandlerRegistration addDeleteHandler(RuleDeleteHandler handler) {
        return this.addHandler(handler, RuleDeleteEvent.TYPE);
    }

    @Override
    public boolean validate() {
        boolean result = super.validate();
        if (this.actionText.getText().equals("")) {
            this.addWarningMessage(this.myConstants.ruleValidationBlankMessage());
            this.actionText.addStyleName("pinkbox");
            this.actionText.addChangeHandler((ChangeHandler)new ActionTextChangeHandler());
            result = false;
        } else if (this.actionText.getText().length() > 1024) {
            this.addWarningMessage(this.myConstants.ruleValidationTooLongMessage());
            this.actionText.addStyleName("pinkbox");
            this.actionText.addChangeHandler((ChangeHandler)new ActionTextChangeHandler());
            result = false;
        }
        return result;
    }

    public static void setCachedActions(List<UIAction> cachedActions) {
        actions = cachedActions;
    }

    public static List<UIAction> getCachedActions() {
        return actions;
    }

    public static boolean cacheLoaded() {
        return actions != null;
    }

    public CriteriaPanelType getCriteriaPanelType() {
        return CriteriaPanelType.RULES;
    }

    private class ActionTextChangeHandler
    implements ChangeHandler {
        private ActionTextChangeHandler() {
        }

        public void onChange(ChangeEvent event) {
            ValidationRule.this.clearWarningMessages();
            if (ValidationRule.this.actionText.getText().equals("")) {
                ValidationRule.this.addWarningMessage(ValidationRule.this.myConstants.ruleValidationBlankMessage());
                ValidationRule.this.actionText.addStyleName("pinkbox");
            } else if (ValidationRule.this.actionText.getText().length() > 1024) {
                ValidationRule.this.addWarningMessage(ValidationRule.this.myConstants.ruleValidationTooLongMessage());
                ValidationRule.this.actionText.addStyleName("pinkbox");
            } else {
                ValidationRule.this.actionText.removeStyleName("pinkbox");
            }
        }
    }
}

