/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.validation;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.criteria.Validatable;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.UiRulesService;
import com.tandbergtv.cms.rules.ui.client.UiRulesServiceAsync;
import com.tandbergtv.cms.rules.ui.client.common.IRuleForm;
import com.tandbergtv.cms.rules.ui.client.common.events.RuleDeleteEvent;
import com.tandbergtv.cms.rules.ui.client.common.events.RuleDeleteHandler;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.cms.rules.ui.client.data.UiRule;
import com.tandbergtv.cms.rules.ui.client.data.UiStandardRule;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiCustomRule;
import com.tandbergtv.cms.rules.ui.client.validation.CustomValidationRule;
import com.tandbergtv.cms.rules.ui.client.validation.ValidationRule;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.List;

public class ValidationRulePanel
extends VerticalContainer
implements Validatable {
    private List<IRuleForm> validationPanels = new ArrayList<IRuleForm>();
    private VerticalPanel rulesContainer;
    private RulesConstants myConstants = (RulesConstants)GWT.create(RulesConstants.class);
    protected static Boolean allowCustomRules;
    protected final UiRulesServiceAsync rulesService = (UiRulesServiceAsync)GWT.create(UiRulesService.class);
    private UiCriteriaMode critMode = UiCriteriaMode.EPISODE;

    public ValidationRulePanel(final UIRuleSet ruleSet) {
        this.rulesContainer = new VerticalPanel();
        if (!ruleSet.isNew()) {
            this.critMode = ruleSet.getTitleFilter().getCriteriaMode();
        }
        if (allowCustomRules == null) {
            try {
                this.rulesService.customRulesExist(Packages.VALIDATION.toString(), (AsyncCallback<Boolean>)new NeptuneAsyncCallback<Boolean>(){

                    public void onNeptuneFailure(Throwable caught) {
                        allowCustomRules = false;
                        ValidationRulePanel.this.populateUi(ruleSet);
                    }

                    public void onNeptuneSuccess(Boolean result) {
                        allowCustomRules = result;
                        ValidationRulePanel.this.populateUi(ruleSet);
                    }
                });
            }
            catch (NeptuneException neptuneException) {
                allowCustomRules = false;
                this.populateUi(ruleSet);
            }
        } else {
            this.populateUi(ruleSet);
        }
    }

    private RuleDeleteHandler getRuleDeleteHandler() {
        return new RuleDeleteHandler(){

            @Override
            public void ruleDeleted(RuleDeleteEvent event) {
                ValidationRulePanel.this.validationPanels.remove(event.getRule());
                ValidationRulePanel.this.rulesContainer.remove((Widget)event.getRule());
            }
        };
    }

    private void populateUi(UIRuleSet ruleSet) {
        for (UiRule rule : ruleSet.getRules()) {
            if (rule instanceof UiStandardRule) {
                ValidationRule vrule = new ValidationRule(this.critMode, (UiStandardRule)rule);
                vrule.addDeleteHandler(this.getRuleDeleteHandler());
                this.validationPanels.add(vrule);
                this.rulesContainer.add((Widget)vrule);
                continue;
            }
            if (!(rule instanceof UiCustomRule)) continue;
            CustomValidationRule cvrule = new CustomValidationRule((UiCustomRule)rule);
            cvrule.addDeleteHandler(this.getRuleDeleteHandler());
            this.validationPanels.add(cvrule);
            this.rulesContainer.add((Widget)cvrule);
        }
        this.add((Widget)this.rulesContainer);
        HorizontalPanel buttonPanel = new HorizontalPanel();
        buttonPanel.addStyleName("cms_button_container");
        buttonPanel.add((Widget)this.createButton());
        if (allowCustomRules.booleanValue()) {
            buttonPanel.add((Widget)this.addCustomButton());
        }
        this.add((Widget)buttonPanel);
    }

    private ButtonWidget addCustomButton() {
        String buttonName = this.myConstants.addCustomRule();
        ButtonWidget button = new ButtonWidget(buttonName, new ClickHandler(){

            public void onClick(ClickEvent event) {
                CustomValidationRule vrule = new CustomValidationRule();
                vrule.addDeleteHandler(ValidationRulePanel.this.getRuleDeleteHandler());
                ValidationRulePanel.this.validationPanels.add(vrule);
                ValidationRulePanel.this.rulesContainer.add((Widget)vrule);
            }
        });
        button.removeStyleName("gwt-Button");
        button.addStyleName("ebBtn");
        button.addStyleName("addgreen_button_icon");
        return button;
    }

    private ButtonWidget createButton() {
        String buttonName = this.myConstants.createRuleButtonLabel();
        ButtonWidget button = new ButtonWidget(buttonName, new ClickHandler(){

            public void onClick(ClickEvent event) {
                ValidationRule vrule = new ValidationRule(ValidationRulePanel.this.critMode);
                vrule.addDeleteHandler(ValidationRulePanel.this.getRuleDeleteHandler());
                ValidationRulePanel.this.validationPanels.add(vrule);
                ValidationRulePanel.this.rulesContainer.add((Widget)vrule);
            }
        });
        button.removeStyleName("gwt-Button");
        button.addStyleName("ebBtn");
        button.addStyleName("ebBtn_color_green");
        button.addStyleName("create_button_icon");
        return button;
    }

    public List<UiRule> getRules() {
        ArrayList<UiRule> result = new ArrayList<UiRule>();
        for (IRuleForm panel : this.validationPanels) {
            result.add(panel.getRule());
        }
        return result;
    }

    public boolean validate() {
        boolean result = true;
        for (IRuleForm panel : this.validationPanels) {
            if (panel.validate()) continue;
            result = false;
        }
        return result;
    }

    public UiCriteriaMode getCriteriaMode() {
        return this.critMode;
    }

    public void setCriteriaMode(UiCriteriaMode critMode) {
        this.critMode = critMode;
    }
}

