/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.validation;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldSelector;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.RulesUtils;
import com.tandbergtv.cms.rules.ui.client.UiActionService;
import com.tandbergtv.cms.rules.ui.client.UiActionServiceAsync;
import com.tandbergtv.cms.rules.ui.client.common.Permissions;
import com.tandbergtv.cms.rules.ui.client.common.RulePanel;
import com.tandbergtv.cms.rules.ui.client.common.TabItem;
import com.tandbergtv.cms.rules.ui.client.common.TabbedWizard;
import com.tandbergtv.cms.rules.ui.client.common.TitleFilterPanel;
import com.tandbergtv.cms.rules.ui.client.common.site.SiteSelectionPanel;
import com.tandbergtv.cms.rules.ui.client.common.site.UiRuleSetsAssocWJobExpception;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.cms.rules.ui.client.data.UiRule;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.ErrorMessageBuilder;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.RuleServiceException;
import com.tandbergtv.cms.rules.ui.client.validation.ValidationRule;
import com.tandbergtv.cms.rules.ui.client.validation.ValidationRuleNamePanel;
import com.tandbergtv.cms.rules.ui.client.validation.ValidationRulePanel;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IMessageListener;
import java.util.List;

public class ValidationRuleSetPanel
extends RulePanel {
    private TabbedWizard tabbedWizard;
    private ValidationRuleNamePanel ruleNamePanel;
    private TitleFilterPanel panelTitleFilter;
    private ValidationRulePanel panelValidation;
    private RulesConstants myConstants = (RulesConstants)GWT.create(RulesConstants.class);
    private BusyIndicator busyIndicator = new BusyIndicator();
    private SiteSelectionPanel siteSelectionPanel;

    protected void onUnload() {
        super.onUnload();
        this.busyIndicator.hide();
    }

    @Override
    public void createPanel() {
        this.busyIndicator.center();
        if (!ValidationRule.cacheLoaded()) {
            this.getActionLookupAsync();
        } else {
            this.populateUi();
        }
    }

    private void populateUi() {
        this.setStyleName("rule-panel");
        this.resetMessagePanel();
        this.setHeaderLabel();
        this.ruleNamePanel = new ValidationRuleNamePanel(this.ruleSet.getName(), this.ruleSet.isEnabled(), this.ruleSet.getIsEmailNotify());
        this.panelValidation = new ValidationRulePanel(this.ruleSet);
        this.panelTitleFilter = new TitleFilterPanel(new SelectionHandler<UiCriteriaMode>(){

            public void onSelection(SelectionEvent<UiCriteriaMode> event) {
                ValidationRuleSetPanel.this.panelValidation.setCriteriaMode((UiCriteriaMode)event.getSelectedItem());
            }
        }, this.ruleSet);
        TabItem titleFilterTabItem = new TabItem(this.myConstants.wizFilterInstruct(), (Widget)this.panelTitleFilter);
        TabItem validationTabItem = new TabItem(this.myConstants.validationCriteriaInstructions(), (Widget)this.panelValidation);
        TabItem ruleNameTabItem = new TabItem(this.myConstants.ruleNameInstructions(), (Widget)this.ruleNamePanel);
        if (RulesUtils.isFeatureAvailable("Sites")) {
            this.siteSelectionPanel = this.ruleSet.isNew() && this.ruleSet.getSites().isEmpty() ? new SiteSelectionPanel() : new SiteSelectionPanel(this.ruleSet.getSites(), this.ruleSet.isRunOnGlobal());
            TabItem siteSelectionTabItem = new TabItem(this.myConstants.siteSelectInstructions(), (Widget)this.siteSelectionPanel);
            this.tabbedWizard = new TabbedWizard((Widget)siteSelectionTabItem, this.myConstants.sitesLabel(), "");
            this.tabbedWizard.addTab((Widget)titleFilterTabItem, this.myConstants.wizardTitleFilter());
        } else {
            this.tabbedWizard = new TabbedWizard((Widget)this.panelTitleFilter, this.myConstants.wizardTitleFilter(), "");
        }
        this.tabbedWizard.addTab((Widget)validationTabItem, this.myConstants.wizardValidationCriteria());
        this.tabbedWizard.addTab((Widget)ruleNameTabItem, this.myConstants.wizardRuleName());
        this.tabbedWizard.addHeightOffsettingWidget((Widget)this.headerPanel);
        this.add((Widget)this.tabbedWizard);
        ButtonWidget cancelButton = this.createCancelButton();
        cancelButton.addClickHandler(this.getDefaultCancelHandler());
        cancelButton.setVisible(false);
        NeptuneSecurity security = RulesComponent.getInstance().getSecurity();
        if (security.isUserInRole(Permissions.MODIFY) || this.ruleSet.isNew() && security.isUserInRole(Permissions.CREATE)) {
            ButtonWidget saveButton = this.createSaveButton();
            saveButton.addClickHandler(this.getSaveHandler());
            saveButton.setVisible(false);
            this.tabbedWizard.addCommonBottomWidget((Widget)saveButton);
            ButtonWidget copyButton = this.createCopyButton();
            copyButton.addClickHandler(this.getCopyHandler());
            copyButton.setVisible(false);
            this.tabbedWizard.addCommonBottomWidget((Widget)copyButton);
            if (this.ruleSet.isNew()) {
                copyButton.setEnabled(false);
            }
        }
        this.tabbedWizard.addCommonBottomWidget((Widget)cancelButton);
        this.tabbedWizard.show(this.ruleSet.isNew(), this.isCopy());
        this.registerMessageListener((IMessageListener)this.tabbedWizard);
        if (this.ruleSet.isNew() || this.ruleSet.getTitleFilter().getCriteriaMode().equals((Object)UiCriteriaMode.EPISODE)) {
            FieldSelector.initialize((CriteriaType)CriteriaType.RULE_CONDITION_LHS, (UiCriteriaMode)UiCriteriaMode.EPISODE);
            FieldSelector.initialize((CriteriaType)CriteriaType.SEARCH_CONDITION_LHS, (UiCriteriaMode)UiCriteriaMode.EPISODE);
        } else {
            FieldSelector.initialize((CriteriaType)CriteriaType.RULE_CONDITION_LHS, (UiCriteriaMode)UiCriteriaMode.SERIES);
            FieldSelector.initialize((CriteriaType)CriteriaType.SEARCH_CONDITION_LHS, (UiCriteriaMode)UiCriteriaMode.SERIES);
        }
        this.busyIndicator.hide();
    }

    private void getActionLookupAsync() {
        UiActionServiceAsync actionService = (UiActionServiceAsync)GWT.create(UiActionService.class);
        actionService.getActions(Packages.VALIDATION, (AsyncCallback<List<UIAction>>)new NeptuneAsyncCallback<List<UIAction>>(){

            public void onNeptuneFailure(Throwable caught) {
                Window.alert((String)(caught == null ? "" : caught.getMessage()));
            }

            public void onNeptuneSuccess(List<UIAction> result) {
                ValidationRule.setCachedActions(result);
                ValidationRuleSetPanel.this.populateUi();
            }
        });
    }

    private ClickHandler getSaveHandler() {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                ValidationRuleSetPanel.this.resetMessagePanel();
                if (!ValidationRuleSetPanel.this.tabbedWizard.validateAllItems()) {
                    return;
                }
                List<UiRule> rules = ValidationRuleSetPanel.this.panelValidation.getRules();
                if (ValidationRuleSetPanel.this.siteSelectionPanel.containsGlobalAndSite() && ValidationRuleSetPanel.this.failsContractValidate(rules)) {
                    ValidationRuleSetPanel.this.showInfoMessage(ValidationRuleSetPanel.this.myConstants.failsContractValidation());
                    return;
                }
                final ButtonWidget button = (ButtonWidget)event.getSource();
                UIRuleSet ruleset = new UIRuleSet();
                ruleset.setId(ValidationRuleSetPanel.this.ruleSet.getId());
                ruleset.setEnabled(ValidationRuleSetPanel.this.ruleNamePanel.isEnabled());
                ruleset.setIsEmailNotify(ValidationRuleSetPanel.this.ruleNamePanel.isEmailNotify());
                ruleset.setName(ValidationRuleSetPanel.this.ruleNamePanel.getRuleName());
                if (ValidationRuleSetPanel.this.siteSelectionPanel != null) {
                    ruleset.setRunOnGlobal(ValidationRuleSetPanel.this.siteSelectionPanel.isRunOnGlobal());
                    ruleset.setSites(ValidationRuleSetPanel.this.siteSelectionPanel.getSites());
                }
                ruleset.setPackageId(Packages.VALIDATION);
                ruleset.setTitleFilter(ValidationRuleSetPanel.this.panelTitleFilter.getTitleFilter());
                ruleset.setRules(rules);
                button.setEnabled(false);
                ValidationRuleSetPanel.this.rulesService.saveRuleSet(ruleset, (AsyncCallback<Integer>)new NeptuneAsyncCallback<Integer>(){

                    public void onNeptuneFailure(Throwable caught) {
                        button.setEnabled(true);
                        if (caught instanceof RuleServiceException) {
                            List<String> messages = ErrorMessageBuilder.getErrorMessages((RuleServiceException)((Object)caught));
                            ValidationRuleSetPanel.this.showErrorMessages(messages);
                        } else if (caught instanceof UiRuleSetsAssocWJobExpception) {
                            ValidationRuleSetPanel.this.handleSiteJobAssoc((UiRuleSetsAssocWJobExpception)((Object)caught));
                        } else {
                            Window.alert((String)(caught == null ? "" : caught.getMessage()));
                        }
                    }

                    public void onNeptuneSuccess(Integer result) {
                        ValidationRuleSetPanel.this.resetMessagePanel();
                        button.setEnabled(true);
                        RulesComponent.getInstance().setRuleListingAnchor(ValidationRuleSetPanel.this.ruleSet.getPackageId());
                    }
                });
            }
        };
    }

    private ClickHandler getCopyHandler() {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                ValidationRuleSetPanel.this.setCopy(true);
                if (!ValidationRuleSetPanel.this.tabbedWizard.validateAllItems()) {
                    return;
                }
                ButtonWidget button = (ButtonWidget)event.getSource();
                UIRuleSet copyRuleSet = new UIRuleSet();
                copyRuleSet.setId(-1);
                String oldName = ValidationRuleSetPanel.this.ruleNamePanel.getRuleName();
                copyRuleSet.setName(ValidationRuleSetPanel.this.updateRuleCopyName(oldName));
                copyRuleSet.setEnabled(ValidationRuleSetPanel.this.ruleNamePanel.isEnabled());
                copyRuleSet.setIsEmailNotify(ValidationRuleSetPanel.this.ruleNamePanel.isEmailNotify());
                if (ValidationRuleSetPanel.this.siteSelectionPanel != null) {
                    copyRuleSet.setRunOnGlobal(ValidationRuleSetPanel.this.siteSelectionPanel.isRunOnGlobal());
                    copyRuleSet.setSites(ValidationRuleSetPanel.this.copyCurrentUISites(ValidationRuleSetPanel.this.ruleSet, ValidationRuleSetPanel.this.siteSelectionPanel.getSites()));
                }
                copyRuleSet.setPackageId(ValidationRuleSetPanel.this.ruleSet.getPackageId());
                copyRuleSet.setRules(ValidationRuleSetPanel.this.panelValidation.getRules());
                copyRuleSet.setTitleFilter(ValidationRuleSetPanel.this.panelTitleFilter.getTitleFilter());
                button.setEnabled(false);
                RulesComponent.getInstance().setNewRuleAnchor(copyRuleSet.getPackageId(), false);
                ValidationRuleSetPanel.this.loadedFlagReset();
                ValidationRuleSetPanel.this.setRule(copyRuleSet);
            }
        };
    }

    private void setHeaderLabel() {
        String newRule = this.myConstants.newValidationRule();
        String ruleName = String.valueOf(this.myConstants.validationRuleDetails()) + " " + this.ruleSet.getName();
        String headerString = this.ruleSet.getName().isEmpty() ? newRule : ruleName;
        this.setHeaderLabel(headerString);
    }
}

