/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.server;

import com.ericsson.rules.fieldprovider.metadataenhancement.IMetadataEnhancementField;
import com.ericsson.rules.fieldprovider.metadataenhancement.IMetadataEnhancementProvider;
import com.ericsson.rules.fieldprovider.metadataenhancement.ISubscriptionProfile;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UIDataType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UiSubscriptionFields;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UiSubscriptionProfile;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UiSubscriptionProfilesList;
import com.tandbergtv.cms.portal.ui.title.server.specification.FieldLookupService;
import com.tandbergtv.cms.rules.ui.client.UiEnhancementRulesDataProvider;
import com.tandbergtv.marvin.udt.DataTypes;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.title.conf.CustomField;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class UiEnhancementRulesDataProviderImpl
implements UiEnhancementRulesDataProvider,
NeptuneRemoteService {
    private IMetadataEnhancementProvider metdataEnhancementProvider;
    private static final Logger logger = Logger.getLogger(UiEnhancementRulesDataProviderImpl.class);

    public UiEnhancementRulesDataProviderImpl() {
        try {
            this.metdataEnhancementProvider = (IMetadataEnhancementProvider)InjectionUtil.injectInstance((String)"cms/MEManager/local", IMetadataEnhancementProvider.class);
        }
        catch (Exception e) {
            logger.error((Object)"could not initialize metadataEnhancementProvider", (Throwable)e);
        }
    }

    @Override
    public UiSubscriptionProfilesList getSubscritionProvides(Date lastUpdatedDate) {
        boolean isRefreshed = false;
        Date meLastUpdateDate = FieldLookupService.getInstance().getEnhancementLastUpdateDate();
        if (lastUpdatedDate == null || lastUpdatedDate.before(meLastUpdateDate)) {
            ArrayList<UiSubscriptionProfile> uiSubProfiles = new ArrayList<UiSubscriptionProfile>();
            List subProfiles = this.metdataEnhancementProvider.getSubscriptionProfiles();
            for (ISubscriptionProfile sp : subProfiles) {
                UiSubscriptionProfile uiProfile = new UiSubscriptionProfile(sp.getName(), sp.getId());
                uiSubProfiles.add(uiProfile);
                for (IMetadataEnhancementField field : sp.getFields()) {
                    UIDataType dataType = this.convertDataType(field.getDataType(), field.getDatatype());
                    uiProfile.addField(new UiSubscriptionFields(dataType, field.getDisplayName(), field.getFieldIdentifier(), uiProfile, field.getDatatype()));
                }
            }
            isRefreshed = true;
            return new UiSubscriptionProfilesList(uiSubProfiles, meLastUpdateDate, isRefreshed);
        }
        return new UiSubscriptionProfilesList();
    }

    private UIDataType convertDataType(DataTypes dt, String complexType) {
        UIDataType dataType = UIDataType.fromValue((String)dt.getDataTypeName());
        if (dataType.equals((Object)UIDataType.STRING) && !complexType.equalsIgnoreCase(CustomField.DataType.STRING.name())) {
            return UIDataType.COMPLEX;
        }
        return dataType;
    }

    public String getRelativePath() {
        return "service/rules/uiEnhancementRulesDataProvider";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }
}

