/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.server;

import com.ericsson.extended_interface.IRulesLicensingField;
import com.ericsson.extended_interface.IRulesLicensingProvider;
import com.ericsson.extended_interface.LicenseKeyName;
import com.ericsson.extended_interface.impl.RulesLicensingField;
import com.ericsson.extended_interface.impl.RulesLicensingFieldOption;
import com.ericsson.rules.contract.ILicensingRule;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.LicenseTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UIDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;
import com.tandbergtv.cms.rules.ui.client.LicensingDataProviderResults;
import com.tandbergtv.cms.rules.ui.client.UiLicenseDataProvider;
import com.tandbergtv.cms.rules.ui.client.licenseassignment.UiLicense;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class UiLicenseDataProviderImpl
implements UiLicenseDataProvider,
NeptuneRemoteService {
    private IRulesLicensingProvider licensingProvider = (IRulesLicensingProvider)InjectionUtil.injectInstance((String)"cms/RulesLicensingProvider/local", IRulesLicensingProvider.class);
    private ILicensingRule licRuleHelper = (ILicensingRule)InjectionUtil.injectInstance((String)"cms/LicensingRuleImpl/local", ILicensingRule.class);
    private static Date lastSyncDate;
    private static List<RulesLicensingField> currentFields;

    @Override
    public LicensingDataProviderResults getContractField(Date lastUpdateDate) {
        List licFields = this.licensingProvider.getFields();
        if (lastSyncDate == null || !this.licensingFieldsEqual(currentFields, licFields)) {
            lastSyncDate = new Date();
            currentFields = licFields;
            return new LicensingDataProviderResults(lastSyncDate, this.buildResults());
        }
        if (lastUpdateDate == null || lastSyncDate.compareTo(lastUpdateDate) > 0) {
            return new LicensingDataProviderResults(lastSyncDate, this.buildResults());
        }
        return new LicensingDataProviderResults();
    }

    private LicenseTreeObject buildResults() {
        LicenseTreeObject root = new LicenseTreeObject("Paranoid_Licensing", "Licensing", UIDataType.COMPLEX, "Licensing");
        for (RulesLicensingField field : currentFields) {
            String[] path = field.getDisplayName().split("/");
            String displayName = path[path.length - 1];
            this.addField(root, path, 0, this.convertField(field, displayName));
        }
        return root;
    }

    private LicenseTreeObject convertField(RulesLicensingField rlf, String displayName) {
        UIDataType dataType = rlf.getFieldDataType().equals((Object)IRulesLicensingField.DataType.LONG) ? UIDataType.INTEGER : UIDataType.fromValue((String)rlf.getFieldDataType().toString().toLowerCase());
        if (rlf.getOptions() != null && rlf.getOptions().size() > 0) {
            return new LicenseTreeObject(rlf.getFieldIdentifier(), displayName, dataType, this.getSuggestedValues(rlf), rlf.getDisplayName().replace("/", "."));
        }
        return new LicenseTreeObject(rlf.getFieldIdentifier(), displayName, dataType, rlf.getDisplayName().replace("/", "."));
    }

    private List<UIValueOption> getSuggestedValues(RulesLicensingField rlf) {
        ArrayList<UIValueOption> values = new ArrayList<UIValueOption>();
        if (rlf.getFieldDataType().equals((Object)UiColumn.DataType.DATE) || rlf.getFieldDataType().equals((Object)UiColumn.DataType.BOOLEAN) || rlf.getFieldDataType().equals((Object)UiColumn.DataType.TIME) || rlf.getFieldDataType().equals((Object)UiColumn.DataType.TIME)) {
            throw new RuntimeException("Suggested values are not supported for " + rlf.getFieldDataType());
        }
        for (RulesLicensingFieldOption option : rlf.getOptions()) {
            values.add(new UIValueOption(option.getDisplayName(), option.getValue().toString()));
        }
        return values;
    }

    private void addField(LicenseTreeObject node, String[] path, int pos, LicenseTreeObject def) {
        if (pos + 1 == path.length) {
            node.addChild((IFieldTreeObject)def);
            return;
        }
        for (IFieldTreeObject child : node.getChildren()) {
            if (!child.getSimpleDisplayName().equals(path[pos])) continue;
            this.addField((LicenseTreeObject)child, path, pos + 1, def);
            return;
        }
        LicenseTreeObject pointer = node;
        int i = pos;
        while (i < path.length - 1) {
            LicenseTreeObject child = new LicenseTreeObject("", path[pos], UIDataType.COMPLEX, "");
            pointer.addChild((IFieldTreeObject)child);
            pointer = child;
            ++i;
        }
        pointer.addChild((IFieldTreeObject)def);
    }

    @Override
    public List<UiLicense> getAvailableLicenses() {
        ArrayList<UiLicense> result = new ArrayList<UiLicense>();
        Set assignedLic = this.licRuleHelper.getAllAssigendLicences();
        for (LicenseKeyName lic : this.licensingProvider.getAllLicenses()) {
            boolean alreadyUsed = assignedLic.contains(lic.getLicenseId());
            result.add(new UiLicense(lic.getLicenseId(), lic.getName(), alreadyUsed));
        }
        return result;
    }

    public String getRelativePath() {
        return "service/rules/uiLicenseDataProvider";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    private boolean licensingFieldsEqual(List<RulesLicensingField> fieldsList1, List<RulesLicensingField> fieldsList2) {
        if (fieldsList1.size() != fieldsList2.size()) {
            return false;
        }
        int j = 0;
        while (j < fieldsList1.size()) {
            IRulesLicensingField field1 = (IRulesLicensingField)fieldsList1.get(j);
            IRulesLicensingField field2 = (IRulesLicensingField)fieldsList2.get(j);
            if (!(field1.getFieldIdentifier().equals(field2.getFieldIdentifier()) && field1.getFieldDataType().equals((Object)field2.getFieldDataType()) && field1.getDisplayName().equals(field2.getDisplayName()))) {
                return false;
            }
            if (field1.getOptions() != null && field2.getOptions() != null) {
                if (field1.getOptions().size() != field2.getOptions().size()) {
                    return false;
                }
                int i = 0;
                while (i < field1.getOptions().size()) {
                    RulesLicensingFieldOption fieldOneValue = (RulesLicensingFieldOption)field1.getOptions().get(i);
                    RulesLicensingFieldOption fieldTwoValue = (RulesLicensingFieldOption)field2.getOptions().get(i);
                    if (!fieldOneValue.getValue().equals(fieldTwoValue.getValue()) || !fieldOneValue.getDisplayName().equals(fieldTwoValue.getDisplayName())) {
                        return false;
                    }
                    ++i;
                }
            }
            ++j;
        }
        return true;
    }
}

