/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.server;

import com.tandbergtv.cms.contentmgmt.service.specification.IAssetSpecificationManager;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UITitleCompareXmlData;
import com.tandbergtv.cms.portal.content.client.title.model.rules.RulePreviewRequest;
import com.tandbergtv.cms.portal.content.client.title.model.rules.RulePreviewResponse;
import com.tandbergtv.cms.portal.content.server.ServiceLocator;
import com.tandbergtv.cms.portal.content.server.title.modelbuilder.UITitleCompareDataBuilder;
import com.tandbergtv.cms.portal.content.server.title.modelbuilder.UITitlePreviewBuilder;
import com.tandbergtv.cms.rules.service.category.IRuleExecutionHandler;
import com.tandbergtv.cms.rules.ui.client.IUiRulesPreviewService;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.cms.rules.ui.server.util.RulesServiceUtil;
import com.tandbergtv.marvin.udt.TreRuleSet;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.NeptuneAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.compare.ITitleCompareReport;
import com.tandbergtv.watchpoint.pmm.title.ITitleCompareService;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import javax.servlet.http.HttpSession;

public class UiRulesPreviewServiceImpl
implements IUiRulesPreviewService,
NeptuneRemoteService {
    private IRuleExecutionHandler ruleRunner = (IRuleExecutionHandler)InjectionUtil.injectInstance((String)"cms/EventHandler/local", IRuleExecutionHandler.class);
    private ITitleCompareService titleCompareService = (ITitleCompareService)ServiceLocator.getService((String)"TitleCompareServiceProxy", ITitleCompareService.class);
    private ITitleManager titleManagerService = (ITitleManager)ServiceLocator.getService((String)"TitleManagerProxy", ITitleManager.class);
    private IAssetSpecificationManager specificationManager = (IAssetSpecificationManager)ServiceLocator.getService((String)"AssetSpecificationManager", IAssetSpecificationManager.class);
    RulesServiceUtil util = new RulesServiceUtil();
    private HttpSession httpSession;
    TreRuleSet rule;

    public void setHttpSession(HttpSession httpSession) {
        this.httpSession = httpSession;
    }

    @Override
    public RulePreviewResponse previewRule(RulePreviewRequest request, UIRuleSet uiRuleSet) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"});
        RulePreviewResponse resp = new RulePreviewResponse();
        Title title1 = this.getTitle(request);
        Title title2 = null;
        title2 = this.getTitle(request);
        this.runRule(title2, request, uiRuleSet);
        ITitleCompareReport report = this.titleCompareService.compareTitles(title1, title2);
        UITitleCompareDataBuilder builder = new UITitleCompareDataBuilder(request.specName);
        resp.diffData = builder.build(report);
        return resp;
    }

    @Override
    public RulePreviewResponse previewRuleSpec(RulePreviewRequest request, boolean useHtml, UIRuleSet uiRuleSet) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"});
        Title title1 = this.getTitle(request);
        Title title2 = this.getTitle(request);
        RulePreviewResponse resp = new RulePreviewResponse();
        this.runRule(title2, request, uiRuleSet);
        UITitleCompareXmlData data = new UITitleCompareXmlData();
        data.preview1URL = this.previewTitle(title1, request.specName, useHtml);
        data.preview2URL = this.previewTitle(title2, request.specName, useHtml);
        resp.xmlData = data;
        return resp;
    }

    private void runRule(Title title, RulePreviewRequest request, UIRuleSet uiRuleSet) throws NeptuneException {
        TreRuleSet treRuleSet = this.util.convertUIRuleSetToTreRuleSetForRulePreview(uiRuleSet);
        this.ruleRunner.testNormalization(title, treRuleSet, request.siteId);
    }

    private Title getTitle(RulePreviewRequest request) {
        Title title = this.titleManagerService.get(request.titleId);
        return title;
    }

    private String previewTitle(Title title, String specificationName, boolean useHtml) throws NeptuneException {
        UITitlePreviewBuilder generator = new UITitlePreviewBuilder(this.httpSession, this.titleManagerService, useHtml);
        Specification spec = this.specificationManager.getSpecification(specificationName);
        return generator.generatePreview(title, spec);
    }

    public String getRelativePath() {
        return "service/rules/IUiRulesPreviewService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }
}

