/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.server;

import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.scheduler.InvalidScheduleException;
import com.ericsson.cms.scheduler.entities.ScheduleRule;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleInfo;
import com.ericsson.cms.scheduling.ui.server.ScheduleConvertor;
import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.Site;
import com.ericsson.cms.sites.core.entities.mediapath.MSO;
import com.ericsson.cms.sites.dependency.ISitesDepCacheService;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterListNode;
import com.tandbergtv.cms.portal.ui.title.server.search.TitleFilterServiceError;
import com.tandbergtv.cms.portal.ui.title.server.search.UiTitleFilterService;
import com.tandbergtv.cms.portal.ui.title.server.specification.FieldLookupService;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.cms.rules.customrules.CustomRule;
import com.tandbergtv.cms.rules.customrules.CustomRuleParameter;
import com.tandbergtv.cms.rules.service.RuleDeleteException;
import com.tandbergtv.cms.rules.service.RuleServiceStatus;
import com.tandbergtv.cms.rules.service.category.EventRetrivalException;
import com.tandbergtv.cms.rules.service.category.IPackageManager;
import com.tandbergtv.cms.rules.service.category.IRuleManager;
import com.tandbergtv.cms.rules.service.category.IRuleManagerCache;
import com.tandbergtv.cms.rules.service.category.PackageRetrievalException;
import com.tandbergtv.cms.rules.ui.client.UiRulesService;
import com.tandbergtv.cms.rules.ui.client.common.Permissions;
import com.tandbergtv.cms.rules.ui.client.common.UiInvalidScheduleException;
import com.tandbergtv.cms.rules.ui.client.common.site.SiteType;
import com.tandbergtv.cms.rules.ui.client.common.site.UISite;
import com.tandbergtv.cms.rules.ui.client.common.site.UiRuleSetsAssocWJobExpception;
import com.tandbergtv.cms.rules.ui.client.data.ActionParams;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import com.tandbergtv.cms.rules.ui.client.data.UIEvent;
import com.tandbergtv.cms.rules.ui.client.data.UIMSORuleSet;
import com.tandbergtv.cms.rules.ui.client.data.UIMsoRuleListItem;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleListItem;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.cms.rules.ui.client.data.UiRule;
import com.tandbergtv.cms.rules.ui.client.data.UiStandardRule;
import com.tandbergtv.cms.rules.ui.client.data.customrules.DisplayCustomRule;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiCustomRule;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiCustomRuleParameter;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiCustomRuleTree;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiDisplayCustRuleParam;
import com.tandbergtv.cms.rules.ui.client.msooverride.UiMso;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.RuleServiceException;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.RuleSetDoesntExist;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.RuleTargetingDoesntHaveAllDependencySites;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.UIRuleServiceErrorMessage;
import com.tandbergtv.cms.rules.ui.server.RulePersistenceException;
import com.tandbergtv.cms.rules.ui.server.UiRulesSiteFetcherImpl;
import com.tandbergtv.cms.rules.ui.server.util.RulesServiceUtil;
import com.tandbergtv.cms.titlefilter.TitleFilter;
import com.tandbergtv.marvin.services.customrules.CustomRuleLoadException;
import com.tandbergtv.marvin.services.customrules.CustomRuleProvider;
import com.tandbergtv.marvin.udt.TreAction;
import com.tandbergtv.marvin.udt.TreActionParameterValue;
import com.tandbergtv.marvin.udt.TreCustomRule;
import com.tandbergtv.marvin.udt.TreCustomRuleParameter;
import com.tandbergtv.marvin.udt.TreEvent;
import com.tandbergtv.marvin.udt.TreMsoOverrrideRuleSet;
import com.tandbergtv.marvin.udt.TrePackage;
import com.tandbergtv.marvin.udt.TreRule;
import com.tandbergtv.marvin.udt.TreRuleSet;
import com.tandbergtv.marvin.udt.TreStandardRule;
import com.tandbergtv.neptune.authorization.service.IAuthorizationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.locale.ClientLocaleProvider;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.PartnerType;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerUserManager;
import com.tandbergtv.watchpoint.routing.SoapRouter;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IPayload;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.StringPayload;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.util.Marshaller;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.naming.InitialContext;
import javax.persistence.NoResultException;
import javax.transaction.TransactionManager;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.w3c.dom.Document;

public class UiRulesServiceImpl
implements UiRulesService,
NeptuneRemoteService {
    private static final Logger logger = Logger.getLogger(UiRulesServiceImpl.class);
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String COMMAND_NAME = "create";
    private static final String UID = "re0101";
    private IRuleManager ruleManager = (IRuleManager)InjectionUtil.injectInstance((String)"cms/RuleManagerImpl/local", IRuleManager.class);
    private IPackageManager packageManager = (IPackageManager)InjectionUtil.injectInstance((String)"cms/PackageManagerImpl/local", IPackageManager.class);
    private UiTitleFilterService titleFilterService = new UiTitleFilterService();
    private IAuthorizationService authorizationService = (IAuthorizationService)InjectionUtil.injectInstance((String)"cms/AuthorizationService/local", IAuthorizationService.class);
    private ISitesDepCacheService sitesDepSvc = (ISitesDepCacheService)InjectionUtil.injectInstance((String)"cms/SitesDepCacheService/local", ISitesDepCacheService.class);
    private IPartnerUserManager partnerService = (IPartnerUserManager)InjectionUtil.injectInstance((String)"PartnerServices/PartnerUserManager", IPartnerUserManager.class);
    RulesServiceUtil util = new RulesServiceUtil();
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ Annotation ajc$anno$5;
    private static /* synthetic */ Annotation ajc$anno$6;
    private static /* synthetic */ Annotation ajc$anno$7;

    @Override
    @Transactional
    public List<UIRuleListItem> getRuleSetsByPackage(String packageName) throws NeptuneException {
        String string = packageName;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = UiRulesServiceImpl.class.getDeclaredMethod("getRuleSetsByPackage", String.class).getAnnotation(Transactional.class);
        }
        return (List)UiRulesServiceImpl.getRuleSetsByPackage_aroundBody1$advice(this, string, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public Packages getPackageType(int ruleSetId) throws NeptuneException {
        int n = ruleSetId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = UiRulesServiceImpl.class.getDeclaredMethod("getPackageType", Integer.TYPE).getAnnotation(Transactional.class);
        }
        return (Packages)((Object)UiRulesServiceImpl.getPackageType_aroundBody3$advice(this, n, transactionEnforcer, (Transactional)annotation, null));
    }

    @Override
    @Transactional
    public void saveRuleSetOrder(String pkgName, List<UIRuleListItem> list) throws NeptuneException {
        String string = pkgName;
        List<UIRuleListItem> list2 = list;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = UiRulesServiceImpl.class.getDeclaredMethod("saveRuleSetOrder", String.class, List.class).getAnnotation(Transactional.class);
        }
        UiRulesServiceImpl.saveRuleSetOrder_aroundBody5$advice(this, string, list2, transactionEnforcer, (Transactional)annotation, null);
    }

    private TreRuleSet getByID(List<TreRuleSet> list, int id) {
        for (TreRuleSet item : list) {
            if (item.getRuleSetId() != id) continue;
            return item;
        }
        return null;
    }

    @Override
    @Transactional
    public UIRuleSet getRuleSet(int ruleSetId) throws NeptuneException {
        int n = ruleSetId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = UiRulesServiceImpl.class.getDeclaredMethod("getRuleSet", Integer.TYPE).getAnnotation(Transactional.class);
        }
        return (UIRuleSet)UiRulesServiceImpl.getRuleSet_aroundBody7$advice(this, n, transactionEnforcer, (Transactional)annotation, null);
    }

    private List<UISite> getSites(Collection<Site> selectedSites) {
        UiRulesSiteFetcherImpl siteService = new UiRulesSiteFetcherImpl();
        List<UISite> sites = siteService.getSitesHelper();
        if (sites.isEmpty()) {
            return sites;
        }
        for (Site s : selectedSites) {
            this.selectSites(s.getId(), sites);
        }
        return sites;
    }

    private void selectSites(int siteId, List<UISite> sites) {
        for (UISite uisite : sites) {
            if (uisite.getId() == siteId) {
                uisite.setSelected(true);
                break;
            }
            if (uisite.getChildren().isEmpty()) continue;
            this.selectSites(siteId, uisite.getChildren());
        }
    }

    private UIRuleSet convertRuleSetToUIRuleSet(TreRuleSet rs, String packageName) throws TitleFilterServiceError {
        UIRuleSet result;
        if (!rs.getTpackage().getName().equals("MSOOVERRIDE")) {
            result = new UIRuleSet();
        } else {
            result = new UIMSORuleSet();
            HashSet<Integer> msoIds = new HashSet<Integer>();
            if (((TreMsoOverrrideRuleSet)rs).getMsos() != null) {
                for (Object mso : ((TreMsoOverrrideRuleSet)rs).getMsos()) {
                    msoIds.add(new Integer(mso.getId()));
                }
            }
            ((UIMSORuleSet)result).setMsoIds(msoIds);
        }
        if (rs.getRuleSetId() != null) {
            result.setId(rs.getRuleSetId());
            result.setVersion(rs.getVersion());
        }
        result.setName(rs.getRuleName());
        result.setEnabled(rs.getEnabled());
        result.setIsEmailNotify(rs.getIsEmailNotify());
        result.setBatches(rs.getBatches());
        result.setJobLimit(rs.getJobLimit());
        result.setPackageId(Packages.lookup(packageName));
        result.setRunOnGlobal(rs.isRunOnGlobal());
        result.setSites(this.getSites(rs.getSites()));
        if (rs.getFilter() != null) {
            result.setTitleFilter(this.titleFilterService.convertTitleFilter(rs.getFilter()));
        }
        for (TreEvent e : rs.getEvents()) {
            result.addEvent(new UIEvent(e.name(), true));
        }
        if (rs.getRules() != null) {
            for (TreRule r : rs.getRules()) {
                if (r.getRuleType().equals((Object)TreRule.RuleType.STANDARD_RULE)) {
                    result.addRule(this.convertStandardRule((TreStandardRule)r));
                    continue;
                }
                if (!r.getRuleType().equals((Object)TreRule.RuleType.CUSTOME_RULE)) continue;
                result.addRule(this.covertCustomRule((TreCustomRule)r));
            }
        }
        if (rs.getScheduleRule() != null) {
            ScheduleConvertor scheduleConvertor = new ScheduleConvertor();
            ScheduleInfo scheduleInfo = scheduleConvertor.convertScheduleRule(rs.getScheduleRule());
            result.setScheduleInfo(scheduleInfo);
        }
        return result;
    }

    private UiCustomRule covertCustomRule(TreCustomRule cr) {
        int id = cr.getRuleId();
        String className = cr.getClassName();
        List<UIAction> actions = this.convertActions((TreRule)cr);
        List<UiCustomRuleParameter> params = this.convertCustomParameters(cr.getParameters());
        return new UiCustomRule(id, actions, className, params);
    }

    private List<UiCustomRuleParameter> convertCustomParameters(List<TreCustomRuleParameter> params) {
        ArrayList<UiCustomRuleParameter> result = new ArrayList<UiCustomRuleParameter>();
        for (TreCustomRuleParameter param : params) {
            result.add(new UiCustomRuleParameter(param.getKey(), param.getValue()));
        }
        return result;
    }

    private UiStandardRule convertStandardRule(TreStandardRule sr) throws TitleFilterServiceError {
        int id = sr.getRuleId();
        UITitleFilterListNode conditions = (UITitleFilterListNode)this.titleFilterService.convertExpNode(sr.getConditions());
        List<UIAction> actions = this.convertActions((TreRule)sr);
        return new UiStandardRule(id, conditions, actions);
    }

    @Override
    public int saveRuleSet(UIRuleSet ruleSet) throws NeptuneException {
        return this.saveRuleSet(ruleSet, true);
    }

    @Override
    @Transactional
    public int saveRuleSet(UIRuleSet ruleSet, boolean skipCheck) throws NeptuneException {
        UIRuleSet uIRuleSet = ruleSet;
        boolean bl = skipCheck;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = UiRulesServiceImpl.class.getDeclaredMethod("saveRuleSet", UIRuleSet.class, Boolean.TYPE).getAnnotation(Transactional.class);
        }
        return Conversions.intValue((Object)UiRulesServiceImpl.saveRuleSet_aroundBody9$advice(this, uIRuleSet, bl, transactionEnforcer, (Transactional)annotation, null));
    }

    @Transactional
    private List<Integer> getAllSitesIdFromUISite(List<UISite> selectedSites) {
        List<UISite> list = selectedSites;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = UiRulesServiceImpl.class.getDeclaredMethod("getAllSitesIdFromUISite", List.class).getAnnotation(Transactional.class);
        }
        return (List)UiRulesServiceImpl.getAllSitesIdFromUISite_aroundBody11$advice(this, list, transactionEnforcer, (Transactional)annotation, null);
    }

    private List<UIRuleServiceErrorMessage> convertErrorMessage(List<RuleServiceStatus> reasons) {
        ArrayList<UIRuleServiceErrorMessage> result = new ArrayList<UIRuleServiceErrorMessage>();
        for (RuleServiceStatus r : reasons) {
            result.add(new UIRuleServiceErrorMessage(r.getErrorCode(), r.getParameters()));
        }
        return result;
    }

    private List<UIAction> convertActions(TreRule rule) {
        ArrayList<UIAction> uiActions = new ArrayList<UIAction>();
        for (TreAction taction : rule.getActions()) {
            FieldLookupService.FieldInfo fieldRight;
            FieldLookupService.FieldInfo fieldLeft;
            UIAction uiAction = new UIAction(taction.getMethod(), taction.getActionId());
            uiActions.add(uiAction);
            FieldType fieldTypeLhs = FieldType.ASSET;
            String assetTypeLhs = "";
            String xpathLhs = "";
            String assetTypeRhs = "";
            String xpathRhs = "";
            for (TreActionParameterValue param : taction.getParams()) {
                String paramVal = param.getValue();
                uiAction.addParam(param.getName(), paramVal);
                if (param.getName().equals(ActionParams.FIELDTYPE.getName())) {
                    fieldTypeLhs = FieldType.valueOf((String)param.getValue());
                }
                if (param.getName().equals(ActionParams.SECTIONTYPE.getName())) {
                    assetTypeLhs = param.getValue();
                }
                if (param.getName().equals(ActionParams.SECTIONTYPERHS.getName())) {
                    assetTypeRhs = param.getValue();
                }
                if (param.getName().equals(ActionParams.XPATH.getName())) {
                    xpathLhs = param.getValue();
                }
                if (!param.getName().equals(ActionParams.XPATHRHS.getName())) continue;
                xpathRhs = param.getValue();
            }
            FieldLookupService fls = FieldLookupService.getInstance();
            if (!(assetTypeLhs.isEmpty() && xpathLhs.isEmpty() || (fieldLeft = fls.getDisplayName(fieldTypeLhs, assetTypeLhs, xpathLhs)) == null)) {
                uiAction.addParam(ActionParams.DATATYPELHS.getName(), fieldLeft.getDataType().getDataTypeName());
                uiAction.addParam(ActionParams.DISPLAYNAMELHS.getName(), fieldLeft.getDisplayName());
                uiAction.addParam(ActionParams.COMPLEXTYPELHS.getName(), fieldLeft.getComplexType());
                uiAction.addParam(ActionParams.EXTENDEDDISPLAYNAMELHS.getName(), fieldLeft.getFullDisplayName());
            }
            if (assetTypeRhs.isEmpty() || (fieldRight = fls.getDisplayName(FieldType.ASSET, assetTypeRhs, xpathRhs)) == null) continue;
            uiAction.addParam(ActionParams.DATATYPERHS.getName(), fieldRight.getDataType().getDataTypeName());
            uiAction.addParam(ActionParams.DISPLAYNAMERHS.getName(), fieldRight.getDisplayName());
            uiAction.addParam(ActionParams.COMPLEXTYPERHS.getName(), fieldRight.getComplexType());
            uiAction.addParam(ActionParams.EXTENDEDDISPLAYNAMERHS.getName(), fieldRight.getFullDisplayName());
        }
        return uiActions;
    }

    public String getRelativePath() {
        return "service/rules/uiRulesService";
    }

    @Transactional
    private TreRuleSet convertUIRuleSetToRuleSet(UIRuleSet rs) throws NeptuneException {
        UIRuleSet uIRuleSet = rs;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$6;
        if (annotation == null) {
            annotation = ajc$anno$6 = UiRulesServiceImpl.class.getDeclaredMethod("convertUIRuleSetToRuleSet", UIRuleSet.class).getAnnotation(Transactional.class);
        }
        return (TreRuleSet)UiRulesServiceImpl.convertUIRuleSetToRuleSet_aroundBody13$advice(this, uIRuleSet, transactionEnforcer, (Transactional)annotation, null);
    }

    private void handleRules(UIRuleSet rs, TreRuleSet result) {
        if (result.getRules() != null && result.getRules().size() > 0) {
            this.updateRules(rs, result);
        } else {
            this.util.createRules(rs, result);
        }
    }

    private void updateRules(UIRuleSet rs, TreRuleSet result) {
        Iterator deleteIterator = result.getRules().iterator();
        while (deleteIterator.hasNext()) {
            TreRule trule = (TreRule)deleteIterator.next();
            boolean found = false;
            for (UiRule r : rs.getRules()) {
                if (r.getId() != trule.getRuleId().intValue()) continue;
                found = true;
                break;
            }
            if (found) continue;
            deleteIterator.remove();
        }
        List<UiRule> uirules = rs.getRules();
        int uiruleIndex = 0;
        while (uiruleIndex < uirules.size()) {
            UiRule uirule = uirules.get(uiruleIndex);
            boolean found = false;
            List resultRules = result.getRules();
            int truleIndex = 0;
            while (truleIndex < resultRules.size()) {
                TreRule trule = (TreRule)resultRules.get(truleIndex);
                if (trule.getRuleId() != null && uirule.getId() == trule.getRuleId().intValue()) {
                    this.util.convertRule(trule, uirule);
                    found = true;
                    if (truleIndex < uiruleIndex) {
                        resultRules.remove(truleIndex);
                        resultRules.add(uiruleIndex - 1, trule);
                        break;
                    }
                    if (truleIndex <= uiruleIndex) break;
                    resultRules.remove(truleIndex);
                    resultRules.add(uiruleIndex, trule);
                    break;
                }
                ++truleIndex;
            }
            if (!found) {
                resultRules.add(uiruleIndex, this.util.createRule(uirule));
            }
            ++uiruleIndex;
        }
    }

    private Set<TreEvent> getEvents(UIRuleSet rs) throws EventRetrivalException {
        List<UIEvent> uievents = rs.getEvents();
        HashSet<TreEvent> events = null;
        for (UIEvent e : uievents) {
            if (!e.isEnabled()) continue;
            if (events == null) {
                events = new HashSet<TreEvent>();
            }
            events.add(TreEvent.valueOf((String)e.getEventType().name()));
        }
        return events;
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    @Override
    public void deleteRuleSet(List<Integer> ruleSetIds) throws NeptuneException {
        if (!this.authorizationService.isAuthorized("RulesManagement_Delete")) {
            throw new NeptuneException("You are not authorized to perform this action.");
        }
        try {
            this.deleteRuleSets(ruleSetIds);
        }
        catch (RuleDeleteException e) {
            throw new RuleServiceException(this.convertErrorMessage(e.getReasons()));
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuleDeleteException) {
                List<UIRuleServiceErrorMessage> reasons = this.convertErrorMessage(((RuleDeleteException)cause).getReasons());
                throw new RuleServiceException(reasons);
            }
            throw e;
        }
    }

    private void deleteRuleSets(List<Integer> ruleSetIds) throws RuleDeleteException {
        this.ruleManager.deleteRuleSets(ruleSetIds);
    }

    @Override
    public void saveAndRunRuleSet(UIRuleSet ruleSet) throws NeptuneException {
        int ruleSetId = this.saveRuleSet(ruleSet);
        logger.info((Object)("Running against all titles the normalization rule with id: " + ruleSetId));
        WorkflowMessage message = WorkflowMessageFactory.createControlMessage((String)UID);
        WPCLCommand command = new WPCLCommand(COMMAND_NAME);
        message.setCommand(command);
        message.getPayload().putValue("ruleSetId", Integer.toString(ruleSetId));
        SoapRouter router = new SoapRouter();
        try {
            router.send(this.getMessage(message));
            logger.info((Object)"Kicked off batch normalization template.");
        }
        catch (Exception e) {
            logger.error((Object)"Error occurred while kicking off batch normalization template.", (Throwable)e);
        }
    }

    private IMessage getMessage(WorkflowMessage wpcl) throws Exception {
        Document document = Marshaller.newMarshaller().marshal(wpcl);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(document.getDocumentElement()), new StreamResult(writer));
        return new MessageImpl((IPayload)new StringPayload(writer.getBuffer().toString()));
    }

    @Override
    public void disableRuleSets(List<Integer> ruleSetIds) throws NeptuneException {
        this.setRuleSetsEnabled(ruleSetIds, false);
    }

    @Override
    public void enableRuleSets(List<Integer> ruleSetIds) throws NeptuneException {
        this.setRuleSetsEnabled(ruleSetIds, true);
    }

    @Transactional
    private void setRuleSetsEnabled(List<Integer> ruleSetIds, boolean enabled) throws NeptuneException {
        List<Integer> list = ruleSetIds;
        boolean bl = enabled;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$7;
        if (annotation == null) {
            annotation = ajc$anno$7 = UiRulesServiceImpl.class.getDeclaredMethod("setRuleSetsEnabled", List.class, Boolean.TYPE).getAnnotation(Transactional.class);
        }
        UiRulesServiceImpl.setRuleSetsEnabled_aroundBody15$advice(this, list, bl, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    public UiCustomRuleTree getCustomRules(String packageName) throws NeptuneException {
        if (!this.authorizationService.isAuthorized("RulesManagement_View")) {
            throw new NeptuneException("You are not authorized to view this data.");
        }
        CustomRuleProvider crps = CustomRuleProvider.getInstance();
        UiCustomRuleTree tree = new UiCustomRuleTree();
        try {
            List cRules = crps.getCustomRules(packageName);
            Locale locale = ClientLocaleProvider.getClientLocaleProvider().getLocale();
            for (CustomRule cr : cRules) {
                try {
                    List params = cr.getParameters(locale);
                    ArrayList<UiDisplayCustRuleParam> uiParams = new ArrayList<UiDisplayCustRuleParam>();
                    for (CustomRuleParameter crv : params) {
                        uiParams.add(new UiDisplayCustRuleParam(crv.getKey(), crv.getDisplayName(), UiDisplayCustRuleParam.VariableDataType.valueOf(crv.getDataType().name())));
                    }
                    tree.addRule(new DisplayCustomRule(cr.getName(locale), cr.getClass().getName(), uiParams));
                }
                catch (Exception e) {
                    String msg = "Could not load custom rule: " + cr.getClass().getName();
                    logger.error((Object)msg, (Throwable)e);
                }
            }
            return tree;
        }
        catch (CustomRuleLoadException e) {
            logger.error((Object)e);
            throw new NeptuneException("Error retrieving custom rules");
        }
    }

    @Override
    public boolean customRulesExist(String packageName) throws NeptuneException {
        CustomRuleProvider crps = CustomRuleProvider.getInstance();
        try {
            return !crps.getCustomRules(packageName).isEmpty();
        }
        catch (CustomRuleLoadException e) {
            logger.error((Object)e);
            return false;
        }
    }

    @Override
    public boolean isCurrentUserAssociatedSelfPartner() {
        List partners = this.partnerService.getPartnersByCurrentUser();
        for (Partner p : partners) {
            if (!p.getType().equals((Object)PartnerType.SELF)) continue;
            return true;
        }
        return false;
    }

    private static final /* synthetic */ List getRuleSetsByPackage_aroundBody0(UiRulesServiceImpl ajc$this, String packageName) {
        if (!ajc$this.authorizationService.isAuthorized("RulesManagement_View")) {
            throw new NeptuneException("You are not authorized to view this data.");
        }
        ArrayList<UIRuleListItem> result = new ArrayList<UIRuleListItem>();
        try {
            TrePackage pkg = ajc$this.packageManager.getPackageByNameFirstMatching(packageName);
            boolean isTargetingPkg = pkg.getName().equals("TARGETING");
            List rulesets = pkg.getRuleSets();
            for (TreRuleSet r : rulesets) {
                UIRuleListItem uiRuleListItem;
                String uuid;
                if (r == null) continue;
                int id = r.getRuleSetId();
                String name = r.getRuleName();
                boolean enabled = r.getEnabled();
                ArrayList<UISite> sites = new ArrayList<UISite>();
                for (Site s : r.getSites()) {
                    int sid = s.getId();
                    String sname = s.getName();
                    boolean active = s.isActive();
                    SiteType stype = SiteType.LOGICAL;
                    if (s instanceof DistributionSite) {
                        stype = SiteType.DISTRIBUTION;
                    }
                    UISite site = new UISite(sid, sname, stype, active);
                    if (stype.equals((Object)SiteType.LOGICAL) && !s.getSiteChildren().isEmpty()) {
                        ArrayList<UISite> uiChidrenList = new ArrayList<UISite>();
                        for (Site childSite : s.getSiteChildren()) {
                            uiChidrenList.add(new UISite(childSite.getId(), childSite.getName(), SiteType.DISTRIBUTION, childSite.isActive()));
                        }
                        site.setChildren(uiChidrenList);
                    }
                    sites.add(site);
                }
                String updateDate = dateFormatter.format(r.getUpdateDate());
                String string = uuid = r.getUuid() != null ? r.getUuid().toString() : "";
                if (pkg.getName().equals("MSOOVERRIDE")) {
                    HashSet<UiMso> msos = new HashSet<UiMso>();
                    if (((TreMsoOverrrideRuleSet)r).getMsos() != null) {
                        for (MSO mso : ((TreMsoOverrrideRuleSet)r).getMsos()) {
                            msos.add(new UiMso(mso.getId(), mso.getMsoName()));
                        }
                    }
                    uiRuleListItem = new UIMsoRuleListItem(id, name, enabled, (Set<UiMso>)msos, updateDate, uuid);
                } else {
                    uiRuleListItem = new UIRuleListItem(id, name, enabled, sites, updateDate, uuid);
                }
                if (isTargetingPkg) {
                    boolean areAllDepSiteSelected = ajc$this.sitesDepSvc.areAllDependencySitesSelected(ajc$this.getAllSitesIdFromUISite(new ArrayList<UISite>(uiRuleListItem.getSites())));
                    uiRuleListItem.setAllDepSitesSelected(areAllDepSiteSelected);
                }
                result.add(uiRuleListItem);
            }
        }
        catch (PackageRetrievalException e1) {
            RulePersistenceException ex = new RulePersistenceException();
            ex.setStackTrace(e1.getStackTrace());
            throw ex;
        }
        return result;
    }

    private static final /* synthetic */ Object getRuleSetsByPackage_aroundBody1$advice(UiRulesServiceImpl ajc$this, String packageName, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return UiRulesServiceImpl.getRuleSetsByPackage_aroundBody0(ajc$this, packageName);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = UiRulesServiceImpl.getRuleSetsByPackage_aroundBody0(ajc$this, packageName);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Packages getPackageType_aroundBody2(UiRulesServiceImpl ajc$this, int ruleSetId) {
        if (!ajc$this.authorizationService.isAuthorized("RulesManagement_View")) {
            throw new NeptuneException("You are not authorized to view this data.");
        }
        try {
            return Packages.lookup(ajc$this.ruleManager.getRuleSet(ruleSetId).getTpackage().getName());
        }
        catch (RuntimeException ex) {
            if (ex.getCause() instanceof NoResultException) {
                throw new RuleSetDoesntExist();
            }
            throw ex;
        }
    }

    private static final /* synthetic */ Object getPackageType_aroundBody3$advice(UiRulesServiceImpl ajc$this, int ruleSetId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return UiRulesServiceImpl.getPackageType_aroundBody2(ajc$this, ruleSetId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Packages object = UiRulesServiceImpl.getPackageType_aroundBody2(ajc$this, ruleSetId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void saveRuleSetOrder_aroundBody4(UiRulesServiceImpl ajc$this, String pkgName, List list) {
        if (!ajc$this.authorizationService.isAuthorized("RulesManagement_Modify")) {
            throw new NeptuneException("You are not authorized to perform this action.");
        }
        try {
            List rulesets = ajc$this.ruleManager.getRuleSetsByPackage(pkgName);
            IRuleManagerCache ruleCache = (IRuleManagerCache)InjectionUtil.injectInstance((String)"cms/RuleManagerCache/local", IRuleManagerCache.class);
            int i = 0;
            for (UIRuleListItem item : list) {
                TreRuleSet ruleset = ajc$this.getByID(rulesets, item.getId());
                if (ruleset == null) continue;
                rulesets.remove(rulesets.indexOf(ruleset));
                rulesets.add(i, ruleset);
                ruleset.setOrder_(Integer.valueOf(i));
                ajc$this.ruleManager.saveRuleSetOrder(ruleset);
                ++i;
            }
            ruleCache.loadCache(pkgName);
        }
        catch (Exception e) {
            RulePersistenceException ex = new RulePersistenceException();
            ex.setStackTrace(e.getStackTrace());
            throw ex;
        }
    }

    private static final /* synthetic */ Object saveRuleSetOrder_aroundBody5$advice(UiRulesServiceImpl ajc$this, String pkgName, List list, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            UiRulesServiceImpl.saveRuleSetOrder_aroundBody4(ajc$this, pkgName, list);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UiRulesServiceImpl.saveRuleSetOrder_aroundBody4(ajc$this, pkgName, list);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ UIRuleSet getRuleSet_aroundBody6(UiRulesServiceImpl ajc$this, int ruleSetId) {
        if (!ajc$this.authorizationService.isAuthorized("RulesManagement_View")) {
            throw new NeptuneException("You are not authorized to view this data.");
        }
        try {
            TreRuleSet rs = ajc$this.ruleManager.getRuleSetWithSchedule(ruleSetId);
            return ajc$this.convertRuleSetToUIRuleSet(rs, rs.getTpackage().getName());
        }
        catch (RuntimeException ex) {
            logger.error((Object)ex);
            if (ex.getCause() instanceof NoResultException) {
                throw new RuleSetDoesntExist();
            }
            throw ex;
        }
    }

    private static final /* synthetic */ Object getRuleSet_aroundBody7$advice(UiRulesServiceImpl ajc$this, int ruleSetId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return UiRulesServiceImpl.getRuleSet_aroundBody6(ajc$this, ruleSetId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UIRuleSet object = UiRulesServiceImpl.getRuleSet_aroundBody6(ajc$this, ruleSetId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ int saveRuleSet_aroundBody8(UiRulesServiceImpl ajc$this, UIRuleSet ruleSet, boolean skipCheck) {
        if (ruleSet.isNew() && !ajc$this.authorizationService.isAuthorized("RulesManagement_Create")) {
            throw new NeptuneException("You are not authorized to perform this action.");
        }
        if (!ruleSet.isNew() && !ajc$this.authorizationService.isAuthorized("RulesManagement_Modify")) {
            throw new NeptuneException("You are not authorized to perform this action.");
        }
        if (!skipCheck && !ajc$this.sitesDepSvc.areAllDependencySitesSelected(ajc$this.getAllSitesIdFromUISite(ruleSet.getSites())).booleanValue()) {
            throw new RuleTargetingDoesntHaveAllDependencySites("Warning! Targeting Rule doesnt have all dependency sites.");
        }
        try {
            logger.debug((Object)"Saving RuleSet");
            TreRuleSet result = ajc$this.convertUIRuleSetToRuleSet(ruleSet);
            return result.getRuleSetId();
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof UiRuleSetsAssocWJobExpception) {
                throw (UiRuleSetsAssocWJobExpception)((Object)re.getCause());
            }
            if (re.getCause() instanceof InvalidScheduleException) {
                InvalidScheduleException ise = (InvalidScheduleException)re.getCause();
                throw new UiInvalidScheduleException(ise.getReasons());
            }
            throw re;
        }
    }

    private static final /* synthetic */ Object saveRuleSet_aroundBody9$advice(UiRulesServiceImpl ajc$this, UIRuleSet ruleSet, boolean skipCheck, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.intObject((int)UiRulesServiceImpl.saveRuleSet_aroundBody8(ajc$this, ruleSet, skipCheck));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.intObject((int)UiRulesServiceImpl.saveRuleSet_aroundBody8(ajc$this, ruleSet, skipCheck));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getAllSitesIdFromUISite_aroundBody10(UiRulesServiceImpl ajc$this, List selectedSites) {
        ArrayList<Integer> siteIds = new ArrayList<Integer>();
        for (UISite site : selectedSites) {
            if (!site.getChildren().isEmpty() && site.getSiteType().equals((Object)SiteType.LOGICAL)) {
                for (UISite childrenSite : site.getChildren()) {
                    if (!childrenSite.getSiteType().equals((Object)SiteType.DISTRIBUTION)) continue;
                    siteIds.add(childrenSite.getId());
                }
                continue;
            }
            siteIds.add(site.getId());
        }
        return siteIds;
    }

    private static final /* synthetic */ Object getAllSitesIdFromUISite_aroundBody11$advice(UiRulesServiceImpl ajc$this, List selectedSites, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return UiRulesServiceImpl.getAllSitesIdFromUISite_aroundBody10(ajc$this, selectedSites);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = UiRulesServiceImpl.getAllSitesIdFromUISite_aroundBody10(ajc$this, selectedSites);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ TreRuleSet convertUIRuleSetToRuleSet_aroundBody12(UiRulesServiceImpl ajc$this, UIRuleSet rs) {
        Object result = null;
        TrePackage pack = null;
        try {
            pack = ajc$this.packageManager.getPackageByNameFirstMatching(rs.getPackageId().toString());
        }
        catch (PackageRetrievalException e1) {
            RulePersistenceException ex = new RulePersistenceException();
            ex.setStackTrace(e1.getStackTrace());
            throw ex;
        }
        if (rs.isNew()) {
            result = pack.getName().equals("MSOOVERRIDE") ? new TreMsoOverrrideRuleSet() : new TreRuleSet();
            pack.getRuleSets().add(result);
            result.setTpackage(pack);
            result.setOrder_(Integer.valueOf(pack.getRuleSets().size() - 1));
        } else {
            result = ajc$this.ruleManager.getRuleSet(rs.getId());
        }
        if (pack.getName().equals("MSOOVERRIDE")) {
            HashSet<MSO> msos = new HashSet<MSO>();
            ((TreMsoOverrrideRuleSet)result).setMsos(msos);
            for (Integer msoId : ((UIMSORuleSet)rs).getMsoIds()) {
                MSO mso = new MSO();
                mso.setId(msoId);
                msos.add(mso);
            }
        }
        result.setRuleName(rs.getName());
        result.setEnabled(Boolean.valueOf(rs.isEnabled()));
        result.setIsEmailNotify(Boolean.valueOf(rs.getIsEmailNotify()));
        result.setRunOnGlobal(rs.isRunOnGlobal());
        result.setBatches(rs.getBatches());
        result.setJobLimit(rs.getJobLimit());
        result.setUiUpdate(true);
        if (result.getSites() == null) {
            result.setSites(new HashSet());
        } else {
            result.getSites().clear();
        }
        result.getSites().addAll(ajc$this.util.getSites(rs.getSites()));
        Date updateDate = new Date();
        if (rs.isNew()) {
            result.setCreateDate(updateDate);
        }
        result.setUpdateDate(updateDate);
        try {
            result.setEvents(ajc$this.getEvents(rs));
        }
        catch (EventRetrivalException e) {
            throw new RulePersistenceException(e.getStackTrace());
        }
        if (rs.getScheduleInfo() != null) {
            ScheduleConvertor scheduleConvertor = new ScheduleConvertor();
            result.setScheduleRule(scheduleConvertor.convertScheduleInfo(rs.getScheduleInfo()));
        }
        if (rs.getTitleFilter() != null) {
            if (result.getFilter() == null) {
                result.setFilter(new TitleFilter());
            }
            ajc$this.titleFilterService.convertTitleFilter(result.getFilter(), rs.getTitleFilter());
        }
        if (rs.getRules() != null) {
            ajc$this.handleRules(rs, (TreRuleSet)result);
        }
        ajc$this.ruleManager.saveRuleSet(result);
        return result;
    }

    private static final /* synthetic */ Object convertUIRuleSetToRuleSet_aroundBody13$advice(UiRulesServiceImpl ajc$this, UIRuleSet rs, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return UiRulesServiceImpl.convertUIRuleSetToRuleSet_aroundBody12(ajc$this, rs);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TreRuleSet object = UiRulesServiceImpl.convertUIRuleSetToRuleSet_aroundBody12(ajc$this, rs);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void setRuleSetsEnabled_aroundBody14(UiRulesServiceImpl ajc$this, List ruleSetIds, boolean enabled) {
        UIRuleServiceErrorMessage reason;
        ArrayList<String> parameters;
        String errorCode;
        Integer problemRuleSetId;
        boolean unauthorized;
        if (!ajc$this.authorizationService.isAuthorized("RulesManagement_Modify")) {
            throw new NeptuneException("You are not authorized to perform this action.");
        }
        List ruleSets = null;
        if (!ajc$this.authorizationService.isAuthorized(Permissions.SCHEDULER_MODIFY)) {
            unauthorized = false;
            problemRuleSetId = null;
            ruleSets = ajc$this.ruleManager.getRuleSetsWithSchedule(ruleSetIds);
            for (TreRuleSet ruleSet : ruleSets) {
                ScheduleRule scheduleRule = ruleSet.getScheduleRule();
                if (scheduleRule == null) continue;
                unauthorized = true;
                problemRuleSetId = ruleSet.getRuleSetId();
                break;
            }
            if (unauthorized) {
                errorCode = "errScheduleModifyNotAuthorized";
                parameters = new ArrayList();
                parameters.add(String.valueOf(problemRuleSetId));
                reason = new UIRuleServiceErrorMessage(errorCode, parameters);
                ArrayList<UIRuleServiceErrorMessage> reasons = new ArrayList<UIRuleServiceErrorMessage>();
                reasons.add(reason);
                throw new RuleServiceException(reasons);
            }
        }
        if (!ajc$this.authorizationService.isAuthorized(Permissions.SITES_MODIFY)) {
            unauthorized = false;
            problemRuleSetId = null;
            if (ruleSets == null) {
                ruleSets = ajc$this.ruleManager.getRuleSets((Collection)ruleSetIds);
            }
            for (TreRuleSet ruleSet : ruleSets) {
                Set associatedSites = ruleSet.getSites();
                if (associatedSites == null || associatedSites.size() <= 0) continue;
                unauthorized = true;
                problemRuleSetId = ruleSet.getRuleSetId();
                break;
            }
            if (unauthorized) {
                errorCode = "errSiteModifyNotAuthorized";
                parameters = new ArrayList<String>();
                parameters.add(String.valueOf(problemRuleSetId));
                reason = new UIRuleServiceErrorMessage(errorCode, parameters);
                ArrayList<UIRuleServiceErrorMessage> reasons = new ArrayList<UIRuleServiceErrorMessage>();
                reasons.add(reason);
                throw new RuleServiceException(reasons);
            }
        }
        ajc$this.ruleManager.setRuleSetsEnabled(ruleSetIds, enabled);
    }

    private static final /* synthetic */ Object setRuleSetsEnabled_aroundBody15$advice(UiRulesServiceImpl ajc$this, List ruleSetIds, boolean enabled, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            UiRulesServiceImpl.setRuleSetsEnabled_aroundBody14(ajc$this, ruleSetIds, enabled);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UiRulesServiceImpl.setRuleSetsEnabled_aroundBody14(ajc$this, ruleSetIds, enabled);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

