/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.server;

import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.LogicalSite;
import com.ericsson.cms.sites.core.entities.Site;
import com.ericsson.cms.sites.core.entities.mediapath.MSO;
import com.ericsson.cms.sites.core.mediapath.IMSOManager;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.cms.rules.ui.client.UiRulesSiteFetcher;
import com.tandbergtv.cms.rules.ui.client.common.site.SiteType;
import com.tandbergtv.cms.rules.ui.client.common.site.UISite;
import com.tandbergtv.cms.rules.ui.client.msooverride.UiMso;
import com.tandbergtv.neptune.authorization.service.IAuthorizationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;

public class UiRulesSiteFetcherImpl
implements UiRulesSiteFetcher,
NeptuneRemoteService {
    private static final String NO_PERMISSION = "You are not authorized to view this data.";
    private static final Logger logger = Logger.getLogger(UiRulesSiteFetcherImpl.class);
    private IAuthorizationService authorizationService = (IAuthorizationService)InjectionUtil.injectInstance((String)"cms/AuthorizationService/local", IAuthorizationService.class);
    private IMSOManager msoManager = (IMSOManager)InjectionUtil.injectInstance((String)"cms/MSOManager/local", IMSOManager.class);
    private ISiteManager siteManager;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;

    public UiRulesSiteFetcherImpl() {
        try {
            this.siteManager = (ISiteManager)InjectionUtil.injectInstance((String)"cms/SiteManager/local", ISiteManager.class);
        }
        catch (Exception e) {
            this.siteManager = null;
            logger.warn((Object)"Could locate site service within rules component.", (Throwable)e);
        }
    }

    @Override
    public List<UISite> getSites() throws NeptuneException {
        if (!this.authorizationService.isAuthorized("RulesManagement_View")) {
            throw new NeptuneException(NO_PERMISSION);
        }
        return this.getSitesHelper();
    }

    @Transactional
    public List<UISite> getSitesHelper() {
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = UiRulesSiteFetcherImpl.class.getDeclaredMethod("getSitesHelper", new Class[0]).getAnnotation(Transactional.class);
        }
        return (List)UiRulesSiteFetcherImpl.getSitesHelper_aroundBody1$advice(this, transactionEnforcer, (Transactional)annotation, null);
    }

    private void siteConverter(List<UISite> uiSites, Collection<Site> sites) {
        for (Site s : sites) {
            if (s instanceof DistributionSite) {
                DistributionSite ds = (DistributionSite)s;
                uiSites.add(new UISite(ds.getId(), ds.getName(), SiteType.DISTRIBUTION, ds.isActive()));
                continue;
            }
            if (!(s instanceof LogicalSite)) continue;
            LogicalSite ls = (LogicalSite)s;
            UISite uiSite = new UISite(ls.getId(), ls.getName(), SiteType.LOGICAL, ls.isActive());
            uiSites.add(uiSite);
            if (ls.getSiteChildren() == null) continue;
            this.siteConverter(uiSite.getChildren(), ls.getSiteChildren());
        }
    }

    public String getRelativePath() {
        return "service/rules/uiRulesSiteFetcher";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    @Override
    @Transactional
    public List<UiMso> getMsos() throws NeptuneException {
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = UiRulesSiteFetcherImpl.class.getDeclaredMethod("getMsos", new Class[0]).getAnnotation(Transactional.class);
        }
        return (List)UiRulesSiteFetcherImpl.getMsos_aroundBody3$advice(this, transactionEnforcer, (Transactional)annotation, null);
    }

    private static final /* synthetic */ List getSitesHelper_aroundBody0(UiRulesSiteFetcherImpl ajc$this) {
        if (ajc$this.siteManager == null) {
            return new ArrayList();
        }
        List sites = ajc$this.siteManager.getTopLevelSites();
        ArrayList<UISite> result = new ArrayList<UISite>();
        ajc$this.siteConverter(result, sites);
        return result;
    }

    private static final /* synthetic */ Object getSitesHelper_aroundBody1$advice(UiRulesSiteFetcherImpl ajc$this, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return UiRulesSiteFetcherImpl.getSitesHelper_aroundBody0(ajc$this);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = UiRulesSiteFetcherImpl.getSitesHelper_aroundBody0(ajc$this);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getMsos_aroundBody2(UiRulesSiteFetcherImpl ajc$this) {
        ArrayList<UiMso> uiMsos = new ArrayList<UiMso>();
        List msos = ajc$this.msoManager.getAllMSOs();
        for (MSO mso : msos) {
            uiMsos.add(new UiMso(mso.getId(), mso.getMsoName()));
        }
        return uiMsos;
    }

    private static final /* synthetic */ Object getMsos_aroundBody3$advice(UiRulesSiteFetcherImpl ajc$this, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return UiRulesSiteFetcherImpl.getMsos_aroundBody2(ajc$this);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = UiRulesSiteFetcherImpl.getMsos_aroundBody2(ajc$this);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

