/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.server;

import com.tandbergtv.cms.rules.ui.client.UiRulesTemplateFetcher;
import com.tandbergtv.cms.rules.ui.client.contentprocessing.UiWorkflowTemplate;
import com.tandbergtv.neptune.authorization.service.IAuthorizationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.title.template.ITitleTemplateProvider;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.List;

public class UiTemplateFetcherImpl
implements NeptuneRemoteService,
UiRulesTemplateFetcher {
    private static final String NO_PERMISSION = "You are not authorized to view this data.";
    private IAuthorizationService authorizationService = (IAuthorizationService)InjectionUtil.injectInstance((String)"cms/AuthorizationService/local", IAuthorizationService.class);

    @Override
    public List<UiWorkflowTemplate> getTemplates() throws NeptuneException {
        if (!this.authorizationService.isAuthorized("RulesManagement_View")) {
            throw new NeptuneException(NO_PERMISSION);
        }
        ArrayList<UiWorkflowTemplate> result = new ArrayList<UiWorkflowTemplate>();
        ITitleTemplateProvider service = (ITitleTemplateProvider)ServiceRegistry.getDefault().lookup(ITitleTemplateProvider.class);
        for (String templateName : service.getTemplateNamesByCategory("ContentProcessing")) {
            result.add(new UiWorkflowTemplate(templateName));
        }
        for (String templateName : service.getTemplateNamesByCategory("LocalContentProcessing")) {
            UiWorkflowTemplate uiTemplate = new UiWorkflowTemplate(templateName);
            if (result.contains(uiTemplate)) continue;
            result.add(uiTemplate);
        }
        return result;
    }

    public String getRelativePath() {
        return "service/rules/uiRulesTemplateFetcher";
    }

    public Class<?> getServiceImplementation() {
        return UiTemplateFetcherImpl.class;
    }
}

