/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.server.util;

import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.LogicalSite;
import com.ericsson.cms.sites.core.entities.Site;
import com.tandbergtv.cms.portal.ui.title.server.search.UiTitleFilterService;
import com.tandbergtv.cms.rules.ui.client.common.site.SiteType;
import com.tandbergtv.cms.rules.ui.client.common.site.UISite;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import com.tandbergtv.cms.rules.ui.client.data.UIActionParam;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.cms.rules.ui.client.data.UiRule;
import com.tandbergtv.cms.rules.ui.client.data.UiRuleType;
import com.tandbergtv.cms.rules.ui.client.data.UiStandardRule;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiCustomRule;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiCustomRuleParameter;
import com.tandbergtv.cms.titlefilter.TitleFilter;
import com.tandbergtv.marvin.udt.TreAction;
import com.tandbergtv.marvin.udt.TreActionParameterValue;
import com.tandbergtv.marvin.udt.TreCustomRule;
import com.tandbergtv.marvin.udt.TreCustomRuleParameter;
import com.tandbergtv.marvin.udt.TrePackage;
import com.tandbergtv.marvin.udt.TreRule;
import com.tandbergtv.marvin.udt.TreRuleSet;
import com.tandbergtv.marvin.udt.TreStandardRule;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class RulesServiceUtil {
    private UiTitleFilterService titleFilterService = new UiTitleFilterService();

    public TreRuleSet convertUIRuleSetToTreRuleSetForRulePreview(UIRuleSet rs) throws NeptuneException {
        TreRuleSet result = new TreRuleSet();
        result.setTpackage(new TrePackage("NORMALIZATION"));
        result.setRuleName(rs.getName());
        result.setEnabled(Boolean.valueOf(rs.isEnabled()));
        result.setIsEmailNotify(Boolean.valueOf(rs.getIsEmailNotify()));
        result.setRunOnGlobal(rs.isRunOnGlobal());
        result.setBatches(rs.getBatches());
        result.setJobLimit(rs.getJobLimit());
        result.setUiUpdate(true);
        if (result.getSites() == null) {
            result.setSites(new HashSet());
        } else {
            result.getSites().clear();
        }
        result.getSites().addAll(this.getSites(rs.getSites()));
        Date updateDate = new Date();
        result.setCreateDate(updateDate);
        result.setUpdateDate(updateDate);
        if (rs.getTitleFilter() != null) {
            if (result.getFilter() == null) {
                result.setFilter(new TitleFilter());
            }
            this.titleFilterService.convertTitleFilter(result.getFilter(), rs.getTitleFilter());
        }
        if (rs.getRules() != null) {
            this.createRules(rs, result);
        }
        return result;
    }

    public Collection<Site> getSites(List<UISite> uisites) {
        ArrayList<Site> sites = new ArrayList<Site>();
        for (UISite s : uisites) {
            if (s.getSiteType().equals((Object)SiteType.LOGICAL)) {
                LogicalSite ls = new LogicalSite();
                ls.setId(Integer.valueOf(s.getId()));
                sites.add((Site)ls);
                continue;
            }
            if (!s.getSiteType().equals((Object)SiteType.DISTRIBUTION)) continue;
            DistributionSite ds = new DistributionSite();
            ds.setId(Integer.valueOf(s.getId()));
            sites.add((Site)ds);
        }
        return sites;
    }

    public void createRules(UIRuleSet rs, TreRuleSet result) {
        ArrayList<TreRule> rules = result.getRules();
        if (rules == null) {
            rules = new ArrayList<TreRule>();
        }
        for (UiRule r : rs.getRules()) {
            rules.add(this.createRule(r));
        }
        result.setRules(rules);
    }

    public TreRule createRule(UiRule r) {
        if (r.getRuleType().equals((Object)UiRuleType.STANDARD_RULE)) {
            UiStandardRule sr = (UiStandardRule)r;
            TreStandardRule trule = new TreStandardRule();
            this.convertRule((TreRule)trule, sr);
            return trule;
        }
        if (r.getRuleType().equals((Object)UiRuleType.CUSTOM_RULE)) {
            UiCustomRule cr = (UiCustomRule)r;
            TreCustomRule trule = new TreCustomRule();
            this.convertRule((TreRule)trule, cr);
            return trule;
        }
        throw new RuntimeException("UNKNOWN RULE TYPE");
    }

    public void convertRule(TreRule trule, UiRule uiRule) {
        if (trule instanceof TreStandardRule) {
            TreStandardRule tsRule = (TreStandardRule)trule;
            UiStandardRule uisRule = (UiStandardRule)uiRule;
            if (uisRule.getUiTitleFilterNode() != null) {
                tsRule.setConditions(this.titleFilterService.convertTree(tsRule.getConditions(), uisRule.getUiTitleFilterNode()));
            }
        } else if (trule instanceof TreCustomRule) {
            TreCustomRule tcr = (TreCustomRule)trule;
            UiCustomRule uicRule = (UiCustomRule)uiRule;
            tcr.setClassName(uicRule.getClassName());
            ArrayList<TreCustomRuleParameter> params = tcr.getParameters();
            List<UiCustomRuleParameter> uiParams = uicRule.getParameters();
            if (params != null || !uiParams.isEmpty()) {
                if (params == null) {
                    params = new ArrayList<TreCustomRuleParameter>();
                    tcr.setParameters(params);
                }
                if (params.size() != uiParams.size()) {
                    params.clear();
                    for (UiCustomRuleParameter param : uiParams) {
                        String key = param.getKey();
                        String value = param.getValue();
                        params.add(new TreCustomRuleParameter(key, value));
                    }
                } else {
                    int i = 0;
                    while (i < uiParams.size()) {
                        ((TreCustomRuleParameter)params.get(i)).setKey(uiParams.get(i).getKey());
                        ((TreCustomRuleParameter)params.get(i)).setValue(uiParams.get(i).getValue());
                        ++i;
                    }
                }
            }
        }
        this.convertAction(trule, uiRule);
    }

    private void convertAction(TreRule trule, UiRule uiRule) {
        ArrayList<TreAction> treActions = trule.getActions();
        if (treActions == null) {
            treActions = new ArrayList<TreAction>();
            trule.setActions(treActions);
        }
        List<UIAction> uiActions = uiRule.getActions();
        int i = 0;
        while (i < uiActions.size()) {
            if (i >= treActions.size()) {
                treActions.add(new TreAction());
            }
            TreAction currAction = (TreAction)treActions.get(i);
            currAction.setMethod(uiActions.get(i).getAction());
            ArrayList<TreActionParameterValue> treparams = currAction.getParams();
            if (treparams == null) {
                treparams = new ArrayList<TreActionParameterValue>();
                currAction.setParams(treparams);
            }
            List<UIActionParam> uiparams = uiActions.get(i).getAllParams();
            int j = 0;
            while (j < uiparams.size()) {
                UIActionParam currUIParam = uiparams.get(j);
                String currUIParamValue = currUIParam.getValue();
                if (j >= treparams.size()) {
                    treparams.add(new TreActionParameterValue(currUIParam.getName(), currUIParamValue));
                } else {
                    ((TreActionParameterValue)treparams.get(j)).setName(currUIParam.getName());
                    ((TreActionParameterValue)treparams.get(j)).setValue(currUIParamValue);
                }
                ++j;
            }
            ArrayList<TreActionParameterValue> tailParamsToRemove = new ArrayList<TreActionParameterValue>();
            int k = uiparams.size();
            while (k < treparams.size()) {
                tailParamsToRemove.add((TreActionParameterValue)treparams.get(k));
                ++k;
            }
            for (TreActionParameterValue param : tailParamsToRemove) {
                treparams.remove(param);
            }
            ++i;
        }
        ArrayList<TreAction> tailActionsToRemove = new ArrayList<TreAction>();
        int i2 = uiActions.size();
        while (i2 < treActions.size()) {
            tailActionsToRemove.add((TreAction)treActions.get(i2));
            ++i2;
        }
        for (TreAction t : tailActionsToRemove) {
            treActions.remove(t);
        }
    }
}

