/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduling.ui.client;

import com.ericsson.cms.scheduling.ui.client.FutureExecutionsList;
import com.ericsson.cms.scheduling.ui.client.ISchedulerTab;
import com.ericsson.cms.scheduling.ui.client.PastExecutionsList;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ExecutionsList
extends Composite {
    private static final String TAB_CONTAINER_STYLE = "scheduler-tabContainer";
    private VerticalContainer mainPanel;
    private Map<String, String> info;
    private NeptuneSecurity security;
    private MessageArea messageArea = new MessageArea();
    private TabContainer tabContainer = new TabContainer();
    private List<ISchedulerTab> tabs = new ArrayList<ISchedulerTab>();

    public ExecutionsList(Map<String, String> info, NeptuneSecurity security) {
        this.info = info;
        this.security = security;
        this.mainPanel = new VerticalContainer();
        this.mainPanel.setSize("100%", "100%");
        this.initWidget((Widget)this.mainPanel);
        this.setWidgets();
    }

    public void setWidgets() {
        this.mainPanel.clear();
        HeaderPanel headP = new HeaderPanel("Past and Future Executions");
        this.mainPanel.add((Widget)headP);
        headP.getLabel().setStyleName("schedule-header-style");
        this.messageArea.reset();
        this.mainPanel.add((Widget)this.messageArea);
        this.tabContainer.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                for (int i = 0; i < ExecutionsList.this.tabs.size(); ++i) {
                    ((ISchedulerTab)ExecutionsList.this.tabs.get(i)).setSelected(i == (Integer)event.getSelectedItem());
                }
            }
        });
        this.tabContainer.addStyleName(TAB_CONTAINER_STYLE);
        this.tabContainer.clear();
        this.mainPanel.add((Widget)this.tabContainer);
        FutureExecutionsList futureExecutionsList = new FutureExecutionsList(this.info, this.security);
        futureExecutionsList.setMessageArea(this.messageArea);
        this.tabContainer.add((Widget)futureExecutionsList, "Next " + this.info.get("scheduler.executions.numHours") + " Hours");
        this.tabs.add(futureExecutionsList);
        PastExecutionsList pastExecutionsList = new PastExecutionsList(this.info);
        pastExecutionsList.setMessageArea(this.messageArea);
        this.tabContainer.add((Widget)pastExecutionsList, "Past " + this.info.get("scheduler.executions.numHours") + " Hours");
        this.tabs.add(pastExecutionsList);
        this.tabContainer.selectTab(0);
    }

    public void showFutureExecutions() {
        this.tabContainer.selectTab(0);
    }

    public void showPastExecutions() {
        this.tabContainer.selectTab(1);
    }
}

