/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduling.ui.client;

import com.ericsson.cms.scheduling.ui.client.Action;
import com.ericsson.cms.scheduling.ui.client.common.Common;
import com.ericsson.cms.scheduling.ui.client.common.SchedulingConstants;
import com.ericsson.cms.scheduling.ui.client.data.UIWOJob;
import com.ericsson.cms.scheduling.ui.client.service.IUISchedulerService;
import com.ericsson.cms.scheduling.ui.client.service.IUISchedulerServiceAsync;
import com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidget;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FilteredSchedules
extends Composite {
    private static final String ENABLED_IMAGE = "cms_scheduling_ui/images/enabled.png";
    private static final String DISABLED_IMAGE = "cms_scheduling_ui/images/disabled.png";
    private static final String ERROR_MESSAGE_STYLE = "scheduler-errorMessage";
    private static final String INFO_MESSAGE_STYLE = "scheduler-infoMessage";
    private static final String TABLE_STYLE = "scheduler-schedulesList";
    private static final String HEADER_ROW_STYLE = "scheduler-schedulesList-header";
    private static final String DATA_ROW_STYLE = "scheduler-schedulesList-data";
    private static final String ENABLED_COL_STYLE = "scheduler-schedulesList-col-enabled";
    private static final String ID_COL_STYLE = "scheduler-schedulesList-col-id";
    private static final String ID_LINK_COL_STYLE = "scheduler-schedulesList-col-id-link";
    private static final String ANCHOR_PARAM_ASSOCIATIONTYPE = "associationType";
    private static final String ANCHOR_PARAM_ASSOCIATIONID = "associationId";
    private static final String STYLE_SCROLL_CONTAINER = "sites-jobsTab-scrollContainer";
    private IUISchedulerServiceAsync service = (IUISchedulerServiceAsync)GWT.create(IUISchedulerService.class);
    private SchedulingConstants constants = (SchedulingConstants)GWT.create(SchedulingConstants.class);
    private BusyIndicator busyIndicator = new BusyIndicator(true);
    private VerticalContainer mainPanel = new VerticalContainer();
    private MessageArea messageArea;
    private SimpleContainer tableContainer = new SimpleContainer();
    private List<CheckBoxWidget> rowCheckBoxes;
    private Set<Long> selectedIds = new HashSet<Long>();
    private String entityType;
    private Long entityId;
    HorizontalContainer buttonPanel;
    ButtonWidget dissociateButton;
    ButtonWidget createButton;
    private ScrollPanel scrollPanel = new ScrollPanel();

    public FilteredSchedules() {
        this.scrollPanel.addStyleName(STYLE_SCROLL_CONTAINER);
        this.scrollPanel.add((Widget)this.tableContainer);
        this.mainPanel.setSpacing(10);
        this.mainPanel.add((Widget)this.scrollPanel);
        this.buttonPanel = new HorizontalContainer();
        this.buttonPanel.addStyleName("cms_button_container");
        this.mainPanel.add((Widget)this.buttonPanel);
        this.createButton = new ButtonWidget(this.constants.buttonLabelCreate());
        this.createButton.removeStyleName("gwt-Button");
        this.createButton.addStyleName("ebBtn");
        this.createButton.addStyleName("ebBtn_color_green");
        this.createButton.addStyleName("create_button_icon");
        this.createButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                String anchor = "Scheduler.View.Create";
                if (FilteredSchedules.this.entityType != null && FilteredSchedules.this.entityId != null) {
                    anchor = anchor + "?";
                    anchor = anchor + FilteredSchedules.ANCHOR_PARAM_ASSOCIATIONTYPE;
                    anchor = anchor + "=";
                    anchor = anchor + FilteredSchedules.this.entityType;
                    anchor = anchor + "&";
                    anchor = anchor + FilteredSchedules.ANCHOR_PARAM_ASSOCIATIONID;
                    anchor = anchor + "=";
                    anchor = anchor + FilteredSchedules.this.entityId;
                }
                History.newItem((String)anchor);
            }
        });
        this.buttonPanel.add((Widget)this.createButton);
        this.dissociateButton = new ButtonWidget(this.constants.buttonLabelDissociate());
        this.dissociateButton.removeStyleName("gwt-Button");
        this.dissociateButton.addStyleName("ebBtn");
        this.dissociateButton.addStyleName("disassociate_button_icon");
        this.dissociateButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (FilteredSchedules.this.selectedIds.size() > 0) {
                    FilteredSchedules.this.service.dissociate(FilteredSchedules.this.selectedIds, FilteredSchedules.this.entityId, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                        public void onNeptuneFailure(Throwable caught) {
                            FilteredSchedules.this.setErrorMessage("Failed to dissociate the selected jobs." + Common.getFailureMessageSuffix(caught));
                        }

                        public void onNeptuneSuccess(Void result) {
                            FilteredSchedules.this.setInfoMessage("Successfully dissociated the jobs.");
                            FilteredSchedules.this.refresh();
                        }
                    });
                } else {
                    FilteredSchedules.this.setErrorMessage(FilteredSchedules.this.constants.noScheduleSelected());
                }
            }
        });
        this.buttonPanel.add((Widget)this.dissociateButton);
        this.initWidget((Widget)this.mainPanel);
    }

    public void setEntity(String entityType, Long entityId) {
        this.entityType = entityType;
        this.entityId = entityId;
        NeptuneSecurity security = NeptuneApplication.getApplication().getSecurity();
        if (!security.isUserInRole("Scheduler_Create") || !Common.isUserAuthorized(entityType, Action.CREATE)) {
            this.createButton.setVisible(false);
        }
        if (!security.isUserInRole("Scheduler_Delete") || !Common.isUserAuthorized(entityType, Action.DELETE)) {
            this.dissociateButton.setVisible(false);
        }
        this.refresh();
    }

    public void setMessageArea(MessageArea messageArea) {
        this.messageArea = messageArea;
    }

    public void clearMessages() {
        this.messageArea.reset();
        this.updateSizeForMessageArea();
    }

    private void refresh() {
        this.load(this.entityType, this.entityId);
    }

    private void load(String entityType, long entityId) {
        this.busyIndicator.center();
        this.service.getSchedulesByAssociatedEntity(entityType, entityId, (AsyncCallback<List<UIWOJob>>)new NeptuneAsyncCallback<List<UIWOJob>>(){

            public void onNeptuneFailure(Throwable caught) {
                FilteredSchedules.this.busyIndicator.hide();
                Window.alert((String)("Failed to load schedules list." + Common.getFailureMessageSuffix(caught)));
            }

            public void onNeptuneSuccess(List<UIWOJob> uiWOJobs) {
                FilteredSchedules.this.rowCheckBoxes = new ArrayList(uiWOJobs.size());
                FilteredSchedules.this.selectedIds.clear();
                FilteredSchedules.this.buildTable(uiWOJobs);
                FilteredSchedules.this.busyIndicator.hide();
            }
        });
    }

    private void buildTable(List<UIWOJob> jobs) {
        FlexTable table = new FlexTable();
        table.addStyleName(TABLE_STYLE);
        this.tableContainer.setWidget((Widget)table);
        table.getRowFormatter().addStyleName(0, HEADER_ROW_STYLE);
        final CheckBoxWidget allCB = new CheckBoxWidget();
        allCB.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                if (FilteredSchedules.this.rowCheckBoxes != null) {
                    for (CheckBoxWidget cb : FilteredSchedules.this.rowCheckBoxes) {
                        cb.setValue((Boolean)event.getValue(), true);
                    }
                }
            }
        });
        table.setWidget(0, 0, (Widget)allCB);
        table.setText(0, 1, this.constants.columnLabelId());
        table.setText(0, 2, this.constants.columnLabelStatus());
        table.setText(0, 3, this.constants.columnLabelName());
        table.setText(0, 4, this.constants.columnLabelTemplateName());
        table.setText(0, 5, this.constants.columnLabelJobScheduleRule());
        int rowIndex = 1;
        for (final UIWOJob job : jobs) {
            table.getRowFormatter().addStyleName(rowIndex, DATA_ROW_STYLE);
            CheckBoxWidget cb = new CheckBoxWidget();
            cb.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    if (((Boolean)event.getValue()).booleanValue()) {
                        FilteredSchedules.this.selectedIds.add(job.getId());
                    } else {
                        allCB.setValue(Boolean.valueOf(false), false);
                        FilteredSchedules.this.selectedIds.remove(job.getId());
                    }
                }
            });
            table.setWidget(rowIndex, 0, (Widget)cb);
            this.rowCheckBoxes.add(cb);
            LabelWidget idWidget = new LabelWidget(Long.toString(job.getJobId()));
            idWidget.addStyleName(ID_COL_STYLE);
            idWidget.addStyleName(ID_LINK_COL_STYLE);
            idWidget.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    History.newItem((String)("Scheduler.View?id=" + job.getJobId()));
                }
            });
            table.setWidget(rowIndex, 1, (Widget)idWidget);
            ImageWidget enabledImageWidget = new ImageWidget(job.isActive() ? ENABLED_IMAGE : DISABLED_IMAGE);
            enabledImageWidget.addStyleName(ENABLED_COL_STYLE);
            HorizontalContainer hc = new HorizontalContainer();
            hc.add((Widget)enabledImageWidget);
            hc.setSpacing(5);
            table.setWidget(rowIndex, 2, (Widget)hc);
            table.setWidget(rowIndex, 3, (Widget)new LabelWidget(job.getName()));
            table.setWidget(rowIndex, 4, (Widget)new LabelWidget(job.getTemplateName()));
            String scheduleInfoString = SchedulingWidget.getScheduleInfoString(job.getScheduleInfo());
            table.setWidget(rowIndex, 5, (Widget)new LabelWidget(scheduleInfoString));
            ++rowIndex;
        }
        FilteredSchedules.enableSort(table.getElement());
    }

    private void setInfoMessage(String message) {
        this.messageArea.setInfoMessage(message);
        this.updateSizeForMessageArea();
    }

    private void setErrorMessage(String message) {
        this.messageArea.setErrorMessage(message);
        this.updateSizeForMessageArea();
    }

    protected void onUnload() {
        super.onUnload();
        this.busyIndicator.hide();
    }

    public static native void enableSort(Element var0);

    public void updateSize(int offsetWidth, int offsetHeight) {
        if (offsetWidth > 0) {
            int width = Window.getClientWidth() - offsetWidth;
            this.scrollPanel.setWidth(width + "px");
        }
        if (offsetHeight > 0) {
            int height = Window.getClientHeight() - offsetHeight - this.messageArea.getOffsetHeight() - this.buttonPanel.getOffsetHeight();
            this.scrollPanel.setHeight(height + "px");
        }
    }

    private void updateSizeForMessageArea() {
        this.scrollPanel.setHeight(this.scrollPanel.getOffsetHeight() - this.messageArea.getOffsetHeight() + "px");
    }
}

