/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduling.ui.client;

import com.ericsson.cms.scheduling.ui.client.Action;
import com.ericsson.cms.scheduling.ui.client.ISchedulerTab;
import com.ericsson.cms.scheduling.ui.client.SchedulesListUtils;
import com.ericsson.cms.scheduling.ui.client.common.Common;
import com.ericsson.cms.scheduling.ui.client.common.SchedulingConstants;
import com.ericsson.cms.scheduling.ui.client.data.UIExecutionRecord;
import com.ericsson.cms.scheduling.ui.client.service.IUISchedulerService;
import com.ericsson.cms.scheduling.ui.client.service.IUISchedulerServiceAsync;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FutureExecutionsList
extends Composite
implements ISchedulerTab {
    private static final String ENABLED_IMAGE = "cms_scheduling_ui/images/enabled.png";
    private static final String DISABLED_IMAGE = "cms_scheduling_ui/images/disabled.png";
    private static final String TABLE_STYLE = "scheduler-schedulesList";
    private static final String HEADER_ROW_STYLE = "scheduler-schedulesList-header";
    private static final String DATA_ROW_STYLE = "scheduler-schedulesList-data";
    private static final int CMS_HEADER_MENU_SIZE_PX = 115;
    private IUISchedulerServiceAsync service = (IUISchedulerServiceAsync)GWT.create(IUISchedulerService.class);
    private SchedulingConstants constants = (SchedulingConstants)GWT.create(SchedulingConstants.class);
    private BusyIndicator busyIndicator = new BusyIndicator(true);
    private VerticalContainer mainPanel = new VerticalContainer();
    private List<CheckBoxWidget> rowCheckBoxes;
    private MessageArea messageArea = new MessageArea();
    VerticalContainer tabPanel = new VerticalContainer();
    private ScrollContainer scrollPanel = new ScrollContainer();
    HorizontalContainer buttonPanel = new HorizontalContainer();
    private HandlerRegistration windowRegistration = null;
    private Set<UIExecutionRecord> selectedRecords = new HashSet<UIExecutionRecord>();

    public FutureExecutionsList(Map<String, String> info, NeptuneSecurity security) {
        this.mainPanel.setWidth("100%");
        this.buttonPanel.addStyleName("cms_button_container");
        this.mainPanel.add((Widget)this.scrollPanel);
        this.mainPanel.add((Widget)this.buttonPanel);
        if (security.isUserInRole("Scheduler_Modify")) {
            ButtonWidget enableButton = new ButtonWidget(this.constants.buttonLabelEnable());
            enableButton.removeStyleName("gwt-Button");
            enableButton.addStyleName("ebBtn");
            enableButton.addStyleName("enable_button_icon");
            enableButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (FutureExecutionsList.this.selectedRecords.isEmpty()) {
                        FutureExecutionsList.this.setErrorMessage("You have to select atleast one row to perform this action.");
                        return;
                    }
                    for (UIExecutionRecord selectedRecord : FutureExecutionsList.this.selectedRecords) {
                        if (!selectedRecord.isEnabled()) continue;
                        FutureExecutionsList.this.setErrorMessage("Only disabled executions can be enabled.");
                        return;
                    }
                    if (!FutureExecutionsList.this.isAuthorized(FutureExecutionsList.this.selectedRecords, Action.ENABLE_EXECUTION)) {
                        FutureExecutionsList.this.setErrorMessage("You are not authorized to enable one or more of the selected executions.");
                        return;
                    }
                    FutureExecutionsList.this.service.setFutureExecutionsEnabled(FutureExecutionsList.this.selectedRecords, true, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                        public void onNeptuneFailure(Throwable caught) {
                            FutureExecutionsList.this.setErrorMessage("Failed to enable the selected executions." + Common.getFailureMessageSuffix(caught));
                        }

                        public void onNeptuneSuccess(Void result) {
                            FutureExecutionsList.this.setInfoMessage("Successfully enabled the executions.");
                            FutureExecutionsList.this.load();
                        }
                    });
                }
            });
            this.buttonPanel.add((Widget)enableButton);
        }
        if (security.isUserInRole("Scheduler_Modify")) {
            ButtonWidget disableButton = new ButtonWidget(this.constants.buttonLabelDisable());
            disableButton.removeStyleName("gwt-Button");
            disableButton.addStyleName("ebBtn");
            disableButton.addStyleName("disable_button_icon");
            disableButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (FutureExecutionsList.this.selectedRecords.isEmpty()) {
                        FutureExecutionsList.this.setErrorMessage("You have to select atleast one row to perform this action.");
                        return;
                    }
                    for (UIExecutionRecord selectedRecord : FutureExecutionsList.this.selectedRecords) {
                        if (selectedRecord.isEnabled()) continue;
                        FutureExecutionsList.this.setErrorMessage("Only enabled executions can be disabled.");
                        return;
                    }
                    if (!FutureExecutionsList.this.isAuthorized(FutureExecutionsList.this.selectedRecords, Action.DISABLE_EXECUTION)) {
                        FutureExecutionsList.this.setErrorMessage("You are not authorized to disable one or more of the selected executions.");
                        return;
                    }
                    FutureExecutionsList.this.service.setFutureExecutionsEnabled(FutureExecutionsList.this.selectedRecords, false, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                        public void onNeptuneFailure(Throwable caught) {
                            FutureExecutionsList.this.setErrorMessage("Failed to disable the selected executions." + Common.getFailureMessageSuffix(caught));
                        }

                        public void onNeptuneSuccess(Void result) {
                            FutureExecutionsList.this.setInfoMessage("Successfully disabled the executions.");
                            FutureExecutionsList.this.load();
                        }
                    });
                }
            });
            this.buttonPanel.add((Widget)disableButton);
        }
        this.initWidget((Widget)this.mainPanel);
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                FutureExecutionsList.this.updateScrollPanelSize();
            }
        });
    }

    private void load() {
        this.busyIndicator.center();
        this.service.getFutureExecutions((AsyncCallback<List<UIExecutionRecord>>)new NeptuneAsyncCallback<List<UIExecutionRecord>>(){

            public void onNeptuneFailure(Throwable caught) {
                FutureExecutionsList.this.busyIndicator.hide();
                Window.alert((String)("Failed to load future executions list." + Common.getFailureMessageSuffix(caught)));
            }

            public void onNeptuneSuccess(List<UIExecutionRecord> records) {
                FutureExecutionsList.this.rowCheckBoxes = new ArrayList(records.size());
                FutureExecutionsList.this.selectedRecords.clear();
                FutureExecutionsList.this.buildTable(records);
                FutureExecutionsList.this.updateScrollPanelSize();
                FutureExecutionsList.this.busyIndicator.hide();
            }
        });
    }

    private void buildTable(List<UIExecutionRecord> records) {
        FlexTable table = new FlexTable();
        table.addStyleName(TABLE_STYLE);
        VerticalContainer tablePanel = new VerticalContainer();
        tablePanel.setWidth("100%");
        tablePanel.add((Widget)table);
        this.scrollPanel.setWidget((Widget)tablePanel);
        table.getRowFormatter().addStyleName(0, HEADER_ROW_STYLE);
        final CheckBoxWidget allCB = new CheckBoxWidget();
        allCB.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                if (FutureExecutionsList.this.rowCheckBoxes != null) {
                    for (CheckBoxWidget cb : FutureExecutionsList.this.rowCheckBoxes) {
                        cb.setValue((Boolean)event.getValue(), true);
                    }
                }
            }
        });
        table.setWidget(0, 0, (Widget)allCB);
        table.setWidget(0, 1, (Widget)new LabelWidget(this.constants.columnLabelEnabled()));
        table.setWidget(0, 2, (Widget)new LabelWidget(this.constants.columnLabelExecutionTime()));
        table.setWidget(0, 3, (Widget)new LabelWidget(this.constants.columnLabelId()));
        table.setWidget(0, 4, (Widget)new LabelWidget(this.constants.columnLabelName()));
        table.setWidget(0, 5, (Widget)new LabelWidget(this.constants.columnLabelAssociation()));
        table.getCellFormatter().setWidth(0, 4, "25%");
        table.getCellFormatter().setWidth(0, 5, "35%");
        int associationDescriptionCellWidth = Window.getClientWidth() * 35 / 100;
        int rowIndex = 1;
        for (final UIExecutionRecord r : records) {
            table.getRowFormatter().addStyleName(rowIndex, DATA_ROW_STYLE);
            CheckBoxWidget cb = new CheckBoxWidget();
            cb.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    if (((Boolean)event.getValue()).booleanValue()) {
                        FutureExecutionsList.this.selectedRecords.add(r);
                    } else {
                        allCB.setValue(Boolean.valueOf(false), false);
                        FutureExecutionsList.this.selectedRecords.remove(r);
                    }
                }
            });
            table.setWidget(rowIndex, 0, (Widget)cb);
            table.getCellFormatter().setAlignment(rowIndex, 0, HasHorizontalAlignment.ALIGN_CENTER, HasVerticalAlignment.ALIGN_MIDDLE);
            this.rowCheckBoxes.add(cb);
            ImageWidget enabledImageWidget = new ImageWidget(r.isEnabled() ? ENABLED_IMAGE : DISABLED_IMAGE);
            table.setWidget(rowIndex, 1, (Widget)enabledImageWidget);
            table.getCellFormatter().setAlignment(rowIndex, 1, HasHorizontalAlignment.ALIGN_CENTER, HasVerticalAlignment.ALIGN_MIDDLE);
            table.setWidget(rowIndex, 2, (Widget)new LabelWidget(r.getExecutionTimeString()));
            Object idWidget = null;
            idWidget = r.getHistoryToken() != null ? new HyperlinkWidget(String.valueOf(r.getJobId()), r.getHistoryToken()) : new LabelWidget(String.valueOf(r.getJobId()));
            table.setWidget(rowIndex, 3, (Widget)idWidget);
            table.getCellFormatter().setAlignment(rowIndex, 3, HasHorizontalAlignment.ALIGN_CENTER, HasVerticalAlignment.ALIGN_MIDDLE);
            table.setWidget(rowIndex, 4, (Widget)new LabelWidget(r.getJobName()));
            String truncatedAssociatedDescription = SchedulesListUtils.getTruncatedAssociationDescription(r.getAssociation(), associationDescriptionCellWidth);
            table.setWidget(rowIndex, 5, (Widget)new LabelWidget(truncatedAssociatedDescription));
            ++rowIndex;
        }
    }

    private boolean isAuthorized(Collection<UIExecutionRecord> records, Action action) {
        for (UIExecutionRecord r : records) {
            if (Common.isUserAuthorized(r.getAssociatedEntityType(), action)) continue;
            return false;
        }
        return true;
    }

    private void setInfoMessage(String message) {
        this.messageArea.setInfoMessage(message);
        this.updateScrollPanelSize();
    }

    private void setErrorMessage(String message) {
        this.messageArea.setErrorMessage(message);
        this.updateScrollPanelSize();
    }

    private void updateScrollPanelSize() {
        int height = Window.getClientHeight() - 115 - this.messageArea.getOffsetHeight() - this.buttonPanel.getOffsetHeight() - 92;
        this.scrollPanel.setHeight(height + "px");
    }

    protected void onLoad() {
        super.onLoad();
        this.windowRegistration = Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                FutureExecutionsList.this.updateScrollPanelSize();
            }
        });
    }

    protected void onUnload() {
        this.windowRegistration.removeHandler();
        this.windowRegistration = null;
        if (this.busyIndicator != null) {
            this.busyIndicator.hide();
        }
        super.onUnload();
    }

    @Override
    public void setMessageArea(MessageArea messageArea) {
        this.messageArea = messageArea;
    }

    @Override
    public void setSelected(boolean selected) {
        if (!selected) {
            return;
        }
        this.messageArea.reset();
        History.newItem((String)"Scheduler.Executions", (boolean)false);
        this.load();
    }
}

