/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduling.ui.client;

import com.ericsson.cms.scheduling.ui.client.ISchedulerTab;
import com.ericsson.cms.scheduling.ui.client.SchedulesListUtils;
import com.ericsson.cms.scheduling.ui.client.common.Common;
import com.ericsson.cms.scheduling.ui.client.common.SchedulingConstants;
import com.ericsson.cms.scheduling.ui.client.data.UIExecutionRecord;
import com.ericsson.cms.scheduling.ui.client.service.IUISchedulerService;
import com.ericsson.cms.scheduling.ui.client.service.IUISchedulerServiceAsync;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HTMLWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.List;
import java.util.Map;

public class PastExecutionsList
extends Composite
implements ISchedulerTab {
    private static final String ENABLED_IMAGE = "cms_scheduling_ui/images/enabled.png";
    private static final String DISABLED_IMAGE = "cms_scheduling_ui/images/disabled.png";
    private static final String TABLE_STYLE = "scheduler-schedulesList";
    private static final String HEADER_ROW_STYLE = "scheduler-schedulesList-header";
    private static final String DATA_ROW_STYLE = "scheduler-schedulesList-data";
    private static final String STALEDATA_ROW_STYLE = "scheduler-schedulesList-staledata";
    private static final String NOTES_MARKER_STYLE = "scheduler-notesMarker";
    private static final int CMS_HEADER_MENU_SIZE_PX = 115;
    private IUISchedulerServiceAsync service = (IUISchedulerServiceAsync)GWT.create(IUISchedulerService.class);
    private SchedulingConstants constants = (SchedulingConstants)GWT.create(SchedulingConstants.class);
    private BusyIndicator busyIndicator = new BusyIndicator(true);
    private VerticalContainer mainPanel = new VerticalContainer();
    private ScrollContainer scrollPanel = new ScrollContainer();
    HTMLWidget legendWidget = new HTMLWidget("<span class='scheduler-notesMarker'>*</span> " + this.constants.staleRecordsLegend());
    private HandlerRegistration windowRegistration = null;
    private MessageArea messageArea = new MessageArea();

    public PastExecutionsList(Map<String, String> info) {
        this.mainPanel.setWidth("100%");
        this.mainPanel.add((Widget)this.scrollPanel);
        this.mainPanel.add((Widget)this.legendWidget);
        this.initWidget((Widget)this.mainPanel);
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                PastExecutionsList.this.updateScrollPanelSize();
            }
        });
    }

    private void load() {
        this.busyIndicator.center();
        this.service.getPastExecutions((AsyncCallback<List<UIExecutionRecord>>)new NeptuneAsyncCallback<List<UIExecutionRecord>>(){

            public void onNeptuneFailure(Throwable caught) {
                PastExecutionsList.this.busyIndicator.hide();
                Window.alert((String)("Failed to load past execution records." + Common.getFailureMessageSuffix(caught)));
            }

            public void onNeptuneSuccess(List<UIExecutionRecord> records) {
                PastExecutionsList.this.buildTable(records);
                PastExecutionsList.this.updateScrollPanelSize();
                PastExecutionsList.this.busyIndicator.hide();
            }
        });
    }

    private void buildTable(List<UIExecutionRecord> records) {
        FlexTable table = new FlexTable();
        table.addStyleName(TABLE_STYLE);
        VerticalContainer tablePanel = new VerticalContainer();
        tablePanel.setWidth("100%");
        tablePanel.add((Widget)table);
        this.scrollPanel.setWidget((Widget)tablePanel);
        table.getRowFormatter().addStyleName(0, HEADER_ROW_STYLE);
        table.setWidget(0, 0, (Widget)new LabelWidget(this.constants.columnLabelEnabled()));
        table.setWidget(0, 1, (Widget)new LabelWidget(this.constants.columnLabelExecutionTime()));
        table.setWidget(0, 2, (Widget)new LabelWidget(this.constants.columnLabelId()));
        table.setWidget(0, 3, (Widget)new LabelWidget(this.constants.columnLabelName()));
        table.setWidget(0, 4, (Widget)new LabelWidget(this.constants.columnLabelAssociation()));
        table.getCellFormatter().setWidth(0, 3, "25%");
        table.getCellFormatter().setWidth(0, 4, "40%");
        int associationDescriptionCellWidth = Window.getClientWidth() * 40 / 100;
        int rowIndex = 1;
        for (UIExecutionRecord r : records) {
            table.getRowFormatter().addStyleName(rowIndex, r.isStale() ? STALEDATA_ROW_STYLE : DATA_ROW_STYLE);
            ImageWidget enabledImageWidget = new ImageWidget(r.isEnabled() ? ENABLED_IMAGE : DISABLED_IMAGE);
            table.setWidget(rowIndex, 0, (Widget)enabledImageWidget);
            table.getCellFormatter().setAlignment(rowIndex, 0, HasHorizontalAlignment.ALIGN_CENTER, HasVerticalAlignment.ALIGN_MIDDLE);
            table.setWidget(rowIndex, 1, (Widget)new LabelWidget(r.getExecutionTimeString()));
            Object idWidget = null;
            idWidget = r.getHistoryToken() != null ? new HyperlinkWidget(String.valueOf(r.getJobId()), r.getHistoryToken()) : new LabelWidget(String.valueOf(r.getJobId()));
            table.setWidget(rowIndex, 2, (Widget)idWidget);
            table.getCellFormatter().setAlignment(rowIndex, 2, HasHorizontalAlignment.ALIGN_CENTER, HasVerticalAlignment.ALIGN_MIDDLE);
            table.setWidget(rowIndex, 3, (Widget)new LabelWidget(r.getJobName()));
            String truncatedAssociatedDescription = SchedulesListUtils.getTruncatedAssociationDescription(r.getAssociation(), associationDescriptionCellWidth);
            table.setWidget(rowIndex, 4, (Widget)new LabelWidget(truncatedAssociatedDescription));
            ++rowIndex;
        }
    }

    private void updateScrollPanelSize() {
        int height = Window.getClientHeight() - 115 - this.messageArea.getOffsetHeight() - 115;
        this.scrollPanel.setHeight(height + "px");
    }

    protected void onLoad() {
        super.onLoad();
        this.windowRegistration = Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                PastExecutionsList.this.updateScrollPanelSize();
            }
        });
    }

    protected void onUnload() {
        this.windowRegistration.removeHandler();
        this.windowRegistration = null;
        if (this.busyIndicator != null) {
            this.busyIndicator.hide();
        }
        super.onUnload();
    }

    @Override
    public void setMessageArea(MessageArea messageArea) {
        this.messageArea = messageArea;
    }

    @Override
    public void setSelected(boolean selected) {
        if (!selected) {
            return;
        }
        this.messageArea.reset();
        History.newItem((String)"Scheduler.Executions.Past", (boolean)false);
        this.load();
    }
}

