/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduling.ui.client;

import com.ericsson.cms.scheduling.ui.client.SchedulerExecutions;
import com.ericsson.cms.scheduling.ui.client.SchedulerView;
import com.ericsson.cms.scheduling.ui.client.common.SchedulingConstants;
import com.ericsson.cms.scheduling.ui.client.portlet.upcomingjobs.UpcomingJobsPortlet;
import com.ericsson.cms.scheduling.ui.client.portlet.upcomingjobs.UpcomingJobsPortletConfig;
import com.google.gwt.core.client.GWT;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.PortletFactory;
import com.tandbergtv.neptune.widgettoolkit.client.application.Service;
import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;
import com.tandbergtv.neptune.widgettoolkit.client.application.WidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.component.Component;
import com.tandbergtv.neptune.widgettoolkit.client.component.ComponentBase;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventListenerRegistry;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventSink;
import com.tandbergtv.neptune.widgettoolkit.client.menu.GroupMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SchedulerComponent
extends ComponentBase {
    private SchedulerView viewPanelFactory = new SchedulerView();
    private SchedulerExecutions executionsPanelFactory = new SchedulerExecutions();
    private SchedulingConstants constants = (SchedulingConstants)GWT.create(SchedulingConstants.class);

    public String getDisplayName() {
        return "Scheduler";
    }

    public String getName() {
        return this.constants.componentName();
    }

    public void init(EventListenerRegistry eventListenerRegistry, EventSink eventSink, ServiceLoader serviceLoader, Map<String, String> info) {
        super.init(eventListenerRegistry, eventSink, serviceLoader, info);
        this.info = info;
    }

    public List<PortletFactory> listPortlets(NeptuneSecurity security) {
        ArrayList<PortletFactory> portletFactories = new ArrayList<PortletFactory>();
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"Scheduler_View"})) {
            UpcomingJobsPortletConfig ujConfig = new UpcomingJobsPortletConfig();
            ujConfig.setRefreshRateSecs(this.getRefreshRate(this.info));
            ujConfig.setRecordCount(this.getUpcomingJobsPortletRecordCount(this.info));
            UpcomingJobsPortlet ujPortlet = new UpcomingJobsPortlet(security, ujConfig);
            portletFactories.add(new SchedulerPortletFactory(ujPortlet, this));
        }
        return portletFactories;
    }

    public <E extends Service> List<E> listServices(Class<E> clazz, NeptuneSecurity security) {
        return null;
    }

    public List<MenuItemBase> listTabs(NeptuneSecurity security) {
        ArrayList<MenuItemBase> tabs = new ArrayList<MenuItemBase>();
        ArrayList<WidgetMenuItem> childMenuItems = new ArrayList<WidgetMenuItem>();
        GroupMenuItem rootMenuItem = new GroupMenuItem("Scheduler", childMenuItems);
        tabs.add((MenuItemBase)rootMenuItem);
        if (security.isUserInRole("Scheduler_View")) {
            this.viewPanelFactory.setSecurity(security);
            WidgetMenuItem viewMenuItem = new WidgetMenuItem("View", (WidgetFactory)this.viewPanelFactory, this.viewPanelFactory.getAnchorChangeListener());
            childMenuItems.add(viewMenuItem);
            this.executionsPanelFactory.setInfo(this.info);
            this.executionsPanelFactory.setSecurity(security);
            WidgetMenuItem executionsMenuItem = new WidgetMenuItem("Executions", (WidgetFactory)this.executionsPanelFactory, this.executionsPanelFactory.getAnchorChangeListener());
            childMenuItems.add(executionsMenuItem);
        }
        return tabs;
    }

    private int getRefreshRate(Map<String, String> info) {
        int refreshRateSecs = 60;
        try {
            refreshRateSecs = Integer.parseInt(info.get("scheduler.portlets.upcomingjobs.refreshRate").trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return refreshRateSecs;
    }

    private int getUpcomingJobsPortletRecordCount(Map<String, String> info) {
        int recordCount = 10;
        try {
            recordCount = Integer.parseInt(info.get("scheduler.portlets.upcomingjobs.recordCount").trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return recordCount;
    }

    private static final class SchedulerPortletFactory
    implements PortletFactory {
        private final Portlet portlet;
        private final SchedulerComponent schedulerComponent;

        public SchedulerPortletFactory(Portlet portlet, SchedulerComponent schedulerComponent) {
            this.portlet = portlet;
            this.schedulerComponent = schedulerComponent;
        }

        public Portlet getInstance() {
            return this.portlet;
        }

        public void release(Portlet widget) {
        }

        public Component getComponent() {
            return this.schedulerComponent;
        }
    }
}

