/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduling.ui.client;

import com.ericsson.cms.scheduling.ui.client.SchedulesListWidget;
import com.ericsson.cms.scheduling.ui.client.common.Common;
import com.ericsson.cms.scheduling.ui.client.detailsPage.ScheduleDetailsWidget;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.WidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import java.util.Map;

public class SchedulerView
implements WidgetFactory {
    private static final String ANCHOR_ID_PREFIX = "?id=";
    private static final String ANCHOR_CREATE = "Create";
    private static final String ANCHOR_PARAM_ASSOCIATIONTYPE = "associationType";
    private static final String ANCHOR_PARAM_ASSOCIATIONID = "associationId";
    private NeptuneSecurity security;
    private SimpleContainer basePanel = new SimpleContainer();

    public SchedulerView() {
        this.basePanel.setStyleName("scheduler-basePanel");
    }

    public void setSecurity(NeptuneSecurity security) {
        this.security = security;
    }

    public Widget getInstance() {
        return this.basePanel;
    }

    public void release(Widget widget) {
        this.basePanel.clear();
    }

    public WidgetMenuItem.AnchorChangeListener getAnchorChangeListener() {
        return new WidgetMenuItem.AnchorChangeListener(){

            public void anchorChanged(String anchor) {
                SchedulerView.this.respondToAnchor(anchor);
            }
        };
    }

    private void respondToAnchor(String anchor) {
        if (anchor == null || anchor.trim().length() == 0) {
            this.basePanel.setWidget((Widget)new SchedulesListWidget(this.security));
        } else if (anchor.startsWith(ANCHOR_ID_PREFIX)) {
            long id;
            String idStr = anchor.substring(ANCHOR_ID_PREFIX.length());
            try {
                id = Long.parseLong(idStr);
            }
            catch (Exception e) {
                Window.alert((String)"Invalid id.");
                return;
            }
            this.basePanel.setWidget((Widget)new ScheduleDetailsWidget(id, this.security));
        } else if (anchor.startsWith(ANCHOR_CREATE)) {
            String paramsStr = anchor.substring(ANCHOR_CREATE.length());
            String associationType = null;
            Long associationId = null;
            if (!Common.isBlank(paramsStr)) {
                try {
                    paramsStr = paramsStr.trim();
                    paramsStr = paramsStr.substring(1);
                    Map<String, String> params = Common.getParams(paramsStr);
                    associationType = params.get(ANCHOR_PARAM_ASSOCIATIONTYPE);
                    associationId = Long.parseLong(params.get(ANCHOR_PARAM_ASSOCIATIONID));
                }
                catch (Exception e) {
                    Window.alert((String)"Invalid URL");
                    return;
                }
            }
            this.basePanel.setWidget((Widget)new ScheduleDetailsWidget(associationType, associationId, this.security));
        } else {
            Window.alert((String)"Invalid URL");
        }
    }
}

