/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduling.ui.client;

import com.ericsson.cms.scheduling.ui.client.Action;
import com.ericsson.cms.scheduling.ui.client.SchedulesListUtils;
import com.ericsson.cms.scheduling.ui.client.common.Common;
import com.ericsson.cms.scheduling.ui.client.common.SchedulingConstants;
import com.ericsson.cms.scheduling.ui.client.data.SchedulesListRow;
import com.ericsson.cms.scheduling.ui.client.service.IUISchedulerService;
import com.ericsson.cms.scheduling.ui.client.service.IUISchedulerServiceAsync;
import com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidget;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Document;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DialogBoxContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SchedulesListWidget
extends Composite {
    private static final String ENABLED_IMAGE = "cms_scheduling_ui/images/enabled.png";
    private static final String DISABLED_IMAGE = "cms_scheduling_ui/images/disabled.png";
    private static final String TAB_CONTAINER_STYLE = "scheduler-tabContainer";
    private static final String TABLE_STYLE = "scheduler-schedulesList";
    private static final String HEADER_ROW_STYLE = "scheduler-schedulesList-header";
    private static final String DATA_ROW_STYLE = "scheduler-schedulesList-data";
    private static int CMS_HEADER_MENU_SIZE_PX = 115;
    private static final String ID_COLUMN_HEADER_CELL_ID = "schedulesListIdHeader";
    private IUISchedulerServiceAsync service = (IUISchedulerServiceAsync)GWT.create(IUISchedulerService.class);
    private SchedulingConstants constants = (SchedulingConstants)GWT.create(SchedulingConstants.class);
    private BusyIndicator busyIndicator = new BusyIndicator(true);
    private VerticalContainer mainPanel = new VerticalContainer();
    private HeaderPanel headerPanel = new HeaderPanel("View Schedules");
    private MessageArea messageArea = new MessageArea();
    private TabContainer tabContainer = new TabContainer();
    private ScrollContainer tableContainer = new ScrollContainer();
    private HorizontalContainer buttonPanel = new HorizontalContainer();
    private HandlerRegistration resizeHandlerRegistration;
    private List<CheckBox> rowCheckBoxes;

    public SchedulesListWidget(NeptuneSecurity security) {
        if (!security.isUserInRole("Scheduler_View")) {
            Window.alert((String)"You do not have permission to view schedules.");
            return;
        }
        this.mainPanel.setWidth("100%");
        this.mainPanel.add((Widget)this.headerPanel);
        this.messageArea.reset();
        this.mainPanel.add((Widget)this.messageArea);
        this.tabContainer.addStyleName(TAB_CONTAINER_STYLE);
        this.mainPanel.add((Widget)this.tabContainer);
        VerticalContainer tabPanel = new VerticalContainer();
        this.tabContainer.add((Widget)tabPanel, "Schedules");
        this.tabContainer.selectTab(0);
        this.tabContainer.getTabBar().setVisible(false);
        this.headerPanel.getLabel().setStyleName("schedule-header-style");
        this.tableContainer.setHeight("0px");
        this.tableContainer.setWidth("100%");
        tabPanel.add((Widget)this.tableContainer);
        this.buttonPanel.addStyleName("cms_button_container");
        tabPanel.add((Widget)this.buttonPanel);
        if (security.isUserInRole("Scheduler_Modify")) {
            ButtonWidget activateButton = new ButtonWidget(this.constants.buttonLabelActivate());
            activateButton.removeStyleName("gwt-Button");
            activateButton.addStyleName("ebBtn");
            activateButton.addStyleName("enable_button_icon");
            activateButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    HashSet<Long> selectedIds = new HashSet<Long>(SchedulesListWidget.this.rowCheckBoxes.size());
                    List selected = SchedulesListWidget.this.getSelected();
                    for (SchedulesListRow schedule : selected) {
                        if (schedule.isActive()) {
                            SchedulesListWidget.this.setErrorMessage("Only inactive schedules can be activated.");
                            return;
                        }
                        selectedIds.add(schedule.getWoJobId());
                    }
                    if (selectedIds.isEmpty()) {
                        SchedulesListWidget.this.setErrorMessage(SchedulesListWidget.this.constants.noScheduleSelected());
                        return;
                    }
                    if (!SchedulesListWidget.this.isUserAuthorized(selected, Action.ACTIVATE)) {
                        SchedulesListWidget.this.setErrorMessage("You are not authorized to activate one or more of the selected schedules.");
                        return;
                    }
                    SchedulesListWidget.this.service.setActive(selectedIds, true, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                        public void onNeptuneFailure(Throwable caught) {
                            SchedulesListWidget.this.setErrorMessage("Failed to activate the selected schedules." + Common.getFailureMessageSuffix(caught));
                        }

                        public void onNeptuneSuccess(Void result) {
                            SchedulesListWidget.this.setInfoMessage("Successfully activated the schedules.");
                            SchedulesListWidget.this.load();
                        }
                    });
                }
            });
            this.buttonPanel.add((Widget)activateButton);
        }
        if (security.isUserInRole("Scheduler_Execute")) {
            ButtonWidget runNowButton = new ButtonWidget(this.constants.buttonLabelRunNow());
            runNowButton.removeStyleName("gwt-Button");
            runNowButton.addStyleName("ebBtn");
            runNowButton.addStyleName("ebBtn_color_green");
            runNowButton.addStyleName("runnow_button_icon");
            runNowButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    HashSet<Long> selectedIds = new HashSet<Long>(SchedulesListWidget.this.rowCheckBoxes.size());
                    List selected = SchedulesListWidget.this.getSelected();
                    for (SchedulesListRow schedule : selected) {
                        if (!schedule.isActive()) {
                            SchedulesListWidget.this.setErrorMessage("Only active schedules can be run.");
                            return;
                        }
                        selectedIds.add(schedule.getId());
                    }
                    if (selectedIds.isEmpty()) {
                        SchedulesListWidget.this.setErrorMessage(SchedulesListWidget.this.constants.noScheduleSelected());
                        return;
                    }
                    if (!SchedulesListWidget.this.isUserAuthorized(selected, Action.EXECUTE)) {
                        SchedulesListWidget.this.setErrorMessage("You are not authorized to run one or more of the selected schedules.");
                        return;
                    }
                    SchedulesListWidget.this.service.runNow(selectedIds, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                        public void onNeptuneFailure(Throwable caught) {
                            SchedulesListWidget.this.setErrorMessage("Failed to run the selected schedules." + Common.getFailureMessageSuffix(caught));
                        }

                        public void onNeptuneSuccess(Void result) {
                            SchedulesListWidget.this.setInfoMessage("Successfully triggered to run the schedules.");
                            for (CheckBox cb : SchedulesListWidget.this.rowCheckBoxes) {
                                cb.setValue(false, false);
                            }
                        }
                    });
                }
            });
            this.buttonPanel.add((Widget)runNowButton);
        }
        if (security.isUserInRole("Scheduler_Create")) {
            ButtonWidget createButton = new ButtonWidget(this.constants.buttonLabelCreate());
            createButton.removeStyleName("gwt-Button");
            createButton.addStyleName("ebBtn");
            createButton.addStyleName("ebBtn_color_green");
            createButton.addStyleName("create_button_icon");
            createButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    History.newItem((String)"Scheduler.View.Create");
                }
            });
            this.buttonPanel.add((Widget)createButton);
        }
        if (security.isUserInRole("Scheduler_Modify")) {
            ButtonWidget inactivateButton = new ButtonWidget(this.constants.buttonLabelInactivate());
            inactivateButton.removeStyleName("gwt-Button");
            inactivateButton.addStyleName("ebBtn");
            inactivateButton.addStyleName("disable_button_icon");
            inactivateButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    HashSet<Long> selectedIds = new HashSet<Long>(SchedulesListWidget.this.rowCheckBoxes.size());
                    List selected = SchedulesListWidget.this.getSelected();
                    for (SchedulesListRow schedule : selected) {
                        if (!schedule.isActive()) {
                            SchedulesListWidget.this.setErrorMessage("Only active schedules can be inactivated.");
                            return;
                        }
                        selectedIds.add(schedule.getWoJobId());
                    }
                    if (selectedIds.isEmpty()) {
                        SchedulesListWidget.this.setErrorMessage(SchedulesListWidget.this.constants.noScheduleSelected());
                        return;
                    }
                    if (!SchedulesListWidget.this.isUserAuthorized(selected, Action.INACTIVATE)) {
                        SchedulesListWidget.this.setErrorMessage("You are not authorized to inactivate one or more of the selected schedules.");
                        return;
                    }
                    SchedulesListWidget.this.service.setActive(selectedIds, false, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                        public void onNeptuneFailure(Throwable caught) {
                            SchedulesListWidget.this.setErrorMessage("Failed to inactivate the selected schedules." + Common.getFailureMessageSuffix(caught));
                        }

                        public void onNeptuneSuccess(Void result) {
                            SchedulesListWidget.this.setInfoMessage("Successfully inactivated the schedules.");
                            SchedulesListWidget.this.load();
                        }
                    });
                }
            });
            this.buttonPanel.add((Widget)inactivateButton);
        }
        if (security.isUserInRole("Scheduler_Delete")) {
            ButtonWidget deleteButton = new ButtonWidget(this.constants.buttonLabelDelete());
            deleteButton.removeStyleName("gwt-Button");
            deleteButton.addStyleName("ebBtn");
            deleteButton.addStyleName("delete_button_icon");
            deleteButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    final HashSet<Long> selectedIds = new HashSet<Long>(SchedulesListWidget.this.rowCheckBoxes.size());
                    List selected = SchedulesListWidget.this.getSelected();
                    for (SchedulesListRow schedule : selected) {
                        selectedIds.add(schedule.getWoJobId());
                    }
                    if (selectedIds.isEmpty()) {
                        SchedulesListWidget.this.setErrorMessage(SchedulesListWidget.this.constants.noScheduleSelected());
                        return;
                    }
                    if (!SchedulesListWidget.this.isUserAuthorized(selected, Action.DELETE)) {
                        SchedulesListWidget.this.setErrorMessage("You are not authorized to delete one or more of the selected schedules.");
                        return;
                    }
                    SchedulesListWidget.this.confirm(SchedulesListWidget.this.constants.confirmMultipleDelete(), new Command(){

                        public void execute() {
                            SchedulesListWidget.this.delete(selectedIds);
                        }
                    }, null);
                }
            });
            this.buttonPanel.add((Widget)deleteButton);
        }
        this.load();
        this.initWidget((Widget)this.mainPanel);
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                SchedulesListWidget.this.updateTableContainerSize();
            }
        });
    }

    private void updateTableContainerSize() {
        int height = Window.getClientHeight() - CMS_HEADER_MENU_SIZE_PX - this.headerPanel.getOffsetHeight() - this.messageArea.getOffsetHeight() - this.tabContainer.getTabBar().getOffsetHeight() - this.buttonPanel.getOffsetHeight() - 14;
        this.tableContainer.setHeight(height + "px");
    }

    private List<SchedulesListRow> getSelected() {
        ArrayList<SchedulesListRow> selected = new ArrayList<SchedulesListRow>(this.rowCheckBoxes.size());
        for (CheckBox rowCB : this.rowCheckBoxes) {
            if (!rowCB.getValue().booleanValue()) continue;
            selected.add(rowCB.getData());
        }
        return selected;
    }

    private boolean isUserAuthorized(List<SchedulesListRow> selected, Action action) {
        for (SchedulesListRow schedule : selected) {
            if (Common.isUserAuthorized(schedule.getAssociatedEntityType(), action)) continue;
            return false;
        }
        return true;
    }

    private void load() {
        this.busyIndicator.center();
        this.service.getAllJobs((AsyncCallback<List<SchedulesListRow>>)new NeptuneAsyncCallback<List<SchedulesListRow>>(){

            public void onNeptuneFailure(Throwable caught) {
                SchedulesListWidget.this.busyIndicator.hide();
                Window.alert((String)("Failed to load schedules list." + Common.getFailureMessageSuffix(caught)));
            }

            public void onNeptuneSuccess(List<SchedulesListRow> schedules) {
                SchedulesListWidget.this.rowCheckBoxes = new ArrayList(schedules.size());
                SchedulesListWidget.this.buildTable(schedules);
                SchedulesListWidget.this.busyIndicator.hide();
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        Document.get().getElementById(SchedulesListWidget.ID_COLUMN_HEADER_CELL_ID).dispatchEvent(Document.get().createClickEvent(0, 0, 0, 0, 0, false, false, false, false));
                    }
                });
            }
        });
    }

    private void buildTable(List<SchedulesListRow> jobs) {
        FlexTable table = new FlexTable();
        table.addStyleName(TABLE_STYLE);
        this.tableContainer.setWidget((Widget)table);
        table.getRowFormatter().addStyleName(0, HEADER_ROW_STYLE);
        final CheckBoxWidget allCB = new CheckBoxWidget();
        allCB.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                if (SchedulesListWidget.this.rowCheckBoxes != null) {
                    for (CheckBoxWidget cb : SchedulesListWidget.this.rowCheckBoxes) {
                        cb.setValue((Boolean)event.getValue(), true);
                    }
                }
            }
        });
        table.setWidget(0, 0, (Widget)allCB);
        table.setText(0, 1, this.constants.columnLabelId());
        table.setText(0, 2, this.constants.columnLabelActive());
        table.setText(0, 3, this.constants.columnLabelName());
        table.setText(0, 4, this.constants.columnLabelAssociation());
        table.setText(0, 5, this.constants.columnLabelTemplateName());
        table.setText(0, 6, this.constants.columnLabelJobScheduleRule());
        table.getCellFormatter().addStyleName(0, 0, "sorttable_nosort");
        table.getCellFormatter().getElement(0, 1).setId(ID_COLUMN_HEADER_CELL_ID);
        table.getCellFormatter().setWidth(0, 0, "1%");
        table.getCellFormatter().setWidth(0, 1, "3%");
        table.getCellFormatter().setWidth(0, 2, "10%");
        table.getCellFormatter().setWidth(0, 3, "12%");
        table.getCellFormatter().setWidth(0, 4, "20%");
        table.getCellFormatter().setWidth(0, 5, "19%");
        table.getCellFormatter().setWidth(0, 6, "35%");
        int tableWidth = table.getOffsetWidth();
        int associationDescriptionCellWidth = tableWidth * 4 / 10;
        int rowIndex = 1;
        for (SchedulesListRow job : jobs) {
            table.getRowFormatter().addStyleName(rowIndex, DATA_ROW_STYLE);
            if (job.isEditAllowed()) {
                CheckBox cb = new CheckBox(job);
                cb.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                    public void onValueChange(ValueChangeEvent<Boolean> event) {
                        if (!((Boolean)event.getValue()).booleanValue()) {
                            allCB.setValue(Boolean.valueOf(false), false);
                        }
                    }
                });
                table.setWidget(rowIndex, 0, (Widget)cb);
                this.rowCheckBoxes.add(cb);
            }
            LabelWidget idWidget = new LabelWidget(Long.toString(job.getId()));
            if (job.getHistoryToken() != null) {
                idWidget = new HyperlinkWidget(Long.toString(job.getId()), job.getHistoryToken());
            }
            table.setWidget(rowIndex, 1, (Widget)idWidget);
            table.getCellFormatter().setAlignment(rowIndex, 1, HasHorizontalAlignment.ALIGN_CENTER, HasVerticalAlignment.ALIGN_MIDDLE);
            ImageWidget enabledImageWidget = new ImageWidget(job.isActive() ? ENABLED_IMAGE : DISABLED_IMAGE);
            LabelWidget hiddenLabelWidget = new LabelWidget(job.isActive() ? "1" : "0");
            hiddenLabelWidget.setVisible(false);
            HorizontalPanel imagePanel = new HorizontalPanel();
            imagePanel.add((Widget)hiddenLabelWidget);
            imagePanel.add((Widget)enabledImageWidget);
            table.setWidget(rowIndex, 2, (Widget)imagePanel);
            table.getCellFormatter().setAlignment(rowIndex, 2, HasHorizontalAlignment.ALIGN_CENTER, HasVerticalAlignment.ALIGN_MIDDLE);
            table.setWidget(rowIndex, 3, (Widget)new LabelWidget(job.getName()));
            String truncatedAssociatedDescription = SchedulesListUtils.getTruncatedAssociationDescription(job.getAssociationDescription(), associationDescriptionCellWidth);
            table.setWidget(rowIndex, 4, (Widget)new LabelWidget(truncatedAssociatedDescription));
            table.setWidget(rowIndex, 5, (Widget)new LabelWidget(job.getTemplateName()));
            table.setWidget(rowIndex, 6, (Widget)new LabelWidget(SchedulingWidget.getScheduleInfoString(job.getScheduleInfo())));
            ++rowIndex;
        }
        SchedulesListWidget.enableSort(table.getElement());
    }

    private void delete(Set<Long> ids) {
        this.service.delete(ids, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                SchedulesListWidget.this.setErrorMessage("Failed to delete the selected schedules." + Common.getFailureMessageSuffix(caught));
            }

            public void onNeptuneSuccess(Void result) {
                SchedulesListWidget.this.setInfoMessage("Successfully deleted the schedules.");
                SchedulesListWidget.this.load();
            }
        });
    }

    private void confirm(String questionText, final Command yesCommand, final Command noCommand) {
        final DialogBoxContainer dialogBox = new DialogBoxContainer(false, true);
        dialogBox.setText(questionText);
        ButtonWidget yesButton = new ButtonWidget(this.constants.yes());
        yesButton.removeStyleName("gwt-Button");
        yesButton.addStyleName("ebBtn");
        yesButton.addStyleName("ebBtn_color_green");
        yesButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                dialogBox.hide();
                if (yesCommand != null) {
                    yesCommand.execute();
                }
            }
        });
        ButtonWidget noButton = new ButtonWidget(this.constants.no());
        noButton.removeStyleName("gwt-Button");
        noButton.addStyleName("ebBtn");
        noButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                dialogBox.hide();
                if (noCommand != null) {
                    noCommand.execute();
                }
            }
        });
        HorizontalContainer buttonPanel = new HorizontalContainer();
        buttonPanel.addStyleName("cms_button_container");
        dialogBox.setWidget((Widget)buttonPanel);
        buttonPanel.add((Widget)yesButton);
        buttonPanel.setCellHorizontalAlignment((Widget)yesButton, HorizontalPanel.ALIGN_RIGHT);
        buttonPanel.add((Widget)noButton);
        buttonPanel.setCellHorizontalAlignment((Widget)noButton, HorizontalPanel.ALIGN_LEFT);
        dialogBox.center();
        dialogBox.show();
    }

    private void setInfoMessage(String message) {
        this.messageArea.setInfoMessage(message);
        this.updateTableContainerSize();
    }

    private void setErrorMessage(String message) {
        this.messageArea.setErrorMessage(message);
        this.updateTableContainerSize();
    }

    private static native void enableSort(Element var0);

    protected void onLoad() {
        super.onLoad();
        this.resizeHandlerRegistration = Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                SchedulesListWidget.this.updateTableContainerSize();
            }
        });
    }

    protected void onUnload() {
        this.resizeHandlerRegistration.removeHandler();
        this.resizeHandlerRegistration = null;
        this.busyIndicator.hide();
        super.onUnload();
    }

    private static class CheckBox
    extends CheckBoxWidget {
        private SchedulesListRow data;

        public CheckBox() {
        }

        public CheckBox(SchedulesListRow data) {
            this();
            this.data = data;
        }

        public SchedulesListRow getData() {
            return this.data;
        }

        public void setData(SchedulesListRow data) {
            this.data = data;
        }
    }
}

