/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduling.ui.client.common;

import com.ericsson.cms.scheduling.ui.client.Action;
import com.ericsson.cms.scheduling.ui.client.IUISchedulerClient;
import com.ericsson.cms.scheduling.ui.client.common.SchedulingConstants;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Common {
    public static final String STYLE_SECTION_HEADING = "scheduler-sectionHeading";
    public static final String STYLE_REQUIRED = "scheduler-requiredMarker";
    public static final String STYLE_DISCLOSURE_CONTAINER = "scheduler-disclosureContainer";
    public static SchedulingConstants constants = (SchedulingConstants)GWT.create(SchedulingConstants.class);

    public static Widget getRequiredFieldName(String associatedWith) {
        HorizontalContainer container = new HorizontalContainer();
        LabelWidget requiredMarker = new LabelWidget("*");
        requiredMarker.setStyleName(STYLE_REQUIRED);
        container.add((Widget)new LabelWidget(associatedWith));
        LabelWidget space = new LabelWidget(" ");
        container.add((Widget)space);
        container.setCellWidth((Widget)space, "5");
        container.add((Widget)requiredMarker);
        return container;
    }

    public static String getFailureMessageSuffix(Throwable caught) {
        return " | " + constants.reason() + ": " + (caught != null ? caught.getLocalizedMessage() : "");
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static Map<String, String> getParams(String anchor) {
        String[] paramsArray;
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        for (String param : paramsArray = anchor.split("&")) {
            String[] nameValueArray = param.split("=");
            paramsMap.put(nameValueArray[0], nameValueArray[1]);
        }
        return paramsMap;
    }

    public static boolean isUserAuthorized(String associatedEntityType, Action action) {
        IUISchedulerClient client = Common.getUIClient(associatedEntityType);
        if (client == null) {
            return true;
        }
        return client.isUserAuthorized(action);
    }

    public static IUISchedulerClient getUIClient(String associatedEntity) {
        List clients = NeptuneApplication.getApplication().getServiceLoader().loadServices(IUISchedulerClient.class);
        if (clients != null) {
            for (IUISchedulerClient client : clients) {
                if (!client.getName().equals(associatedEntity)) continue;
                return client;
            }
        }
        return null;
    }
}

