/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduling.ui.client.detailsPage;

import com.ericsson.cms.scheduling.ui.client.common.Common;
import com.ericsson.cms.scheduling.ui.client.common.SchedulingConstants;
import com.ericsson.cms.scheduling.ui.client.service.IUISchedulerService;
import com.ericsson.cms.scheduling.ui.client.service.IUISchedulerServiceAsync;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.MultiTaskBusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EntityAssociationWidget
extends Composite {
    private IUISchedulerServiceAsync service = (IUISchedulerServiceAsync)GWT.create(IUISchedulerService.class);
    private SchedulingConstants constants = (SchedulingConstants)GWT.create(SchedulingConstants.class);
    private MultiTaskBusyIndicator busyIndicator = new MultiTaskBusyIndicator();
    private ValueChangeListener listener;
    private ListBoxWidget<String> associatedEntityTypeListBox;
    private ListBoxWidget<Long> associatedEntitiesListBox;

    public EntityAssociationWidget(String selectedEntityType, Set<Long> selectedEntities) {
        RoundedDisclosureContainer disclosurePanel = new RoundedDisclosureContainer(this.constants.association(), true);
        disclosurePanel.addStyleName("scheduler-disclosureContainer");
        VerticalContainer associationPanel = new VerticalContainer();
        disclosurePanel.add((Widget)associationPanel);
        associationPanel.add(Common.getRequiredFieldName(this.constants.associatedWith()));
        HorizontalContainer associationSelectionPanel = new HorizontalContainer();
        associationPanel.add((Widget)associationSelectionPanel);
        this.associatedEntityTypeListBox = new ListBoxWidget(false);
        associationSelectionPanel.add(this.associatedEntityTypeListBox);
        LabelWidget spacerWidget = new LabelWidget();
        associationSelectionPanel.add((Widget)spacerWidget);
        associationSelectionPanel.setCellWidth((Widget)spacerWidget, "10");
        this.associatedEntitiesListBox = new ListBoxWidget(true);
        this.associatedEntitiesListBox.setVisibleItemCount(5);
        this.associatedEntitiesListBox.setVisible(false);
        associationSelectionPanel.add(this.associatedEntitiesListBox);
        this.associatedEntityTypeListBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                EntityAssociationWidget.this.updateEntities((String)EntityAssociationWidget.this.associatedEntityTypeListBox.getSelectedItem(), null);
                if (EntityAssociationWidget.this.listener != null) {
                    EntityAssociationWidget.this.listener.valueChanged((String)EntityAssociationWidget.this.associatedEntityTypeListBox.getSelectedItem());
                }
            }
        });
        this.initialize(selectedEntityType, selectedEntities);
        this.initWidget((Widget)disclosurePanel);
    }

    private void initialize(final String selectedEntityType, final Set<Long> selectedEntities) {
        this.busyIndicator.center();
        this.service.getAllEntityTypes((AsyncCallback<Map<String, String>>)new NeptuneAsyncCallback<Map<String, String>>(){

            public void onNeptuneFailure(Throwable caught) {
                EntityAssociationWidget.this.busyIndicator.hide();
                Window.alert((String)("Failed to get list of entity types." + Common.getFailureMessageSuffix(caught)));
            }

            public void onNeptuneSuccess(Map<String, String> entityTypes) {
                for (Map.Entry<String, String> entry : entityTypes.entrySet()) {
                    EntityAssociationWidget.this.associatedEntityTypeListBox.addItem(entry.getValue(), (Object)entry.getKey());
                }
                if (selectedEntityType != null) {
                    EntityAssociationWidget.this.associatedEntityTypeListBox.setSelectedItem((Object)selectedEntityType);
                } else {
                    EntityAssociationWidget.this.associatedEntityTypeListBox.setSelectedIndex(0);
                }
                EntityAssociationWidget.this.updateEntities((String)EntityAssociationWidget.this.associatedEntityTypeListBox.getSelectedItem(), selectedEntities);
                EntityAssociationWidget.this.busyIndicator.hide();
            }
        });
    }

    private void updateEntities(final String selectedEntityType, final Set<Long> selectedEntities) {
        if (selectedEntityType == null) {
            return;
        }
        this.busyIndicator.center();
        this.service.getEntitiesOfType(selectedEntityType, (AsyncCallback<Map<Long, String>>)new NeptuneAsyncCallback<Map<Long, String>>(){

            public void onNeptuneFailure(Throwable caught) {
                EntityAssociationWidget.this.busyIndicator.hide();
                Window.alert((String)("Failed to get list of entities of type: " + selectedEntityType + Common.getFailureMessageSuffix(caught)));
            }

            public void onNeptuneSuccess(Map<Long, String> entities) {
                EntityAssociationWidget.this.associatedEntitiesListBox.clear();
                if (entities == null) {
                    EntityAssociationWidget.this.associatedEntitiesListBox.setVisible(false);
                } else {
                    for (Map.Entry<Long, String> entry : entities.entrySet()) {
                        EntityAssociationWidget.this.associatedEntitiesListBox.addItem(entry.getValue(), (Object)entry.getKey());
                    }
                    if (selectedEntities != null) {
                        for (Long selectedEntity : selectedEntities) {
                            int index = EntityAssociationWidget.this.associatedEntitiesListBox.getIndex((Object)selectedEntity);
                            if (index == -1) continue;
                            EntityAssociationWidget.this.associatedEntitiesListBox.setItemSelected(index, true);
                        }
                    }
                    EntityAssociationWidget.this.associatedEntitiesListBox.setVisible(true);
                }
                EntityAssociationWidget.this.busyIndicator.hide();
            }
        });
    }

    public void setValueChangeListener(ValueChangeListener listener) {
        this.listener = listener;
    }

    public String getEntityType() {
        return (String)this.associatedEntityTypeListBox.getSelectedItem();
    }

    public Set<Long> getEntities() {
        HashSet<Long> entities = new HashSet<Long>();
        for (int i = 0; i < this.associatedEntitiesListBox.getItemCount(); ++i) {
            if (!this.associatedEntitiesListBox.isItemSelected(i)) continue;
            entities.add((Long)this.associatedEntitiesListBox.getItem(i));
        }
        return entities;
    }

    protected void onUnload() {
        super.onUnload();
        this.busyIndicator.hide();
    }

    public Collection<? extends String> validate() {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.associatedEntitiesListBox.isVisible() && this.getEntities().isEmpty()) {
            messages.add("Association is required");
        }
        return messages;
    }

    public String getEntityTypeDisplayName(String entityType) {
        for (int i = 0; i < this.associatedEntityTypeListBox.getItemCount(); ++i) {
            if (!((String)this.associatedEntityTypeListBox.getItem(i)).equals(entityType)) continue;
            return this.associatedEntityTypeListBox.getItemText(i);
        }
        return null;
    }

    public static interface ValueChangeListener {
        public void valueChanged(String var1);
    }
}

