/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduling.ui.client.detailsPage;

import com.ericsson.cms.scheduling.ui.client.common.Common;
import com.ericsson.cms.scheduling.ui.client.common.SchedulingConstants;
import com.ericsson.cms.scheduling.ui.client.common.UiProcessPriority;
import com.ericsson.cms.scheduling.ui.client.data.UITemplateVariable;
import com.ericsson.cms.scheduling.ui.client.data.UiMetadataTree;
import com.ericsson.cms.scheduling.ui.client.service.IUISchedulerService;
import com.ericsson.cms.scheduling.ui.client.service.IUISchedulerServiceAsync;
import com.ericsson.cms.scheduling.ui.client.widgets.MetadataFieldWidget;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.MultiTaskBusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExecutionInfoWidget
extends Composite {
    private static final String IMAGE = "neptune_framework/images/information_black_16px.svg";
    private static final String PRIORITY_INFO_TEXT = "priority-info-text";
    private static final String PRIORITY_ICON_SPACING = "priority-icon-spacing";
    private IUISchedulerServiceAsync service = (IUISchedulerServiceAsync)GWT.create(IUISchedulerService.class);
    private SchedulingConstants constants = (SchedulingConstants)GWT.create(SchedulingConstants.class);
    private String entityType;
    private boolean associatedWithTitles;
    private UiMetadataTree metadataTree;
    private MultiTaskBusyIndicator busyIndicator = new MultiTaskBusyIndicator();
    private ListBoxWidget<String> templateListBox;
    private ListBoxWidget<String> priorityListBox;
    private SimpleContainer paramsContainer;
    private ImageWidget toolTipImage;
    private LabelWidget priorityToolTipLabel;
    private Map<String, MetadataFieldWidget> paramWidgetsMap = new HashMap<String, MetadataFieldWidget>();
    private List<UITemplateVariable> params;

    public ExecutionInfoWidget(String entityType, boolean associatedWithTitles, final String templateName, String priority, final Map<String, String> paramValues) {
        this.entityType = entityType;
        this.associatedWithTitles = associatedWithTitles;
        RoundedDisclosureContainer disclosurePanel = new RoundedDisclosureContainer(this.constants.executeWorkOrder(), true);
        disclosurePanel.addStyleName("scheduler-disclosureContainer");
        VerticalContainer sectionContainer = new VerticalContainer();
        disclosurePanel.add((Widget)sectionContainer);
        FormContainer templatePriorityForm = new FormContainer(HorizontalContainer.ALIGN_CENTER);
        this.templateListBox = new ListBoxWidget();
        templatePriorityForm.addRow(this.constants.template(), this.templateListBox, true);
        HorizontalContainer priorityContainer = new HorizontalContainer();
        this.priorityListBox = new ListBoxWidget();
        for (UiProcessPriority property : UiProcessPriority.values()) {
            this.priorityListBox.addItem(property.toString(), (Object)property.toString());
        }
        this.priorityListBox.addItem(this.constants.priorityAssignByRules(), (Object)"_rules");
        this.priorityListBox.setSelectedItem((Object)priority);
        this.toolTipImage = new ImageWidget(IMAGE);
        this.toolTipImage.setTitle(this.constants.priorityInformation());
        this.toolTipImage.setVisible(true);
        this.toolTipImage.addStyleName(PRIORITY_ICON_SPACING);
        this.toolTipImage.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (ExecutionInfoWidget.this.priorityToolTipLabel.isVisible()) {
                    ExecutionInfoWidget.this.priorityToolTipLabel.setVisible(false);
                } else {
                    ExecutionInfoWidget.this.priorityToolTipLabel.setVisible(true);
                }
            }
        });
        this.priorityToolTipLabel = new LabelWidget(this.constants.priorityInformation());
        this.priorityToolTipLabel.setVisible(false);
        this.priorityToolTipLabel.addStyleName(PRIORITY_INFO_TEXT);
        priorityContainer.add(this.priorityListBox);
        priorityContainer.add((Widget)this.toolTipImage);
        priorityContainer.add((Widget)this.priorityToolTipLabel);
        templatePriorityForm.addRow(this.constants.priority(), (Widget)priorityContainer, true);
        sectionContainer.add((Widget)templatePriorityForm);
        LabelWidget jobParamsHeading = new LabelWidget(this.constants.jobParameters());
        sectionContainer.add((Widget)jobParamsHeading);
        this.paramsContainer = new SimpleContainer();
        sectionContainer.add((Widget)this.paramsContainer);
        this.templateListBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ExecutionInfoWidget.this.showParams((String)ExecutionInfoWidget.this.templateListBox.getSelectedItem(), null);
            }
        });
        this.loadTemplates(templateName, associatedWithTitles);
        this.loadMetadataTree(new Command(){

            public void execute() {
                ExecutionInfoWidget.this.showParams(templateName, paramValues);
            }
        });
        this.initWidget((Widget)disclosurePanel);
    }

    private void loadTemplates(final String selectedTemplate, boolean associatedWithTitles) {
        this.busyIndicator.center();
        this.service.getTemplates(associatedWithTitles, (AsyncCallback<List<String>>)new NeptuneAsyncCallback<List<String>>(){

            public void onNeptuneFailure(Throwable caught) {
                ExecutionInfoWidget.this.busyIndicator.hide();
                Window.alert((String)("Failed to get list of templates." + Common.getFailureMessageSuffix(caught)));
            }

            public void onNeptuneSuccess(List<String> templates) {
                ExecutionInfoWidget.this.templateListBox.clear();
                for (String template : templates) {
                    ExecutionInfoWidget.this.templateListBox.addItem(template, (Object)template);
                }
                ExecutionInfoWidget.this.templateListBox.setSelectedItem((Object)selectedTemplate);
                ExecutionInfoWidget.this.busyIndicator.hide();
            }
        });
    }

    private void showParams(final String templateName, final Map<String, String> paramValues) {
        this.paramsContainer.clear();
        this.paramWidgetsMap.clear();
        if (this.params != null) {
            this.params.clear();
        }
        if (templateName == null) {
            return;
        }
        this.busyIndicator.center();
        this.service.getStartVariablesForTemplate(templateName, this.associatedWithTitles, (AsyncCallback<List<UITemplateVariable>>)new NeptuneAsyncCallback<List<UITemplateVariable>>(){

            public void onNeptuneFailure(Throwable caught) {
                ExecutionInfoWidget.this.busyIndicator.hide();
                Window.alert((String)("Failed to get list of params for template: " + templateName + Common.getFailureMessageSuffix(caught)));
            }

            public void onNeptuneSuccess(List<UITemplateVariable> variables) {
                ExecutionInfoWidget.this.params = variables;
                if (variables != null) {
                    FormContainer paramsForm = new FormContainer(HorizontalContainer.ALIGN_CENTER);
                    ExecutionInfoWidget.this.paramsContainer.setWidget((Widget)paramsForm);
                    for (UITemplateVariable var : variables) {
                        MetadataFieldWidget treeWidget = new MetadataFieldWidget(true);
                        treeWidget.setVisibleLength(50);
                        treeWidget.setMetadataTree(ExecutionInfoWidget.this.metadataTree);
                        ExecutionInfoWidget.this.paramWidgetsMap.put(var.getName(), treeWidget);
                        if (var.isAutoMapped()) {
                            treeWidget.setValue("_autoMapped");
                        }
                        if (paramValues != null) {
                            treeWidget.setValue((String)paramValues.get(var.getName()));
                        }
                        if (var.isAutoMapped()) continue;
                        paramsForm.addRow(var.getDisplayName(), (Widget)treeWidget, var.isRequired());
                    }
                }
                ExecutionInfoWidget.this.busyIndicator.hide();
            }
        });
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
        this.loadMetadataTree(new Command(){

            public void execute() {
                ExecutionInfoWidget.this.showParams((String)ExecutionInfoWidget.this.templateListBox.getSelectedItem(), null);
            }
        });
    }

    public void setAssociatedWithTitles(boolean associatedWithTitles) {
        this.associatedWithTitles = associatedWithTitles;
        this.loadTemplates((String)this.templateListBox.getSelectedItem(), associatedWithTitles);
        this.loadMetadataTree(new Command(){

            public void execute() {
                ExecutionInfoWidget.this.showParams((String)ExecutionInfoWidget.this.templateListBox.getSelectedItem(), null);
            }
        });
    }

    private void loadMetadataTree(final Command command) {
        this.busyIndicator.center();
        this.service.getWOMappingMetadataTree(this.entityType, this.associatedWithTitles, (AsyncCallback<UiMetadataTree>)new NeptuneAsyncCallback<UiMetadataTree>(){

            public void onNeptuneFailure(Throwable caught) {
                ExecutionInfoWidget.this.busyIndicator.hide();
                Window.alert((String)("Failed to get workorder mapping metadata tree for entity type: " + ExecutionInfoWidget.this.entityType + " | associatedWithTitles: " + ExecutionInfoWidget.this.associatedWithTitles + Common.getFailureMessageSuffix(caught)));
            }

            public void onNeptuneSuccess(UiMetadataTree result) {
                ExecutionInfoWidget.this.metadataTree = result;
                command.execute();
                ExecutionInfoWidget.this.busyIndicator.hide();
            }
        });
    }

    public List<String> validate() {
        ArrayList<String> messages = new ArrayList<String>();
        if (Common.isBlank(this.getTemplateName())) {
            messages.add("Template Name is a required field.");
        }
        if (Common.isBlank(this.getPriority())) {
            messages.add("Priority is a required field.");
        }
        if (this.params != null) {
            for (UITemplateVariable var : this.params) {
                if (!var.isRequired() || !Common.isBlank(this.paramWidgetsMap.get(var.getName()).getValue())) continue;
                messages.add("Job parameter " + var.getDisplayName() + " is required.");
            }
        }
        return messages;
    }

    public String getTemplateName() {
        return (String)this.templateListBox.getSelectedItem();
    }

    public String getPriority() {
        return (String)this.priorityListBox.getSelectedItem();
    }

    public Map<String, String> getWoMappingParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry<String, MetadataFieldWidget> entry : this.paramWidgetsMap.entrySet()) {
            String value = entry.getValue().getValue();
            if (Common.isBlank(value)) continue;
            params.put(entry.getKey(), value);
        }
        return params;
    }

    protected void onUnload() {
        super.onUnload();
        this.busyIndicator.hideAll();
    }
}

