/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduling.ui.client.detailsPage;

import com.ericsson.cms.scheduling.ui.client.Action;
import com.ericsson.cms.scheduling.ui.client.common.Common;
import com.ericsson.cms.scheduling.ui.client.common.SchedulingConstants;
import com.ericsson.cms.scheduling.ui.client.common.UiInvalidScheduleException;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleType;
import com.ericsson.cms.scheduling.ui.client.data.UIWOJob;
import com.ericsson.cms.scheduling.ui.client.detailsPage.EntityAssociationWidget;
import com.ericsson.cms.scheduling.ui.client.detailsPage.ExecutionInfoWidget;
import com.ericsson.cms.scheduling.ui.client.detailsPage.ScheduleInfoWidget;
import com.ericsson.cms.scheduling.ui.client.service.IUISchedulerService;
import com.ericsson.cms.scheduling.ui.client.service.IUISchedulerServiceAsync;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.MultiTaskBusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ScheduleDetailsWidget
extends Composite {
    private static final String TAB_CONTAINER_STYLE = "scheduler-tabContainer";
    private static int CMS_HEADER_MENU_SIZE_PX = 115;
    private IUISchedulerServiceAsync service = (IUISchedulerServiceAsync)GWT.create(IUISchedulerService.class);
    private SchedulingConstants constants = (SchedulingConstants)GWT.create(SchedulingConstants.class);
    private MultiTaskBusyIndicator busyIndicator = new MultiTaskBusyIndicator();
    private HeaderPanel headerWidget;
    private MessageArea messageArea;
    private TabContainer tabContainer;
    private VerticalContainer tabPanel;
    private ScrollContainer scrollPanel;
    private VerticalContainer contentPanel;
    private TextBoxWidget nameTextBox;
    private EntityAssociationWidget ea;
    private ScheduleInfoWidget si;
    private ExecutionInfoWidget ei;
    private HorizontalContainer buttonPanel;
    private ButtonWidget saveButton;
    private ButtonWidget activateButton;
    private ButtonWidget inactivateButton;
    private ButtonWidget runNowButton;
    private ButtonWidget cancelButton;
    private HandlerRegistration resizeHandlerRegistration;
    private NeptuneSecurity security;
    private UIWOJob uiWOJob;
    private ViewMode viewMode;

    protected ScheduleDetailsWidget(NeptuneSecurity security) {
        this.security = security;
        VerticalContainer pagePanel = new VerticalContainer();
        pagePanel.setWidth("100%");
        this.headerWidget = new HeaderPanel(null);
        pagePanel.add((Widget)this.headerWidget);
        this.messageArea = new MessageArea();
        this.messageArea.reset();
        pagePanel.add((Widget)this.messageArea);
        this.tabContainer = new TabContainer();
        this.tabContainer.addStyleName(TAB_CONTAINER_STYLE);
        pagePanel.add((Widget)this.tabContainer);
        this.tabContainer.getTabBar().setVisible(false);
        this.tabPanel = new VerticalContainer();
        this.scrollPanel = new ScrollContainer();
        this.tabPanel.add((Widget)this.scrollPanel);
        this.contentPanel = new VerticalContainer();
        this.contentPanel.setSpacing(10);
        this.scrollPanel.add((Widget)this.contentPanel);
        this.buttonPanel = new HorizontalContainer();
        this.buttonPanel.addStyleName("cms_button_container");
        this.tabPanel.add((Widget)this.buttonPanel);
        this.initWidget((Widget)pagePanel);
    }

    public ScheduleDetailsWidget(final String associatedEntityType, Long associatedEntityId, NeptuneSecurity security) {
        this(security);
        if (!security.isUserInRole("Scheduler_Create")) {
            Window.alert((String)"You do not have permission to create a schedule.");
            return;
        }
        this.viewMode = ViewMode.CREATE;
        if (associatedEntityType != null && !Common.isUserAuthorized(associatedEntityType, Action.CREATE)) {
            this.busyIndicator.center();
            this.service.getAllEntityTypes((AsyncCallback<Map<String, String>>)new NeptuneAsyncCallback<Map<String, String>>(){

                public void onNeptuneFailure(Throwable caught) {
                    ScheduleDetailsWidget.this.busyIndicator.hide();
                    Window.alert((String)"You do not have permission to create a schedule for this entity.");
                }

                public void onNeptuneSuccess(Map<String, String> entityTypes) {
                    String entityTypeDisplayName = "this entity";
                    for (Map.Entry<String, String> entry : entityTypes.entrySet()) {
                        if (!entry.getKey().equals(associatedEntityType)) continue;
                        entityTypeDisplayName = entry.getValue();
                        break;
                    }
                    ScheduleDetailsWidget.this.busyIndicator.hide();
                    Window.alert((String)("You do not have permission to create a schedule for " + entityTypeDisplayName + "."));
                }
            });
            return;
        }
        this.uiWOJob = new UIWOJob();
        this.uiWOJob.setAssociatedEntityType(associatedEntityType);
        if (associatedEntityId != null) {
            HashSet<Long> associatedEntities = new HashSet<Long>();
            associatedEntities.add(associatedEntityId);
            this.uiWOJob.setAssociatedEntities(associatedEntities);
        }
        this.uiWOJob.setPriority("_rules");
        this.busyIndicator.center();
        if (Common.isBlank(associatedEntityType)) {
            this.service.isSelfPartnerAssociated((AsyncCallback<Boolean>)new NeptuneAsyncCallback<Boolean>(){

                public void onNeptuneFailure(Throwable caught) {
                    ScheduleDetailsWidget.this.busyIndicator.hide();
                    Window.alert((String)("Checking SELF Partner association with user failed: " + Common.getFailureMessageSuffix(caught)));
                }

                public void onNeptuneSuccess(Boolean result) {
                    if (Boolean.TRUE.equals(result)) {
                        ScheduleDetailsWidget.this.uiWOJob.setAssociatedEntityType("SELF");
                    } else {
                        ScheduleDetailsWidget.this.uiWOJob.setAssociatedEntityType("SOURCE");
                    }
                    ScheduleDetailsWidget.this.show(ScheduleDetailsWidget.this.uiWOJob);
                    ScheduleDetailsWidget.this.busyIndicator.hide();
                }
            });
        } else {
            this.show(this.uiWOJob);
            this.busyIndicator.hide();
        }
    }

    public ScheduleDetailsWidget(final long jobId, final NeptuneSecurity security) {
        this(security);
        if (!security.isUserInRole("Scheduler_Modify") && !security.isUserInRole("Scheduler_View")) {
            Window.alert((String)"You do not have permission to view or edit a schedule.");
            return;
        }
        this.busyIndicator.center();
        this.service.getWOJobByJobId(jobId, (AsyncCallback<UIWOJob>)new NeptuneAsyncCallback<UIWOJob>(){

            public void onNeptuneFailure(Throwable caught) {
                ScheduleDetailsWidget.this.busyIndicator.hide();
                Window.alert((String)("Getting workorder job failed for jobId: " + jobId + Common.getFailureMessageSuffix(caught)));
            }

            public void onNeptuneSuccess(UIWOJob result) {
                ScheduleDetailsWidget.this.uiWOJob = result;
                if (security.isUserInRole("Scheduler_Modify") && Common.isUserAuthorized(ScheduleDetailsWidget.this.uiWOJob.getAssociatedEntityType(), Action.MODIFY)) {
                    ScheduleDetailsWidget.this.viewMode = ViewMode.EDIT;
                } else if (security.isUserInRole("Scheduler_View") && Common.isUserAuthorized(ScheduleDetailsWidget.this.uiWOJob.getAssociatedEntityType(), Action.VIEW)) {
                    ScheduleDetailsWidget.this.viewMode = ViewMode.VIEW;
                } else {
                    ScheduleDetailsWidget.this.busyIndicator.hide();
                    Window.alert((String)"You do not have permission to view or edit this schedule.");
                    return;
                }
                ScheduleDetailsWidget.this.show(ScheduleDetailsWidget.this.uiWOJob);
                ScheduleDetailsWidget.this.busyIndicator.hide();
            }
        });
    }

    private void show(UIWOJob woJob) {
        this.setHeaderLabelAndTab(woJob);
        HorizontalContainer namePanel = new HorizontalContainer();
        namePanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        namePanel.add(Common.getRequiredFieldName(this.constants.name()));
        LabelWidget spacerWidget = new LabelWidget();
        namePanel.add((Widget)spacerWidget);
        namePanel.setCellWidth((Widget)spacerWidget, "10");
        this.nameTextBox = new TextBoxWidget();
        this.nameTextBox.setVisibleLength(this.constants.maxVisibleLengthJobName());
        this.nameTextBox.setText(woJob.getName());
        namePanel.add((Widget)this.nameTextBox);
        this.contentPanel.add((Widget)namePanel);
        this.ea = new EntityAssociationWidget(woJob.getAssociatedEntityType(), woJob.getAssociatedEntities());
        this.contentPanel.add((Widget)this.ea);
        this.si = new ScheduleInfoWidget(woJob.getAssociatedEntityType(), woJob.getScheduleInfo());
        this.contentPanel.add((Widget)this.si);
        boolean associatedWithTitles = true;
        if (woJob.getScheduleInfo() != null) {
            associatedWithTitles = woJob.getScheduleInfo().getScheduleType() == ScheduleType.N_DAYS_FROM_METADATA;
        }
        this.ei = new ExecutionInfoWidget(woJob.getAssociatedEntityType(), associatedWithTitles, woJob.getTemplateName(), woJob.getPriority(), woJob.getWoMappingParams());
        this.contentPanel.add((Widget)this.ei);
        this.ea.setValueChangeListener(new EntityAssociationWidget.ValueChangeListener(){

            @Override
            public void valueChanged(String entityType) {
                ScheduleDetailsWidget.this.si.setEntityType(entityType);
                ScheduleDetailsWidget.this.ei.setEntityType(entityType);
            }
        });
        this.si.setValueChangeListener(new ScheduleInfoWidget.ValueChangeListener(){

            @Override
            public void valueChanged(boolean associatedWithTitles) {
                ScheduleDetailsWidget.this.ei.setAssociatedWithTitles(associatedWithTitles);
            }
        });
        this.saveButton = new ButtonWidget(this.constants.buttonLabelSave());
        this.saveButton.removeStyleName("gwt-Button");
        this.saveButton.addStyleName("ebBtn");
        this.saveButton.addStyleName("ebBtn_color_green");
        this.saveButton.addStyleName("save_button_icon");
        this.saveButton.setVisible(false);
        this.saveButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ScheduleDetailsWidget.this.busyIndicator.center();
                List<String> validationMessages = ScheduleDetailsWidget.this.validate();
                if (!validationMessages.isEmpty()) {
                    ScheduleDetailsWidget.this.setErrorMessages(validationMessages);
                    ScheduleDetailsWidget.this.busyIndicator.hide();
                    return;
                }
                final String jobName = ScheduleDetailsWidget.this.nameTextBox.getText().trim();
                ScheduleDetailsWidget.this.service.isJobNameAlreadyUsed(jobName, (AsyncCallback<Boolean>)new NeptuneAsyncCallback<Boolean>(){

                    public void onNeptuneFailure(Throwable caught) {
                        ScheduleDetailsWidget.this.setErrorMessage("Failed to check if Job Name is unique." + Common.getFailureMessageSuffix(caught));
                        ScheduleDetailsWidget.this.busyIndicator.hide();
                    }

                    public void onNeptuneSuccess(Boolean result) {
                        if (Boolean.FALSE.equals(result) || jobName.equals(ScheduleDetailsWidget.this.uiWOJob.getName())) {
                            ScheduleDetailsWidget.this.busyIndicator.center();
                            ScheduleDetailsWidget.this.service.save(ScheduleDetailsWidget.this.getData(), (AsyncCallback<UIWOJob>)new NeptuneAsyncCallback<UIWOJob>(){

                                public void onNeptuneFailure(Throwable caught) {
                                    if (caught instanceof UiInvalidScheduleException) {
                                        UiInvalidScheduleException uise = (UiInvalidScheduleException)((Object)caught);
                                        ArrayList<String> errorMessages = new ArrayList<String>();
                                        for (String reasonCode : uise.getReasons().keySet()) {
                                            if ("errInvalidSchedule".equals(reasonCode)) {
                                                errorMessages.add(ScheduleDetailsWidget.this.constants.errInvalidSchedule());
                                                continue;
                                            }
                                            errorMessages.add(ScheduleDetailsWidget.this.constants.errDefault());
                                        }
                                        ScheduleDetailsWidget.this.setErrorMessages(errorMessages);
                                    } else {
                                        ScheduleDetailsWidget.this.setErrorMessage("Failed to save the schedule." + Common.getFailureMessageSuffix(caught));
                                    }
                                    ScheduleDetailsWidget.this.busyIndicator.hide();
                                }

                                public void onNeptuneSuccess(UIWOJob result) {
                                    ScheduleDetailsWidget.this.uiWOJob = result;
                                    ScheduleDetailsWidget.this.setInfoMessage("Successfully saved the schedule.");
                                    if (ScheduleDetailsWidget.this.viewMode == ViewMode.CREATE) {
                                        if (ScheduleDetailsWidget.this.security.isUserInRole("Scheduler_Modify") && Common.isUserAuthorized(ScheduleDetailsWidget.this.uiWOJob.getAssociatedEntityType(), Action.MODIFY)) {
                                            ScheduleDetailsWidget.this.viewMode = ViewMode.EDIT;
                                        } else {
                                            ScheduleDetailsWidget.this.viewMode = ViewMode.VIEW;
                                        }
                                    }
                                    ScheduleDetailsWidget.this.setHeaderLabelAndTab(ScheduleDetailsWidget.this.uiWOJob);
                                    ScheduleDetailsWidget.this.showAppropriateButtons();
                                    ScheduleDetailsWidget.this.busyIndicator.hide();
                                }
                            });
                        } else {
                            ScheduleDetailsWidget.this.setErrorMessage(ScheduleDetailsWidget.this.constants.jobNameIsAlredayInUse());
                        }
                        ScheduleDetailsWidget.this.busyIndicator.hide();
                    }
                });
            }
        });
        this.buttonPanel.add((Widget)this.saveButton);
        this.activateButton = new ButtonWidget(this.constants.buttonLabelActivate());
        this.activateButton.removeStyleName("gwt-Button");
        this.activateButton.addStyleName("ebBtn");
        this.activateButton.addStyleName("enable_button_icon");
        this.activateButton.setVisible(false);
        this.activateButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                HashSet<Long> ids = new HashSet<Long>();
                ids.add(ScheduleDetailsWidget.this.uiWOJob.getId());
                ScheduleDetailsWidget.this.service.setActive(ids, true, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                    public void onNeptuneFailure(Throwable caught) {
                        ScheduleDetailsWidget.this.setErrorMessage("Failed to activate the schedule." + Common.getFailureMessageSuffix(caught));
                    }

                    public void onNeptuneSuccess(Void result) {
                        ScheduleDetailsWidget.this.setInfoMessage("Successfully activated the schedule.");
                        ScheduleDetailsWidget.this.uiWOJob.setActive(true);
                        ScheduleDetailsWidget.this.showAppropriateButtons();
                    }
                });
            }
        });
        this.buttonPanel.add((Widget)this.activateButton);
        this.runNowButton = new ButtonWidget(this.constants.buttonLabelRunNow());
        this.runNowButton.removeStyleName("gwt-Button");
        this.runNowButton.addStyleName("ebBtn");
        this.runNowButton.addStyleName("ebBtn_color_green");
        this.runNowButton.addStyleName("runnow_button_icon");
        this.runNowButton.setVisible(false);
        this.runNowButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                HashSet<Long> ids = new HashSet<Long>();
                ids.add(ScheduleDetailsWidget.this.uiWOJob.getJobId());
                ScheduleDetailsWidget.this.service.runNow(ids, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                    public void onNeptuneFailure(Throwable caught) {
                        ScheduleDetailsWidget.this.setErrorMessage("Failed to run schedule." + Common.getFailureMessageSuffix(caught));
                    }

                    public void onNeptuneSuccess(Void result) {
                        ScheduleDetailsWidget.this.setInfoMessage("Requested to run the schedule.");
                    }
                });
            }
        });
        this.buttonPanel.add((Widget)this.runNowButton);
        this.inactivateButton = new ButtonWidget(this.constants.buttonLabelInactivate());
        this.inactivateButton.removeStyleName("gwt-Button");
        this.inactivateButton.addStyleName("ebBtn");
        this.inactivateButton.addStyleName("disable_button_icon");
        this.inactivateButton.setVisible(false);
        this.inactivateButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                HashSet<Long> ids = new HashSet<Long>();
                ids.add(ScheduleDetailsWidget.this.uiWOJob.getId());
                ScheduleDetailsWidget.this.service.setActive(ids, false, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                    public void onNeptuneFailure(Throwable caught) {
                        ScheduleDetailsWidget.this.setErrorMessage("Failed to inactivate the schedule." + Common.getFailureMessageSuffix(caught));
                    }

                    public void onNeptuneSuccess(Void result) {
                        ScheduleDetailsWidget.this.setInfoMessage("Successfully inactivated the schedule.");
                        ScheduleDetailsWidget.this.uiWOJob.setActive(false);
                        ScheduleDetailsWidget.this.showAppropriateButtons();
                    }
                });
            }
        });
        this.buttonPanel.add((Widget)this.inactivateButton);
        this.cancelButton = new ButtonWidget(this.constants.buttonLabelCancel());
        this.cancelButton.removeStyleName("gwt-Button");
        this.cancelButton.addStyleName("ebBtn");
        this.cancelButton.setVisible(false);
        this.cancelButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                History.back();
            }
        });
        this.buttonPanel.add((Widget)this.cancelButton);
        this.showAppropriateButtons();
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                ScheduleDetailsWidget.this.updateScrollPanelSize();
                ScheduleDetailsWidget.this.nameTextBox.setFocus(true);
            }
        });
    }

    private void setHeaderLabelAndTab(UIWOJob woJob) {
        switch (this.viewMode) {
            case CREATE: {
                this.headerWidget.setLabel(this.constants.headingCreate());
                this.tabContainer.add((Widget)this.tabPanel, "Create");
                break;
            }
            case VIEW: {
                this.headerWidget.setLabel(this.constants.headingView() + woJob.getName());
                this.tabContainer.add((Widget)this.tabPanel, "View");
                break;
            }
            case EDIT: {
                this.headerWidget.setLabel(this.constants.headingEdit() + woJob.getName());
                this.tabContainer.add((Widget)this.tabPanel, "Edit");
            }
        }
        this.tabContainer.selectTab(0);
    }

    private void showAppropriateButtons() {
        this.saveButton.setVisible(false);
        this.activateButton.setVisible(false);
        this.inactivateButton.setVisible(false);
        this.runNowButton.setVisible(false);
        this.cancelButton.setVisible(true);
        if (this.viewMode == ViewMode.CREATE || this.viewMode == ViewMode.EDIT) {
            this.saveButton.setVisible(true);
        }
        if (this.viewMode == ViewMode.EDIT) {
            if (this.uiWOJob.isActive()) {
                if (Common.isUserAuthorized(this.uiWOJob.getAssociatedEntityType(), Action.INACTIVATE)) {
                    this.inactivateButton.setVisible(true);
                }
            } else if (Common.isUserAuthorized(this.uiWOJob.getAssociatedEntityType(), Action.ACTIVATE)) {
                this.activateButton.setVisible(true);
            }
        }
        if (this.viewMode != ViewMode.CREATE && this.uiWOJob.isActive() && this.security.isUserInRole("Scheduler_Execute") && Common.isUserAuthorized(this.uiWOJob.getAssociatedEntityType(), Action.EXECUTE)) {
            this.runNowButton.setVisible(true);
        }
    }

    private void updateScrollPanelSize() {
        int height = Window.getClientHeight() - CMS_HEADER_MENU_SIZE_PX - this.headerWidget.getOffsetHeight() - this.messageArea.getOffsetHeight() - this.tabContainer.getTabBar().getOffsetHeight() - this.buttonPanel.getOffsetHeight() - 14;
        this.scrollPanel.setHeight(height + "px");
    }

    private void setInfoMessage(String message) {
        this.messageArea.setInfoMessage(message);
        this.updateScrollPanelSize();
    }

    private void setErrorMessage(String message) {
        this.messageArea.setErrorMessage(message);
        this.updateScrollPanelSize();
    }

    private void setErrorMessages(List<String> messages) {
        StringBuilder sb = new StringBuilder();
        sb.append("<ul>");
        for (String message : messages) {
            sb.append("<li>").append(message).append("</li>");
        }
        sb.append("</ul>");
        this.messageArea.setErrorHTML(sb.toString());
        this.updateScrollPanelSize();
    }

    public List<String> validate() {
        ArrayList<String> messages = new ArrayList<String>();
        String jobName = this.nameTextBox.getText();
        if (Common.isBlank(jobName)) {
            messages.add(this.constants.jobNameIsRequired());
        } else {
            jobName = jobName.trim();
            int jobNameMaxLength = this.constants.maxLengthJobName();
            if (jobNameMaxLength < jobName.length()) {
                messages.add(this.constants.jobNameCannotBeLonger());
            }
        }
        messages.addAll(this.ea.validate());
        messages.addAll(this.si.validate());
        messages.addAll(this.ei.validate());
        messages.addAll(this.verifyAssociationPermissions(this.uiWOJob, this.getData()));
        return messages;
    }

    public UIWOJob getData() {
        UIWOJob uiWOJob = new UIWOJob();
        uiWOJob.setId(this.uiWOJob.getId());
        uiWOJob.setName(this.nameTextBox.getText().trim());
        uiWOJob.setAssociatedEntityType(this.ea.getEntityType());
        uiWOJob.setAssociatedEntities(this.ea.getEntities());
        try {
            uiWOJob.setScheduleInfo(this.si.getScheduleInfo());
        }
        catch (Exception exception) {
            // empty catch block
        }
        uiWOJob.setTemplateName(this.ei.getTemplateName());
        uiWOJob.setPriority(this.ei.getPriority());
        uiWOJob.setWoMappingParams(this.ei.getWoMappingParams());
        return uiWOJob;
    }

    private List<String> verifyAssociationPermissions(UIWOJob oldJob, UIWOJob newJob) {
        LinkedList<String> errorMessages = new LinkedList<String>();
        if (this.viewMode == ViewMode.CREATE) {
            if (!this.authorizedToAssociate(newJob.getAssociatedEntityType())) {
                errorMessages.add("You do not have permission to create a schedule for " + this.ea.getEntityTypeDisplayName(newJob.getAssociatedEntityType()));
            }
        } else if (this.viewMode == ViewMode.EDIT) {
            if (newJob.getAssociatedEntityType().equals(oldJob.getAssociatedEntityType())) {
                HashSet<Long> oldEntities = new HashSet<Long>(oldJob.getAssociatedEntities());
                HashSet<Long> newEntities = new HashSet<Long>(newJob.getAssociatedEntities());
                oldEntities.removeAll(newEntities);
                HashSet<Long> removedEntities = oldEntities;
                oldEntities = new HashSet<Long>(oldJob.getAssociatedEntities());
                newEntities.removeAll(oldEntities);
                HashSet<Long> addedEntities = newEntities;
                if (!removedEntities.isEmpty() && !this.authorizedToDissociate(newJob.getAssociatedEntityType())) {
                    errorMessages.add("You do not have permission to dissociate this schedule from " + this.ea.getEntityTypeDisplayName(newJob.getAssociatedEntityType()));
                }
                if (!addedEntities.isEmpty() && !this.authorizedToAssociate(newJob.getAssociatedEntityType())) {
                    errorMessages.add("You do not have permission to associate this schedule with " + this.ea.getEntityTypeDisplayName(newJob.getAssociatedEntityType()));
                }
            } else {
                if (!this.authorizedToDissociate(oldJob.getAssociatedEntityType())) {
                    errorMessages.add("You do not have permission to dissociate this schedule from " + this.ea.getEntityTypeDisplayName(oldJob.getAssociatedEntityType()));
                }
                if (!this.authorizedToAssociate(newJob.getAssociatedEntityType())) {
                    errorMessages.add("You do not have permission to associate this schedule with " + this.ea.getEntityTypeDisplayName(newJob.getAssociatedEntityType()));
                }
            }
        }
        return errorMessages;
    }

    private boolean authorizedToAssociate(String entityType) {
        return this.security.isUserInRole("Scheduler_Create") && Common.isUserAuthorized(entityType, Action.CREATE);
    }

    private boolean authorizedToDissociate(String entityType) {
        return this.security.isUserInRole("Scheduler_Delete") && Common.isUserAuthorized(entityType, Action.DELETE);
    }

    protected void onLoad() {
        super.onLoad();
        this.resizeHandlerRegistration = Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                ScheduleDetailsWidget.this.updateScrollPanelSize();
            }
        });
    }

    protected void onUnload() {
        this.resizeHandlerRegistration.removeHandler();
        this.resizeHandlerRegistration = null;
        this.busyIndicator.hide();
        super.onUnload();
    }

    static enum ViewMode {
        CREATE,
        VIEW,
        EDIT;

    }
}

