/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduling.ui.client.detailsPage;

import com.ericsson.cms.scheduling.ui.client.common.Common;
import com.ericsson.cms.scheduling.ui.client.common.SchedulingConstants;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleInfo;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleType;
import com.ericsson.cms.scheduling.ui.client.data.UiMetadataTree;
import com.ericsson.cms.scheduling.ui.client.service.IUISchedulerService;
import com.ericsson.cms.scheduling.ui.client.service.IUISchedulerServiceAsync;
import com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidget2;
import com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetConfig;
import com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetFactory;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.RadioButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.MultiTaskBusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.List;

public class ScheduleInfoWidget
extends Composite {
    private IUISchedulerServiceAsync service = (IUISchedulerServiceAsync)GWT.create(IUISchedulerService.class);
    private SchedulingConstants constants = (SchedulingConstants)GWT.create(SchedulingConstants.class);
    private UiMetadataTree ruleMetadataTree;
    private ValueChangeListener listener;
    private MultiTaskBusyIndicator busyIndicator = new MultiTaskBusyIndicator();
    private RadioButtonWidget yesRadioButton;
    private RadioButtonWidget noRadioButton;
    private SimpleContainer schedulingWidgetContainer;
    private SchedulingWidget2 schedulingWidget;
    private static final String SCHEDULE_WIDGET_TABLE_STYLE = "schedule-widget-table";
    private static final String SCHEDULE_WIDGET_PANEL_STYLE = "schedule-widget-panel";

    public ScheduleInfoWidget(String entityType, final ScheduleInfo scheduleInfo) {
        RoundedDisclosureContainer disclosurePanel = new RoundedDisclosureContainer(this.constants.scheduleInformation(), true);
        disclosurePanel.addStyleName("scheduler-disclosureContainer");
        VerticalContainer sectionContainer = new VerticalContainer();
        disclosurePanel.add((Widget)sectionContainer);
        HorizontalContainer associateWithTitlesPanel = new HorizontalContainer();
        associateWithTitlesPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        associateWithTitlesPanel.add(Common.getRequiredFieldName(this.constants.associatedWithTitles()));
        LabelWidget spacerWidget = new LabelWidget();
        associateWithTitlesPanel.add((Widget)spacerWidget);
        associateWithTitlesPanel.setCellWidth((Widget)spacerWidget, "10");
        this.yesRadioButton = new RadioButtonWidget("associateWithTitles");
        this.yesRadioButton.setText(this.constants.yes());
        this.yesRadioButton.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                if (ScheduleInfoWidget.this.yesRadioButton.getValue().booleanValue()) {
                    ScheduleInfoWidget.this.updateSchedulingWidget(true, null);
                    if (ScheduleInfoWidget.this.listener != null) {
                        ScheduleInfoWidget.this.listener.valueChanged(true);
                    }
                }
            }
        });
        associateWithTitlesPanel.add((Widget)this.yesRadioButton);
        spacerWidget = new LabelWidget();
        associateWithTitlesPanel.add((Widget)spacerWidget);
        associateWithTitlesPanel.setCellWidth((Widget)spacerWidget, "10");
        this.noRadioButton = new RadioButtonWidget("associateWithTitles");
        this.noRadioButton.setText(this.constants.no());
        this.noRadioButton.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                if (ScheduleInfoWidget.this.noRadioButton.getValue().booleanValue()) {
                    ScheduleInfoWidget.this.updateSchedulingWidget(false, null);
                    if (ScheduleInfoWidget.this.listener != null) {
                        ScheduleInfoWidget.this.listener.valueChanged(false);
                    }
                }
            }
        });
        associateWithTitlesPanel.add((Widget)this.noRadioButton);
        sectionContainer.add((Widget)associateWithTitlesPanel);
        HorizontalContainer hc = new HorizontalContainer();
        hc.setVerticalAlignment(HasVerticalAlignment.ALIGN_TOP);
        this.schedulingWidgetContainer = new SimpleContainer();
        hc.add(Common.getRequiredFieldName(this.constants.scheduleRule()));
        hc.add((Widget)this.schedulingWidgetContainer);
        this.schedulingWidgetContainer.setStyleName(SCHEDULE_WIDGET_PANEL_STYLE);
        hc.getWidget(0).setStyleName(SCHEDULE_WIDGET_TABLE_STYLE);
        sectionContainer.add((Widget)hc);
        this.loadMetadataTree(entityType, new Command(){

            public void execute() {
                if (scheduleInfo == null) {
                    ScheduleInfoWidget.this.yesRadioButton.setValue(Boolean.valueOf(true));
                    ScheduleInfoWidget.this.updateSchedulingWidget(true, null);
                } else {
                    ScheduleType type = scheduleInfo.getScheduleType();
                    if (type == ScheduleType.N_DAYS_FROM_METADATA) {
                        ScheduleInfoWidget.this.yesRadioButton.setValue(Boolean.valueOf(true));
                        ScheduleInfoWidget.this.updateSchedulingWidget(true, scheduleInfo);
                    } else {
                        ScheduleInfoWidget.this.noRadioButton.setValue(Boolean.valueOf(true));
                        ScheduleInfoWidget.this.updateSchedulingWidget(false, scheduleInfo);
                    }
                }
            }
        });
        this.initWidget((Widget)disclosurePanel);
    }

    private void loadMetadataTree(final String entityType, final Command command) {
        this.busyIndicator.center();
        this.service.getRuleMetadataTree(entityType, (AsyncCallback<UiMetadataTree>)new NeptuneAsyncCallback<UiMetadataTree>(){

            public void onNeptuneFailure(Throwable caught) {
                ScheduleInfoWidget.this.busyIndicator.hide();
                Window.alert((String)("Failed to get rule metadata tree for entity type:" + entityType + Common.getFailureMessageSuffix(caught)));
            }

            public void onNeptuneSuccess(UiMetadataTree result) {
                ScheduleInfoWidget.this.ruleMetadataTree = result;
                command.execute();
                ScheduleInfoWidget.this.busyIndicator.hide();
            }
        });
    }

    private void updateSchedulingWidget(boolean associatedWithTitles, ScheduleInfo scheduleInfo) {
        SchedulingWidgetConfig widgetConfig = new SchedulingWidgetConfig();
        widgetConfig.setShowOnDateRow(!associatedWithTitles);
        widgetConfig.setShowEveryNDaysRow(!associatedWithTitles);
        widgetConfig.setShowOnDayEveryNWeeksRow(!associatedWithTitles);
        widgetConfig.setShowNDaysFromMetadataRow(associatedWithTitles);
        widgetConfig.setShowEveryNHourMinsRow(!associatedWithTitles);
        this.schedulingWidget = SchedulingWidgetFactory.create2(widgetConfig);
        this.schedulingWidget.setScheduleInfo(scheduleInfo);
        this.schedulingWidget.setMetadataTree(this.ruleMetadataTree);
        this.schedulingWidgetContainer.setWidget((Widget)this.schedulingWidget);
    }

    public void setValueChangeListener(ValueChangeListener listener) {
        this.listener = listener;
    }

    public void setEntityType(String entityType) {
        this.loadMetadataTree(entityType, new Command(){

            public void execute() {
                ScheduleInfoWidget.this.updateSchedulingWidget(ScheduleInfoWidget.this.yesRadioButton.getValue(), null);
            }
        });
    }

    public List<String> validate() {
        return this.schedulingWidget.validate();
    }

    public ScheduleInfo getScheduleInfo() {
        return this.schedulingWidget.getScheduleInfo();
    }

    protected void onUnload() {
        super.onUnload();
        this.busyIndicator.hide();
    }

    public static interface ValueChangeListener {
        public void valueChanged(boolean var1);
    }
}

