/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduling.ui.client.portlet.upcomingjobs;

import com.ericsson.cms.scheduling.ui.client.data.UIExecutionRecord;
import com.ericsson.cms.scheduling.ui.client.portlet.PortletConstants;
import com.ericsson.cms.scheduling.ui.client.portlet.upcomingjobs.UpcomingJobsPortletConfig;
import com.ericsson.cms.scheduling.ui.client.service.IUISchedulerService;
import com.ericsson.cms.scheduling.ui.client.service.IUISchedulerServiceAsync;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachHandler;
import java.util.List;

public class UpcomingJobsPortlet
extends Portlet {
    private UpcomingJobsPortletConfig config;
    private NeptuneSecurity security;
    private PortletConstants constants;
    private Timer refreshTimer;
    private IUISchedulerServiceAsync service;
    private FlexTableContainer table;
    private SimplePanel empty;

    public UpcomingJobsPortlet(NeptuneSecurity security, UpcomingJobsPortletConfig config) {
        super("UPCOMINGJOBS");
        this.security = security;
        this.config = config;
        this.service = (IUISchedulerServiceAsync)GWT.create(IUISchedulerService.class);
        this.constants = (PortletConstants)GWT.create(PortletConstants.class);
        this.setTitle(this.constants.ujPortletHeader());
        this.setDisplayName(this.constants.ujPortletHeader());
        this.table = new FlexTableContainer();
        this.table.setCellSpacing(0);
        this.table.setStyleName("portletTable");
        this.add((Widget)this.table);
        this.empty = new SimplePanel((Widget)new LabelWidget(this.constants.ujNoData()));
        this.add((Widget)this.empty);
        this.refreshTimer = new Timer(){

            public void run() {
                UpcomingJobsPortlet.this.reload();
            }
        };
        EventHandler handler = new EventHandler();
        this.addDocumentAttachHandler(handler);
        this.addDocumentDetachHandler(handler);
    }

    private void reload() {
        this.service.getNextNFutureExecutions(this.config.getRecordCount(), (AsyncCallback<List<UIExecutionRecord>>)new NeptuneAsyncCallback<List<UIExecutionRecord>>(){

            public void onNeptuneFailure(Throwable caught) {
                UpcomingJobsPortlet.this.table.removeAllRows();
            }

            public void onNeptuneSuccess(List<UIExecutionRecord> result) {
                if (result.size() > 0) {
                    UpcomingJobsPortlet.this.table.removeAllRows();
                    if (result != null && !result.isEmpty()) {
                        UpcomingJobsPortlet.this.createTableHeader(UpcomingJobsPortlet.this.table);
                        for (int row = 0; row < result.size(); ++row) {
                            UIExecutionRecord uiExecutionRecord = result.get(row);
                            UpcomingJobsPortlet.this.createTableRecord(UpcomingJobsPortlet.this.table, row + 1, uiExecutionRecord);
                        }
                    }
                    UpcomingJobsPortlet.this.table.setVisible(true);
                    UpcomingJobsPortlet.this.empty.setVisible(false);
                } else {
                    UpcomingJobsPortlet.this.table.setVisible(false);
                    UpcomingJobsPortlet.this.empty.setVisible(true);
                }
                UpcomingJobsPortlet.this.update();
            }
        });
    }

    private void createTableHeader(FlexTableContainer table) {
        int row = 0;
        int col = 0;
        table.setWidget(row, col, (Widget)new LabelWidget(this.constants.jobName()));
        table.getCellFormatter().setStyleName(row, col, "portlet-tableHeader");
        table.setWidget(row, ++col, (Widget)new LabelWidget(this.constants.jobKickOffTime()));
        table.getCellFormatter().setStyleName(row, col, "portlet-tableHeader");
    }

    private void createTableRecord(FlexTableContainer table, int row, UIExecutionRecord uiExecutionRecord) {
        int colIndex = 0;
        String jobName = uiExecutionRecord.getJobName();
        if (uiExecutionRecord.getHistoryToken() != null && this.security.isUserInRole("Scheduler_View")) {
            table.setWidget(row, colIndex, (Widget)new HyperlinkWidget(jobName, uiExecutionRecord.getHistoryToken()));
        } else {
            table.setWidget(row, colIndex, (Widget)new LabelWidget(jobName));
        }
        table.getCellFormatter().setStyleName(row, colIndex, "portlet-table-text");
        table.setWidget(row, ++colIndex, (Widget)new LabelWidget(uiExecutionRecord.getExecutionTimeString()));
        table.getCellFormatter().setStyleName(row, colIndex, "portlet-table-text");
    }

    private final class EventHandler
    implements DocumentAttachHandler,
    DocumentDetachHandler {
        private EventHandler() {
        }

        public void onAttach(DocumentAttachEvent event) {
            UpcomingJobsPortlet.this.refreshTimer.scheduleRepeating(UpcomingJobsPortlet.this.config.getRefreshRateSecs() * 1000);
            UpcomingJobsPortlet.this.reload();
        }

        public void onDetach(DocumentDetachEvent event) {
            UpcomingJobsPortlet.this.refreshTimer.cancel();
        }
    }
}

