/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduling.ui.client.widgets;

import com.ericsson.cms.scheduling.ui.client.common.SchedulingConstants;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleInfo;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleType;
import com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetRow;
import com.ericsson.cms.scheduling.ui.client.widgets.TimeEntryWidget;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;

public class EveryNDaysRow
extends SchedulingWidgetRow {
    private static final int MIN_N_DAYS = 1;
    private static final int MAX_N_DAYS = 11574;
    Label everyLabel;
    TextBox nDaysBox;
    Label daysAtLabel;
    TimeEntryWidget timeEntryWidget;
    static SchedulingConstants schedulingConstants = (SchedulingConstants)GWT.create(SchedulingConstants.class);

    public EveryNDaysRow() {
        Label everyLabel = new Label(schedulingConstants.everyLabel());
        this.add((Widget)everyLabel);
        this.nDaysBox = new TextBox();
        this.nDaysBox.setVisibleLength(4);
        this.add((Widget)this.nDaysBox);
        this.daysAtLabel = new Label(schedulingConstants.daysAtLabel());
        this.add((Widget)this.daysAtLabel);
        this.timeEntryWidget = new TimeEntryWidget();
        this.add((Widget)this.timeEntryWidget);
    }

    @Override
    public ScheduleType getScheduleType() {
        return ScheduleType.EVERY_N_DAYS;
    }

    @Override
    public ScheduleInfo getScheduleInfo() {
        ScheduleInfo scheduleInfo = new ScheduleInfo();
        scheduleInfo.setScheduleType(this.getScheduleType());
        scheduleInfo.setnDays(Integer.parseInt(this.nDaysBox.getText()));
        scheduleInfo.setSpecificTime(this.timeEntryWidget.getTime());
        return scheduleInfo;
    }

    @Override
    public void setScheduleInfo(ScheduleInfo scheduleInfo) {
        this.nDaysBox.setText(String.valueOf(scheduleInfo.getnDays()));
        this.timeEntryWidget.setTime(scheduleInfo.getSpecificTime());
    }

    @Override
    public void reset() {
        super.reset();
        this.nDaysBox.setText(null);
        this.timeEntryWidget.reset();
    }

    @Override
    public List<String> validate() {
        ArrayList<String> validationMessages = new ArrayList<String>();
        String nDaysBoxText = this.nDaysBox.getText();
        if (nDaysBoxText == null || nDaysBoxText.isEmpty()) {
            validationMessages.add(schedulingConstants.numDaysRequired());
        } else {
            try {
                int numDays = Integer.parseInt(nDaysBoxText);
                if (numDays < 1) {
                    validationMessages.add(schedulingConstants.numDaysRequiredInteger());
                }
                if (numDays > 11574) {
                    validationMessages.add(schedulingConstants.numDaysExceededMax());
                }
            }
            catch (NumberFormatException e) {
                validationMessages.add(schedulingConstants.numDaysRequiredInteger());
            }
        }
        validationMessages.addAll(this.timeEntryWidget.validate());
        return validationMessages;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.nDaysBox.setEnabled(enabled);
        this.timeEntryWidget.setEnabled(enabled);
    }

    public static String getScheduleInfoString(ScheduleInfo scheduleInfo) {
        String scheduleInfoString = "";
        if (scheduleInfo != null) {
            scheduleInfoString = schedulingConstants.everyLabel();
            scheduleInfoString = scheduleInfoString + " ";
            scheduleInfoString = scheduleInfoString + scheduleInfo.getnDays();
            scheduleInfoString = scheduleInfoString + " ";
            scheduleInfoString = scheduleInfoString + schedulingConstants.daysAtLabel();
            scheduleInfoString = scheduleInfoString + " ";
            scheduleInfoString = scheduleInfoString + scheduleInfo.getSpecificTime();
        }
        return scheduleInfoString;
    }
}

