/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduling.ui.client.widgets;

import com.ericsson.cms.scheduling.ui.client.common.Common;
import com.ericsson.cms.scheduling.ui.client.common.SchedulingConstants;
import com.ericsson.cms.scheduling.ui.client.common.SchedulingMessages;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleInfo;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleType;
import com.ericsson.cms.scheduling.ui.client.service.IUISchedulerService;
import com.ericsson.cms.scheduling.ui.client.service.IUISchedulerServiceAsync;
import com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetRow;
import com.ericsson.cms.scheduling.ui.client.widgets.TimeEntryWidget;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class EveryNHourMinsRow
extends SchedulingWidgetRow {
    private static final int MIN_N_HOURS = 1;
    private static final int MAX_N_HOURS = 23;
    private static final int MIN_N_MINS = 10;
    private static final int MAX_N_MINS = 59;
    private static final String TIMEBOX_ERROR_STYLE = "schedule-timebox-error";
    LabelWidget everyLabel;
    LabelWidget hourLabel;
    TextBoxWidget nHourMinsBox;
    ListBoxWidget<String> timeUnitBox;
    TimeEntryWidget timeEntryWidget;
    private static final String HOUR_LABEL_STYLE = "scheduler-widget-hours-label";
    static SchedulingConstants schedulingConstants = (SchedulingConstants)GWT.create(SchedulingConstants.class);
    static SchedulingMessages schedulingMessages = (SchedulingMessages)GWT.create(SchedulingMessages.class);
    private IUISchedulerServiceAsync service = (IUISchedulerServiceAsync)GWT.create(IUISchedulerService.class);
    private Boolean isOnlyHour;

    public EveryNHourMinsRow() {
        this.loadNeptuneSetting();
        this.buildUI();
    }

    private void loadNeptuneSetting() {
        this.service.getAllowOnlyHourFromConfig((AsyncCallback<Boolean>)new NeptuneAsyncCallback<Boolean>(){

            public void onNeptuneFailure(Throwable caught) {
                Window.alert((String)("Failed to get is only every n hours allow from neptune settings" + Common.getFailureMessageSuffix(caught)));
            }

            public void onNeptuneSuccess(Boolean result) {
                EveryNHourMinsRow.this.setIsOnlyHour(result);
                EveryNHourMinsRow.this.updateTimeUnitWidget();
            }
        });
    }

    private void buildUI() {
        LabelWidget everyLabel = new LabelWidget(schedulingConstants.everyLabel());
        this.add((Widget)everyLabel);
        this.nHourMinsBox = new TextBoxWidget();
        this.nHourMinsBox.setVisibleLength(4);
        this.add((Widget)this.nHourMinsBox);
        this.timeUnitBox = new ListBoxWidget();
        this.timeUnitBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                EveryNHourMinsRow.this.timeUnitBox.removeStyleName(EveryNHourMinsRow.TIMEBOX_ERROR_STYLE);
            }
        });
        this.timeUnitBox.addItem(schedulingConstants.getString(TimeUnit.HOURS.name().toLowerCase()), (Object)TimeUnit.HOURS.name());
        this.timeUnitBox.addItem(schedulingConstants.getString(TimeUnit.MINUTES.name().toLowerCase()), (Object)TimeUnit.MINUTES.name());
        this.timeUnitBox.setSelectedIndex(0);
        this.timeUnitBox.setVisible(false);
        this.add((Widget)this.timeUnitBox);
        this.hourLabel = new LabelWidget(schedulingConstants.hours());
        this.hourLabel.addStyleName(HOUR_LABEL_STYLE);
        this.hourLabel.setVisible(true);
        this.add((Widget)this.hourLabel);
        LabelWidget startAtLabel = new LabelWidget(schedulingConstants.startAtLabel());
        this.add((Widget)startAtLabel);
        this.timeEntryWidget = new TimeEntryWidget();
        this.add((Widget)this.timeEntryWidget);
    }

    private void updateTimeUnitWidget() {
        if (this.isOnlyHour().booleanValue() && this.getScheduleInfo().getTimeUnit() != TimeUnit.MINUTES.name()) {
            this.timeUnitBox.setVisible(false);
            this.hourLabel.setVisible(true);
            this.timeUnitBox.removeStyleName(TIMEBOX_ERROR_STYLE);
        } else if (this.isOnlyHour().booleanValue() && this.getScheduleInfo().getTimeUnit() == TimeUnit.MINUTES.name()) {
            this.timeUnitBox.setVisible(true);
            this.hourLabel.setVisible(false);
            this.timeUnitBox.addStyleName(TIMEBOX_ERROR_STYLE);
        } else {
            this.timeUnitBox.setVisible(true);
            this.hourLabel.setVisible(false);
            this.timeUnitBox.removeStyleName(TIMEBOX_ERROR_STYLE);
        }
    }

    @Override
    public ScheduleType getScheduleType() {
        return ScheduleType.EVERY_N_HOURMINS;
    }

    @Override
    public ScheduleInfo getScheduleInfo() {
        ScheduleInfo scheduleInfo = new ScheduleInfo();
        scheduleInfo.setScheduleType(this.getScheduleType());
        scheduleInfo.setnHourMins(Integer.parseInt(this.nHourMinsBox.getText()));
        int selectIndex = this.timeUnitBox.getSelectedIndex();
        scheduleInfo.setTimeUnit((String)this.timeUnitBox.getItem(selectIndex));
        scheduleInfo.setSpecificTime(this.timeEntryWidget.getTime());
        return scheduleInfo;
    }

    @Override
    public void setScheduleInfo(ScheduleInfo scheduleInfo) {
        this.nHourMinsBox.setText(String.valueOf(scheduleInfo.getnHourMins()));
        String strTimeUnit = scheduleInfo.getTimeUnit();
        if (strTimeUnit.equals(TimeUnit.HOURS.name())) {
            this.timeUnitBox.setSelectedIndex(0);
        } else if (strTimeUnit.equals(TimeUnit.MINUTES.name())) {
            this.timeUnitBox.setSelectedIndex(1);
        }
        this.timeEntryWidget.setTime(scheduleInfo.getSpecificTime());
    }

    @Override
    public void reset() {
        super.reset();
        this.loadNeptuneSetting();
        this.nHourMinsBox.setText(null);
        this.timeUnitBox.setSelectedIndex(0);
        this.timeEntryWidget.reset();
    }

    private String getSelectedTimeUnit() {
        return this.timeUnitBox.getItemText(this.timeUnitBox.getSelectedIndex());
    }

    @Override
    public List<String> validate() {
        ArrayList<String> validationMessages = new ArrayList<String>();
        String nHourMinsBoxText = this.nHourMinsBox.getText();
        if (nHourMinsBoxText == null || nHourMinsBoxText.isEmpty()) {
            validationMessages.add(schedulingMessages.numTimeRequired(this.getSelectedTimeUnit()));
        } else {
            int min = 1;
            int max = 23;
            if (this.timeUnitBox.getSelectedIndex() == 0) {
                min = 1;
                max = 23;
            } else if (this.timeUnitBox.getSelectedIndex() == 1) {
                min = 10;
                max = 59;
            }
            try {
                int nHourMins = Integer.parseInt(nHourMinsBoxText);
                if (nHourMins < min) {
                    validationMessages.add(schedulingMessages.numTimeRequiredInteger(this.getSelectedTimeUnit(), min));
                }
                if (nHourMins > max) {
                    validationMessages.add(schedulingMessages.numTimeExceed(this.getSelectedTimeUnit(), max));
                }
                if (this.isOnlyHour().booleanValue() && this.getScheduleInfo().getTimeUnit() == TimeUnit.MINUTES.name()) {
                    validationMessages.add(schedulingMessages.timeUnitMustBeHour());
                    this.timeUnitBox.addStyleName(TIMEBOX_ERROR_STYLE);
                }
            }
            catch (NumberFormatException e) {
                validationMessages.add(schedulingMessages.numTimeRequiredInteger(this.getSelectedTimeUnit(), min));
            }
        }
        validationMessages.addAll(this.timeEntryWidget.validate());
        return validationMessages;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.nHourMinsBox.setEnabled(enabled);
        this.timeUnitBox.setEnabled(enabled);
        this.timeEntryWidget.setEnabled(enabled);
    }

    public static String getScheduleInfoString(ScheduleInfo scheduleInfo) {
        String scheduleInfoString = "";
        if (scheduleInfo != null) {
            scheduleInfoString = schedulingConstants.everyLabel();
            scheduleInfoString = scheduleInfoString + " ";
            scheduleInfoString = scheduleInfoString + scheduleInfo.getnHourMins();
            scheduleInfoString = scheduleInfoString + " ";
            scheduleInfoString = scheduleInfoString + scheduleInfo.getTimeUnit().toLowerCase();
            scheduleInfoString = scheduleInfoString + " ";
            scheduleInfoString = scheduleInfoString + schedulingConstants.startAtLabel();
            scheduleInfoString = scheduleInfoString + " ";
            scheduleInfoString = scheduleInfoString + scheduleInfo.getSpecificTime();
        }
        return scheduleInfoString;
    }

    public Boolean isOnlyHour() {
        return this.isOnlyHour;
    }

    public void setIsOnlyHour(Boolean isOnlyHour) {
        this.isOnlyHour = isOnlyHour;
    }
}

