/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduling.ui.client.widgets;

import com.ericsson.cms.scheduling.ui.client.data.UiMetadataTree;
import com.ericsson.cms.scheduling.ui.client.widgets.MetadataSelector;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;

public class MetadataFieldWidget
extends HorizontalContainer {
    private static final String FULL_DISPLAY_NAME_PREFIX = "$";
    private static final String FULL_NAME_PREFIX = "$";
    private static final String SCHEDULE_METADATA_TEXTBOX_STYLE = "schedule-metadata-textbox-style";
    String value;
    TextBoxWidget textBox = new TextBoxWidget();
    ImageWidget imageWidget = new ImageWidget("cms_scheduling_ui/images/popup_searchicon.png");
    UiMetadataTree metadataTree;
    MetadataSelector metadataSelector;
    boolean editable = false;

    public MetadataFieldWidget(boolean isEditable) {
        this.setEditable(isEditable);
        this.add((Widget)this.textBox);
        this.textBox.addStyleDependentName(SCHEDULE_METADATA_TEXTBOX_STYLE);
        MetadataFieldClickAndFocusHandler handler = new MetadataFieldClickAndFocusHandler();
        if (this.editable) {
            this.add((Widget)this.imageWidget);
            this.imageWidget.addClickHandler((ClickHandler)handler);
        } else {
            this.textBox.addClickHandler((ClickHandler)handler);
            this.textBox.addFocusHandler((FocusHandler)handler);
        }
    }

    public MetadataFieldWidget(UiMetadataTree tree) {
        this(false);
        this.setMetadataTree(tree);
    }

    public void setVisibleLength(int length) {
        this.textBox.setVisibleLength(length);
    }

    public String getText() {
        return this.textBox.getText();
    }

    public void setText(String text) {
        this.textBox.setText(text);
    }

    public UiMetadataTree getMetadataTree() {
        return this.metadataTree;
    }

    public void setMetadataTree(UiMetadataTree tree) {
        this.metadataTree = tree;
        this.resolveTextBox(this.value);
    }

    private void setEditable(boolean editable) {
        this.editable = editable;
        this.textBox.setReadOnly(!this.editable);
    }

    public String getValue() {
        String text = this.textBox.getText();
        if (text != null && text.startsWith("$")) {
            return this.value;
        }
        return text;
    }

    public void setValue(String value) {
        this.value = value;
        this.resolveTextBox(value);
    }

    public void setEnabled(boolean enabled) {
        this.textBox.setEnabled(enabled);
    }

    private void resolveTextBox(String value) {
        String text = value;
        if (value != null && value.startsWith("$")) {
            text = this.resolveDisplayName();
        }
        this.setText(text);
    }

    private String resolveDisplayName() {
        String fullDisplayName = null;
        if (this.metadataTree != null && this.value != null) {
            UiMetadataTree foundNode;
            String fullName = this.value;
            if (fullName.startsWith("$")) {
                fullName = fullName.substring("$".length());
            }
            if ((foundNode = this.findNodeByFullName(fullName)) != null) {
                fullDisplayName = foundNode.getFullDisplayName();
            }
        }
        if (fullDisplayName != null) {
            fullDisplayName = "$" + fullDisplayName;
        }
        return fullDisplayName;
    }

    private UiMetadataTree findNodeByFullName(String fullName) {
        UiMetadataTree foundNode = null;
        foundNode = this.findNodeByFullName(this.metadataTree, fullName);
        return foundNode;
    }

    private UiMetadataTree findNodeByFullName(UiMetadataTree uiMetadataTree, String fullName) {
        UiMetadataTree foundNode = null;
        if (uiMetadataTree != null) {
            for (UiMetadataTree node : uiMetadataTree.getChildren()) {
                if (fullName.equals(node.getFullName())) {
                    foundNode = node;
                    break;
                }
                foundNode = this.findNodeByFullName(node, fullName);
                if (foundNode == null) continue;
                break;
            }
        }
        return foundNode;
    }

    private void showMetadataSelector() {
        String selectedFullDispalyName = null;
        String text = this.textBox.getText();
        if (text.startsWith("$")) {
            selectedFullDispalyName = text.substring("$".length());
        }
        this.metadataSelector = new MetadataSelector(this.metadataTree, !this.editable, selectedFullDispalyName);
        this.metadataSelector.addSelectionHandler(new SelectionHandler<UiMetadataTree>(){

            public void onSelection(SelectionEvent<UiMetadataTree> event) {
                UiMetadataTree metadataNode = (UiMetadataTree)event.getSelectedItem();
                MetadataFieldWidget.this.textBox.setText("$" + metadataNode.getFullDisplayName());
                MetadataFieldWidget.this.value = "$" + metadataNode.getFullName();
            }
        });
        int x = this.textBox.getAbsoluteLeft();
        int y = this.textBox.getAbsoluteTop();
        if (this.editable) {
            y = this.textBox.getAbsoluteTop() + this.textBox.getOffsetHeight();
        }
        this.metadataSelector.show(x, y);
        if (this.editable) {
            this.textBox.selectAll();
            this.textBox.setFocus(true);
        }
    }

    class MetadataFieldClickAndFocusHandler
    implements ClickHandler,
    FocusHandler {
        MetadataFieldClickAndFocusHandler() {
        }

        public void onClick(ClickEvent event) {
            MetadataFieldWidget.this.showMetadataSelector();
        }

        public void onFocus(FocusEvent event) {
            MetadataFieldWidget.this.showMetadataSelector();
        }
    }
}

