/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduling.ui.client.widgets;

import com.ericsson.cms.scheduling.ui.client.data.UiMetadataTree;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TreeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.PopupContainer;
import java.util.ArrayList;
import java.util.List;

public class MetadataSelector
extends PopupContainer
implements HasSelectionHandlers<UiMetadataTree> {
    private static final int BOX_HEIGHT_INT = 200;
    private ScrollPanel scrollPanel = new ScrollPanel();
    private Tree tree;
    private int currentPosition = 0;
    private Timer timer;
    private List<HandlerRegistration> currentHackHandlers = new ArrayList<HandlerRegistration>();

    public MetadataSelector(UiMetadataTree metadataTree, boolean modal) {
        super(true, modal);
        this.timer = new Timer(){

            public void run() {
                MetadataSelector.this.scrollPanel.setScrollPosition(MetadataSelector.this.currentPosition);
            }
        };
        this.buildTree(metadataTree);
        this.tree.addSelectionHandler((SelectionHandler)new SelectionHandler<TreeItem>(){

            public void onSelection(SelectionEvent<TreeItem> event) {
                UiMetadataTree metadataTree;
                List<UiMetadataTree> childrenUiMetadataTree;
                TreeItem treeItem = (TreeItem)event.getSelectedItem();
                if (treeItem.getUserObject() != null && ((childrenUiMetadataTree = (metadataTree = (UiMetadataTree)treeItem.getUserObject()).getChildren()) == null || childrenUiMetadataTree.size() < 1)) {
                    SelectionEvent.fire((HasSelectionHandlers)MetadataSelector.this, (Object)metadataTree);
                    MetadataSelector.this.hide();
                }
            }
        });
        this.scrollPanel.setSize("250px", "200px");
        this.scrollPanel.setWidget((Widget)this.tree);
        this.addScrollHack(this.tree);
        this.setWidget((Widget)this.scrollPanel);
    }

    public MetadataSelector(UiMetadataTree metadataTree, boolean modal, String fullDisplayName) {
        this(metadataTree, modal);
        if (fullDisplayName != null && !fullDisplayName.isEmpty()) {
            this.setSelectedItem(fullDisplayName);
        }
    }

    public void setSelectedItem(String fullDisplayName) {
        TreeItem item;
        boolean itemSelected;
        for (int i = 0; i < this.tree.getItemCount() && !(itemSelected = this.setSelectedItem(fullDisplayName, item = this.tree.getItem(i))); ++i) {
        }
    }

    public boolean setSelectedItem(String fullDisplayName, TreeItem item) {
        boolean itemSelected = false;
        if (item.getUserObject() != null) {
            UiMetadataTree metadataTree = (UiMetadataTree)item.getUserObject();
            String mtFullDisplayName = metadataTree.getFullDisplayName();
            if (fullDisplayName != null && fullDisplayName.equals(mtFullDisplayName)) {
                itemSelected = true;
                this.tree.setSelectedItem(item);
                this.tree.ensureSelectedItemVisible();
            }
        }
        if (!itemSelected) {
            TreeItem childItem;
            for (int i = 0; i < item.getChildCount() && !(itemSelected = this.setSelectedItem(fullDisplayName, childItem = item.getChild(i))); ++i) {
            }
        }
        return itemSelected;
    }

    private void buildTree(UiMetadataTree metadataTree) {
        this.tree = new TreeWidget();
        if (metadataTree != null) {
            if (metadataTree.getName().isEmpty()) {
                for (UiMetadataTree node : metadataTree.getChildren()) {
                    TreeItem item = new TreeItem(node.getDisplayName());
                    item.setUserObject((Object)node);
                    this.addNodes(item, node.getChildren());
                    this.tree.addItem(item);
                }
            } else {
                TreeItem item = new TreeItem(metadataTree.getDisplayName());
                item.setUserObject((Object)metadataTree);
                this.addNodes(item, metadataTree.getChildren());
                this.tree.addItem(item);
            }
        }
    }

    private void addNodes(TreeItem item, List<UiMetadataTree> nodes) {
        for (UiMetadataTree node : nodes) {
            TreeItem childItem = new TreeItem(node.getDisplayName());
            childItem.setUserObject((Object)node);
            this.addNodes(childItem, node.getChildren());
            item.addItem(childItem);
        }
    }

    public void show(final int x, final int y) {
        this.setPopupPositionAndShow(new PopupPanel.PositionCallback(){

            public void setPosition(int offsetWidth, int offsetHeight) {
                int height = Window.getClientHeight();
                int yOffset = 0;
                if (y + 200 > height) {
                    yOffset = 230;
                }
                MetadataSelector.this.setPopupPosition(x, y - yOffset);
            }
        });
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<UiMetadataTree> handler) {
        return this.addHandler((EventHandler)handler, SelectionEvent.getType());
    }

    private void addScrollHack(Tree currentTree) {
        for (HandlerRegistration r : this.currentHackHandlers) {
            r.removeHandler();
        }
        this.currentHackHandlers.clear();
        this.currentHackHandlers.add(currentTree.addMouseDownHandler(new MouseDownHandler(){

            public void onMouseDown(MouseDownEvent event) {
                MetadataSelector.this.currentPosition = MetadataSelector.this.scrollPanel.getScrollPosition();
            }
        }));
        this.currentHackHandlers.add(currentTree.addMouseUpHandler(new MouseUpHandler(){

            public void onMouseUp(MouseUpEvent event) {
                MetadataSelector.this.timer.schedule(5);
            }
        }));
    }
}

