/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduling.ui.client.widgets;

import com.ericsson.cms.scheduling.ui.client.common.SchedulingConstants;
import com.ericsson.cms.scheduling.ui.client.data.BeforeAfter;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleInfo;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleType;
import com.ericsson.cms.scheduling.ui.client.data.UiMetadataTree;
import com.ericsson.cms.scheduling.ui.client.widgets.MetadataFieldWidget;
import com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetRow;
import com.ericsson.cms.scheduling.ui.client.widgets.TimeEntryWidget;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import java.util.ArrayList;
import java.util.List;

public class NDaysFromMetadataRow
extends SchedulingWidgetRow {
    private static final int MIN_N_DAYS = 0;
    TextBox nDaysBox = new TextBox();
    Label noOfDaysLabel;
    ListBoxWidget<BeforeAfter> beforeAfterOption;
    MetadataFieldWidget metadataFieldWidget;
    Label atTimeLabel;
    TimeEntryWidget timeEntryWidget;
    Label metadataLabel;
    static SchedulingConstants schedulingConstants = (SchedulingConstants)GWT.create(SchedulingConstants.class);

    public NDaysFromMetadataRow() {
        this.nDaysBox.setVisibleLength(4);
        this.add((Widget)this.nDaysBox);
        this.noOfDaysLabel = new Label(schedulingConstants.noOfDaysLabel());
        this.add((Widget)this.noOfDaysLabel);
        this.beforeAfterOption = new ListBoxWidget();
        this.beforeAfterOption.setVisibleItemCount(1);
        for (BeforeAfter beforeAfter : BeforeAfter.values()) {
            this.beforeAfterOption.addItem(beforeAfter.toString(), (Object)beforeAfter);
        }
        this.add((Widget)this.beforeAfterOption);
        this.metadataLabel = new Label(schedulingConstants.metadataLabel());
        this.add((Widget)this.metadataLabel);
        this.metadataFieldWidget = new MetadataFieldWidget(false);
        this.metadataFieldWidget.setVisibleLength(50);
        this.add((Widget)this.metadataFieldWidget);
        this.atTimeLabel = new Label(schedulingConstants.atTimeLabel());
        this.add((Widget)this.atTimeLabel);
        this.timeEntryWidget = new TimeEntryWidget();
        this.add((Widget)this.timeEntryWidget);
    }

    @Override
    public ScheduleType getScheduleType() {
        return ScheduleType.N_DAYS_FROM_METADATA;
    }

    @Override
    public ScheduleInfo getScheduleInfo() {
        ScheduleInfo scheduleInfo = new ScheduleInfo();
        scheduleInfo.setScheduleType(this.getScheduleType());
        scheduleInfo.setnDays(Integer.parseInt(this.nDaysBox.getText()));
        scheduleInfo.setBeforeAfter((BeforeAfter)((Object)this.beforeAfterOption.getSelectedItem()));
        scheduleInfo.setMetadataField(this.metadataFieldWidget.getValue());
        scheduleInfo.setSpecificTime(this.timeEntryWidget.getTime());
        return scheduleInfo;
    }

    @Override
    public void setScheduleInfo(ScheduleInfo scheduleInfo) {
        this.nDaysBox.setText(String.valueOf(scheduleInfo.getnDays()));
        this.beforeAfterOption.setSelectedItem((Object)scheduleInfo.getBeforeAfter());
        this.metadataFieldWidget.setValue(scheduleInfo.getMetadataField());
        this.timeEntryWidget.setTime(scheduleInfo.getSpecificTime());
    }

    @Override
    public void reset() {
        super.reset();
        this.nDaysBox.setText(null);
        this.beforeAfterOption.setSelectedItem((Object)BeforeAfter.before);
        this.metadataFieldWidget.setValue(null);
        this.metadataFieldWidget.setText(null);
        this.timeEntryWidget.reset();
    }

    @Override
    public List<String> validate() {
        ArrayList<String> validationMessages = new ArrayList<String>();
        String nDaysBoxText = this.nDaysBox.getText();
        if (nDaysBoxText == null || nDaysBoxText.isEmpty()) {
            validationMessages.add(schedulingConstants.numDaysRequired());
        } else {
            try {
                int numDays = Integer.parseInt(nDaysBoxText);
                if (numDays < 0) {
                    validationMessages.add(schedulingConstants.numDaysRequiredInteger2());
                }
            }
            catch (NumberFormatException e) {
                validationMessages.add(schedulingConstants.numDaysRequiredInteger2());
            }
        }
        String mfwValue = this.metadataFieldWidget.getValue();
        if (mfwValue == null || mfwValue.isEmpty()) {
            validationMessages.add(schedulingConstants.metadataFieldRequired());
        }
        validationMessages.addAll(this.timeEntryWidget.validate());
        return validationMessages;
    }

    @Override
    public void setMetadataTree(UiMetadataTree metadataTree) {
        if (this.metadataFieldWidget != null) {
            this.metadataFieldWidget.setMetadataTree(metadataTree);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.nDaysBox.setEnabled(enabled);
        this.beforeAfterOption.setEnabled(enabled);
        this.metadataFieldWidget.setEnabled(enabled);
        this.timeEntryWidget.setEnabled(enabled);
    }

    public static String getScheduleInfoString(ScheduleInfo scheduleInfo) {
        String scheduleInfoString = "";
        if (scheduleInfo != null) {
            scheduleInfoString = scheduleInfoString + scheduleInfo.getnDays();
            scheduleInfoString = scheduleInfoString + " ";
            scheduleInfoString = scheduleInfoString + schedulingConstants.noOfDaysLabel();
            scheduleInfoString = scheduleInfoString + " ";
            scheduleInfoString = scheduleInfoString + (Object)((Object)scheduleInfo.getBeforeAfter());
            scheduleInfoString = scheduleInfoString + " ";
            scheduleInfoString = scheduleInfoString + scheduleInfo.getMetadataField();
            scheduleInfoString = scheduleInfoString + " ";
            scheduleInfoString = scheduleInfoString + schedulingConstants.atTimeLabel();
            scheduleInfoString = scheduleInfoString + " ";
            scheduleInfoString = scheduleInfoString + scheduleInfo.getSpecificTime();
        }
        return scheduleInfoString;
    }
}

