/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduling.ui.client.widgets;

import com.ericsson.cms.scheduling.ui.client.common.SchedulingConstants;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleInfo;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleType;
import com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetRow;
import com.ericsson.cms.scheduling.ui.client.widgets.TimeEntryWidget;
import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.DateBox;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.DateBoxWidget;
import java.util.ArrayList;
import java.util.List;

public class OnDateRow
extends SchedulingWidgetRow {
    private static final String PATTERN_DATE_FORMAT = "yyyy-MM-dd";
    Label onLabel = new Label(schedulingConstants.onLabel());
    DateBox dateBox;
    Label atLabel;
    TimeEntryWidget timeEntryWidget;
    static SchedulingConstants schedulingConstants = (SchedulingConstants)GWT.create(SchedulingConstants.class);

    public OnDateRow() {
        this.add((Widget)this.onLabel);
        this.dateBox = new DateBoxWidget();
        this.dateBox.getTextBox().setVisibleLength(12);
        this.dateBox.getTextBox().setHeight("20px");
        DateBox.DefaultFormat fmt = new DateBox.DefaultFormat(DateTimeFormat.getFormat((String)PATTERN_DATE_FORMAT));
        this.dateBox.setFormat((DateBox.Format)fmt);
        this.add((Widget)this.dateBox);
        this.atLabel = new Label(schedulingConstants.atLabel());
        this.add((Widget)this.atLabel);
        this.timeEntryWidget = new TimeEntryWidget();
        this.add((Widget)this.timeEntryWidget);
    }

    @Override
    public ScheduleType getScheduleType() {
        return ScheduleType.ON_DATE;
    }

    @Override
    public ScheduleInfo getScheduleInfo() {
        ScheduleInfo scheduleInfo = new ScheduleInfo();
        scheduleInfo.setScheduleType(this.getScheduleType());
        scheduleInfo.setSpecificDate(this.dateBox.getTextBox().getText());
        scheduleInfo.setSpecificTime(this.timeEntryWidget.getTime());
        return scheduleInfo;
    }

    @Override
    public void setScheduleInfo(ScheduleInfo scheduleInfo) {
        this.dateBox.getTextBox().setText(scheduleInfo.getSpecificDate());
        this.timeEntryWidget.setTime(scheduleInfo.getSpecificTime());
    }

    @Override
    public void reset() {
        super.reset();
        this.dateBox.getTextBox().setText(null);
        this.timeEntryWidget.reset();
    }

    @Override
    public List<String> validate() {
        ArrayList<String> validationMessages = new ArrayList<String>();
        String strDate = this.dateBox.getTextBox().getText();
        if (strDate == null || strDate.isEmpty()) {
            validationMessages.add(schedulingConstants.dateRequired());
        } else {
            try {
                DateTimeFormat fmt = DateTimeFormat.getFormat((String)PATTERN_DATE_FORMAT);
                fmt.parse(strDate);
            }
            catch (IllegalArgumentException e) {
                validationMessages.add(schedulingConstants.dateRequiredFormat());
            }
        }
        validationMessages.addAll(this.timeEntryWidget.validate());
        return validationMessages;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.dateBox.setEnabled(enabled);
        this.timeEntryWidget.setEnabled(enabled);
    }

    public static String getScheduleInfoString(ScheduleInfo scheduleInfo) {
        String scheduleInfoString = "";
        if (scheduleInfo != null) {
            scheduleInfoString = schedulingConstants.onLabel();
            scheduleInfoString = scheduleInfoString + " ";
            scheduleInfoString = scheduleInfoString + scheduleInfo.getSpecificDate();
            scheduleInfoString = scheduleInfoString + " ";
            scheduleInfoString = scheduleInfoString + schedulingConstants.atLabel();
            scheduleInfoString = scheduleInfoString + " ";
            scheduleInfoString = scheduleInfoString + scheduleInfo.getSpecificTime();
        }
        return scheduleInfoString;
    }
}

