/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduling.ui.client.widgets;

import com.ericsson.cms.scheduling.ui.client.common.SchedulingConstants;
import com.ericsson.cms.scheduling.ui.client.data.DayOfWeek;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleInfo;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleType;
import com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetRow;
import com.ericsson.cms.scheduling.ui.client.widgets.TimeEntryWidget;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import java.util.ArrayList;
import java.util.List;

public class OnDayEveryNWeeksRow
extends SchedulingWidgetRow {
    private static final int MIN_N_WEEKS = 1;
    private static final int MAX_N_WEEKS = 1653;
    Label onLabel = new Label(schedulingConstants.onLabel());
    ListBoxWidget<DayOfWeek> dayOption;
    Label everyLabel;
    TextBox nWeeksBox;
    TimeEntryWidget timeEntryWidget;
    static SchedulingConstants schedulingConstants = (SchedulingConstants)GWT.create(SchedulingConstants.class);

    public OnDayEveryNWeeksRow() {
        this.add((Widget)this.onLabel);
        this.dayOption = new ListBoxWidget();
        this.dayOption.setVisibleItemCount(1);
        for (DayOfWeek dayOfWeek : DayOfWeek.values()) {
            this.dayOption.addItem(dayOfWeek.toString(), (Object)dayOfWeek);
        }
        this.add((Widget)this.dayOption);
        this.everyLabel = new Label(schedulingConstants.everyLabel2());
        this.add((Widget)this.everyLabel);
        this.nWeeksBox = new TextBox();
        this.nWeeksBox.setVisibleLength(4);
        this.add((Widget)this.nWeeksBox);
        Label weeksAtLabel = new Label(schedulingConstants.weeksAtLabel());
        this.add((Widget)weeksAtLabel);
        this.timeEntryWidget = new TimeEntryWidget();
        this.add((Widget)this.timeEntryWidget);
    }

    @Override
    public ScheduleType getScheduleType() {
        return ScheduleType.ON_DAY_EVERY_N_WEEKS;
    }

    @Override
    public ScheduleInfo getScheduleInfo() {
        ScheduleInfo scheduleInfo = new ScheduleInfo();
        scheduleInfo.setScheduleType(this.getScheduleType());
        scheduleInfo.setDayOfWeek((DayOfWeek)((Object)this.dayOption.getSelectedItem()));
        scheduleInfo.setnWeeks(Integer.parseInt(this.nWeeksBox.getText()));
        scheduleInfo.setSpecificTime(this.timeEntryWidget.getTime());
        return scheduleInfo;
    }

    @Override
    public void setScheduleInfo(ScheduleInfo scheduleInfo) {
        this.dayOption.setSelectedItem((Object)scheduleInfo.getDayOfWeek());
        this.nWeeksBox.setText(String.valueOf(scheduleInfo.getnWeeks()));
        this.timeEntryWidget.setTime(scheduleInfo.getSpecificTime());
    }

    @Override
    public void reset() {
        super.reset();
        this.dayOption.setSelectedItem((Object)DayOfWeek.MONDAY);
        this.nWeeksBox.setText(null);
        this.timeEntryWidget.reset();
    }

    @Override
    public List<String> validate() {
        ArrayList<String> validationMessages = new ArrayList<String>();
        String nWeeksBoxText = this.nWeeksBox.getText();
        if (nWeeksBoxText == null || nWeeksBoxText.isEmpty()) {
            validationMessages.add(schedulingConstants.numWeeksRequired());
        } else {
            try {
                int numWeeks = Integer.parseInt(nWeeksBoxText);
                if (numWeeks < 1) {
                    validationMessages.add(schedulingConstants.numWeeksRequiredInteger());
                }
                if (numWeeks > 1653) {
                    validationMessages.add(schedulingConstants.numWeeksExceededMax());
                }
            }
            catch (NumberFormatException e) {
                validationMessages.add(schedulingConstants.numWeeksRequiredInteger());
            }
        }
        validationMessages.addAll(this.timeEntryWidget.validate());
        return validationMessages;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.dayOption.setEnabled(enabled);
        this.nWeeksBox.setEnabled(enabled);
        this.timeEntryWidget.setEnabled(enabled);
    }

    public static String getScheduleInfoString(ScheduleInfo scheduleInfo) {
        String scheduleInfoString = "";
        if (scheduleInfo != null) {
            scheduleInfoString = schedulingConstants.onLabel();
            scheduleInfoString = scheduleInfoString + " ";
            scheduleInfoString = scheduleInfoString + (Object)((Object)scheduleInfo.getDayOfWeek());
            scheduleInfoString = scheduleInfoString + " ";
            scheduleInfoString = scheduleInfoString + schedulingConstants.everyLabel2();
            scheduleInfoString = scheduleInfoString + " ";
            scheduleInfoString = scheduleInfoString + scheduleInfo.getnWeeks();
            scheduleInfoString = scheduleInfoString + " ";
            scheduleInfoString = scheduleInfoString + schedulingConstants.weeksAtLabel();
            scheduleInfoString = scheduleInfoString + " ";
            scheduleInfoString = scheduleInfoString + scheduleInfo.getSpecificTime();
        }
        return scheduleInfoString;
    }
}

