/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduling.ui.client.widgets;

import com.ericsson.cms.scheduling.ui.client.common.SchedulingConstants;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleInfo;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleType;
import com.ericsson.cms.scheduling.ui.client.data.UiMetadataTree;
import com.ericsson.cms.scheduling.ui.client.widgets.EveryNDaysRow;
import com.ericsson.cms.scheduling.ui.client.widgets.EveryNHourMinsRow;
import com.ericsson.cms.scheduling.ui.client.widgets.NDaysFromMetadataRow;
import com.ericsson.cms.scheduling.ui.client.widgets.OnDateRow;
import com.ericsson.cms.scheduling.ui.client.widgets.OnDayEveryNWeeksRow;
import com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetConfig;
import com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetRow;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.List;

public class SchedulingWidget
extends VerticalContainer {
    private SchedulingWidgetConfig widgetConfig;
    SchedulingWidgetRow onDateRow;
    SchedulingWidgetRow everyNDaysRow;
    SchedulingWidgetRow onDayEveryNWeeksRow;
    SchedulingWidgetRow nDaysFromMetadataRow;
    SchedulingWidgetRow everyNHourMinsRow;
    boolean isEnabled = true;
    private TextBox jobLimit;
    private TextBox batches;
    private CheckBox batchesCheckBox = null;
    private CheckBox jobLimitCheckBox = null;
    private HorizontalContainer jobLimitItems;
    SchedulingConstants schedulingConstants = (SchedulingConstants)GWT.create(SchedulingConstants.class);
    private HorizontalContainer batchItems;

    public SchedulingWidget(SchedulingWidgetConfig widgetConfig) {
        this.widgetConfig = widgetConfig;
        this.onDateRow = new OnDateRow();
        this.everyNDaysRow = new EveryNDaysRow();
        this.onDayEveryNWeeksRow = new OnDayEveryNWeeksRow();
        this.nDaysFromMetadataRow = new NDaysFromMetadataRow();
        this.everyNHourMinsRow = new EveryNHourMinsRow();
        if (widgetConfig != null) {
            if (widgetConfig.isShowOnDateRow()) {
                this.add((Widget)this.onDateRow);
            }
            if (widgetConfig.isShowEveryNDaysRow()) {
                this.add((Widget)this.everyNDaysRow);
            }
            if (widgetConfig.isShowOnDayEveryNWeeksRow()) {
                this.add((Widget)this.onDayEveryNWeeksRow);
            }
            if (widgetConfig.isShowNDaysFromMetadataRow()) {
                this.add((Widget)this.nDaysFromMetadataRow);
            }
            if (widgetConfig.isShowEveryNHourMinsRow()) {
                this.add((Widget)this.everyNHourMinsRow);
            }
        }
        this.jobLimitItems = new HorizontalContainer();
        this.jobLimitItems.setVerticalAlignment(ALIGN_MIDDLE);
        this.jobLimit = new TextBox();
        this.jobLimitCheckBox = new CheckBox();
        this.jobLimitCheckBox.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                boolean checked = ((CheckBox)event.getSource()).getValue();
                SchedulingWidget.this.jobLimit.setEnabled(checked);
                if (!checked) {
                    SchedulingWidget.this.jobLimit.setText("0");
                }
            }
        });
        this.jobLimitItems.add((Widget)this.jobLimitCheckBox);
        this.jobLimitItems.add((Widget)new Label(" Limit job size to "));
        this.jobLimitItems.add((Widget)this.jobLimit);
        this.jobLimitItems.add((Widget)new Label(" Title(s) "));
        this.add((Widget)this.jobLimitItems);
        this.jobLimitItems.setVisible(false);
        this.jobLimit.setEnabled(false);
        this.jobLimit.setText("0");
        this.batches = new TextBox();
        this.batchesCheckBox = new CheckBox();
        this.batchesCheckBox.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                boolean checked = ((CheckBox)event.getSource()).getValue();
                SchedulingWidget.this.batches.setEnabled(checked);
                if (!checked) {
                    SchedulingWidget.this.batches.setText("1");
                }
            }
        });
        this.batchItems = new HorizontalContainer();
        this.batchItems.setVerticalAlignment(ALIGN_MIDDLE);
        this.batchItems.add((Widget)this.batchesCheckBox);
        this.batchItems.add((Widget)new Label(" Number of batches "));
        this.batchItems.add((Widget)this.batches);
        this.add((Widget)this.batchItems);
        this.batchItems.setVisible(false);
        this.batches.setEnabled(false);
        this.batches.setText("1");
        this.setStyleName("scheduling-widget");
    }

    public void batchEnabled(boolean enabled) {
        this.jobLimitItems.setVisible(enabled);
    }

    public ScheduleType getScheduleType() {
        ScheduleType scheduleType = null;
        SchedulingWidgetRow selectedSchedulingWidgetRow = this.getSelectedSchedulingWidgetRow();
        if (selectedSchedulingWidgetRow != null) {
            scheduleType = selectedSchedulingWidgetRow.getScheduleType();
        }
        return scheduleType;
    }

    public ScheduleInfo getScheduleInfo() {
        ScheduleInfo scheduleInfo = null;
        SchedulingWidgetRow selectedSchedulingWidgetRow = this.getSelectedSchedulingWidgetRow();
        scheduleInfo = selectedSchedulingWidgetRow.getScheduleInfo();
        scheduleInfo.setBatches(this.batches.getText() == null ? 0 : Integer.parseInt(this.batches.getText()));
        scheduleInfo.setJobLimit(this.jobLimit.getText() == null ? 0 : Integer.parseInt(this.jobLimit.getText()));
        return scheduleInfo;
    }

    public void setScheduleInfo(ScheduleInfo scheduleInfo) {
        this.reset();
        if (scheduleInfo != null) {
            ScheduleType scheduleType = scheduleInfo.getScheduleType();
            SchedulingWidgetRow targetRow = null;
            switch (scheduleType) {
                case ON_DATE: {
                    targetRow = this.onDateRow;
                    break;
                }
                case EVERY_N_DAYS: {
                    targetRow = this.everyNDaysRow;
                    break;
                }
                case ON_DAY_EVERY_N_WEEKS: {
                    targetRow = this.onDayEveryNWeeksRow;
                    break;
                }
                case N_DAYS_FROM_METADATA: {
                    targetRow = this.nDaysFromMetadataRow;
                    break;
                }
                case EVERY_N_HOURMINS: {
                    targetRow = this.everyNHourMinsRow;
                }
            }
            if (targetRow != null) {
                this.onDateRow.setChecked(false);
                this.everyNDaysRow.setChecked(false);
                this.onDayEveryNWeeksRow.setChecked(false);
                this.nDaysFromMetadataRow.setChecked(false);
                targetRow.setChecked(true);
                targetRow.setScheduleInfo(scheduleInfo);
                if (scheduleInfo.getBatches() > 1) {
                    this.batches.setEnabled(true);
                    this.batchesCheckBox.setValue(Boolean.valueOf(true));
                } else {
                    this.batches.setEnabled(false);
                    this.batchesCheckBox.setValue(Boolean.valueOf(false));
                }
                if (scheduleInfo.getJobLimit() > 0) {
                    this.jobLimit.setEnabled(true);
                    this.jobLimitCheckBox.setValue(Boolean.valueOf(true));
                } else {
                    this.jobLimit.setEnabled(false);
                    this.jobLimitCheckBox.setValue(Boolean.valueOf(false));
                }
                this.batches.setText(Integer.toString(scheduleInfo.getBatches()));
                this.jobLimit.setText(Integer.toString(scheduleInfo.getJobLimit()));
            } else {
                this.batches.setText("1");
                this.jobLimit.setText("0");
            }
        }
    }

    public static String getScheduleInfoString(ScheduleInfo scheduleInfo) {
        String scheduleInfoString = "";
        if (scheduleInfo != null) {
            ScheduleType scheduleType = scheduleInfo.getScheduleType();
            switch (scheduleType) {
                case ON_DATE: {
                    scheduleInfoString = OnDateRow.getScheduleInfoString(scheduleInfo);
                    break;
                }
                case EVERY_N_DAYS: {
                    scheduleInfoString = EveryNDaysRow.getScheduleInfoString(scheduleInfo);
                    break;
                }
                case ON_DAY_EVERY_N_WEEKS: {
                    scheduleInfoString = OnDayEveryNWeeksRow.getScheduleInfoString(scheduleInfo);
                    break;
                }
                case N_DAYS_FROM_METADATA: {
                    scheduleInfoString = NDaysFromMetadataRow.getScheduleInfoString(scheduleInfo);
                    break;
                }
                case EVERY_N_HOURMINS: {
                    scheduleInfoString = EveryNHourMinsRow.getScheduleInfoString(scheduleInfo);
                }
            }
        }
        return scheduleInfoString;
    }

    public void reset() {
        if (this.widgetConfig.isShowOnDateRow()) {
            this.onDateRow.setChecked(true);
        } else if (this.widgetConfig.isShowEveryNDaysRow()) {
            this.everyNDaysRow.setChecked(true);
        } else if (this.widgetConfig.isShowOnDayEveryNWeeksRow()) {
            this.onDayEveryNWeeksRow.setChecked(true);
        } else if (this.widgetConfig.isShowNDaysFromMetadataRow()) {
            this.nDaysFromMetadataRow.setChecked(true);
        } else if (this.widgetConfig.isShowEveryNHourMinsRow()) {
            this.everyNHourMinsRow.setChecked(true);
        }
        this.onDateRow.reset();
        this.everyNDaysRow.reset();
        this.onDayEveryNWeeksRow.reset();
        this.nDaysFromMetadataRow.reset();
        this.everyNHourMinsRow.reset();
    }

    public List<String> validate() {
        ArrayList<String> validationMessages = new ArrayList<String>();
        SchedulingWidgetRow selectedSchedulingWidgetRow = this.getSelectedSchedulingWidgetRow();
        if (selectedSchedulingWidgetRow == null) {
            validationMessages.add(this.schedulingConstants.scheduleTypeRequired());
        } else {
            validationMessages.addAll(selectedSchedulingWidgetRow.validate());
        }
        try {
            Integer jobLimitInt = Integer.parseInt(this.jobLimit.getText());
            if (jobLimitInt < 0) {
                validationMessages.add("Job Limit is less than 0.");
            } else if (jobLimitInt > 99999) {
                validationMessages.add("Job Limit Exceeds 99,999.");
            }
        }
        catch (Exception e) {
            validationMessages.add("Job Limit is either not a number or a whole number.");
        }
        return validationMessages;
    }

    public void setMetadataTree(UiMetadataTree metadataTree) {
        if (this.nDaysFromMetadataRow != null) {
            this.nDaysFromMetadataRow.setMetadataTree(metadataTree);
        }
    }

    public SchedulingWidgetRow getSelectedSchedulingWidgetRow() {
        SchedulingWidgetRow selectedSchedulingWidgetRow = null;
        if (this.onDateRow.isChecked()) {
            selectedSchedulingWidgetRow = this.onDateRow;
        } else if (this.everyNDaysRow.isChecked()) {
            selectedSchedulingWidgetRow = this.everyNDaysRow;
        } else if (this.onDayEveryNWeeksRow.isChecked()) {
            selectedSchedulingWidgetRow = this.onDayEveryNWeeksRow;
        } else if (this.nDaysFromMetadataRow.isChecked()) {
            selectedSchedulingWidgetRow = this.nDaysFromMetadataRow;
        } else if (this.everyNHourMinsRow.isChecked()) {
            selectedSchedulingWidgetRow = this.everyNHourMinsRow;
        }
        return selectedSchedulingWidgetRow;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
        this.onDateRow.setEnabled(enabled);
        this.everyNDaysRow.setEnabled(enabled);
        this.onDayEveryNWeeksRow.setEnabled(enabled);
        this.nDaysFromMetadataRow.setEnabled(enabled);
        this.everyNHourMinsRow.setEnabled(enabled);
    }
}

