/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduling.ui.client.widgets;

import com.ericsson.cms.scheduling.ui.client.common.SchedulingConstants;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleInfo;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleType;
import com.ericsson.cms.scheduling.ui.client.data.UiMetadataTree;
import com.ericsson.cms.scheduling.ui.client.widgets.NoClickDateBox;
import com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidget;
import com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetConfig;
import com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetRow;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.DateBox;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SchedulingWidget2
extends VerticalContainer {
    private static final String PATTERN_DATE_FORMAT = "yyyy-MM-dd";
    private static final DateTimeFormat DATE_FORMAT = DateTimeFormat.getFormat((String)"yyyy-MM-dd");
    FormContainer formContainer;
    LabelWidget startDateLabel;
    NoClickDateBox startNoClickDateBox;
    LabelWidget endDateLabel;
    NoClickDateBox endNoClickDateBox;
    SchedulingWidget schedulingWidget;
    HorizontalContainer hc = new HorizontalContainer();
    boolean isEnabled = true;
    SchedulingConstants schedulingConstants = (SchedulingConstants)GWT.create(SchedulingConstants.class);

    public SchedulingWidget2(SchedulingWidgetConfig widgetConfig) {
        HorizontalContainer hcntnr1 = new HorizontalContainer();
        HorizontalContainer hcntnr2 = new HorizontalContainer();
        hcntnr1.setVerticalAlignment(ALIGN_MIDDLE);
        hcntnr2.setVerticalAlignment(ALIGN_MIDDLE);
        ImageWidget cross_icon1 = new ImageWidget("cms_contentmgmt_ui/resources/images/icon_close.png");
        ImageWidget cross_icon2 = new ImageWidget("cms_contentmgmt_ui/resources/images/icon_close.png");
        this.startDateLabel = new LabelWidget(this.schedulingConstants.startDateLabel());
        this.startNoClickDateBox = this.newNoClickDateBoxInstance();
        this.endDateLabel = new LabelWidget(this.schedulingConstants.endDateLabel());
        this.endNoClickDateBox = this.newNoClickDateBoxInstance();
        this.formContainer = new FormContainer(HorizontalContainer.ALIGN_LEFT);
        this.formContainer.addRow(this.startDateLabel, (Widget)this.startNoClickDateBox);
        this.formContainer.addRow(this.endDateLabel, (Widget)this.endNoClickDateBox);
        ImageWidget img1 = new ImageWidget("cms_scheduling_ui/images/icon_cal.png");
        ImageWidget img2 = new ImageWidget("cms_scheduling_ui/images/icon_cal.png");
        img1.setStyleName("cal1-style");
        img2.setStyleName("cal1-style");
        hcntnr1.add((Widget)this.startDateLabel);
        hcntnr1.add((Widget)this.startNoClickDateBox);
        hcntnr1.add((Widget)cross_icon1);
        cross_icon1.setStyleName("date-box-cross-icon");
        cross_icon2.setStyleName("date-box-cross-icon");
        this.hc.add((Widget)hcntnr1);
        this.hc.add((Widget)img1);
        hcntnr2.add((Widget)this.endDateLabel);
        hcntnr2.add((Widget)this.endNoClickDateBox);
        hcntnr2.add((Widget)cross_icon2);
        this.hc.add((Widget)hcntnr2);
        this.hc.add((Widget)img2);
        img1.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SchedulingWidget2.this.startNoClickDateBox.getDatePicker().setVisible(true);
                SchedulingWidget2.this.startNoClickDateBox.showDatePicker();
            }
        });
        img2.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SchedulingWidget2.this.endNoClickDateBox.getDatePicker().setVisible(true);
                SchedulingWidget2.this.endNoClickDateBox.showDatePicker();
            }
        });
        this.startNoClickDateBox.getTextBox().addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SchedulingWidget2.this.startNoClickDateBox.hideDatePicker();
                SchedulingWidget2.this.endNoClickDateBox.getDatePicker().setVisible(false);
                SchedulingWidget2.this.startNoClickDateBox.getDatePicker().setVisible(false);
            }
        });
        this.endNoClickDateBox.getTextBox().addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SchedulingWidget2.this.endNoClickDateBox.hideDatePicker();
                SchedulingWidget2.this.endNoClickDateBox.getDatePicker().setVisible(false);
                SchedulingWidget2.this.startNoClickDateBox.getDatePicker().setVisible(false);
            }
        });
        cross_icon1.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SchedulingWidget2.this.startNoClickDateBox.hideDatePicker();
                SchedulingWidget2.this.startNoClickDateBox.getTextBox().setText("");
                SchedulingWidget2.this.endNoClickDateBox.getDatePicker().setVisible(false);
                SchedulingWidget2.this.startNoClickDateBox.getDatePicker().setVisible(false);
            }
        });
        cross_icon2.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SchedulingWidget2.this.endNoClickDateBox.hideDatePicker();
                SchedulingWidget2.this.endNoClickDateBox.getTextBox().setText("");
                SchedulingWidget2.this.endNoClickDateBox.getDatePicker().setVisible(false);
                SchedulingWidget2.this.startNoClickDateBox.getDatePicker().setVisible(false);
            }
        });
        hcntnr1.setStyleName("table-style-for-date-widget");
        hcntnr2.setStyleName("table-style-for-date-widget");
        this.hc.setSpacing(4);
        this.add((Widget)this.hc);
        this.schedulingWidget = new SchedulingWidget(widgetConfig);
        this.add((Widget)this.schedulingWidget);
    }

    public ScheduleInfo getScheduleInfo() {
        ScheduleInfo scheduleInfo = null;
        scheduleInfo = this.schedulingWidget.getScheduleInfo();
        ScheduleType scheduleType = this.schedulingWidget.getScheduleType();
        if (!ScheduleType.ON_DATE.equals((Object)scheduleType)) {
            String strStartDate = this.startNoClickDateBox.getTextBox().getText();
            scheduleInfo.setStrStartDate(strStartDate);
            String strEndDate = this.endNoClickDateBox.getTextBox().getText();
            scheduleInfo.setStrEndDate(strEndDate);
        }
        return scheduleInfo;
    }

    public void setBatchEnabled(boolean enabled) {
        if (this.schedulingWidget != null) {
            this.schedulingWidget.batchEnabled(enabled);
        }
    }

    public void setScheduleInfo(ScheduleInfo scheduleInfo) {
        this.reset();
        this.schedulingWidget.setScheduleInfo(scheduleInfo);
        if (scheduleInfo != null) {
            String strEndDate;
            String strStartDate = scheduleInfo.getStrStartDate();
            if (strStartDate != null) {
                this.startNoClickDateBox.getTextBox().setText(strStartDate);
            }
            if ((strEndDate = scheduleInfo.getStrEndDate()) != null) {
                this.endNoClickDateBox.getTextBox().setText(strEndDate);
            }
        }
    }

    public static String getScheduleInfoString(ScheduleInfo scheduleInfo) {
        String scheduleInfoString = "";
        if (scheduleInfo != null) {
            scheduleInfoString = SchedulingWidget.getScheduleInfoString(scheduleInfo);
        }
        return scheduleInfoString;
    }

    public void reset() {
        this.schedulingWidget.reset();
        this.startNoClickDateBox.getTextBox().setText(null);
        this.endNoClickDateBox.getTextBox().setText(null);
    }

    public List<String> validate() {
        ArrayList<String> validationMessages = new ArrayList<String>();
        ScheduleType scheduleType = this.schedulingWidget.getScheduleType();
        String strStartDate = this.startNoClickDateBox.getTextBox().getText();
        String strEndDate = this.endNoClickDateBox.getTextBox().getText();
        if (ScheduleType.ON_DATE.equals((Object)scheduleType)) {
            if (strStartDate != null && !strStartDate.isEmpty()) {
                validationMessages.add(this.schedulingConstants.startDateNotRequired());
            }
            if (strEndDate != null && !strEndDate.isEmpty()) {
                validationMessages.add(this.schedulingConstants.endDateNotRequired());
            }
        } else {
            Date startDate = null;
            if (strStartDate != null && !strStartDate.isEmpty()) {
                try {
                    startDate = DATE_FORMAT.parseStrict(strStartDate);
                }
                catch (IllegalArgumentException e) {
                    validationMessages.add(this.schedulingConstants.startDateRequiredFormat());
                }
            }
            Date endDate = null;
            if (strEndDate != null && !strEndDate.isEmpty()) {
                try {
                    endDate = DATE_FORMAT.parseStrict(strEndDate);
                }
                catch (IllegalArgumentException e) {
                    validationMessages.add(this.schedulingConstants.endDateRequiredFormat());
                }
            }
            if (startDate != null && endDate != null && endDate.before(startDate)) {
                validationMessages.add(this.schedulingConstants.endDateBeforeStartDate());
            }
        }
        validationMessages.addAll(this.schedulingWidget.validate());
        return validationMessages;
    }

    public void setMetadataTree(UiMetadataTree metadataTree) {
        this.schedulingWidget.setMetadataTree(metadataTree);
    }

    public SchedulingWidgetRow getSelectedSchedulingWidgetRow() {
        return this.schedulingWidget.getSelectedSchedulingWidgetRow();
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
        this.schedulingWidget.setEnabled(enabled);
        this.startNoClickDateBox.setEnabled(enabled);
        this.endNoClickDateBox.setEnabled(enabled);
    }

    private NoClickDateBox newNoClickDateBoxInstance() {
        NoClickDateBox dateBox = new NoClickDateBox();
        dateBox.getTextBox().setVisibleLength(12);
        dateBox.getTextBox().setHeight("20px");
        DateBox.DefaultFormat fmt = new DateBox.DefaultFormat(DATE_FORMAT);
        dateBox.setFormat((DateBox.Format)fmt);
        return dateBox;
    }
}

