/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduling.ui.client.widgets;

import com.ericsson.cms.scheduling.ui.client.common.SchedulingConstants;
import com.ericsson.cms.scheduling.ui.client.data.AmPm;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ComboBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import java.util.ArrayList;
import java.util.List;

public class TimeEntryWidget
extends HorizontalContainer {
    private static final String PATTERN_TIME_FORMAT = "h:mm a";
    TextBox timeEntryBox;
    ListBoxWidget<AmPm> ampmOption;
    ComboBoxWidget cb = new ComboBoxWidget();
    SchedulingConstants schedulingConstants = (SchedulingConstants)GWT.create(SchedulingConstants.class);

    public TimeEntryWidget() {
        this.cb.setEditable(true);
        this.cb.addItem("01:00", null);
        this.cb.addItem("02:00", null);
        this.cb.addItem("03:00", null);
        this.cb.addItem("04:00", null);
        this.cb.addItem("05:00", null);
        this.cb.addItem("06:00", null);
        this.cb.addItem("07:00", null);
        this.cb.addItem("08:00", null);
        this.cb.addItem("09:00", null);
        this.cb.addItem("10:00", null);
        this.cb.addItem("11:00", null);
        this.cb.addItem("12:00", null);
        this.timeEntryBox = new TextBox();
        this.cb.setStyleName("combo-box-style");
        this.cb.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                TimeEntryWidget.this.timeEntryBox.setText(TimeEntryWidget.this.cb.getText());
            }
        });
        this.timeEntryBox.setVisibleLength(5);
        this.add((Widget)this.cb);
        this.setSpacing(10);
        this.ampmOption = new ListBoxWidget();
        this.ampmOption.setVisibleItemCount(1);
        this.ampmOption.addItem(AmPm.am.toString(), (Object)AmPm.am);
        this.ampmOption.addItem(AmPm.pm.toString(), (Object)AmPm.pm);
        this.add((Widget)this.ampmOption);
    }

    public String getTime() {
        String strTime = this.cb.getText();
        strTime = strTime + " ";
        strTime = strTime + ((AmPm)((Object)this.ampmOption.getSelectedItem())).toString();
        return strTime;
    }

    public void setTime(String strTime) {
        String[] strTimeComponents = strTime.split(" ");
        int numStrTimeComponents = strTimeComponents.length;
        String strAmPm = strTimeComponents[numStrTimeComponents - 1];
        String strHrMins = strTimeComponents[0];
        this.ampmOption.setSelectedItem((Object)AmPm.valueOf(strAmPm));
        this.timeEntryBox.setText(strHrMins);
        this.cb.setText(strHrMins);
    }

    public void reset() {
        this.timeEntryBox.setText(null);
        this.ampmOption.setSelectedItem((Object)AmPm.am);
    }

    public List<String> validate() {
        ArrayList<String> validationMessages = new ArrayList<String>();
        String strTime = this.getTime();
        DateTimeFormat fmt = DateTimeFormat.getFormat((String)PATTERN_TIME_FORMAT);
        try {
            fmt.parseStrict(strTime);
        }
        catch (IllegalArgumentException e) {
            validationMessages.add(this.schedulingConstants.timeRequiredFormat());
        }
        if (!validationMessages.contains(this.schedulingConstants.timeRequiredFormat())) {
            try {
                String[] strTimeParts = strTime.split(":");
                String strTimeHourPart = strTimeParts[0];
                int hour = Integer.parseInt(strTimeHourPart.trim());
                if (hour > 12) {
                    validationMessages.add(this.schedulingConstants.timeRequiredFormat());
                }
            }
            catch (NumberFormatException e) {
                validationMessages.add(this.schedulingConstants.timeRequiredFormat());
            }
        }
        return validationMessages;
    }

    public void setEnabled(boolean enabled) {
        this.timeEntryBox.setEnabled(enabled);
        this.ampmOption.setEnabled(enabled);
    }

    public ComboBoxWidget<?> getComboBoxWidget() {
        return this.cb;
    }
}

