/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduling.ui.server;

import com.ericsson.cms.scheduler.Node;
import com.ericsson.cms.scheduling.ui.client.data.UiMetadataTree;
import java.util.List;

public class MetadataTreeConvertor {
    public UiMetadataTree convertMetadataTree(List<Node> metadataTree) {
        UiMetadataTree uiMetadataTree = null;
        if (metadataTree != null) {
            uiMetadataTree = new UiMetadataTree();
            for (Node node : metadataTree) {
                UiMetadataTree uiMetadataTreeNode = this.convert(null, node);
                uiMetadataTree.getChildren().add(uiMetadataTreeNode);
            }
        }
        return uiMetadataTree;
    }

    private UiMetadataTree convert(UiMetadataTree parentUiMetadataTree, Node node) {
        UiMetadataTree uiMetadataTree = null;
        if (node != null) {
            uiMetadataTree = new UiMetadataTree();
            uiMetadataTree.setName(node.getName());
            uiMetadataTree.setDisplayName(node.getDisplayName());
            if (parentUiMetadataTree != null) {
                String fullName = parentUiMetadataTree.getFullName();
                if (node.getName() != null) {
                    fullName = parentUiMetadataTree.getFullName() + "." + node.getName();
                }
                uiMetadataTree.setFullName(fullName);
                uiMetadataTree.setFullDisplayName(parentUiMetadataTree.getFullDisplayName() + "." + node.getDisplayName());
            } else {
                uiMetadataTree.setFullName(node.getName());
                uiMetadataTree.setFullDisplayName(node.getDisplayName());
            }
            if (node.getChildren() != null) {
                for (Node childNode : node.getChildren()) {
                    UiMetadataTree childUiMetadataTree = this.convert(uiMetadataTree, childNode);
                    uiMetadataTree.getChildren().add(childUiMetadataTree);
                }
            }
        }
        return uiMetadataTree;
    }
}

