/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduling.ui.server;

import com.ericsson.cms.scheduler.entities.Job;
import com.ericsson.cms.scheduler.entities.ScheduleRule;
import com.ericsson.cms.scheduler.entities.ScheduleRuleParameter;
import com.ericsson.cms.scheduler.entities.ScheduleRuleType;
import com.ericsson.cms.scheduling.ui.client.data.BeforeAfter;
import com.ericsson.cms.scheduling.ui.client.data.DayOfWeek;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleInfo;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleType;
import com.ericsson.cms.scheduling.ui.client.data.UIJob;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class ScheduleConvertor {
    private static final long MILLISECONDS_IN_A_DAY = 86400000L;
    private DateFormat df = new SimpleDateFormat("yyyy-MM-dd");

    public UIJob convertJob(Job job) {
        UIJob uiJob = null;
        if (job != null) {
            uiJob = new UIJob();
            uiJob.setId(job.getId());
            uiJob.setName(job.getName());
            uiJob.setScheduleInfo(this.convertScheduleRule(job.getRule()));
            uiJob.setAssociatedEntityType(job.getAssociatedEntityType());
            HashSet<Long> associatedEntities = new HashSet<Long>();
            associatedEntities.addAll(job.getAssociatedEntities());
            uiJob.setAssociatedEntities(associatedEntities);
            uiJob.setAssociationDescription(job.getAssociationDescription());
            Class callbackClass = job.getCallbackClass();
            if (callbackClass != null) {
                uiJob.setCallbackClass(callbackClass.getName());
            }
            uiJob.setActive(job.isActive());
        }
        return uiJob;
    }

    public Job convertUIJob(UIJob uiJob) {
        Job job = null;
        if (uiJob != null) {
            job = new Job();
            job.setId(uiJob.getId());
            job.setName(uiJob.getName());
            job.setRule(this.convertScheduleInfo(uiJob.getScheduleInfo()));
            job.setAssociatedEntityType(uiJob.getAssociatedEntityType());
            job.setAssociatedEntities(uiJob.getAssociatedEntities());
            job.setAssociationDescription(uiJob.getAssociationDescription());
            job.setActive(uiJob.isActive());
        }
        return job;
    }

    public ScheduleRule convertScheduleInfo(ScheduleInfo scheduleInfo) {
        ScheduleRule scheduleRule = null;
        if (scheduleInfo != null) {
            scheduleRule = new ScheduleRule();
            ArrayList<ScheduleRuleParameter> scheduleRuleParams = new ArrayList<ScheduleRuleParameter>();
            scheduleRule.setParams(scheduleRuleParams);
            ScheduleRuleType scheduleRuleType = null;
            ScheduleType scheduleType = scheduleInfo.getScheduleType();
            switch (scheduleType) {
                case ON_DATE: {
                    scheduleRuleType = ScheduleRuleType.ON_DATE;
                    ScheduleRuleParameter ruleParamDate = new ScheduleRuleParameter();
                    ruleParamDate.setOrder(1);
                    ruleParamDate.setValue(scheduleInfo.getSpecificDate());
                    scheduleRuleParams.add(ruleParamDate);
                    ScheduleRuleParameter ruleParamTime = new ScheduleRuleParameter();
                    ruleParamTime.setOrder(2);
                    ruleParamTime.setValue(scheduleInfo.getSpecificTime());
                    scheduleRuleParams.add(ruleParamTime);
                    break;
                }
                case EVERY_N_DAYS: {
                    scheduleRuleType = ScheduleRuleType.EVERY_N_DAYS;
                    ScheduleRuleParameter ruleParamNDays = new ScheduleRuleParameter();
                    ruleParamNDays.setOrder(1);
                    ruleParamNDays.setValue(String.valueOf(scheduleInfo.getnDays()));
                    scheduleRuleParams.add(ruleParamNDays);
                    ScheduleRuleParameter ruleParamTime = new ScheduleRuleParameter();
                    ruleParamTime.setOrder(2);
                    ruleParamTime.setValue(scheduleInfo.getSpecificTime());
                    scheduleRuleParams.add(ruleParamTime);
                    break;
                }
                case ON_DAY_EVERY_N_WEEKS: {
                    scheduleRuleType = ScheduleRuleType.ON_DAY_EVERY_N_WEEKS;
                    ScheduleRuleParameter ruleParamDay = new ScheduleRuleParameter();
                    ruleParamDay.setOrder(1);
                    ruleParamDay.setValue(String.valueOf((Object)scheduleInfo.getDayOfWeek()));
                    scheduleRuleParams.add(ruleParamDay);
                    ScheduleRuleParameter ruleParamNWeeks = new ScheduleRuleParameter();
                    ruleParamNWeeks.setOrder(2);
                    ruleParamNWeeks.setValue(String.valueOf(scheduleInfo.getnWeeks()));
                    scheduleRuleParams.add(ruleParamNWeeks);
                    ScheduleRuleParameter ruleParamTime = new ScheduleRuleParameter();
                    ruleParamTime.setOrder(3);
                    ruleParamTime.setValue(scheduleInfo.getSpecificTime());
                    scheduleRuleParams.add(ruleParamTime);
                    break;
                }
                case N_DAYS_FROM_METADATA: {
                    scheduleRuleType = ScheduleRuleType.N_DAYS_FROM_METADATA;
                    ScheduleRuleParameter ruleParamNDays = new ScheduleRuleParameter();
                    ruleParamNDays.setOrder(1);
                    ruleParamNDays.setValue(String.valueOf(scheduleInfo.getnDays()));
                    scheduleRuleParams.add(ruleParamNDays);
                    ScheduleRuleParameter ruleParamBeforeAfter = new ScheduleRuleParameter();
                    ruleParamBeforeAfter.setOrder(2);
                    ruleParamBeforeAfter.setValue(String.valueOf((Object)scheduleInfo.getBeforeAfter()));
                    scheduleRuleParams.add(ruleParamBeforeAfter);
                    ScheduleRuleParameter ruleParamMetadataField = new ScheduleRuleParameter();
                    ruleParamMetadataField.setOrder(3);
                    ruleParamMetadataField.setValue(String.valueOf(scheduleInfo.getMetadataField()));
                    scheduleRuleParams.add(ruleParamMetadataField);
                    ScheduleRuleParameter ruleParamTime = new ScheduleRuleParameter();
                    ruleParamTime.setOrder(4);
                    ruleParamTime.setValue(scheduleInfo.getSpecificTime());
                    scheduleRuleParams.add(ruleParamTime);
                    break;
                }
                case EVERY_N_HOURMINS: {
                    scheduleRuleType = ScheduleRuleType.EVERY_N_HOURMINS;
                    ScheduleRuleParameter ruleParamNHourMins = new ScheduleRuleParameter();
                    ruleParamNHourMins.setOrder(1);
                    ruleParamNHourMins.setValue(String.valueOf(scheduleInfo.getnHourMins()));
                    scheduleRuleParams.add(ruleParamNHourMins);
                    ScheduleRuleParameter ruleParamUnit = new ScheduleRuleParameter();
                    ruleParamUnit.setOrder(2);
                    ruleParamUnit.setValue(scheduleInfo.getTimeUnit());
                    scheduleRuleParams.add(ruleParamUnit);
                    ScheduleRuleParameter ruleParamTime = new ScheduleRuleParameter();
                    ruleParamTime.setOrder(3);
                    ruleParamTime.setValue(scheduleInfo.getSpecificTime());
                    scheduleRuleParams.add(ruleParamTime);
                }
            }
            scheduleRule.setType(scheduleRuleType);
            String strStartDate = scheduleInfo.getStrStartDate();
            String strEndDate = scheduleInfo.getStrEndDate();
            Date startDate = null;
            Date endDate = null;
            this.df.setLenient(false);
            if (strStartDate != null && !strStartDate.isEmpty()) {
                try {
                    startDate = this.df.parse(strStartDate);
                }
                catch (Exception ruleParamNWeeks) {
                    // empty catch block
                }
            }
            scheduleRule.setStartDate(startDate);
            if (strEndDate != null && !strEndDate.isEmpty()) {
                try {
                    endDate = this.df.parse(strEndDate);
                    long endDateTime = endDate.getTime();
                    endDate = new Date(endDateTime += 86399999L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            scheduleRule.setEndDate(endDate);
        }
        return scheduleRule;
    }

    public ScheduleInfo convertScheduleRule(ScheduleRule scheduleRule) {
        ScheduleInfo scheduleInfo = null;
        if (scheduleRule != null) {
            scheduleInfo = new ScheduleInfo();
            ScheduleRuleType scheduleRuleType = scheduleRule.getType();
            ScheduleType scheduleType = null;
            List scheduleRuleParams = null;
            int numScheduleRuleParams = 0;
            switch (scheduleRuleType) {
                case ON_DATE: {
                    ScheduleRuleParameter scheduleRuleParam;
                    scheduleType = ScheduleType.ON_DATE;
                    scheduleRuleParams = scheduleRule.getParams();
                    if (scheduleRuleParams == null) break;
                    numScheduleRuleParams = scheduleRuleParams.size();
                    if (numScheduleRuleParams > 0) {
                        scheduleRuleParam = (ScheduleRuleParameter)scheduleRuleParams.get(0);
                        String specificDate = scheduleRuleParam.getValue();
                        scheduleInfo.setSpecificDate(specificDate);
                    }
                    if (numScheduleRuleParams <= 1) break;
                    scheduleRuleParam = (ScheduleRuleParameter)scheduleRuleParams.get(1);
                    String specificTime = scheduleRuleParam.getValue();
                    scheduleInfo.setSpecificTime(specificTime);
                    break;
                }
                case EVERY_N_DAYS: {
                    String strnDays;
                    ScheduleRuleParameter scheduleRuleParam;
                    scheduleType = ScheduleType.EVERY_N_DAYS;
                    scheduleRuleParams = scheduleRule.getParams();
                    if (scheduleRuleParams == null) break;
                    numScheduleRuleParams = scheduleRuleParams.size();
                    if (numScheduleRuleParams > 0) {
                        scheduleRuleParam = (ScheduleRuleParameter)scheduleRuleParams.get(0);
                        strnDays = scheduleRuleParam.getValue();
                        try {
                            int nDays = Integer.parseInt(strnDays);
                            scheduleInfo.setnDays(nDays);
                        }
                        catch (NumberFormatException nDays) {
                            // empty catch block
                        }
                    }
                    if (numScheduleRuleParams <= 1) break;
                    scheduleRuleParam = (ScheduleRuleParameter)scheduleRuleParams.get(1);
                    String specificTime = scheduleRuleParam.getValue();
                    scheduleInfo.setSpecificTime(specificTime);
                    break;
                }
                case ON_DAY_EVERY_N_WEEKS: {
                    ScheduleRuleParameter scheduleRuleParam;
                    scheduleType = ScheduleType.ON_DAY_EVERY_N_WEEKS;
                    scheduleRuleParams = scheduleRule.getParams();
                    if (scheduleRuleParams == null) break;
                    numScheduleRuleParams = scheduleRuleParams.size();
                    if (numScheduleRuleParams > 0) {
                        scheduleRuleParam = (ScheduleRuleParameter)scheduleRuleParams.get(0);
                        String strDayOfWeek = scheduleRuleParam.getValue();
                        try {
                            DayOfWeek dayOfWeek = DayOfWeek.valueOf(strDayOfWeek);
                            scheduleInfo.setDayOfWeek(dayOfWeek);
                        }
                        catch (Exception dayOfWeek) {
                            // empty catch block
                        }
                    }
                    if (numScheduleRuleParams > 1) {
                        scheduleRuleParam = (ScheduleRuleParameter)scheduleRuleParams.get(1);
                        String strnWeeks = scheduleRuleParam.getValue();
                        try {
                            int nWeeks = Integer.parseInt(strnWeeks);
                            scheduleInfo.setnWeeks(nWeeks);
                        }
                        catch (NumberFormatException nWeeks) {
                            // empty catch block
                        }
                    }
                    if (numScheduleRuleParams <= 2) break;
                    scheduleRuleParam = (ScheduleRuleParameter)scheduleRuleParams.get(2);
                    String specificTime = scheduleRuleParam.getValue();
                    scheduleInfo.setSpecificTime(specificTime);
                    break;
                }
                case N_DAYS_FROM_METADATA: {
                    String strnDays;
                    ScheduleRuleParameter scheduleRuleParam;
                    scheduleType = ScheduleType.N_DAYS_FROM_METADATA;
                    scheduleRuleParams = scheduleRule.getParams();
                    if (scheduleRuleParams == null) break;
                    numScheduleRuleParams = scheduleRuleParams.size();
                    if (numScheduleRuleParams > 0) {
                        scheduleRuleParam = (ScheduleRuleParameter)scheduleRuleParams.get(0);
                        strnDays = scheduleRuleParam.getValue();
                        try {
                            int nDays = Integer.parseInt(strnDays);
                            scheduleInfo.setnDays(nDays);
                        }
                        catch (NumberFormatException nDays) {
                            // empty catch block
                        }
                    }
                    if (numScheduleRuleParams > 1) {
                        scheduleRuleParam = (ScheduleRuleParameter)scheduleRuleParams.get(1);
                        String strBeforeAfter = scheduleRuleParam.getValue();
                        try {
                            BeforeAfter beforeAfter = BeforeAfter.valueOf(strBeforeAfter);
                            scheduleInfo.setBeforeAfter(beforeAfter);
                        }
                        catch (Exception beforeAfter) {
                            // empty catch block
                        }
                    }
                    if (numScheduleRuleParams > 2) {
                        scheduleRuleParam = (ScheduleRuleParameter)scheduleRuleParams.get(2);
                        String metadataField = scheduleRuleParam.getValue();
                        scheduleInfo.setMetadataField(metadataField);
                    }
                    if (numScheduleRuleParams <= 3) break;
                    scheduleRuleParam = (ScheduleRuleParameter)scheduleRuleParams.get(3);
                    String specificTime = scheduleRuleParam.getValue();
                    scheduleInfo.setSpecificTime(specificTime);
                    break;
                }
                case EVERY_N_HOURMINS: {
                    ScheduleRuleParameter scheduleRuleParam;
                    scheduleType = ScheduleType.EVERY_N_HOURMINS;
                    scheduleRuleParams = scheduleRule.getParams();
                    if (scheduleRuleParams == null) break;
                    numScheduleRuleParams = scheduleRuleParams.size();
                    if (numScheduleRuleParams > 0) {
                        scheduleRuleParam = (ScheduleRuleParameter)scheduleRuleParams.get(0);
                        String strnHourMins = scheduleRuleParam.getValue();
                        try {
                            int nHourMins = Integer.parseInt(strnHourMins);
                            scheduleInfo.setnHourMins(nHourMins);
                        }
                        catch (NumberFormatException nHourMins) {
                            // empty catch block
                        }
                    }
                    if (numScheduleRuleParams > 1) {
                        scheduleRuleParam = (ScheduleRuleParameter)scheduleRuleParams.get(1);
                        String timeUnit = scheduleRuleParam.getValue();
                        scheduleInfo.setTimeUnit(timeUnit);
                    }
                    if (numScheduleRuleParams <= 2) break;
                    scheduleRuleParam = (ScheduleRuleParameter)scheduleRuleParams.get(2);
                    String specificTime = scheduleRuleParam.getValue();
                    scheduleInfo.setSpecificTime(specificTime);
                }
            }
            scheduleInfo.setScheduleType(scheduleType);
            Date startDate = scheduleRule.getStartDate();
            Date endDate = scheduleRule.getEndDate();
            if (startDate != null) {
                String strStartDate = this.df.format(startDate);
                scheduleInfo.setStrStartDate(strStartDate);
            }
            if (endDate != null) {
                String strEndDate = this.df.format(endDate);
                scheduleInfo.setStrEndDate(strEndDate);
            }
        }
        return scheduleInfo;
    }
}

