/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduling.ui.server;

import com.ericsson.cms.scheduler.IHistoryTokenProvider;
import com.ericsson.cms.scheduler.IScheduler;
import com.ericsson.cms.scheduler.IWOScheduler;
import com.ericsson.cms.scheduler.IWOSchedulerClient;
import com.ericsson.cms.scheduler.InvalidScheduleException;
import com.ericsson.cms.scheduler.entities.FutureExecution;
import com.ericsson.cms.scheduler.entities.Job;
import com.ericsson.cms.scheduler.entities.PastExecution;
import com.ericsson.cms.scheduler.entities.TemplateVariable;
import com.ericsson.cms.scheduler.entities.WOJob;
import com.ericsson.cms.scheduling.ui.client.common.UiInvalidScheduleException;
import com.ericsson.cms.scheduling.ui.client.data.SchedulesListRow;
import com.ericsson.cms.scheduling.ui.client.data.UIExecutionRecord;
import com.ericsson.cms.scheduling.ui.client.data.UITemplateVariable;
import com.ericsson.cms.scheduling.ui.client.data.UIWOJob;
import com.ericsson.cms.scheduling.ui.client.data.UiMetadataTree;
import com.ericsson.cms.scheduling.ui.client.service.IUISchedulerService;
import com.ericsson.cms.scheduling.ui.server.MetadataTreeConvertor;
import com.ericsson.cms.scheduling.ui.server.ScheduleConvertor;
import com.ericsson.cms.scheduling.ui.server.util.DateFormatter;
import com.ericsson.cms.scheduling.ui.server.util.UIPropertyReader;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.PartnerType;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.ejb.EJBTransactionRolledbackException;
import org.apache.log4j.Logger;

public class UISchedulerService
implements IUISchedulerService,
NeptuneRemoteService {
    private static final String CONF_EXECUTIONS_NUMHOURS = "scheduler.executions.numHours";
    private static final String CONF_UPCOMING_JOBS_PORTLET_DATE_FORMAT = "scheduler.portlets.upcomingjobs.dateFormat";
    private static final String CONF_ALLOW_ONLY_EVERY_N_HOURS = "scheduler.executions.isOnlyHour";
    private static final String UPCOMING_JOBS_PORTLET_DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm";
    private static ServiceLoader<IHistoryTokenProvider> htpLoader = ServiceLoader.load(IHistoryTokenProvider.class);
    private Logger logger = Logger.getLogger(UISchedulerService.class);
    private IScheduler scheduler = (IScheduler)InjectionUtil.injectInstance((String)"cms/Scheduler/local", IScheduler.class);
    private IWOScheduler woScheduler = (IWOScheduler)InjectionUtil.injectInstance((String)"cms/WOScheduler/local", IWOScheduler.class);
    private Map<String, String> config = new UIPropertyReader().getInfo();

    public UISchedulerService() {
        String portalDatePattern = this.config.get(CONF_UPCOMING_JOBS_PORTLET_DATE_FORMAT);
        if (portalDatePattern != null && !(portalDatePattern = portalDatePattern.trim()).isEmpty()) {
            try {
                DateFormatter.PORTAL.setPattern(portalDatePattern);
            }
            catch (Exception e) {
                this.logger.warn((Object)("Exception occurred while applying date format pattern for the setting scheduler.portlets.upcomingjobs.dateFormat: " + e), (Throwable)e);
                this.logger.warn((Object)("The value '" + portalDatePattern + "' specified for setting " + CONF_UPCOMING_JOBS_PORTLET_DATE_FORMAT + " is not a valid Date Format. Default Date Format '" + UPCOMING_JOBS_PORTLET_DEFAULT_DATE_FORMAT + "' would be used instead."));
                DateFormatter.PORTAL.setPattern(UPCOMING_JOBS_PORTLET_DEFAULT_DATE_FORMAT);
            }
        }
    }

    public String getRelativePath() {
        return "service/scheduler/IUISchedulerService";
    }

    public Class<? extends UISchedulerService> getServiceImplementation() {
        return this.getClass();
    }

    @Override
    public List<SchedulesListRow> getAllJobs() {
        List jobs = this.scheduler.getAllJobs();
        ArrayList<SchedulesListRow> rows = new ArrayList<SchedulesListRow>();
        if (jobs != null) {
            for (Job job : jobs) {
                SchedulesListRow row = new SchedulesListRow();
                row.setId(job.getId());
                row.setName(job.getName());
                row.setActive(job.isActive());
                row.setAssociatedEntityType(job.getAssociatedEntityType());
                row.setAssociatedEntities(this.getAsArray(job.getAssociatedEntities()));
                row.setAssociationDescription(job.getAssociationDescription());
                row.setScheduleInfo(new ScheduleConvertor().convertScheduleRule(job.getRule()));
                WOJob woJob = this.woScheduler.getScheduleByJobId(job.getId().longValue());
                if (woJob != null) {
                    row.setWoJobId(woJob.getId());
                    row.setTemplateName(woJob.getTemplateName());
                }
                String historyToken = this.getHistoryToken(job);
                row.setHistoryToken(historyToken);
                rows.add(row);
            }
        }
        return rows;
    }

    private long[] getAsArray(Collection<Long> coll) {
        if (coll == null) {
            return new long[0];
        }
        long[] array = new long[coll.size()];
        int i = 0;
        for (Long item : coll) {
            array[i++] = item;
        }
        return array;
    }

    @Override
    public List<UIWOJob> getSchedulesByAssociatedEntity(String entityType, long entityId) {
        ArrayList<UIWOJob> uiWOJobs = new ArrayList<UIWOJob>();
        List woJobs = this.woScheduler.getSchedulesByAssociatedEntity(entityType, entityId);
        if (woJobs != null) {
            for (WOJob woJob : woJobs) {
                UIWOJob uiWOJob = this.convert(woJob);
                uiWOJobs.add(uiWOJob);
            }
        }
        return uiWOJobs;
    }

    @Override
    public UIWOJob getWOJob(long id) {
        WOJob woJob = this.woScheduler.getSchedule(id);
        return this.convert(woJob);
    }

    @Override
    public UIWOJob getWOJobByJobId(long jobId) throws NeptuneException {
        WOJob woJob;
        try {
            woJob = this.woScheduler.getScheduleByJobId(jobId);
        }
        catch (Exception e) {
            Throwable cause;
            if (e instanceof EJBTransactionRolledbackException && (cause = e.getCause()) != null) {
                throw new NeptuneException(cause.getMessage());
            }
            throw new NeptuneException(e.getMessage());
        }
        return this.convert(woJob);
    }

    @Override
    public Map<String, String> getAllEntityTypes() {
        boolean hasSelfPartner;
        HashMap<String, String> entityTypes = new HashMap<String, String>();
        for (IWOSchedulerClient client : this.woScheduler.getAllClients()) {
            entityTypes.put(client.getName(), client.getDisplayName());
        }
        boolean entityTypesHasSelfPartner = entityTypes.keySet().contains(PartnerType.SELF.name());
        if (entityTypesHasSelfPartner && !(hasSelfPartner = this.isSelfPartnerAssociated())) {
            entityTypes.remove(PartnerType.SELF.name());
        }
        return entityTypes;
    }

    @Override
    public Map<Long, String> getEntitiesOfType(String entityType) throws NeptuneException {
        IWOSchedulerClient client = this.woScheduler.getClientByName(entityType);
        if (client == null) {
            throw new NeptuneException("No Workorder Scheduler Client found with name: " + entityType);
        }
        return client.getAllEntities();
    }

    @Override
    public List<String> getTemplates(boolean associatedWithTitles) {
        return this.woScheduler.getTemplates(associatedWithTitles);
    }

    @Override
    public List<UITemplateVariable> getStartVariablesForTemplate(String templateName, boolean associatedWithTitles) {
        List templateVariables = this.woScheduler.getTemplateStartParamNames(templateName, associatedWithTitles);
        ArrayList<UITemplateVariable> uiTemplateVariables = new ArrayList<UITemplateVariable>();
        for (TemplateVariable var : templateVariables) {
            uiTemplateVariables.add(new UITemplateVariable(var.getName(), var.getDisplayName(), var.isRequired(), var.isAutoMapped()));
        }
        return uiTemplateVariables;
    }

    @Override
    public UiMetadataTree getRuleMetadataTree(String entityType) {
        List tree = this.woScheduler.getParametersForFilter(entityType);
        return new MetadataTreeConvertor().convertMetadataTree(tree);
    }

    @Override
    public UiMetadataTree getWOMappingMetadataTree(String entityType, boolean associatedWithTitles) {
        List tree = this.woScheduler.getParametersForWorkOrderMapping(entityType, associatedWithTitles);
        return new MetadataTreeConvertor().convertMetadataTree(tree);
    }

    @Override
    public void delete(Set<Long> woJobIds) {
        this.woScheduler.deleteSchedules(woJobIds);
    }

    @Override
    public void dissociate(Set<Long> woJobIds, long entityId) {
        for (Long woJobId : woJobIds) {
            this.woScheduler.dissociate(woJobId.longValue(), entityId);
        }
    }

    @Override
    public UIWOJob save(UIWOJob woJob) throws NeptuneException {
        try {
            WOJob scheduledWoJob = this.woScheduler.schedule(this.convert(woJob));
            return this.convert(scheduledWoJob);
        }
        catch (RuntimeException re) {
            if (re instanceof EJBTransactionRolledbackException) {
                Throwable cause = re.getCause();
                if (cause instanceof InvalidScheduleException) {
                    InvalidScheduleException ise = (InvalidScheduleException)cause;
                    throw new UiInvalidScheduleException(ise.getReasons());
                }
                throw re;
            }
            throw re;
        }
    }

    @Override
    public void setActive(Set<Long> woJobIds, boolean active) {
        this.woScheduler.setSchedulesActive(woJobIds, active);
    }

    @Override
    public void runNow(Set<Long> jobIds) {
        if (jobIds != null) {
            for (Long id : jobIds) {
                this.scheduler.runNow(id.longValue());
            }
        }
    }

    @Override
    public List<UIExecutionRecord> getPastExecutions() {
        ArrayList<UIExecutionRecord> uiExecRecords = new ArrayList<UIExecutionRecord>();
        int numHours = this.getNumHoursFromConfig();
        List execRecords = this.scheduler.getPastExecutions(numHours);
        if (execRecords != null) {
            for (PastExecution e : execRecords) {
                uiExecRecords.add(this.convert(e, DateFormatter.LIST_PAGE));
            }
        }
        return uiExecRecords;
    }

    @Override
    public List<UIExecutionRecord> getFutureExecutions() {
        ArrayList<UIExecutionRecord> uiExecRecords = new ArrayList<UIExecutionRecord>();
        int numHours = this.getNumHoursFromConfig();
        List execRecords = this.scheduler.getFutureExecutions(numHours);
        if (execRecords != null) {
            for (FutureExecution e : execRecords) {
                uiExecRecords.add(this.convert(e, DateFormatter.LIST_PAGE));
            }
        }
        return uiExecRecords;
    }

    private int getNumHoursFromConfig() {
        return Integer.parseInt(this.config.get(CONF_EXECUTIONS_NUMHOURS));
    }

    @Override
    public List<UIExecutionRecord> getNextNFutureExecutions(int count) {
        this.logger.debug((Object)("Getting Next N Future Executions, N = " + count));
        ArrayList<UIExecutionRecord> uiExecRecords = new ArrayList<UIExecutionRecord>();
        List execRecords = this.scheduler.getNFutureExecutions(count);
        if (execRecords != null) {
            for (FutureExecution e : execRecords) {
                uiExecRecords.add(this.convert(e, DateFormatter.PORTAL));
            }
        }
        return uiExecRecords;
    }

    @Override
    public void setFutureExecutionsEnabled(Set<UIExecutionRecord> records, boolean enabled) {
        for (UIExecutionRecord uiExecutionRecord : records) {
            long jobId = uiExecutionRecord.getJobId();
            Date execDate = uiExecutionRecord.getExecutionTime();
            this.scheduler.setFutureExecutionEnabled(jobId, execDate, enabled);
        }
    }

    @Override
    public boolean isSelfPartnerAssociated() {
        boolean isSelfPartnerAssociated = false;
        IPartnerManagement partnerManager = (IPartnerManagement)ServiceRegistry.getDefault().lookup(IPartnerManagement.class);
        List partners = partnerManager.getAllActivePartnerDTOsForCurrentUser();
        for (Partner partner : partners) {
            PartnerType partnerType = partner.getType();
            if (!PartnerType.SELF.equals((Object)partnerType)) continue;
            isSelfPartnerAssociated = true;
            break;
        }
        return isSelfPartnerAssociated;
    }

    @Override
    public boolean isJobNameAlreadyUsed(String jobName) {
        boolean isJobNameAlreadyUsed = true;
        Job job = this.scheduler.getJobByJobName(jobName);
        if (job == null) {
            isJobNameAlreadyUsed = false;
        }
        return isJobNameAlreadyUsed;
    }

    private UIWOJob convert(WOJob job) {
        UIWOJob uiJob = new UIWOJob();
        uiJob.setId(job.getId());
        uiJob.setJobId(job.getJobId());
        uiJob.setName(job.getName());
        uiJob.setAssociatedEntityType(job.getAssociatedEntityType());
        HashSet<Long> associatedEntities = new HashSet<Long>();
        if (job.getAssociatedEntities() != null) {
            associatedEntities.addAll(job.getAssociatedEntities());
        }
        uiJob.setAssociatedEntities(associatedEntities);
        uiJob.setScheduleInfo(new ScheduleConvertor().convertScheduleRule(job.getRule()));
        uiJob.setTemplateName(job.getTemplateName());
        uiJob.setPriority(job.getPriority());
        HashMap<String, String> mappingParams = new HashMap<String, String>();
        if (job.getWoMappingParams() != null) {
            mappingParams.putAll(job.getWoMappingParams());
        }
        uiJob.setWoMappingParams(mappingParams);
        uiJob.setActive(job.isActive());
        return uiJob;
    }

    private WOJob convert(UIWOJob uiJob) {
        WOJob job = new WOJob();
        job.setId(uiJob.getId());
        job.setName(uiJob.getName());
        job.setAssociatedEntityType(uiJob.getAssociatedEntityType());
        job.setAssociatedEntities(uiJob.getAssociatedEntities());
        job.setRule(new ScheduleConvertor().convertScheduleInfo(uiJob.getScheduleInfo()));
        job.setTemplateName(uiJob.getTemplateName());
        job.setPriority(uiJob.getPriority());
        job.setWoMappingParams(uiJob.getWoMappingParams());
        return job;
    }

    private UIExecutionRecord convert(FutureExecution execRecord, DateFormatter df) {
        UIExecutionRecord uiExecRecord = new UIExecutionRecord();
        uiExecRecord.setJobId(execRecord.getJob().getId());
        uiExecRecord.setJobName(execRecord.getJob().getName());
        uiExecRecord.setAssociatedEntityType(execRecord.getJob().getAssociatedEntityType());
        uiExecRecord.setAssociation(execRecord.getJob().getAssociationDescription());
        uiExecRecord.setExecutionTime(execRecord.getExecutionTime());
        uiExecRecord.setExecutionTimeString(df.format(execRecord.getExecutionTime()));
        uiExecRecord.setEnabled(execRecord.isEnabled());
        WOJob woJob = this.woScheduler.getScheduleByJobId(execRecord.getJob().getId().longValue());
        if (woJob != null) {
            uiExecRecord.setWoJobId(woJob.getId());
        }
        String historyToken = this.getHistoryToken(execRecord.getJob());
        uiExecRecord.setHistoryToken(historyToken);
        return uiExecRecord;
    }

    private UIExecutionRecord convert(PastExecution execRecord, DateFormatter df) {
        UIExecutionRecord uiExecRecord = new UIExecutionRecord();
        uiExecRecord.setJobId(execRecord.getJob().getId());
        uiExecRecord.setJobName(execRecord.getJob().getName());
        uiExecRecord.setAssociation(execRecord.getJob().getAssociationDescription());
        uiExecRecord.setExecutionTime(execRecord.getExecutionTime());
        uiExecRecord.setExecutionTimeString(df.format(execRecord.getExecutionTime()));
        uiExecRecord.setEnabled(execRecord.isEnabled());
        uiExecRecord.setStale(execRecord.isStale());
        WOJob woJob = this.woScheduler.getScheduleByJobId(execRecord.getJob().getId().longValue());
        if (woJob != null) {
            uiExecRecord.setWoJobId(woJob.getId());
        }
        String historyToken = this.getHistoryToken(execRecord.getJob());
        uiExecRecord.setHistoryToken(historyToken);
        return uiExecRecord;
    }

    private String getHistoryToken(Job job) {
        String historyToken = null;
        for (IHistoryTokenProvider htp : htpLoader) {
            try {
                historyToken = htp.getHistoryToken(job);
            }
            catch (Exception e) {
                this.logger.warn((Object)("Exception occurred getting history token for Job : " + job + " : " + e), (Throwable)e);
            }
            if (historyToken == null) continue;
            break;
        }
        return historyToken;
    }

    @Override
    public boolean getAllowOnlyHourFromConfig() {
        return Boolean.valueOf(this.config.get(CONF_ALLOW_ONLY_EVERY_N_HOURS));
    }
}

