/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduling.ui.server.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public enum DateFormatter {
    LIST_PAGE("EEE, MMM d, yyyy h:mm a"),
    PORTAL("yyyy-MM-dd HH:mm");

    private static final Logger logger;
    private SimpleDateFormat formatter;

    private DateFormatter(String pattern) {
        this.formatter = new SimpleDateFormat(pattern);
    }

    public synchronized void setPattern(String pattern) {
        this.formatter.applyPattern(pattern);
    }

    public synchronized String format(Date date) {
        return this.formatter.format(date);
    }

    public synchronized Date parse(String s) {
        try {
            return this.formatter.parse(s);
        }
        catch (ParseException e) {
            logger.error((Object)e);
            return null;
        }
    }

    public String getPattern() {
        return this.formatter.toPattern();
    }

    static {
        logger = Logger.getLogger(DateFormatter.class);
    }
}

