/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduling.ui.server.util;

import com.ericsson.cms.scheduler.authorization.ISchedulerLicenseManager;
import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.infoprovider.IServerInfoProvider;
import com.tandbergtv.neptune.licensing.ILicenseManager;
import com.tandbergtv.neptune.licensing.InvalidLicenseException;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.util.Map;
import org.apache.log4j.Logger;

public class UIPropertyReader
implements IServerInfoProvider {
    private static final String SCHEDULER_UI_PROPERTIES_GROUP_NAME = "com.ericsson.cms.scheduler.ui";
    private static final String CONF_EXECUTIONS_NUMHOURS = "scheduler.executions.numHours";
    private static final int DEFAULT_EXECUTIONS_NUMHOURS = 72;
    private static final String SCHEDULER_LICENSE_KEY = "SchedulerLicense";
    private static final String PMM_LICENSE_KEY = "PMMLicense";
    private ISchedulerLicenseManager schedulerLicenseManager = (ISchedulerLicenseManager)InjectionUtil.injectInstance((String)"cms/SchedulerLicenseManager/local", ISchedulerLicenseManager.class);
    private static ILicenseManager licenseManager = (ILicenseManager)InjectionUtil.injectInstance((String)"cms/LicenseManager/local", ILicenseManager.class);
    private Logger logger = Logger.getLogger(UIPropertyReader.class);

    public Map<String, String> getInfo() {
        Map info = UIPropertyReader.getConfigurationService().getProperties(SCHEDULER_UI_PROPERTIES_GROUP_NAME);
        info.put(SCHEDULER_LICENSE_KEY, this.getSchedulerLicenseInfo());
        info.put(PMM_LICENSE_KEY, this.getPMMLicenseInfo());
        this.validateNumHoursProperty(info);
        return info;
    }

    private String getSchedulerLicenseInfo() {
        String isLicensed;
        try {
            isLicensed = String.valueOf(this.schedulerLicenseManager.isLicensed());
        }
        catch (InvalidLicenseException e) {
            isLicensed = "false";
            this.logger.error((Object)("Error reading scheduler license : " + (Object)((Object)e)), (Throwable)e);
        }
        return isLicensed;
    }

    private String getPMMLicenseInfo() {
        String isLicensed;
        try {
            isLicensed = String.valueOf(licenseManager.getProperty(PMM_LICENSE_KEY));
        }
        catch (InvalidLicenseException e) {
            isLicensed = "false";
            this.logger.error((Object)("Error reading PMM license : " + (Object)((Object)e)), (Throwable)e);
        }
        return isLicensed;
    }

    private void validateNumHoursProperty(Map<String, String> info) {
        String numHoursStr = info.get(CONF_EXECUTIONS_NUMHOURS);
        int numHours = 72;
        if (numHoursStr != null) {
            numHoursStr = numHoursStr.trim();
            try {
                numHours = Integer.parseInt(numHoursStr);
            }
            catch (Exception e) {
                this.logger.warn((Object)("Invalid executions list - number of hours configuration: [" + numHoursStr + "]. Using default value: [" + 72 + "]"));
            }
        }
        info.put(CONF_EXECUTIONS_NUMHOURS, String.valueOf(numHours));
    }

    private static IConfigurationService getConfigurationService() {
        String jndiName = "cms/ConfigurationService/local";
        return (IConfigurationService)InjectionUtil.injectInstance((String)jndiName, IConfigurationService.class);
    }
}

