/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.core;

import com.ericsson.cms.scheduler.entities.Job;
import com.ericsson.cms.sites.core.EntitiesAssociatedException;
import com.ericsson.cms.sites.core.SiteManagementException;
import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.DistributionSiteTitle;
import com.ericsson.cms.sites.core.entities.DistributionStatus;
import com.ericsson.cms.sites.core.entities.LogicalSite;
import com.ericsson.cms.sites.core.entities.Site;
import com.ericsson.cms.sites.core.entities.SitePartner;
import com.ericsson.cms.sites.core.entities.SiteType;
import com.ericsson.cms.sites.core.entities.TargetResult;
import com.ericsson.cms.sites.core.entities.TrackingSite;
import com.ericsson.cms.sites.core.entities.TrackingSiteTitle;
import com.ericsson.cms.sites.core.entities.TrackingStatus;
import com.ericsson.cms.sites.distribution.TemplateInfo;
import com.tandbergtv.watchpoint.pmm.entities.ITitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.Local;

@Local
public interface ISiteManager {
    public Site getSite(int var1);

    public Site getSiteByName(String var1);

    public List<Site> getSitesByExternalId(String var1);

    public List<Site> getAllSites();

    public List<Site> getTopLevelSites();

    public List<DistributionSite> getAllDistributionSites();

    public List<DistributionSite> getActiveDistributionSites();

    public List<TrackingSite> getAllTrackingSites(Integer var1);

    public List<TrackingSite> getShareableTrackingSites(int var1);

    public List<Title> getSiteCopies(long var1);

    public List<Long> getSiteCopyIds(long var1);

    public DistributionSite getAssociatedDistributionSite(long var1);

    public DistributionSiteTitle getDistributionSiteTitleById(long var1);

    public DistributionSiteTitle getDistributionSiteTitle(long var1);

    public List<DistributionSiteTitle> getDistributionSiteTitles(long var1);

    public List<DistributionSiteTitle> getDistributionSiteTitles(int var1, List<Long> var2);

    public List<DistributionSiteTitle> getDistributionSiteTitlesByStatus(DistributionStatus var1);

    public List<DistributionSiteTitle> getDistributionSiteTitlesBySiteAndStatus(int var1, DistributionStatus var2);

    public List<Long> getDistributionSiteTitleIdsBySiteAndStatus(int var1, DistributionStatus var2);

    public List<TrackingSiteTitle> getTrackingSiteTitlesByStatus(TrackingStatus var1);

    public List<DistributionSiteTitle> getDistributionSiteTitlesOfLogicalSite(int var1, List<Long> var2);

    public List<TrackingSiteTitle> getTrackingSiteTitles(long var1);

    public TrackingSiteTitle getTrackingSiteTitle(long var1, int var3);

    public LogicalSite createLogicalSite(LogicalSite var1);

    public LogicalSite createLogicalSite(LogicalSite var1, SitePartner var2);

    public boolean hasReachedMaxLicensedDistributionSites();

    public DistributionSite createDistributionSite(DistributionSite var1, Integer var2);

    public DistributionSite createDistributionSite(DistributionSite var1, Integer var2, SitePartner var3);

    public boolean hasReachedMaxLicensedTrackingSites();

    public TrackingSite createTrackingSite(TrackingSite var1, Integer var2);

    public void associateTrackingSites(Set<Integer> var1, int var2);

    public void dissociateTrackingSite(int var1, int var2);

    public Site save(Site var1);

    public SitePartner save(Site var1, SitePartner var2);

    public Site updateSiteProperties(Site var1);

    public SitePartner updateSitePartnerProperties(Site var1, SitePartner var2);

    public void delete(int var1) throws EntitiesAssociatedException;

    public void activate(int var1) throws SiteManagementException;

    public void activateNoCascade(int var1) throws SiteManagementException;

    public void inactivate(int var1) throws SiteManagementException;

    public void inactivateNoCascade(int var1) throws SiteManagementException;

    public Set<TemplateInfo> getDistributionTemplatesInfo();

    public Set<String> getDistributionTemplateNames();

    public Title createSiteCopy(long var1, int var3) throws SiteManagementException;

    public Set<Site> target(long var1, List<Integer> var3) throws SiteManagementException;

    public TargetResult targetWithRules(long var1);

    @Deprecated
    public void distribute(int var1, List<Long> var2) throws SiteManagementException;

    public void distribute(long var1) throws SiteManagementException;

    public void distributeImmediately(long var1) throws SiteManagementException;

    public void distributeImmediately(int var1, List<Long> var2) throws SiteManagementException;

    public void distributeReadyTitlesImmediately(int var1) throws SiteManagementException;

    public void updateDistributionStatus(long var1, DistributionStatus var3);

    public void updateTrackingStatus(int var1, long var2, TrackingStatus var4);

    public void updateTrackingStatus(String var1, long var2, TrackingStatus var4);

    public void updateTitlesStatusFromInProgressToFailed();

    public Map<Title, Exception> purgeSiteTitles(long var1);

    @Deprecated
    public void delete(long var1);

    public void deleteTitle(long var1);

    public void deleteTrackingSiteTitle(long var1, int var3);

    public void deleteTrackingSiteTitles(int var1, int var2);

    public List<DistributionSiteTitle> getDistributionSiteTitlesByMasterTitleId(long var1);

    public int getMasterTitleCountOfLogicalSite(int var1, List<Long> var2);

    public int getMasterTitleCountOfDistributionSite(int var1, List<Long> var2);

    public List<Long> getMasterTitleIdsOfLogicalSite(int var1, int var2, int var3, boolean var4, List<Long> var5);

    public List<Long> getMasterTitleIdsOfDistributionSite(int var1, int var2, int var3, boolean var4, List<Long> var5);

    public List<List<?>> getAggDistStatusCountsOfLogicalSite(int var1, boolean var2, long var3, long var5, List<Long> var7);

    public List<List<?>> getAggDistStatusCountsOfDistributionSite(int var1, boolean var2, long var3, long var5, List<Long> var7);

    public List<List<?>> getAggTrackStatusCountsOfLogicalSite(int var1, boolean var2, long var3, long var5, List<Long> var7);

    public List<List<?>> getAggTrackStatusCountsOfDistributionSite(int var1, boolean var2, long var3, long var5, List<Long> var7);

    public Set<Integer> getActiveDistributionSitesInError(List<Long> var1);

    public Set<String> getActiveTrackingSitesInError(List<Long> var1);

    public boolean isSiteNameAlreadyUsed(String var1);

    public boolean isExternalSiteIdAlreadyUsed(String var1, SiteType var2);

    public Job getTimerJob(DistributionSite var1);

    public Integer getDistributionSiteId(Long var1);

    public void validateDistributionSiteforDistribution(Site var1);

    public void validateTitleforDistribution(DistributionSiteTitle var1, long var2, int var4);

    public List<Long> getSiteTitleIds(long var1, Set<String> var3);

    public List<Long> getSiteTitleIdsInDependencyOrder(long var1);

    public Map<Integer, Long> getDistributionSiteTitleIdsByMasterTitleIdForTrackingSite(long var1, String var3);

    public List<TrackingSite> getAllTrackingSites();

    public Boolean hasMPWithTrackingSites();

    public Boolean isMediaPathSiteTitle(Integer var1);

    public boolean isDistributionOrDeploymentInError(long var1);

    public List<String> getAllGroupNamesByTemplate(String var1);

    public List<Long> getRecentDistributionActivity(int var1, int var2, boolean var3, List<Long> var4);

    public void deleteDistributionSiteTitles(int var1);

    public void restartTimerForWaitingForDependencyTitles();

    public List<Integer> getDependsOnSites(Integer var1);

    public void updateSitesGraph(DistributionSite var1, boolean var2);

    public List<String> getSiteNamesBySiteIds(List<Integer> var1);

    public List<Site> getSitesByIds(List<Integer> var1);

    public void removeSiteTitleAttempts(Long var1);

    public void ExecuteActionOnFailure(Long var1, Long var2, String var3);

    public void updateDistributionStatus(DistributionSiteTitle var1, DistributionStatus var2);

    public void updateDistributionStatus(long var1, DistributionStatus var3, ITitleActionSource var4);
}

