/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.core.entities;

import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.Site;
import com.ericsson.cms.sites.core.entities.SiteType;
import com.ericsson.cms.sites.core.entities.TrackingSiteTitle;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="trackingSite")
public class TrackingSite
extends Site
implements Comparable<TrackingSite> {
    private static final long serialVersionUID = -9193525032417805770L;
    private static final Set<Site> EMPTY_CHILDREN = new TreeSet<Site>();
    private Set<DistributionSite> parents;
    private Set<TrackingSiteTitle> trackingSiteTitles;
    private Integer alertDelayPeriod;

    @Override
    public Set<Site> getSiteChildren() {
        return EMPTY_CHILDREN;
    }

    public void addParent(DistributionSite parent) {
        if (this.parents == null) {
            this.parents = new HashSet<DistributionSite>();
        }
        this.parents.add(parent);
    }

    public void clearParents() {
        if (this.parents != null) {
            this.parents.clear();
        }
    }

    public void setParents(Set<DistributionSite> parents) {
        this.parents = parents;
    }

    @XmlTransient
    public Set<DistributionSite> getParents() {
        return this.parents;
    }

    @Override
    @XmlElement(nillable=true)
    public SiteType getType() {
        return SiteType.TRACKING;
    }

    @Override
    @XmlTransient
    public Set<Site> getSiteParents() {
        HashSet<Site> siteParents = new HashSet<Site>();
        if (this.parents != null) {
            for (DistributionSite distSiteParent : this.parents) {
                siteParents.add(distSiteParent);
            }
        }
        return siteParents;
    }

    @XmlElement(nillable=true)
    public Integer getAlertDelayPeriod() {
        return this.alertDelayPeriod;
    }

    public void setAlertDelayPeriod(Integer alertDelayPeriod) {
        this.alertDelayPeriod = alertDelayPeriod;
    }

    @XmlTransient
    public Set<TrackingSiteTitle> getTrackingSiteTitles() {
        return this.trackingSiteTitles;
    }

    public void setTrackingSiteTitles(Set<TrackingSiteTitle> trackingSiteTitles) {
        this.trackingSiteTitles = trackingSiteTitles;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    @Override
    public int compareTo(TrackingSite o) {
        return this.getName().compareToIgnoreCase(o.getName());
    }
}

