/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client;

import com.ericsson.cms.scheduling.ui.client.data.ScheduleInfo;
import com.ericsson.cms.scheduling.ui.client.data.UIJob;
import com.ericsson.cms.scheduling.ui.client.data.UiMetadataTree;
import com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidget;
import com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetConfig;
import com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetFactory;
import com.ericsson.cms.sites.ui.client.Anchors;
import com.ericsson.cms.sites.ui.client.CISInfoPanel;
import com.ericsson.cms.sites.ui.client.CheckboxGroup;
import com.ericsson.cms.sites.ui.client.ConfirmDialog;
import com.ericsson.cms.sites.ui.client.CreateSiteDialogBox;
import com.ericsson.cms.sites.ui.client.DistConfPanel;
import com.ericsson.cms.sites.ui.client.ExportConfPanel;
import com.ericsson.cms.sites.ui.client.ExportStatusSelectionDialog;
import com.ericsson.cms.sites.ui.client.ISiteTab;
import com.ericsson.cms.sites.ui.client.IUISiteService;
import com.ericsson.cms.sites.ui.client.IUISiteServiceAsync;
import com.ericsson.cms.sites.ui.client.PartnerInfoPanel;
import com.ericsson.cms.sites.ui.client.RetryConfPanel;
import com.ericsson.cms.sites.ui.client.SitesTabContainer;
import com.ericsson.cms.sites.ui.client.SitesTree;
import com.ericsson.cms.sites.ui.client.StatusPluginPanel;
import com.ericsson.cms.sites.ui.client.TrackingSitesListPanel;
import com.ericsson.cms.sites.ui.client.entities.UIDistributionOption;
import com.ericsson.cms.sites.ui.client.entities.UISite;
import com.ericsson.cms.sites.ui.client.entities.UISiteCIS;
import com.ericsson.cms.sites.ui.client.entities.UISitePartner;
import com.ericsson.cms.sites.ui.client.entities.UISiteTreeNode;
import com.ericsson.cms.sites.ui.client.entities.UISiteType;
import com.ericsson.cms.sites.ui.client.entities.UIStatusPlugin;
import com.ericsson.cms.sites.ui.client.entities.UIStatusPluginType;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.ericsson.cms.sites.ui.client.i18n.SitesMessages;
import com.ericsson.cms.sites.ui.client.images.ISiteClientBundle;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UIDistributionStatus;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextAreaWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DialogBoxContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BasicTab
extends Composite
implements ISiteTab {
    private static final String STYLE_DIALOG_BOX = "sites-basicTab-rollbackDialogBox";
    private static final String STYLE_DIALOG_BOX_BUTTON_PANEL = "sites-basicTab-rollbackDialogBoxButtonPanel";
    private static final String STYLE_DIALOG_BOX_DETAIL_MESSAGE = "sites-basicTab-rollbackDialogBoxDetailMessage";
    private static final String STYLE_SCROLL_CONTAINER = "sites-basicTab-scrollContainer";
    private static final String STYLE_DISCLOSURE_CONTAINER = "sites-basicTab-disclosureContainer";
    private static final String STYLE_DEPENDSON_CONTAINER = "sites-basicTab-dependsOn";
    private static final boolean DISTRIBUTION_STATUS_PLUGIN_REQUIRED = false;
    private static final String SCHEDULER_LICENSE_KEY = "SchedulerLicense";
    private static final String METADATA_FORMAT_CABLELABSVOD1_1 = "CableLabsVOD1.1";
    private static final String METADATA_FORMAT_ALIAS_CABLELABSVOD1_1 = "CL1_1";
    private NeptuneSecurity security;
    private SitesTabContainer.SiteCRUDNotifier crudNotifier;
    private VerticalContainer mainPanel;
    private SimpleContainer basicInfoPanel;
    private RoundedDisclosureContainer basicInfoDisclosurePanel;
    private PartnerInfoPanel partnerInfoPanel;
    private RoundedDisclosureContainer partnerInfoDisclosurePanel;
    private CISInfoPanel cisPanel;
    private RoundedDisclosureContainer cisDisclosurePanel;
    private LabelWidget noSiteLabel;
    private MessageArea messageArea;
    private HorizontalContainer siteStatusPanel;
    private FormContainer basicFormContainer;
    private HorizontalPanel buttonsPanel;
    private LabelWidget siteStatusLabel;
    private LabelWidget fileLookupKeysLabel;
    private LabelWidget metadataFormatLabel;
    private LabelWidget distOptionLabel;
    private LabelWidget distConfLabel;
    private LabelWidget exportConfLabel;
    private LabelWidget alertDelayPeriodLabel;
    private LabelWidget distStatusPluginPanelLabel;
    private LabelWidget deplStatusPluginPanelLabel;
    private LabelWidget retryActionLabel;
    private ISiteClientBundle clientBundle = (ISiteClientBundle)GWT.create(ISiteClientBundle.class);
    private ImageWidget siteActiveImage = new ImageWidget();
    private ImageWidget siteInactiveImage = new ImageWidget();
    private TextBoxWidget nameValueWidget = new TextBoxWidget();
    private TextBoxWidget externalIdValueWidget = new TextBoxWidget();
    private TextAreaWidget descriptionValueWidget = new TextAreaWidget();
    private ListBoxWidget<UISiteType> siteTypeValueWidget = new ListBoxWidget();
    private CheckboxGroup<String> fileLookupKeysValueWidget = new CheckboxGroup();
    private CheckboxGroup<UISite> dependsOnValueWidget = new CheckboxGroup();
    private ListBoxWidget<String> metadataFormatValueWidget = new ListBoxWidget();
    private VerticalContainer distOptionValueWidget;
    private SchedulingWidget schedulingWidget;
    private ListBoxWidget<UIDistributionOption> distOptionListBox;
    private DistConfPanel distConfPanel;
    private ExportConfPanel exportConfPanel;
    private HorizontalContainer alertDelayPeriodValueWidget;
    private TextBoxWidget alertDelayPeriodTextWidget = new TextBoxWidget();
    private StatusPluginPanel distStatusPluginPanel;
    private StatusPluginPanel deplStatusPluginPanel;
    private DockPanel dockPanel;
    private ScrollPanel rightScrollPanel;
    private HandlerRegistration windowRegistration = null;
    protected Scheduler.ScheduledCommand resizeCommand;
    private SitesTree treeWidget;
    private SitesTabContainer parentTabContainer;
    private RetryConfPanel retryConfPanel;
    private ButtonWidget saveButton;
    private ButtonWidget activateButton;
    private ButtonWidget inactivateButton;
    private ButtonWidget deleteButton;
    private ButtonWidget exportButton;
    private ButtonWidget createChildButton;
    private ButtonWidget addExistingButton;
    private ButtonWidget dissociateFromParentButton;
    private UISite site;
    private BusyIndicator busyIndicator = new BusyIndicator();
    private IUISiteServiceAsync service = (IUISiteServiceAsync)GWT.create(IUISiteService.class);
    private SitesConstants constants = (SitesConstants)GWT.create(SitesConstants.class);
    private SitesMessages messages = (SitesMessages)GWT.create(SitesMessages.class);
    List<String> siteNameValidationErrors = new ArrayList<String>();
    List<String> externalSiteIdValidationErrors = new ArrayList<String>();
    private boolean isDistStatusPluginRequired = false;
    private boolean isSchedulerLicensed;

    public BasicTab(Map<String, String> info) {
        boolean isTimedOptionAvailable;
        this.security = NeptuneApplication.getApplication().getSecurity();
        this.mainPanel = new VerticalContainer();
        this.mainPanel.setSpacing(10);
        this.basicInfoPanel = new SimpleContainer();
        this.partnerInfoPanel = new PartnerInfoPanel();
        this.cisPanel = new CISInfoPanel();
        this.noSiteLabel = new LabelWidget(this.constants.noSiteSelected());
        this.siteActiveImage.setResource(this.clientBundle.siteActive());
        this.siteInactiveImage.setResource(this.clientBundle.siteInactive());
        this.siteStatusPanel = new HorizontalContainer();
        this.siteStatusLabel = new LabelWidget(this.constants.fieldLabelSiteStatus());
        this.nameValueWidget.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                String siteName = BasicTab.this.nameValueWidget.getText();
                BasicTab.this.validateSiteName(siteName);
            }
        });
        this.externalIdValueWidget.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                String externalId = BasicTab.this.externalIdValueWidget.getText();
                BasicTab.this.validateExternalSiteId(externalId);
            }
        });
        this.siteTypeValueWidget.addItem(this.constants.fieldValueSiteTypeLogical(), (Object)UISiteType.LOGICAL);
        this.siteTypeValueWidget.addItem(this.constants.fieldValueSiteTypeDistribution(), (Object)UISiteType.DISTRIBUTION);
        this.siteTypeValueWidget.addItem(this.constants.fieldValueSiteTypeMediaPathDistribution(), (Object)UISiteType.MEDIAPATH_DISTRIBUTION);
        this.siteTypeValueWidget.addItem(this.constants.fieldValueSiteTypeTracking(), (Object)UISiteType.TRACKING);
        this.siteTypeValueWidget.setEnabled(false);
        this.fileLookupKeysLabel = new LabelWidget(this.constants.fieldLabelFileLookupKeys());
        this.metadataFormatLabel = new LabelWidget(this.constants.fieldLabelMetadataFormat());
        this.distOptionLabel = new LabelWidget(this.constants.fieldLabelDistOption());
        this.distOptionValueWidget = new VerticalContainer();
        this.distOptionListBox = new ListBoxWidget();
        this.distOptionListBox.addItem(this.constants.fieldValueDistOptionImmediate(), (Object)UIDistributionOption.IMMEDIATE);
        this.isSchedulerLicensed = Boolean.parseBoolean(info.get(SCHEDULER_LICENSE_KEY));
        boolean canCreateSchedule = this.security.isUserInRole("Scheduler_Create");
        boolean canViewSchedule = this.security.isUserInRole("Scheduler_View");
        boolean canEditSchedule = this.security.isUserInRole("Sites_Modify") && this.security.isUserInRole("Scheduler_Modify");
        boolean canDeleteSchedule = this.security.isUserInRole("Sites_Modify") && this.security.isUserInRole("Scheduler_Delete");
        boolean bl = isTimedOptionAvailable = canCreateSchedule || canViewSchedule || canEditSchedule || canDeleteSchedule;
        if (isTimedOptionAvailable) {
            this.distOptionListBox.addItem(this.constants.fieldValueDistOptionTimed(), (Object)UIDistributionOption.TIMED);
        }
        this.distOptionListBox.addItem(this.constants.fieldValueDistOptionManual(), (Object)UIDistributionOption.MANUAL);
        this.distOptionListBox.addItem(this.constants.fieldValueDistOptionDepends(), (Object)UIDistributionOption.DEPENDSON);
        this.distOptionValueWidget.add(this.distOptionListBox);
        this.schedulingWidget = this.getSchedulingWidget();
        this.schedulingWidget.setVisible(false);
        this.distOptionValueWidget.add((Widget)this.schedulingWidget);
        this.distOptionValueWidget.add(this.dependsOnValueWidget);
        this.dependsOnValueWidget.removeStyleName("sites-basicTab-fileLookupKeys");
        this.dependsOnValueWidget.addStyleName(STYLE_DEPENDSON_CONTAINER);
        this.dependsOnValueWidget.setVisible(false);
        this.distOptionListBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                UIDistributionOption selectedDistributionOption = (UIDistributionOption)((Object)BasicTab.this.distOptionListBox.getSelectedItem());
                if (UIDistributionOption.TIMED.equals((Object)selectedDistributionOption)) {
                    boolean isScheduleVisible = BasicTab.this.security.isUserInRole("Scheduler_Create") && BasicTab.this.site.getTimerJob() == null || BasicTab.this.security.isUserInRole("Scheduler_View") && BasicTab.this.site.getTimerJob() != null || BasicTab.this.security.isUserInRole("Scheduler_Modify") && BasicTab.this.site.getTimerJob() != null || BasicTab.this.security.isUserInRole("Scheduler_Delete") && BasicTab.this.site.getTimerJob() != null;
                    boolean isScheduleEnabled = BasicTab.this.security.isUserInRole("Scheduler_Create") && BasicTab.this.site.getTimerJob() == null || BasicTab.this.security.isUserInRole("Scheduler_Modify") && BasicTab.this.site.getTimerJob() != null;
                    BasicTab.this.schedulingWidget.setVisible(isScheduleVisible);
                    BasicTab.this.schedulingWidget.setEnabled(isScheduleEnabled);
                    BasicTab.this.dependsOnValueWidget.setVisible(false);
                    if (!isScheduleVisible) {
                        Window.alert((String)"You do not have permission for this operation.");
                        BasicTab.this.distOptionListBox.setSelectedItem((Object)BasicTab.this.site.getDistributionOption());
                    }
                } else if (UIDistributionOption.DEPENDSON.equals((Object)selectedDistributionOption)) {
                    BasicTab.this.schedulingWidget.setVisible(false);
                    BasicTab.this.dependsOnValueWidget.setVisible(true);
                } else {
                    BasicTab.this.schedulingWidget.setVisible(false);
                    BasicTab.this.dependsOnValueWidget.setVisible(false);
                }
            }
        });
        this.distConfLabel = new LabelWidget(this.constants.fieldLabelDistConf());
        this.distConfPanel = new DistConfPanel();
        this.exportConfLabel = new LabelWidget(this.constants.fieldLabelExportConf());
        this.exportConfPanel = new ExportConfPanel();
        this.alertDelayPeriodLabel = new LabelWidget(this.constants.fieldLabelAlertDelayPeriod());
        this.alertDelayPeriodValueWidget = new HorizontalContainer();
        this.alertDelayPeriodValueWidget.add((Widget)this.alertDelayPeriodTextWidget);
        LabelWidget minutesLabel = new LabelWidget(this.constants.minutes());
        this.alertDelayPeriodValueWidget.add((Widget)minutesLabel);
        this.retryActionLabel = new LabelWidget(this.constants.actionOnFailure());
        this.retryConfPanel = new RetryConfPanel();
        this.distStatusPluginPanelLabel = new LabelWidget(this.constants.fieldLabelDistStatusPluginPanel());
        this.distStatusPluginPanel = new StatusPluginPanel();
        this.deplStatusPluginPanel = new StatusPluginPanel();
        this.deplStatusPluginPanelLabel = new LabelWidget(this.constants.fieldLabelDeplStatusPluginPanel());
        this.saveButton = new ButtonWidget(this.constants.buttonLabelSave(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                BasicTab.this.save();
            }
        });
        this.saveButton.removeStyleName("gwt-Button");
        this.saveButton.addStyleName("ebBtn");
        this.saveButton.addStyleName("ebBtn_color_green");
        this.saveButton.addStyleName("save_button_icon");
        this.activateButton = new ButtonWidget(this.constants.buttonLabelActivate(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                BasicTab.this.activateAfterConfirming();
            }
        });
        this.activateButton.removeStyleName("gwt-Button");
        this.activateButton.addStyleName("ebBtn");
        this.activateButton.addStyleName("enable_button_icon");
        this.inactivateButton = new ButtonWidget(this.constants.buttonLabelInactivate(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                BasicTab.this.inactivateAfterConfirming();
            }
        });
        this.inactivateButton.removeStyleName("gwt-Button");
        this.inactivateButton.addStyleName("ebBtn");
        this.inactivateButton.addStyleName("disable_button_icon");
        this.deleteButton = new ButtonWidget(this.constants.buttonLabelDelete(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                BasicTab.this.confirm(BasicTab.this.constants.confirmDeleteSite(), new Command(){

                    public void execute() {
                        BasicTab.this.delete();
                    }
                }, null);
            }
        });
        this.deleteButton.removeStyleName("gwt-Button");
        this.deleteButton.addStyleName("ebBtn");
        this.deleteButton.addStyleName("delete_button_icon");
        this.exportButton = new ButtonWidget(this.constants.buttonLabelExport(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                BasicTab.this.showExportDialog();
            }
        });
        this.exportButton.removeStyleName("gwt-Button");
        this.exportButton.addStyleName("ebBtn");
        this.exportButton.addStyleName("export_button_icon");
        this.createChildButton = new ButtonWidget(this.constants.buttonLabelCreateChild());
        this.createChildButton.removeStyleName("gwt-Button");
        this.createChildButton.addStyleName("ebBtn");
        this.createChildButton.addStyleName("ebBtn_color_green");
        this.createChildButton.addStyleName("create_button_icon");
        this.createChildButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                BasicTab.this.createChildSite(event);
            }
        });
        this.addExistingButton = new ButtonWidget(this.constants.buttonLabelAddExisting());
        this.addExistingButton.removeStyleName("gwt-Button");
        this.addExistingButton.addStyleName("ebBtn");
        this.addExistingButton.addStyleName("addgreen_button_icon");
        this.addExistingButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                BasicTab.this.addExistingSite();
            }
        });
        this.dissociateFromParentButton = new ButtonWidget(this.constants.buttonLabelDissociate());
        this.dissociateFromParentButton.removeStyleName("gwt-Button");
        this.dissociateFromParentButton.addStyleName("ebBtn");
        this.dissociateFromParentButton.addStyleName("disassociate_button_icon");
        this.dissociateFromParentButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                BasicTab.this.dissociate();
            }
        });
        this.dockPanel = new DockPanel();
        this.dockPanel.setSpacing(10);
        this.buttonsPanel = new HorizontalPanel();
        this.buttonsPanel.addStyleName("cms_button_container");
        this.dockPanel.add((Widget)this.buttonsPanel, DockPanel.SOUTH);
        this.rightScrollPanel = new ScrollPanel();
        this.rightScrollPanel.addStyleName(STYLE_SCROLL_CONTAINER);
        this.rightScrollPanel.add((Widget)this.mainPanel);
        this.rightScrollPanel.setHeight("500px");
        this.rightScrollPanel.setWidth("500px");
        this.dockPanel.add((Widget)this.rightScrollPanel, DockPanel.CENTER);
        this.initWidget((Widget)this.dockPanel);
        this.resizeCommand = new Scheduler.ScheduledCommand(){

            public void execute() {
                BasicTab.this.resizeRightScrollPanel();
            }
        };
        this.showNoSiteSelectedLabel();
    }

    @Override
    public String getName() {
        return "Basic";
    }

    @Override
    public String getDisplayName() {
        return this.constants.basicTabName();
    }

    @Override
    public void setCRUDNotifier(SitesTabContainer.SiteCRUDNotifier crudListener) {
        this.crudNotifier = crudListener;
    }

    @Override
    public void setSelected(boolean selected) {
        if (!selected) {
            return;
        }
        this.messageArea.reset();
        if (this.site != null && this.site.getId() != null) {
            History.newItem((String)Anchors.getAnchor(this.site.getId(), this.site.getParentId()), (boolean)false);
            this.setMetadataTree(this.schedulingWidget);
        }
        this.updateScrollPanelSize();
    }

    public void setParentTabContainer(SitesTabContainer parentTabContainer) {
        this.parentTabContainer = parentTabContainer;
    }

    public void setTreeWidget(SitesTree treeWidget) {
        this.treeWidget = treeWidget;
    }

    private void showNoSiteSelectedLabel() {
        this.mainPanel.clear();
        this.mainPanel.add((Widget)this.noSiteLabel);
        this.buttonsPanel.clear();
    }

    private void showForm() {
        this.setErrorMessage(null);
        this.setInfoMessage(null);
        this.mainPanel.clear();
        this.mainPanel.add((Widget)this.siteStatusPanel);
        this.mainPanel.add((Widget)this.basicInfoPanel);
    }

    private void setErrorMessage(String message) {
        this.messageArea.setErrorMessage(message);
        this.updateScrollPanelSize();
    }

    private void setErrorHTML(String html) {
        this.messageArea.setErrorHTML(html);
        this.updateScrollPanelSize();
    }

    private void setInfoMessage(String message) {
        this.messageArea.setInfoMessage(message);
        this.updateScrollPanelSize();
    }

    private void showErrorMessage(String message) {
        this.mainPanel.clear();
        this.setErrorMessage(message);
    }

    private void showInfoMessage(String message) {
        this.mainPanel.clear();
        this.setInfoMessage(message);
    }

    private void setValidationErrors(String heading, List<String> validationErrors, String message) {
        this.setInfoMessage(null);
        String errorHtml = BasicTab.buildValidationErrorsHTML(heading, validationErrors, message);
        this.setErrorHTML(errorHtml);
    }

    public static String buildValidationErrorsHTML(String heading, List<String> validationErrors, String message) {
        StringBuilder html = new StringBuilder();
        if (heading != null) {
            html.append(heading).append("<br>");
        }
        if (validationErrors != null) {
            html.append("<ul>");
            for (String e : validationErrors) {
                html.append("<li>" + e + "</li>");
            }
            html.append("</ul>");
        }
        if (message != null) {
            html.append(message);
        }
        return html.toString();
    }

    public void showAddExistingTrackingSite(int parentSiteId, AsyncCallback<Void> callback) {
        this.site = null;
        this.mainPanel.clear();
        this.buttonsPanel.clear();
        this.mainPanel.add((Widget)new TrackingSitesListPanel(parentSiteId, callback));
    }

    private void buildFormUI(UISiteType siteType) {
        this.basicFormContainer = new FormContainer(HasHorizontalAlignment.ALIGN_LEFT);
        this.basicFormContainer.addRow(this.constants.fieldLabelName(), (Widget)this.nameValueWidget, true);
        this.basicFormContainer.addRow(this.constants.fieldLabelSiteType(), this.siteTypeValueWidget);
        this.basicFormContainer.addRow(this.constants.fieldLabelExternalId(), (Widget)this.externalIdValueWidget, true);
        this.basicFormContainer.addRow(this.constants.fieldLabelDescription(), (Widget)this.descriptionValueWidget);
        if (siteType == UISiteType.DISTRIBUTION || siteType == UISiteType.MEDIAPATH_DISTRIBUTION) {
            this.basicFormContainer.addRow(this.fileLookupKeysLabel, this.fileLookupKeysValueWidget, true);
            this.basicFormContainer.addRow(this.metadataFormatLabel, this.metadataFormatValueWidget, true);
            this.basicFormContainer.addRow(this.distOptionLabel, (Widget)this.distOptionValueWidget, true);
            this.basicFormContainer.addRow(this.distConfLabel, (Widget)this.distConfPanel, true);
            this.basicFormContainer.addRow(this.retryActionLabel, (Widget)this.retryConfPanel);
            this.basicFormContainer.addRow(this.exportConfLabel, (Widget)this.exportConfPanel);
            this.basicFormContainer.addRow(this.alertDelayPeriodLabel, (Widget)this.alertDelayPeriodValueWidget, true);
            this.basicFormContainer.addRow(this.distStatusPluginPanelLabel, (Widget)this.distStatusPluginPanel, this.isDistStatusPluginRequired);
            this.basicFormContainer.addRow(this.deplStatusPluginPanelLabel, (Widget)this.deplStatusPluginPanel);
        } else if (siteType == UISiteType.TRACKING) {
            this.basicFormContainer.addRow(this.alertDelayPeriodLabel, (Widget)this.alertDelayPeriodValueWidget, true);
            this.basicFormContainer.addRow(this.deplStatusPluginPanelLabel, (Widget)this.deplStatusPluginPanel);
        }
        this.basicInfoPanel.setWidget((Widget)this.basicFormContainer);
        this.buttonsPanel.add((Widget)this.saveButton);
        if (siteType == UISiteType.DISTRIBUTION || siteType == UISiteType.MEDIAPATH_DISTRIBUTION) {
            this.buttonsPanel.add((Widget)this.exportButton);
        }
        this.buttonsPanel.add((Widget)this.createChildButton);
        this.buttonsPanel.add((Widget)this.activateButton);
        this.buttonsPanel.add((Widget)this.inactivateButton);
        this.buttonsPanel.add((Widget)this.addExistingButton);
        this.buttonsPanel.add((Widget)this.dissociateFromParentButton);
        this.buttonsPanel.add((Widget)this.deleteButton);
    }

    private String getFailureMessageSuffix(Throwable caught) {
        return " | " + this.constants.reason() + ": " + (caught != null ? caught.getLocalizedMessage() : "");
    }

    private void showCommonSiteInfo(UISite site) {
        this.buildFormUI(site.getType());
        this.showForm();
        this.siteNameValidationErrors.clear();
        this.externalSiteIdValidationErrors.clear();
        this.nameValueWidget.setText(site.getName());
        this.externalIdValueWidget.setText(site.getExternalId());
        this.descriptionValueWidget.setText(site.getDescription());
        this.siteTypeValueWidget.setSelectedItem((Object)site.getType());
        boolean siteActive = site.isActive();
        this.siteActiveImage.setVisible(siteActive);
        this.siteInactiveImage.setVisible(!siteActive);
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                BasicTab.this.nameValueWidget.setFocus(true);
            }
        });
    }

    private void showPartnerInfo(UISite site) {
        this.mainPanel.clear();
        this.mainPanel.add((Widget)this.siteStatusPanel);
        this.basicInfoDisclosurePanel = new RoundedDisclosureContainer((Widget)new LabelWidget(this.constants.basicDisclosurePanelHeading()), true);
        this.basicInfoDisclosurePanel.addStyleName(STYLE_DISCLOSURE_CONTAINER);
        this.basicInfoDisclosurePanel.setContent((Widget)this.basicInfoPanel);
        this.mainPanel.add((Widget)this.basicInfoDisclosurePanel);
        this.partnerInfoDisclosurePanel = new RoundedDisclosureContainer((Widget)new LabelWidget(this.constants.partnerDisclosurePanelHeading()), true);
        this.partnerInfoDisclosurePanel.addStyleName(STYLE_DISCLOSURE_CONTAINER);
        this.partnerInfoDisclosurePanel.setContent((Widget)this.partnerInfoPanel);
        this.mainPanel.add((Widget)this.partnerInfoDisclosurePanel);
        this.partnerInfoPanel.showSite(site);
    }

    private void showCisInfo(UISite site) {
        this.cisDisclosurePanel = new RoundedDisclosureContainer((Widget)new LabelWidget(this.constants.cisDisclosurePanelHeading()), true);
        this.cisDisclosurePanel.addStyleName(STYLE_DISCLOSURE_CONTAINER);
        this.cisDisclosurePanel.setContent((Widget)this.cisPanel);
        this.mainPanel.add((Widget)this.cisDisclosurePanel);
        this.cisPanel.showSite(site);
    }

    private void showCreateButtons() {
        this.saveButton.setVisible(true);
        this.activateButton.setVisible(false);
        this.inactivateButton.setVisible(false);
        this.deleteButton.setVisible(false);
        this.exportButton.setVisible(false);
        this.createChildButton.setVisible(false);
        this.addExistingButton.setVisible(false);
        this.dissociateFromParentButton.setVisible(false);
    }

    private void showViewEditButtons(UISite site) {
        boolean hasCreatePrivilege = this.security.isUserInRole("Sites_Create");
        boolean hasEditPrivilege = this.security.isUserInRole("Sites_Modify");
        boolean hasDeletePrivilege = this.security.isUserInRole("Sites_Delete");
        UIJob timerJob = site.getTimerJob();
        if (timerJob != null) {
            hasEditPrivilege = hasEditPrivilege && this.security.isUserInRole("Scheduler_Modify");
            hasDeletePrivilege = hasDeletePrivilege && this.security.isUserInRole("Scheduler_Delete");
        }
        UISiteType siteType = site.getType();
        this.saveButton.setVisible(hasEditPrivilege);
        this.activateButton.setVisible(hasEditPrivilege && !site.isActive());
        this.inactivateButton.setVisible(hasEditPrivilege && site.isActive());
        this.deleteButton.setVisible(hasDeletePrivilege && !site.isShared());
        this.exportButton.setVisible((siteType.equals((Object)UISiteType.DISTRIBUTION) || siteType.equals((Object)UISiteType.MEDIAPATH_DISTRIBUTION)) && this.security.isUserInRole("Sites_Export"));
        this.createChildButton.setVisible(hasCreatePrivilege && hasEditPrivilege && (siteType.equals((Object)UISiteType.LOGICAL) || siteType.equals((Object)UISiteType.DISTRIBUTION) || siteType.equals((Object)UISiteType.MEDIAPATH_DISTRIBUTION)));
        this.addExistingButton.setVisible(hasEditPrivilege && (siteType.equals((Object)UISiteType.DISTRIBUTION) || siteType.equals((Object)UISiteType.MEDIAPATH_DISTRIBUTION)));
        this.dissociateFromParentButton.setVisible(hasEditPrivilege && siteType.equals((Object)UISiteType.TRACKING) && site.isShared());
    }

    private void showLogicalSite(UISite site) {
        this.showCommonSiteInfo(site);
        this.showPartnerInfo(site);
    }

    public void showCreateLogicalSite() {
        this.site = new UISite();
        this.site.setType(UISiteType.LOGICAL);
        this.showLogicalSite(this.site);
        this.showCreateButtons();
    }

    private void showViewEditLogicalSite(UISite site) {
        this.showLogicalSite(site);
        this.showViewEditButtons(site);
    }

    private void showDistributionSite(UISite site) {
        UISite uiSite;
        this.showCommonSiteInfo(site);
        this.fileLookupKeysValueWidget.clear();
        if (site.getAllFileLookupKeys() != null) {
            for (String fileLookupKey : site.getAllFileLookupKeys()) {
                this.fileLookupKeysValueWidget.addItem(fileLookupKey, fileLookupKey);
            }
        }
        if (site.getFileLookupKeys() != null) {
            for (String key : site.getFileLookupKeys()) {
                this.fileLookupKeysValueWidget.setItemSelected(new CheckboxGroup.Item<String>(key, key), true);
            }
        }
        this.dependsOnValueWidget.clear();
        if (site.getAllDistributionSites() != null) {
            for (UISite distSite : site.getAllDistributionSites()) {
                if (distSite.getName().equals(site.getName())) continue;
                this.dependsOnValueWidget.addItem(distSite.getName(), distSite);
            }
        }
        if (site.getDependsOnSites() != null) {
            for (Integer distSiteId : site.getDependsOnSites()) {
                uiSite = this.getUISiteFromId(distSiteId);
                this.dependsOnValueWidget.setItemSelected(new CheckboxGroup.Item<UISite>(uiSite.getName(), uiSite), true);
            }
        }
        if (site.getNonSelectableSites() != null) {
            for (Integer disableSite : site.getNonSelectableSites()) {
                uiSite = this.getUISiteFromId(disableSite);
                this.dependsOnValueWidget.setEnabledItem(new CheckboxGroup.Item<UISite>(uiSite.getName(), uiSite), false);
            }
        }
        this.metadataFormatValueWidget.clear();
        for (String mf : site.getAllMetadataFormats()) {
            if (UISiteType.MEDIAPATH_DISTRIBUTION.equals((Object)site.getType())) {
                if (!METADATA_FORMAT_CABLELABSVOD1_1.equals(mf) && !METADATA_FORMAT_ALIAS_CABLELABSVOD1_1.equals(mf)) continue;
                this.metadataFormatValueWidget.addItem(mf, (Object)mf);
                continue;
            }
            this.metadataFormatValueWidget.addItem(mf, (Object)mf);
        }
        this.metadataFormatValueWidget.setSelectedItem((Object)site.getMetadataFormat());
        this.distOptionListBox.setEnabled(true);
        this.distOptionListBox.setSelectedItem((Object)site.getDistributionOption());
        if (this.isSchedulerLicensed && UIDistributionOption.TIMED.equals((Object)site.getDistributionOption())) {
            boolean isScheduleEnabled;
            UIJob timerJob = site.getTimerJob();
            if (timerJob != null) {
                UIDistributionOption selectedDistributionOption;
                this.schedulingWidget.setScheduleInfo(timerJob.getScheduleInfo());
                if (!this.security.isUserInRole("Scheduler_Delete") && UIDistributionOption.TIMED.equals((Object)(selectedDistributionOption = (UIDistributionOption)((Object)this.distOptionListBox.getSelectedItem())))) {
                    this.distOptionListBox.setEnabled(false);
                }
                isScheduleEnabled = this.security.isUserInRole("Scheduler_Modify");
            } else {
                isScheduleEnabled = this.security.isUserInRole("Scheduler_Create");
            }
            this.schedulingWidget.setEnabled(isScheduleEnabled);
            boolean isScheduleVisible = this.security.isUserInRole("Scheduler_Create") && timerJob == null || this.security.isUserInRole("Scheduler_View") && timerJob != null || this.security.isUserInRole("Scheduler_Modify") && timerJob != null || this.security.isUserInRole("Scheduler_Delete") && timerJob != null;
            this.schedulingWidget.setVisible(isScheduleVisible);
            this.dependsOnValueWidget.setVisible(false);
        } else {
            this.schedulingWidget.setScheduleInfo(null);
            this.schedulingWidget.setEnabled(false);
            this.schedulingWidget.setVisible(false);
        }
        if (UIDistributionOption.DEPENDSON.equals((Object)site.getDistributionOption())) {
            this.dependsOnValueWidget.setVisible(true);
        } else {
            this.dependsOnValueWidget.setVisible(false);
        }
        this.distConfPanel.setData(site.getAllTemplatesInfo(), site.getDistTemplateName(), site.getAssociatedGroupName(), site.getDistConfParams(), site.getAssociatedResourceId());
        this.exportConfPanel.setData(site.getAllExportPluginsInfo(), site.getExportPluginName(), site.getExportConfParams());
        this.alertDelayPeriodTextWidget.setText(site.getAlertDelayPeriod() == null ? "" : Integer.toString(site.getAlertDelayPeriod()));
        this.retryConfPanel.setData(site.getActionOnFailure(), site.getRetryAttempt(), site.getRetryWaitTime());
        this.showStatusPlugin(site.getId(), UIStatusPluginType.DISTRIBUTION_STATUS, this.distStatusPluginPanel);
        this.showStatusPlugin(site.getId(), UIStatusPluginType.DEPLOYMENT_STATUS, this.deplStatusPluginPanel);
        this.showPartnerInfo(site);
        this.showCisInfo(site);
    }

    private UISite getUISiteFromId(Integer siteId) {
        if (this.site.getAllDistributionSites() != null) {
            for (UISite distSite : this.site.getAllDistributionSites()) {
                if (!siteId.equals(distSite.getId())) continue;
                return distSite;
            }
        }
        return null;
    }

    public void showCreateDistributionSite(final Integer parentSiteId) {
        this.site = new UISite();
        this.site.setType(UISiteType.DISTRIBUTION);
        this.busyIndicator.center();
        this.service.getNew((AsyncCallback<UISite>)new NeptuneAsyncCallback<UISite>(){

            public void onNeptuneFailure(Throwable caught) {
                BasicTab.this.showErrorMessage(String.valueOf(BasicTab.this.constants.loadingAllListsFailed()) + BasicTab.this.getFailureMessageSuffix(caught));
                BasicTab.this.busyIndicator.hide();
            }

            public void onNeptuneSuccess(UISite newSite) {
                newSite.setType(UISiteType.DISTRIBUTION);
                newSite.setParentId(parentSiteId);
                BasicTab.this.site = newSite;
                BasicTab.this.schedulingWidget.setScheduleInfo(null);
                BasicTab.this.schedulingWidget.setVisible(false);
                BasicTab.this.showDistributionSite(BasicTab.this.site);
                BasicTab.this.showCreateButtons();
                BasicTab.this.busyIndicator.hide();
            }
        });
    }

    public void showCreateMediaPathDistributionSite(final Integer parentSiteId) {
        this.site = new UISite();
        this.site.setType(UISiteType.MEDIAPATH_DISTRIBUTION);
        this.busyIndicator.center();
        this.service.getNew((AsyncCallback<UISite>)new NeptuneAsyncCallback<UISite>(){

            public void onNeptuneFailure(Throwable caught) {
                BasicTab.this.showErrorMessage(String.valueOf(BasicTab.this.constants.loadingAllListsFailed()) + BasicTab.this.getFailureMessageSuffix(caught));
                BasicTab.this.busyIndicator.hide();
            }

            public void onNeptuneSuccess(UISite newSite) {
                newSite.setType(UISiteType.MEDIAPATH_DISTRIBUTION);
                newSite.setParentId(parentSiteId);
                BasicTab.this.site = newSite;
                BasicTab.this.schedulingWidget.setScheduleInfo(null);
                BasicTab.this.schedulingWidget.setVisible(false);
                BasicTab.this.showDistributionSite(BasicTab.this.site);
                BasicTab.this.showCreateButtons();
                BasicTab.this.busyIndicator.hide();
            }
        });
    }

    public MessageArea getMessageArea() {
        return this.messageArea;
    }

    @Override
    public void setMessageArea(MessageArea messageArea) {
        this.messageArea = messageArea;
        this.partnerInfoPanel.setMessageArea(messageArea);
    }

    private void showViewEditDistributionSite(UISite site) {
        this.showDistributionSite(site);
        this.showViewEditButtons(site);
    }

    private void showTrackingSite(UISite site) {
        this.showCommonSiteInfo(site);
        this.alertDelayPeriodTextWidget.setText(site.getAlertDelayPeriod() == null ? "" : Integer.toString(site.getAlertDelayPeriod()));
        this.showStatusPlugin(site.getId(), UIStatusPluginType.DEPLOYMENT_STATUS, this.deplStatusPluginPanel);
    }

    public void showCreateTrackingSite(int parentSiteId) {
        this.site = new UISite();
        this.site.setType(UISiteType.TRACKING);
        this.site.setParentId(parentSiteId);
        this.showTrackingSite(this.site);
        this.showCreateButtons();
    }

    private void showViewEditTrackingSite(UISite site) {
        this.showTrackingSite(site);
        this.showViewEditButtons(site);
    }

    @Override
    public boolean setSite(UISite site, Map<String, String> params) {
        this.internalSetSite(site);
        if (site == null) {
            this.showNoSiteSelectedLabel();
        }
        return true;
    }

    private void internalSetSite(UISite site) {
        this.site = site;
        if (site == null) {
            return;
        }
        switch (site.getType()) {
            case LOGICAL: {
                this.showViewEditLogicalSite(site);
                break;
            }
            case DISTRIBUTION: 
            case MEDIAPATH_DISTRIBUTION: {
                this.showViewEditDistributionSite(site);
                break;
            }
            case TRACKING: {
                this.showViewEditTrackingSite(site);
            }
        }
    }

    public void showStatusPlugin(final Integer siteId, UIStatusPluginType uiStatusPluginType, final StatusPluginPanel statusPluginPanel) {
        statusPluginPanel.reset();
        this.service.getStatusPlugins(uiStatusPluginType, (AsyncCallback<List<UIStatusPlugin>>)new NeptuneAsyncCallback<List<UIStatusPlugin>>(){

            public void onNeptuneFailure(Throwable caught) {
                BasicTab.this.busyIndicator.hide();
                BasicTab.this.showErrorMessage(String.valueOf(BasicTab.this.messages.loadStatusPluginFailed(siteId)) + BasicTab.this.getFailureMessageSuffix(caught));
            }

            public void onNeptuneSuccess(List<UIStatusPlugin> uiStatusPlugins) {
                statusPluginPanel.setAvailablePlugins(uiStatusPlugins);
            }
        });
        if (siteId != null) {
            this.service.getAssociatedPluginForSite(siteId, uiStatusPluginType, (AsyncCallback<UIStatusPlugin>)new NeptuneAsyncCallback<UIStatusPlugin>(){

                public void onNeptuneFailure(Throwable caught) {
                    BasicTab.this.busyIndicator.hide();
                    BasicTab.this.showErrorMessage(String.valueOf(BasicTab.this.messages.loadStatusPluginFailed(siteId)) + BasicTab.this.getFailureMessageSuffix(caught));
                }

                public void onNeptuneSuccess(UIStatusPlugin uiStatusPlugin) {
                    statusPluginPanel.setAssociatedPlugin(uiStatusPlugin);
                    BasicTab.this.busyIndicator.hide();
                }
            });
        } else {
            this.service.getBlankUiStatusPlugin(uiStatusPluginType, (AsyncCallback<UIStatusPlugin>)new NeptuneAsyncCallback<UIStatusPlugin>(){

                public void onNeptuneFailure(Throwable caught) {
                    BasicTab.this.busyIndicator.hide();
                    BasicTab.this.showErrorMessage(String.valueOf(BasicTab.this.messages.loadBlankStatusPluginFailed()) + BasicTab.this.getFailureMessageSuffix(caught));
                }

                public void onNeptuneSuccess(UIStatusPlugin uiStatusPlugin) {
                    statusPluginPanel.setAssociatedPlugin(uiStatusPlugin);
                    BasicTab.this.busyIndicator.hide();
                }
            });
        }
    }

    private UISite getSiteFromForm() {
        UISite site = new UISite();
        site.setId(this.site.getId());
        site.setParentId(this.site.getParentId());
        site.setName(this.nameValueWidget.getText().trim());
        site.setType((UISiteType)((Object)this.siteTypeValueWidget.getSelectedItem()));
        site.setExternalId(this.externalIdValueWidget.getText());
        site.setDescription(this.descriptionValueWidget.getText());
        if (site.getType() == UISiteType.DISTRIBUTION || site.getType() == UISiteType.MEDIAPATH_DISTRIBUTION) {
            ArrayList<String> selectedFileLookupKeys = new ArrayList<String>();
            for (CheckboxGroup.Item<String> selectedItem : this.fileLookupKeysValueWidget.getSelectedItems()) {
                selectedFileLookupKeys.add(selectedItem.getValue());
            }
            site.setFileLookupKeys(selectedFileLookupKeys);
            site.setMetadataFormat((String)this.metadataFormatValueWidget.getSelectedItem());
            site.setDistributionOption((UIDistributionOption)((Object)this.distOptionListBox.getSelectedItem()));
            if (UIDistributionOption.TIMED.equals(this.distOptionListBox.getSelectedItem())) {
                UIJob timerJob = this.site.getTimerJob();
                if (timerJob == null) {
                    timerJob = new UIJob();
                }
                ScheduleInfo scheduleInfo = this.schedulingWidget.getScheduleInfo();
                timerJob.setScheduleInfo(scheduleInfo);
                site.setTimerJob(timerJob);
            }
            if (UIDistributionOption.DEPENDSON.equals(this.distOptionListBox.getSelectedItem())) {
                ArrayList<Integer> selectedDependsOnSites = new ArrayList<Integer>();
                for (CheckboxGroup.Item<UISite> selectedItem : this.dependsOnValueWidget.getSelectedItems()) {
                    selectedDependsOnSites.add(selectedItem.getValue().getId());
                }
                site.setDependsOnSites(selectedDependsOnSites);
            } else {
                site.setDependsOnSites(new ArrayList<Integer>());
            }
            site.setDistConfParams(this.distConfPanel.getParamValues());
            site.setAssociatedResourceId(this.distConfPanel.getAssociatedResource());
            site.setDistTemplateName(this.distConfPanel.getSelectedTemplateName());
            site.setAssociatedGroupName(this.distConfPanel.getAssociatedGroupName());
            site.setExportPluginName(this.exportConfPanel.getSelectedPluginName());
            site.setExportConfParams(this.exportConfPanel.getParams());
            site.setActionOnFailure(this.retryConfPanel.getActionOnFailure());
            site.setRetryAttempt(this.isBlank(this.retryConfPanel.getRetryAttempts()) ? null : Integer.valueOf(Integer.parseInt(this.retryConfPanel.getRetryAttempts())));
            site.setRetryWaitTime(this.isBlank(this.retryConfPanel.getRetryWaitTime()) ? null : Integer.valueOf(Integer.parseInt(this.retryConfPanel.getRetryWaitTime())));
        }
        if (site.getType() == UISiteType.DISTRIBUTION || site.getType() == UISiteType.MEDIAPATH_DISTRIBUTION || site.getType() == UISiteType.TRACKING) {
            Integer delayPeriodInt = null;
            if (!this.isBlank(this.alertDelayPeriodTextWidget.getText())) {
                try {
                    delayPeriodInt = Integer.parseInt(this.alertDelayPeriodTextWidget.getText());
                }
                catch (Exception exception) {}
            }
            site.setAlertDelayPeriod(delayPeriodInt);
        }
        site.setDistUiStatusPlugin(this.distStatusPluginPanel.getAssociatedPlugin());
        site.setDeplUiStatusPlugin(this.deplStatusPluginPanel.getAssociatedPlugin());
        if (site.getType() != UISiteType.TRACKING) {
            UISitePartner uiSitePartner = this.partnerInfoPanel.getPartnerFromForm();
            site.setSitePartner(uiSitePartner);
            UISiteCIS uiSiteCis = this.cisPanel.getCisFromForm();
            site.setCisMode(uiSiteCis.getCisMode());
        }
        return site;
    }

    private List<String> validateBasicInfo() {
        int maxLengthDescription;
        int lengthDescription;
        ArrayList<String> validationErrors = new ArrayList<String>();
        String siteName = this.nameValueWidget.getText();
        UISiteType siteType = (UISiteType)((Object)this.siteTypeValueWidget.getSelectedItem());
        String externalId = this.externalIdValueWidget.getText();
        String description = this.descriptionValueWidget.getText();
        String metadataFormat = (String)this.metadataFormatValueWidget.getSelectedItem();
        UIDistributionOption uiDistributionOption = (UIDistributionOption)((Object)this.distOptionListBox.getSelectedItem());
        String distributionConfiguration = this.distConfPanel.getSelectedTemplateName();
        String strAlertDelayPeriod = this.alertDelayPeriodTextWidget.getText();
        UIStatusPlugin distributionStatusPlugin = this.distStatusPluginPanel.getAssociatedPlugin();
        if (this.isBlank(siteName) && this.siteNameValidationErrors.isEmpty()) {
            this.siteNameValidationErrors.add(this.constants.nameIsRequired());
        }
        validationErrors.addAll(this.siteNameValidationErrors);
        if (this.isBlank(externalId) && this.externalSiteIdValidationErrors.isEmpty()) {
            this.externalSiteIdValidationErrors.add(this.constants.externalIdIsRequired());
        }
        validationErrors.addAll(this.externalSiteIdValidationErrors);
        if (!this.isBlank(description) && (lengthDescription = description.length()) > (maxLengthDescription = this.constants.maxLengthSiteDescription())) {
            validationErrors.add(this.messages.siteDescriptionCannotBeLonger(maxLengthDescription));
        }
        if (UISiteType.DISTRIBUTION.equals((Object)siteType) || UISiteType.MEDIAPATH_DISTRIBUTION.equals((Object)siteType)) {
            List<CheckboxGroup.Item<String>> items = this.fileLookupKeysValueWidget.getSelectedItems();
            if (items == null || items.isEmpty()) {
                validationErrors.add(this.constants.fileLookupKeysIsRequired());
            }
            if (this.isBlank(metadataFormat)) {
                validationErrors.add(this.constants.metadataFormatIsRequired());
            }
            if (uiDistributionOption == null) {
                validationErrors.add(this.constants.distributionOptionIsRequired());
            }
            if (this.schedulingWidget.isVisible() && this.schedulingWidget.isEnabled()) {
                List schedulingWidgetValidationErrors = this.schedulingWidget.validate();
                validationErrors.addAll(schedulingWidgetValidationErrors);
            }
            if (this.isBlank(distributionConfiguration)) {
                validationErrors.add(this.constants.distributionConfigurationIsRequired());
            } else {
                List<String> distConfValidationErrors = this.distConfPanel.validate();
                if (distConfValidationErrors != null && !distConfValidationErrors.isEmpty()) {
                    validationErrors.addAll(distConfValidationErrors);
                }
            }
            if (this.isDistStatusPluginRequired && this.isBlank(distributionStatusPlugin)) {
                validationErrors.add(this.constants.distStatusPluginIsRequired());
            }
            if (this.retryConfPanel.getActionOnFailure() != null) {
                String retryAttemptValidationError = this.validateIntegerRange(this.retryConfPanel.getRetryAttemptLabel(), this.retryConfPanel.getRetryAttempts(), this.constants.minValueSiteAlertDelayPeriod(), this.constants.maxValueSiteRetryAttempt());
                String retryWaitTimeValidationError = this.validateIntegerRange(this.retryConfPanel.getRetryWaitTimeLabel(), this.retryConfPanel.getRetryWaitTime(), this.constants.minValueSiteAlertDelayPeriod(), this.constants.maxValueSiteRetryAttempt());
                if (retryAttemptValidationError != null) {
                    validationErrors.add(retryAttemptValidationError);
                }
                if (retryWaitTimeValidationError != null) {
                    validationErrors.add(retryWaitTimeValidationError);
                }
            }
        }
        if (UISiteType.DISTRIBUTION.equals((Object)siteType) || UISiteType.MEDIAPATH_DISTRIBUTION.equals((Object)siteType) || UISiteType.TRACKING.equals((Object)siteType)) {
            List<CheckboxGroup.Item<UISite>> items;
            String alertDelayValidationError = this.validateIntegerRange(this.alertDelayPeriodLabel.getText(), strAlertDelayPeriod, this.constants.minValueSiteAlertDelayPeriod(), this.constants.maxValueSiteAlertDelayPeriod());
            if (alertDelayValidationError != null) {
                validationErrors.add(alertDelayValidationError);
            }
            if (this.dependsOnValueWidget.isVisible() && ((items = this.dependsOnValueWidget.getSelectedItems()) == null || items.isEmpty())) {
                validationErrors.add(this.constants.dependsOnIsRequired());
            }
        }
        return validationErrors;
    }

    private String validateIntegerRange(String label, String strValue, Integer minValue, Integer maxValue) {
        if (this.isBlank(strValue)) {
            return this.messages.parameterIsRequired(label);
        }
        try {
            int value = Integer.parseInt(strValue);
            if (value < minValue || value > maxValue) {
                return this.messages.parameterRequiredRange(label, minValue, maxValue);
            }
            return null;
        }
        catch (Exception exception) {
            return this.messages.parameterRequiredRange(label, minValue, maxValue);
        }
    }

    private List<String> validateForActivation() {
        String alertDelayValidationError;
        ArrayList<String> validationErrors = new ArrayList<String>();
        UISiteType siteType = (UISiteType)((Object)this.siteTypeValueWidget.getSelectedItem());
        String externalId = this.externalIdValueWidget.getText();
        String metadataFormat = (String)this.metadataFormatValueWidget.getSelectedItem();
        String distTemplateName = this.distConfPanel.getSelectedTemplateName();
        String strAlertDelayPeriod = this.alertDelayPeriodTextWidget.getText();
        UIStatusPlugin distStatusPlugin = this.distStatusPluginPanel.getAssociatedPlugin();
        if (this.isBlank(externalId) && this.externalSiteIdValidationErrors.isEmpty()) {
            this.externalSiteIdValidationErrors.add(this.constants.externalIdIsRequired());
        }
        validationErrors.addAll(this.externalSiteIdValidationErrors);
        if (UISiteType.DISTRIBUTION.equals((Object)siteType) || UISiteType.MEDIAPATH_DISTRIBUTION.equals((Object)siteType)) {
            List<CheckboxGroup.Item<String>> items = this.fileLookupKeysValueWidget.getSelectedItems();
            if (items == null || items.isEmpty()) {
                validationErrors.add(this.constants.fileLookupKeysIsRequired());
            }
            if (this.isBlank(metadataFormat)) {
                validationErrors.add(this.constants.metadataFormatIsRequired());
            }
            if (this.isBlank(distTemplateName)) {
                validationErrors.add(this.constants.distributionConfigurationIsRequired());
            }
            if (this.isDistStatusPluginRequired && this.isBlank(distStatusPlugin)) {
                validationErrors.add(this.constants.distStatusPluginIsRequired());
            }
        }
        if ((UISiteType.DISTRIBUTION.equals((Object)siteType) || UISiteType.MEDIAPATH_DISTRIBUTION.equals((Object)siteType) || UISiteType.TRACKING.equals((Object)siteType)) && (alertDelayValidationError = this.validateIntegerRange(this.alertDelayPeriodLabel.getText(), strAlertDelayPeriod, this.constants.minValueSiteAlertDelayPeriod(), this.constants.maxValueSiteAlertDelayPeriod())) != null) {
            validationErrors.add(alertDelayValidationError);
        }
        return validationErrors;
    }

    private void validateSiteName(String siteName) {
        this.siteNameValidationErrors = new ArrayList<String>();
        if (this.isBlank(siteName)) {
            this.siteNameValidationErrors.add(this.constants.nameIsRequired());
        } else {
            int maxLengthSiteName;
            int lengthSiteName = (siteName = siteName.trim()).length();
            if (lengthSiteName > (maxLengthSiteName = this.constants.maxLengthSiteName())) {
                this.siteNameValidationErrors.add(this.messages.siteNameCannotBeLonger(maxLengthSiteName));
            } else if (this.site.getId() == null || !siteName.equals(this.site.getName())) {
                this.service.isSiteNameAlreadyUsed(siteName, (AsyncCallback<Boolean>)new NeptuneAsyncCallback<Boolean>(){

                    public void onNeptuneFailure(Throwable caught) {
                        BasicTab.this.showErrorMessage(String.valueOf(BasicTab.this.constants.failedCheckingSiteNameUniqueness()) + BasicTab.this.getFailureMessageSuffix(caught));
                    }

                    public void onNeptuneSuccess(Boolean isSiteNameAlreadyUsed) {
                        BasicTab.this.busyIndicator.hide();
                        if (isSiteNameAlreadyUsed.booleanValue()) {
                            BasicTab.this.siteNameValidationErrors.add(BasicTab.this.constants.nameRequiredUnique());
                        }
                        if (!BasicTab.this.siteNameValidationErrors.isEmpty()) {
                            BasicTab.this.setValidationErrors("Site Name Validation Failed: ", BasicTab.this.siteNameValidationErrors, null);
                        } else {
                            BasicTab.this.setErrorMessage("");
                        }
                    }
                });
            }
        }
        if (!this.siteNameValidationErrors.isEmpty()) {
            this.setValidationErrors("Site Name Validation Failed: ", this.siteNameValidationErrors, null);
        } else {
            this.setErrorMessage("");
        }
    }

    private void validateExternalSiteId(final String externalSiteId) {
        this.externalSiteIdValidationErrors = new ArrayList<String>();
        if (this.isBlank(externalSiteId)) {
            this.externalSiteIdValidationErrors.add(this.constants.externalIdIsRequired());
        } else {
            int maxLengthExternalSiteId;
            int lengthExternalSiteId = externalSiteId.length();
            if (lengthExternalSiteId > (maxLengthExternalSiteId = this.constants.maxLengthSiteExternalId())) {
                this.externalSiteIdValidationErrors.add(this.messages.siteExternalIdCannotBeLonger(maxLengthExternalSiteId));
            } else if (this.site.getId() == null || !externalSiteId.equals(this.site.getExternalId())) {
                this.service.isExternalSiteIdAlreadyUsed(externalSiteId, this.site.getType(), (AsyncCallback<Boolean>)new NeptuneAsyncCallback<Boolean>(){

                    public void onNeptuneFailure(Throwable caught) {
                        BasicTab.this.showErrorMessage(String.valueOf(BasicTab.this.constants.failedCheckingSiteExternalIdUniqueness()) + BasicTab.this.getFailureMessageSuffix(caught));
                    }

                    public void onNeptuneSuccess(Boolean isExternalSiteIdAlreadyUsed) {
                        BasicTab.this.busyIndicator.hide();
                        if (isExternalSiteIdAlreadyUsed.booleanValue()) {
                            BasicTab.this.externalSiteIdValidationErrors.add(BasicTab.this.messages.externalIdAlreadyInUse(externalSiteId));
                        }
                        if (!BasicTab.this.externalSiteIdValidationErrors.isEmpty()) {
                            BasicTab.this.setValidationErrors("External Site Id Validation Failed: ", BasicTab.this.externalSiteIdValidationErrors, null);
                        } else {
                            BasicTab.this.setErrorMessage("");
                        }
                    }
                });
            }
        }
        if (!this.externalSiteIdValidationErrors.isEmpty()) {
            this.setValidationErrors("External Site Id Validation Failed: ", this.externalSiteIdValidationErrors, null);
        } else {
            this.setErrorMessage("");
        }
    }

    private boolean isBlank(String s) {
        return s == null || s.trim().isEmpty();
    }

    private boolean isBlank(UIStatusPlugin uiStatusPlugin) {
        boolean isBlank = false;
        if (uiStatusPlugin == null) {
            isBlank = true;
        } else {
            String pluginId = uiStatusPlugin.getId();
            if (pluginId == null || pluginId.trim().isEmpty()) {
                isBlank = true;
            }
        }
        return isBlank;
    }

    private void save() {
        final List<String> validationErrors = this.validateBasicInfo();
        UISiteType siteType = (UISiteType)((Object)this.siteTypeValueWidget.getSelectedItem());
        if (!UISiteType.TRACKING.equals((Object)siteType)) {
            this.partnerInfoPanel.validate(new AsyncCallback<List<String>>(){

                public void onFailure(Throwable caught) {
                    BasicTab.this.setErrorMessage("Unable to validate partner information. | Reason: " + caught != null ? caught.getLocalizedMessage() : null);
                }

                public void onSuccess(List<String> errors) {
                    validationErrors.addAll(errors);
                    BasicTab.this.cisPanel.validate(new AsyncCallback<List<String>>(){

                        public void onFailure(Throwable caught) {
                            BasicTab.this.setErrorMessage("Unable to validate cis information. | Reason: " + caught != null ? caught.getLocalizedMessage() : null);
                        }

                        public void onSuccess(List<String> errors) {
                            validationErrors.addAll(errors);
                            BasicTab.this.saveToServer(validationErrors);
                        }
                    });
                }
            });
        } else {
            this.saveToServer(validationErrors);
        }
    }

    private void saveToServer(List<String> validationErrors) {
        if (!validationErrors.isEmpty()) {
            this.setValidationErrors("Validation Failed: ", validationErrors, null);
        } else {
            final UISite site = this.getSiteFromForm();
            if (this.site != null && this.site.isActive() && this.site.getDistributionOption() != UIDistributionOption.IMMEDIATE && site.getDistributionOption() == UIDistributionOption.IMMEDIATE) {
                this.confirm(this.constants.confirmTitleDistribution(), new Command(){

                    public void execute() {
                        BasicTab.this.saveToServer(site);
                    }
                }, null);
            } else {
                this.saveToServer(site);
            }
        }
    }

    private void saveToServer(final UISite site) {
        this.busyIndicator.center();
        this.service.save(site, (AsyncCallback<UISite>)new NeptuneAsyncCallback<UISite>(){

            public void onNeptuneFailure(Throwable caught) {
                BasicTab.this.setInfoMessage(null);
                BasicTab.this.setErrorMessage(String.valueOf(BasicTab.this.constants.saveFailed()) + BasicTab.this.getFailureMessageSuffix(caught));
                BasicTab.this.busyIndicator.hide();
            }

            public void onNeptuneSuccess(UISite result) {
                BasicTab.this.internalSetSite(result);
                BasicTab.this.setInfoMessage(BasicTab.this.constants.saveSuccessful());
                BasicTab.this.setErrorMessage(null);
                if (site.getId() == null) {
                    BasicTab.this.crudNotifier.created(result, BasicTab.this);
                } else {
                    BasicTab.this.crudNotifier.updated(result, BasicTab.this);
                }
                BasicTab.this.busyIndicator.hide();
            }
        });
    }

    private void confirm(String questionText, Command yesCommand, Command noCommand) {
        ConfirmDialog confirmDialog = new ConfirmDialog(questionText, yesCommand, noCommand);
        confirmDialog.center();
        confirmDialog.show();
    }

    private void alert(String text, Command command) {
        this.alert(text, command, null);
    }

    private void alert(String text, final Command command, String detail) {
        final DialogBoxContainer dialogBox = new DialogBoxContainer(false, true);
        dialogBox.addStyleName(STYLE_DIALOG_BOX);
        dialogBox.setText(text);
        ButtonWidget okButton = new ButtonWidget(this.constants.buttonLabelOk());
        okButton.removeStyleName("gwt-Button");
        okButton.addStyleName("ebBtn");
        okButton.addStyleName("ebBtn_color_darkBlue");
        okButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                dialogBox.hide();
                if (command != null) {
                    command.execute();
                }
            }
        });
        VerticalContainer buttonPanel = new VerticalContainer();
        buttonPanel.addStyleName(STYLE_DIALOG_BOX_BUTTON_PANEL);
        buttonPanel.setCellHorizontalAlignment((Widget)okButton, HasHorizontalAlignment.ALIGN_CENTER);
        LabelWidget detailMessage = new LabelWidget(detail);
        detailMessage.addStyleName(STYLE_DIALOG_BOX_DETAIL_MESSAGE);
        buttonPanel.add((Widget)detailMessage);
        dialogBox.setWidget((Widget)buttonPanel);
        buttonPanel.add((Widget)okButton);
        dialogBox.center();
        dialogBox.show();
    }

    private void activateAfterConfirming() {
        if (this.site.hasChildren()) {
            this.confirm(this.constants.confirmRecursiveActivate(), new Command(){

                public void execute() {
                    BasicTab.this.activate();
                }
            }, null);
        } else {
            this.activate();
        }
    }

    private void activate() {
        this.internalSetSite(this.site);
        List<String> validationErrors = this.validateForActivation();
        if (!validationErrors.isEmpty()) {
            this.setValidationErrors("Validation Failed: ", validationErrors, "Fix the validation errors, save the site and try activating again.");
            return;
        }
        if ((this.site.getType() == UISiteType.DISTRIBUTION || this.site.getType() == UISiteType.MEDIAPATH_DISTRIBUTION) && this.site.getDistributionOption() == UIDistributionOption.IMMEDIATE) {
            this.alert(this.constants.activationTitleNotification(), new Command(){

                public void execute() {
                    BasicTab.this.performSiteActivation();
                }
            });
        } else {
            this.performSiteActivation();
        }
    }

    private void performSiteActivation() {
        this.busyIndicator.center();
        this.service.activate(this.site.getId(), (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                BasicTab.this.busyIndicator.hide();
                BasicTab.this.setInfoMessage(null);
                BasicTab.this.setErrorMessage(String.valueOf(BasicTab.this.constants.activateFailed()) + BasicTab.this.getFailureMessageSuffix(caught));
            }

            public void onNeptuneSuccess(Void result) {
                BasicTab.this.setErrorMessage(null);
                BasicTab.this.setInfoMessage(BasicTab.this.constants.activateSuccessful());
                BasicTab.this.site.setActive(true);
                BasicTab.this.siteActiveImage.setVisible(true);
                BasicTab.this.siteInactiveImage.setVisible(false);
                BasicTab.this.activateButton.setVisible(false);
                BasicTab.this.inactivateButton.setVisible(true);
                BasicTab.this.crudNotifier.updated(BasicTab.this.site, BasicTab.this);
                BasicTab.this.busyIndicator.hide();
                if (BasicTab.this.security.isUserInRole("Scheduler_View")) {
                    BasicTab.this.alert(BasicTab.this.constants.notifyJobsMayNeedEnabling(), new Command(){

                        public void execute() {
                            BasicTab.this.updateStatusForAllPluginsAfterConfirming();
                        }
                    });
                } else {
                    BasicTab.this.updateStatusForAllPluginsAfterConfirming();
                }
            }
        });
    }

    private void updateStatusForAllPluginsAfterConfirming() {
        this.confirm(this.constants.confirmUpdateStatus(), new Command(){

            public void execute() {
                BasicTab.this.updateStatusForAllPlugins();
            }
        }, null);
    }

    private void updateStatusForAllPlugins() {
        this.busyIndicator.center();
        this.service.updateStatusForAllPlugins(this.site.getId(), (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                BasicTab.this.busyIndicator.hide();
                BasicTab.this.setErrorMessage(String.valueOf(BasicTab.this.constants.updateStatusFailed()) + BasicTab.this.getFailureMessageSuffix(caught));
            }

            public void onNeptuneSuccess(Void result) {
                BasicTab.this.setInfoMessage(BasicTab.this.constants.updateStatusSuccessful());
                BasicTab.this.busyIndicator.hide();
            }
        });
    }

    private void inactivateAfterConfirming() {
        if (this.site.hasChildren()) {
            this.confirm(this.constants.confirmRecursiveInactivate(), new Command(){

                public void execute() {
                    BasicTab.this.inactivate();
                }
            }, null);
        } else {
            this.inactivate();
        }
    }

    private void inactivate() {
        this.internalSetSite(this.site);
        this.busyIndicator.center();
        this.service.getDependencyInfo(this.site.getId(), (AsyncCallback<Map<String, List<String>>>)new NeptuneAsyncCallback<Map<String, List<String>>>(){

            public void onNeptuneFailure(Throwable caught) {
                BasicTab.this.showErrorMessage(String.valueOf(BasicTab.this.constants.inactivateFailed()) + BasicTab.this.getFailureMessageSuffix(caught));
                BasicTab.this.busyIndicator.hide();
            }

            public void onNeptuneSuccess(Map<String, List<String>> siteDependencyInfo) {
                BasicTab.this.inactiveExecute(siteDependencyInfo);
            }
        });
    }

    private void inactiveExecute(Map<String, List<String>> siteDependencyInfo) {
        final List<String> dependentSitesName = siteDependencyInfo.get("dependentSites");
        final List<String> dependsOnSitesName = siteDependencyInfo.get("dependsOnSites");
        this.service.inactivate(this.site.getId(), (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                BasicTab.this.busyIndicator.hide();
                BasicTab.this.setInfoMessage(null);
                BasicTab.this.setErrorMessage(String.valueOf(BasicTab.this.constants.inactivateFailed()) + BasicTab.this.getFailureMessageSuffix(caught));
            }

            public void onNeptuneSuccess(Void result) {
                BasicTab.this.setErrorMessage(null);
                BasicTab.this.setInfoMessage(BasicTab.this.constants.inactivateSuccessful());
                BasicTab.this.site.setActive(false);
                BasicTab.this.siteActiveImage.setVisible(false);
                BasicTab.this.siteInactiveImage.setVisible(true);
                BasicTab.this.activateButton.setVisible(true);
                BasicTab.this.inactivateButton.setVisible(false);
                BasicTab.this.crudNotifier.updated(BasicTab.this.site, BasicTab.this);
                BasicTab.this.busyIndicator.hide();
                if (BasicTab.this.security.isUserInRole("Scheduler_View")) {
                    Command dependencyCheck = new Command(){

                        public void execute() {
                            if (!dependentSitesName.isEmpty()) {
                                String messageDetail = "";
                                if (!BasicTab.this.site.getDependsOnSites().isEmpty()) {
                                    messageDetail = BasicTab.this.messages.siteDependsOnFollowingDistributionSites(dependsOnSitesName.toString());
                                }
                                BasicTab.this.alert(BasicTab.this.messages.disableDependentSiteWarning(dependentSitesName.toString()), null, messageDetail);
                            }
                        }
                    };
                    BasicTab.this.alert(BasicTab.this.constants.notifyJobsMayNeedDisabling(), dependencyCheck);
                }
            }
        });
    }

    private void delete() {
        this.busyIndicator.center();
        this.service.delete(this.site.getId(), (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                BasicTab.this.busyIndicator.hide();
                BasicTab.this.setInfoMessage(null);
                BasicTab.this.setErrorMessage(String.valueOf(BasicTab.this.constants.deleteFailed()) + BasicTab.this.getFailureMessageSuffix(caught));
            }

            public void onNeptuneSuccess(Void result) {
                UISite deletedSite = BasicTab.this.site;
                BasicTab.this.internalSetSite(null);
                BasicTab.this.setErrorMessage(null);
                BasicTab.this.showInfoMessage(BasicTab.this.constants.deleteSuccessful());
                BasicTab.this.showNoSiteSelectedLabel();
                BasicTab.this.crudNotifier.deleted(deletedSite, BasicTab.this);
                BasicTab.this.busyIndicator.hide();
            }
        });
    }

    private void showExportDialog() {
        ExportStatusSelectionDialog dialogBox = new ExportStatusSelectionDialog(new ExportStatusSelectionDialog.IExportActionHandler(){

            @Override
            public void export(List<UIDistributionStatus> statuses) {
                if (statuses == null || statuses.isEmpty()) {
                    BasicTab.this.setInfoMessage(null);
                    BasicTab.this.setErrorMessage(BasicTab.this.constants.exportNoneSelected());
                } else {
                    BasicTab.this.export(statuses);
                }
            }
        });
        dialogBox.addStyleName(STYLE_DIALOG_BOX);
        dialogBox.center();
    }

    private void export(List<UIDistributionStatus> statuses) {
        this.busyIndicator.center();
        this.service.export(this.site.getId(), statuses, (AsyncCallback<String>)new NeptuneAsyncCallback<String>(){

            public void onNeptuneFailure(Throwable caught) {
                BasicTab.this.busyIndicator.hide();
                BasicTab.this.setInfoMessage(null);
                BasicTab.this.setErrorMessage(String.valueOf(BasicTab.this.constants.exportFailed()) + BasicTab.this.getFailureMessageSuffix(caught));
            }

            public void onNeptuneSuccess(String result) {
                BasicTab.this.setErrorMessage(null);
                BasicTab.this.setInfoMessage(null);
                BasicTab.this.busyIndicator.hide();
                Window.Location.replace((String)("ExportSiteTitles?filePath=" + URL.encode((String)result)));
            }
        });
    }

    private void createChildSite(final ClickEvent event) {
        UISiteType siteType = this.site.getType();
        Integer parentSiteId = this.site.getId();
        String siteName = this.site.getName();
        if (UISiteType.LOGICAL.equals((Object)siteType)) {
            UISiteTreeNode siteTreeNode = new UISiteTreeNode();
            siteTreeNode.setId(parentSiteId);
            siteTreeNode.setType(siteType);
            siteTreeNode.setName(siteName);
            final CreateSiteDialogBox createSiteDialogBox = new CreateSiteDialogBox(this.security, true, true, this.parentTabContainer, siteTreeNode);
            createSiteDialogBox.setPopupPositionAndShow(new PopupPanel.PositionCallback(){

                public void setPosition(int offsetWidth, int offsetHeight) {
                    Button source = (Button)event.getSource();
                    int left = source.getAbsoluteLeft() + source.getOffsetWidth();
                    int top = source.getAbsoluteTop() - offsetHeight;
                    createSiteDialogBox.setPopupPosition(left, top);
                }
            });
        } else if (UISiteType.DISTRIBUTION.equals((Object)siteType) || UISiteType.MEDIAPATH_DISTRIBUTION.equals((Object)siteType)) {
            this.parentTabContainer.showCreateTrackingSite(parentSiteId);
        }
    }

    private void addExistingSite() {
        Integer siteId = this.site.getId();
        this.parentTabContainer.showAddExistingTrackingSite(siteId);
    }

    private void dissociate() {
        Integer trackingSiteId = this.site.getId();
        Integer parentDistSiteId = this.site.getParentId();
        this.dissociateAfterConfirming(trackingSiteId, parentDistSiteId);
    }

    private void dissociateAfterConfirming(final int trackingSiteId, final int parentDistSiteId) {
        this.confirm(this.constants.confirmDissociate(), new Command(){

            public void execute() {
                BasicTab.this.dissociateFromParent(trackingSiteId, parentDistSiteId);
            }
        }, null);
    }

    private void dissociateFromParent(int trackingSiteId, final int parentDistSiteId) {
        this.busyIndicator.center();
        this.service.dissociateTrackingSite(trackingSiteId, parentDistSiteId, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                BasicTab.this.busyIndicator.hide();
                Window.alert((String)(String.valueOf(BasicTab.this.constants.dissociatingTrackingSiteFailed()) + " | " + BasicTab.this.constants.reason() + ": " + (caught != null ? caught.getLocalizedMessage() : "")));
            }

            public void onNeptuneSuccess(Void result) {
                BasicTab.this.treeWidget.reload(parentDistSiteId, null);
                BasicTab.this.parentTabContainer.showSite(parentDistSiteId, null);
                BasicTab.this.busyIndicator.hide();
            }
        });
    }

    protected SchedulingWidget getSchedulingWidget() {
        SchedulingWidgetConfig widgetConfig = new SchedulingWidgetConfig();
        widgetConfig.setShowOnDateRow(false);
        widgetConfig.setShowEveryNDaysRow(true);
        widgetConfig.setShowOnDayEveryNWeeksRow(true);
        widgetConfig.setShowNDaysFromMetadataRow(true);
        widgetConfig.setShowEveryNHourMinsRow(true);
        SchedulingWidget schedulingWidget = SchedulingWidgetFactory.create((SchedulingWidgetConfig)widgetConfig);
        this.setMetadataTree(schedulingWidget);
        return schedulingWidget;
    }

    protected void setMetadataTree(final SchedulingWidget schedulingWidget) {
        if (schedulingWidget != null) {
            this.busyIndicator.center();
            this.service.getSiteTimerMetadataTree((AsyncCallback<UiMetadataTree>)new NeptuneAsyncCallback<UiMetadataTree>(){

                public void onNeptuneFailure(Throwable caught) {
                    BasicTab.this.busyIndicator.hide();
                    BasicTab.this.showErrorMessage(String.valueOf(BasicTab.this.messages.loadMetadataTreeFailed()) + BasicTab.this.getFailureMessageSuffix(caught));
                }

                public void onNeptuneSuccess(UiMetadataTree result) {
                    schedulingWidget.setMetadataTree(result);
                    BasicTab.this.busyIndicator.hide();
                }
            });
        }
    }

    protected void updateScrollPanelSize() {
        Scheduler.get().scheduleDeferred(this.resizeCommand);
    }

    protected void resizeRightScrollPanel() {
        int width = Window.getClientWidth() - 335;
        int height = Window.getClientHeight() - 280 - this.messageArea.getOffsetHeight();
        this.rightScrollPanel.setPixelSize(width, height - this.buttonsPanel.getOffsetHeight());
        this.dockPanel.setPixelSize(width, height);
        this.messageArea.setWidth(String.valueOf(width) + "px");
    }

    protected void onLoad() {
        super.onLoad();
        this.windowRegistration = Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                BasicTab.this.updateScrollPanelSize();
            }
        });
    }

    protected void onUnload() {
        this.windowRegistration.removeHandler();
        this.windowRegistration = null;
        if (this.busyIndicator != null) {
            this.busyIndicator.hide();
        }
        super.onUnload();
    }
}

