/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client;

import com.ericsson.cms.sites.ui.client.BasicTab;
import com.ericsson.cms.sites.ui.client.CISInfoTab;
import com.ericsson.cms.sites.ui.client.IUISiteCISService;
import com.ericsson.cms.sites.ui.client.IUISiteCISServiceAsync;
import com.ericsson.cms.sites.ui.client.entities.UICISNotification;
import com.ericsson.cms.sites.ui.client.entities.UICISNotificationType;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.ericsson.cms.sites.ui.client.i18n.SitesMessages;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.i18n.NeptuneWidgetConstants;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CISCreatePanel
extends SimpleContainer {
    private HorizontalContainer buttonPanel;
    private VerticalContainer mainPanel;
    private ButtonWidget saveButton;
    private ButtonWidget cancelButton;
    private LabelWidget headerLabel;
    private TextBoxWidget identityValueWidget;
    private TextBoxWidget systemValueWidget;
    private TextBoxWidget calloutUrlValueWidget;
    private BusyIndicator busyIndicator = new BusyIndicator();
    private FormContainer basicFormContainer;
    private CISInfoTab rootPanel;
    private IUISiteCISServiceAsync service = (IUISiteCISServiceAsync)GWT.create(IUISiteCISService.class);
    private SitesConstants constants = (SitesConstants)GWT.create(SitesConstants.class);
    private SitesMessages messages = (SitesMessages)GWT.create(SitesMessages.class);
    protected NeptuneWidgetConstants neptuneConstants = (NeptuneWidgetConstants)GWT.create(NeptuneWidgetConstants.class);

    public CISCreatePanel(CISInfoTab rootPanel) {
        this.rootPanel = rootPanel;
        this.buildUI();
    }

    private void buildUI() {
        this.mainPanel = new VerticalContainer();
        this.buildHeaderPanel();
        this.buildFormUI();
        this.buildButtonPanel();
        this.setWidget((Widget)this.mainPanel);
    }

    private void buildHeaderPanel() {
        this.headerLabel = new LabelWidget(this.constants.cisCreateHeader());
        this.headerLabel.setStyleName("sites-cisTab-create-header-label");
        HorizontalContainer headerContainer = new HorizontalContainer();
        headerContainer.add((Widget)this.headerLabel);
        headerContainer.setWidth("100%");
        this.mainPanel.add((Widget)headerContainer);
    }

    private void buildFormUI() {
        this.identityValueWidget = new TextBoxWidget();
        this.systemValueWidget = new TextBoxWidget();
        this.calloutUrlValueWidget = new TextBoxWidget();
        this.calloutUrlValueWidget.addStyleName("sites-cisTab-url-txtbox");
        this.basicFormContainer = new FormContainer(HasHorizontalAlignment.ALIGN_LEFT);
        this.basicFormContainer.setWidth("100%");
        this.basicFormContainer.addRow(this.constants.cmsIdentity(), (Widget)this.identityValueWidget, true);
        this.basicFormContainer.addRow(this.constants.cmsSystem(), (Widget)this.systemValueWidget, true);
        this.basicFormContainer.addRow(this.constants.callOutURL(), (Widget)this.calloutUrlValueWidget, true);
        this.mainPanel.add((Widget)this.basicFormContainer);
    }

    private void buildButtonPanel() {
        this.buttonPanel = new HorizontalContainer();
        this.buttonPanel.addStyleName("sites-cisTab-create-button-container");
        this.saveButton = new ButtonWidget(this.constants.saveButtonText());
        this.saveButton.removeStyleName("gwt-Button");
        this.saveButton.addStyleName("ebBtn");
        this.saveButton.addStyleName("ebBtn_color_green");
        this.saveButton.addStyleName("save_button_icon");
        this.saveButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CISCreatePanel.this.handleSaveEvent();
            }
        });
        this.cancelButton = new ButtonWidget(this.constants.cancelButtonText());
        this.cancelButton.removeStyleName("gwt-Button");
        this.cancelButton.addStyleName("ebBtn");
        this.cancelButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CISCreatePanel.this.rootPanel.refresh();
            }
        });
        this.buttonPanel.add((Widget)this.saveButton);
        this.buttonPanel.add((Widget)this.cancelButton);
        this.mainPanel.add((Widget)this.buttonPanel);
    }

    private void handleSaveEvent() {
        List<String> validationErrors = this.validationCISCreate();
        if (!validationErrors.isEmpty()) {
            this.rootPanel.setErrorHTML(BasicTab.buildValidationErrorsHTML("Validation Failed: ", validationErrors, null));
        } else {
            UICISNotification notification = new UICISNotification(null, this.identityValueWidget.getValue(), this.systemValueWidget.getValue(), null, Arrays.asList(this.calloutUrlValueWidget.getValue()), null, UICISNotificationType.CIS_NOTIFICATION);
            this.busyIndicator.center();
            this.service.createNotificationItem(this.rootPanel.getUISite().getId(), notification, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                public void onNeptuneFailure(Throwable caught) {
                    CISCreatePanel.this.busyIndicator.hide();
                    CISCreatePanel.this.rootPanel.refresh();
                    CISCreatePanel.this.rootPanel.showError(CISCreatePanel.this.messages.errorCreateCISNotification(caught.getMessage()));
                }

                public void onNeptuneSuccess(Void result) {
                    CISCreatePanel.this.busyIndicator.hide();
                    CISCreatePanel.this.rootPanel.refresh();
                    CISCreatePanel.this.rootPanel.showInfo(CISCreatePanel.this.messages.successCreateCISNotification());
                }
            });
        }
    }

    private List<String> validationCISCreate() {
        ArrayList<String> validationErrors = new ArrayList<String>();
        String identityValue = this.identityValueWidget.getValue();
        String callOutUrlValue = this.calloutUrlValueWidget.getValue();
        String systemValue = this.systemValueWidget.getValue();
        if (this.isBlank(identityValue)) {
            validationErrors.add(this.messages.parameterIsRequired(this.constants.cmsIdentity()));
        }
        if (this.isBlank(callOutUrlValue)) {
            validationErrors.add(this.messages.parameterIsRequired(this.constants.callOutURL()));
        }
        if (this.isBlank(systemValue)) {
            validationErrors.add(this.messages.parameterIsRequired(this.constants.cmsSystem()));
        }
        if (this.rootPanel.getUISite().getCisMode() == null) {
            validationErrors.add(this.messages.cisModeIsNotSetForSite(this.rootPanel.getUISite().getName()));
        }
        return validationErrors;
    }

    private boolean isBlank(String s) {
        return s == null || s.trim().isEmpty();
    }
}

