/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client;

import com.ericsson.cms.sites.ui.client.IUISiteCISService;
import com.ericsson.cms.sites.ui.client.IUISiteCISServiceAsync;
import com.ericsson.cms.sites.ui.client.entities.UICISMode;
import com.ericsson.cms.sites.ui.client.entities.UISite;
import com.ericsson.cms.sites.ui.client.entities.UISiteCIS;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.MultiTaskBusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class CISInfoPanel
extends Composite {
    private VerticalContainer mainPanel;
    private FormContainer formContainer;
    private LabelWidget cisModeLabel;
    private ListBoxWidget<UICISMode> cisModeValueWidget = new ListBoxWidget();
    private MultiTaskBusyIndicator busyIndicator = new MultiTaskBusyIndicator();
    private IUISiteCISServiceAsync service = (IUISiteCISServiceAsync)GWT.create(IUISiteCISService.class);
    private SitesConstants constants = (SitesConstants)GWT.create(SitesConstants.class);
    private UISiteCIS cis;
    private NeptuneSecurity security = NeptuneApplication.getApplication().getSecurity();

    public CISInfoPanel() {
        this.buildUI();
        this.initWidget((Widget)this.mainPanel);
    }

    public void showSite(UISite site) {
        if (site != null && site.getId() != null) {
            this.busyIndicator.center();
            this.updateForm(site);
            this.formContainer.setVisible(true);
            this.busyIndicator.hide();
        }
    }

    public UISiteCIS getCisFromForm() {
        this.updateCISFromForm();
        return this.cis;
    }

    public void validate(final AsyncCallback<List<String>> callback) {
        final ArrayList errors = new ArrayList();
        this.updateCISFromForm();
        this.busyIndicator.center();
        this.service.validate(this.cis, new AsyncCallback<Set<String>>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
                CISInfoPanel.this.busyIndicator.hide();
            }

            public void onSuccess(Set<String> serverErrors) {
                if (serverErrors != null) {
                    for (String se : serverErrors) {
                        errors.add(CISInfoPanel.this.constants.getString(se));
                    }
                }
                callback.onSuccess((Object)errors);
                CISInfoPanel.this.busyIndicator.hide();
            }
        });
    }

    private void updateCISFromForm() {
        this.cis = new UISiteCIS();
        if (this.cisModeValueWidget.getSelectedItem() != null) {
            this.cis.setCisMode((UICISMode)((Object)this.cisModeValueWidget.getSelectedItem()));
        }
    }

    private void buildUI() {
        this.mainPanel = new VerticalContainer();
        this.cisModeLabel = new LabelWidget(this.constants.fieldLabelCisMode());
        this.cisModeValueWidget.addItem("", null);
        this.cisModeValueWidget.addItem(this.constants.fieldValueCisModeSTDADI30(), (Object)UICISMode.STDADI30);
        this.cisModeValueWidget.addItem(this.constants.fieldValueCisModeBLACKARROWADI30(), (Object)UICISMode.BLACKARROWADI30);
        this.formContainer = new FormContainer(HasHorizontalAlignment.ALIGN_LEFT);
        this.formContainer.addRow(this.cisModeLabel, this.cisModeValueWidget);
        this.mainPanel.add((Widget)this.formContainer);
    }

    private void updateForm(UISite site) {
        if (site != null) {
            this.cisModeValueWidget.setSelectedItem((Object)site.getCisMode());
        }
    }
}

