/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client;

import com.ericsson.cms.sites.ui.client.Anchors;
import com.ericsson.cms.sites.ui.client.CISCreatePanel;
import com.ericsson.cms.sites.ui.client.ConfirmDialog;
import com.ericsson.cms.sites.ui.client.ISiteTab;
import com.ericsson.cms.sites.ui.client.IUISiteCISService;
import com.ericsson.cms.sites.ui.client.IUISiteCISServiceAsync;
import com.ericsson.cms.sites.ui.client.SitesTabContainer;
import com.ericsson.cms.sites.ui.client.entities.UICISNotification;
import com.ericsson.cms.sites.ui.client.entities.UISite;
import com.ericsson.cms.sites.ui.client.entities.UISiteType;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.i18n.NeptuneWidgetConstants;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CISInfoTab
extends Composite
implements ISiteTab {
    public static final String NAME = "CIS";
    private static final int MAIN_PANEL_OFFSET_WIDTH = 300;
    private static final int MAIN_PANEL_OFFSET_HEIGHT = 300;
    private VerticalContainer mainPanel;
    private SimpleContainer tableContainer = new SimpleContainer();
    private SimpleContainer rootPanel = new SimpleContainer();
    private ScrollPanel scrollPanel;
    private HorizontalContainer buttonPanel;
    private ButtonWidget deleteButton;
    private ButtonWidget createButton;
    private List<CheckBoxWidget> rowCheckBoxes;
    private CheckBoxWidget allCB;
    private BusyIndicator busyIndicator = new BusyIndicator();
    private IUISiteCISServiceAsync service = (IUISiteCISServiceAsync)GWT.create(IUISiteCISService.class);
    private SitesConstants constants = (SitesConstants)GWT.create(SitesConstants.class);
    private MessageArea messageArea;
    private FlexTableContainer table = new FlexTableContainer();
    private UISite site;
    private HandlerRegistration windowRegistration = null;
    private List<UICISNotification> selectedIds;
    private static final String STYLE_SCROLL_CONTAINER = "sites-cisTab-scrollContainer";
    private static final String TABLE_STYLE = "sites-cisTab-table";
    private static final String HEADER_ROW_STYLE = "sites-cisTab-table-header";
    private static final String DATA_ROW_STYLE = "sites-cisTab-table-data";
    protected NeptuneWidgetConstants neptuneConstants = (NeptuneWidgetConstants)GWT.create(NeptuneWidgetConstants.class);
    private LabelWidget numRecordsLabel;
    private LabelWidget numRecordsLabelFront;
    private HorizontalContainer topPanel;
    private Integer totalRecordCount;
    private boolean isMessageShowed = false;

    public CISInfoTab() {
        this.initWidget((Widget)this.rootPanel);
        this.buildUI();
        this.setWidget((Widget)this.mainPanel);
    }

    @Override
    public void setMessageArea(MessageArea messageArea) {
        this.messageArea = messageArea;
    }

    protected void showInfo(String message) {
        this.messageArea.setInfoMessage(message);
        if (!this.isMessageShowed) {
            this.updateSizeForMessageArea();
        }
        this.isMessageShowed = true;
    }

    protected void showError(String message) {
        this.messageArea.setErrorMessage(message);
        if (!this.isMessageShowed) {
            this.updateSizeForMessageArea();
        }
        this.isMessageShowed = true;
    }

    protected void setErrorHTML(String message) {
        this.messageArea.setErrorHTML(message);
        if (!this.isMessageShowed) {
            this.updateSizeForMessageArea();
        }
        this.isMessageShowed = true;
    }

    public void clearMessages() {
        this.messageArea.reset();
        this.updateSizeForMessageArea();
        this.isMessageShowed = false;
    }

    public void setWidget(Widget widget) {
        this.rootPanel.setWidget(widget);
    }

    private void buildUI() {
        this.initTopPanel();
        this.mainPanel = new VerticalContainer();
        this.scrollPanel = new ScrollPanel();
        this.scrollPanel.addStyleName(STYLE_SCROLL_CONTAINER);
        this.scrollPanel.add((Widget)this.tableContainer);
        this.mainPanel.setSpacing(10);
        this.mainPanel.add((Widget)this.topPanel);
        this.mainPanel.add((Widget)this.scrollPanel);
        HorizontalContainer hc = new HorizontalContainer();
        this.mainPanel.add((Widget)hc);
        this.buttonPanel = new HorizontalContainer();
        this.buttonPanel.addStyleName("cms_button_container");
        this.mainPanel.add((Widget)this.buttonPanel);
        this.createButton = new ButtonWidget(this.constants.buttonLabelAdd());
        this.createButton.removeStyleName("gwt-Button");
        this.createButton.addStyleName("ebBtn");
        this.createButton.addStyleName("ebBtn_color_green");
        this.createButton.addStyleName("create_button_icon");
        this.createButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CISCreatePanel createPanel = new CISCreatePanel(CISInfoTab.this);
                CISInfoTab.this.clearMessages();
                CISInfoTab.this.setWidget((Widget)createPanel);
            }
        });
        this.deleteButton = new ButtonWidget(this.constants.buttonLabelDelete());
        this.deleteButton.removeStyleName("gwt-Button");
        this.deleteButton.addStyleName("ebBtn");
        this.deleteButton.addStyleName("delete_button_icon");
        this.deleteButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!CISInfoTab.this.selectedIds.isEmpty()) {
                    CISInfoTab.this.confirm(CISInfoTab.this.constants.confirmDeleteSite(), new Command(){

                        public void execute() {
                            CISInfoTab.this.busyIndicator.center();
                            CISInfoTab.this.service.deleteNotificationItems(CISInfoTab.this.selectedIds, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                                public void onNeptuneFailure(Throwable caught) {
                                    CISInfoTab.this.showError("Unable to delete CIS notifications for this site. | Reason: " + caught != null ? caught.getLocalizedMessage() : null);
                                    CISInfoTab.this.busyIndicator.hide();
                                }

                                public void onNeptuneSuccess(Void result) {
                                    CISInfoTab.this.refresh();
                                    CISInfoTab.this.busyIndicator.hide();
                                }
                            });
                        }
                    }, null);
                } else {
                    CISInfoTab.this.showError("Please select at least 1 item");
                }
            }
        });
        this.buttonPanel.add((Widget)this.createButton);
        this.buttonPanel.add((Widget)this.deleteButton);
        this.deleteButton.setVisible(false);
    }

    private void initTopPanel() {
        this.numRecordsLabel = new LabelWidget("");
        this.numRecordsLabel.setStyleName("nwt_HeaderSection_count");
        this.numRecordsLabelFront = new LabelWidget(this.neptuneConstants.recordsLabel());
        this.numRecordsLabelFront.setStyleName("nwt_HeaderSection_label");
        this.numRecordsLabelFront.setVisible(false);
        HorizontalContainer recordCountContainer = new HorizontalContainer();
        recordCountContainer.add((Widget)this.numRecordsLabelFront);
        recordCountContainer.add((Widget)this.numRecordsLabel);
        this.topPanel = new HorizontalContainer();
        this.topPanel.add((Widget)recordCountContainer);
        this.topPanel.setStylePrimaryName("nwt-TableListViewPanel-recordCount");
        this.topPanel.setWidth("100%");
    }

    private void reset() {
        this.selectedIds = new ArrayList<UICISNotification>();
        this.table.removeAllRows();
        this.deleteButton.setVisible(false);
        this.clearMessages();
    }

    public void setNotificationListTable(List<UICISNotification> notificationList) {
        if (!notificationList.isEmpty()) {
            this.rowCheckBoxes = new ArrayList<CheckBoxWidget>(notificationList.size());
            this.tableContainer.setWidget((Widget)this.table);
            this.table.setStyleName(TABLE_STYLE);
            this.table.getRowFormatter().addStyleName(0, HEADER_ROW_STYLE);
            this.allCB = new CheckBoxWidget();
            this.allCB.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    if (CISInfoTab.this.rowCheckBoxes != null) {
                        for (CheckBoxWidget cb : CISInfoTab.this.rowCheckBoxes) {
                            cb.setValue((Boolean)event.getValue(), true);
                        }
                    }
                }
            });
            this.table.setWidget(0, 0, (Widget)this.allCB);
            this.table.setWidget(0, 1, (Widget)new LabelWidget(this.constants.identity()));
            this.table.setWidget(0, 2, (Widget)new LabelWidget(this.constants.cmsIdentity()));
            this.table.setWidget(0, 3, (Widget)new LabelWidget(this.constants.cmsSystem()));
            this.table.setWidget(0, 4, (Widget)new LabelWidget(this.constants.messageUID()));
            this.table.setWidget(0, 5, (Widget)new LabelWidget(this.constants.callOutURL()));
            this.table.setWidget(0, 6, (Widget)new LabelWidget(this.constants.query()));
            for (UICISNotification notification : notificationList) {
                this.addRow(notification);
            }
            this.deleteButton.setVisible(true);
        } else {
            this.showInfo("There is no CIS Notification Data.");
        }
    }

    private void addRow(final UICISNotification notification) {
        int rowIndex = this.table.getRowCount();
        String styleName = rowIndex % 2 == 0 ? "table-data-even-row" : "table-data-odd-row";
        this.table.getRowFormatter().setStyleName(rowIndex, styleName);
        this.table.getRowFormatter().addStyleName(rowIndex, DATA_ROW_STYLE);
        CheckBoxWidget cb = new CheckBoxWidget();
        cb.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                if (((Boolean)event.getValue()).booleanValue()) {
                    CISInfoTab.this.selectedIds.add(notification);
                } else {
                    CISInfoTab.this.allCB.setValue(Boolean.valueOf(false), false);
                    CISInfoTab.this.selectedIds.remove(notification);
                }
            }
        });
        this.table.setWidget(rowIndex, 0, (Widget)cb);
        this.rowCheckBoxes.add(cb);
        LabelWidget identityWidget = new LabelWidget(notification.getIdentify());
        this.table.setWidget(rowIndex, 1, (Widget)identityWidget);
        LabelWidget cmsIdentityWidget = new LabelWidget(notification.getCmsIdentity());
        this.table.setWidget(rowIndex, 2, (Widget)cmsIdentityWidget);
        LabelWidget cmsSystemWidget = new LabelWidget(notification.getCmsSystemId());
        this.table.setWidget(rowIndex, 3, (Widget)cmsSystemWidget);
        LabelWidget messageUIDWidget = new LabelWidget(notification.getMessageId());
        this.table.setWidget(rowIndex, 4, (Widget)messageUIDWidget);
        StringBuilder urls = new StringBuilder();
        for (String url : notification.getUrls()) {
            urls.append(url);
            urls.append("\n");
        }
        this.table.setWidget(rowIndex, 5, this.getShorterTextWidget(urls.toString()));
        this.table.setWidget(rowIndex, 6, this.getShorterTextWidget(notification.getQuery()));
    }

    public Widget getShorterTextWidget(String text) {
        int firstLineIndex = text.indexOf("\n");
        int maxChar = 50;
        if (firstLineIndex != -1 && firstLineIndex < maxChar) {
            maxChar = firstLineIndex;
        }
        String subText = null;
        if (text.length() > maxChar + 1) {
            subText = String.valueOf(text.substring(0, maxChar)) + "...";
            VerticalContainer vc = new VerticalContainer();
            final DisclosureContainer pnlDisclosure = new DisclosureContainer();
            final LabelWidget btnSeeMore = new LabelWidget();
            btnSeeMore.setText("see more");
            btnSeeMore.addStyleName("hyperlink");
            final HTML subTextWidget = new HTML(new SafeHtmlBuilder().appendEscapedLines(subText).toSafeHtml());
            HorizontalContainer hc = new HorizontalContainer();
            hc.add((Widget)subTextWidget);
            hc.add((Widget)btnSeeMore);
            vc.add((Widget)hc);
            vc.add((Widget)pnlDisclosure);
            final LabelWidget btnSeeLess = new LabelWidget();
            btnSeeLess.setText("see less");
            btnSeeLess.setVisible(false);
            btnSeeLess.addStyleName("hyperlink");
            VerticalContainer seeLessVC = new VerticalContainer();
            seeLessVC.add((Widget)new LabelWidget(text));
            seeLessVC.add((Widget)btnSeeLess);
            pnlDisclosure.setWidth("100%");
            pnlDisclosure.setContent((Widget)seeLessVC);
            btnSeeMore.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    pnlDisclosure.setOpen(true);
                }
            });
            btnSeeLess.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    pnlDisclosure.setOpen(false);
                }
            });
            pnlDisclosure.addOpenHandler((OpenHandler)new OpenHandler<DisclosureContainer>(){

                public void onOpen(OpenEvent<DisclosureContainer> event) {
                    subTextWidget.setVisible(false);
                    btnSeeMore.setVisible(false);
                    btnSeeLess.setVisible(true);
                }
            });
            pnlDisclosure.addCloseHandler((CloseHandler)new CloseHandler<DisclosureContainer>(){

                public void onClose(CloseEvent<DisclosureContainer> event) {
                    subTextWidget.setVisible(true);
                    btnSeeMore.setVisible(true);
                    btnSeeLess.setVisible(false);
                }
            });
            ScrollContainer scrollPanel = new ScrollContainer((Widget)vc);
            scrollPanel.addStyleName("scrollpanel");
            return scrollPanel;
        }
        return new HTML(new SafeHtmlBuilder().appendEscapedLines(text).toSafeHtml());
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDisplayName() {
        return this.constants.cisTabName();
    }

    @Override
    public boolean setSite(UISite site, Map<String, String> params) {
        this.site = site;
        return site != null && (site.getType() == UISiteType.DISTRIBUTION || site.getType() == UISiteType.MEDIAPATH_DISTRIBUTION);
    }

    @Override
    public void setCRUDNotifier(SitesTabContainer.SiteCRUDNotifier crudNotifier) {
    }

    @Override
    public void setSelected(boolean selected) {
        if (!selected || this.site == null) {
            return;
        }
        History.newItem((String)Anchors.getAnchor(this.site.getId(), this.site.getParentId(), this.getName()), (boolean)false);
        if (this.site.getId() != null) {
            this.refresh();
        }
    }

    protected void loadData(int siteId) {
        this.busyIndicator.center();
        this.service.getSiteCIS(siteId, (AsyncCallback<List<UICISNotification>>)new NeptuneAsyncCallback<List<UICISNotification>>(){

            public void onNeptuneFailure(Throwable caught) {
                CISInfoTab.this.showError("Unable to get CIS information for this site. | Reason: " + caught != null ? caught.getLocalizedMessage() : null);
                CISInfoTab.this.busyIndicator.hide();
            }

            public void onNeptuneSuccess(List<UICISNotification> result) {
                CISInfoTab.this.setTotalRecordCount(result != null ? result.size() : 0);
                CISInfoTab.this.setNotificationListTable(result);
                CISInfoTab.this.busyIndicator.hide();
            }
        });
    }

    protected void updateMainPanelSize() {
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                int offsetWidth = 300;
                int offsetHeight = 300;
                if (offsetWidth > 0) {
                    int width = Window.getClientWidth() - offsetWidth;
                    CISInfoTab.this.scrollPanel.setWidth(String.valueOf(width) + "px");
                }
                if (offsetHeight > 0) {
                    int height = Window.getClientHeight() - offsetHeight - CISInfoTab.this.messageArea.getOffsetHeight() - CISInfoTab.this.topPanel.getOffsetHeight();
                    CISInfoTab.this.scrollPanel.setHeight(String.valueOf(height) + "px");
                }
            }
        });
    }

    private void confirm(String questionText, Command yesCommand, Command noCommand) {
        ConfirmDialog confirmDialog = new ConfirmDialog(questionText, yesCommand, noCommand);
        confirmDialog.center();
        confirmDialog.show();
    }

    private void updateSizeForMessageArea() {
        this.scrollPanel.setHeight(String.valueOf(this.scrollPanel.getOffsetHeight() - this.messageArea.getOffsetHeight()) + "px");
    }

    public void setTotalRecordCount(Integer recordCount) {
        if (recordCount == null || recordCount <= 0) {
            this.resetTotalRecordCount();
        } else {
            this.totalRecordCount = recordCount;
            this.updateRecordCountLabel();
        }
    }

    private void resetTotalRecordCount() {
        this.totalRecordCount = null;
        this.updateRecordCountLabel();
    }

    private void updateRecordCountLabel() {
        if (this.totalRecordCount == null) {
            this.numRecordsLabel.setText("");
            this.numRecordsLabelFront.setVisible(false);
        } else {
            this.numRecordsLabelFront.setVisible(true);
            this.numRecordsLabel.setText("(" + this.totalRecordCount + ")");
        }
    }

    protected UISite getUISite() {
        return this.site;
    }

    protected void onLoad() {
        super.onLoad();
        this.windowRegistration = Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                CISInfoTab.this.updateMainPanelSize();
            }
        });
    }

    protected void onUnload() {
        this.windowRegistration.removeHandler();
        this.windowRegistration = null;
        if (this.busyIndicator != null) {
            this.busyIndicator.hide();
        }
        super.onUnload();
    }

    public void refresh() {
        this.reset();
        this.loadData(this.site.getId());
        this.setWidget((Widget)this.mainPanel);
        this.updateMainPanelSize();
    }
}

