/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import java.util.ArrayList;
import java.util.List;

public class CheckboxGroup<T>
extends Composite {
    private ScrollPanel scrollPanel = new ScrollPanel();
    private VerticalPanel verticalPanel;
    private List<Item<T>> items;

    public CheckboxGroup() {
        this.scrollPanel.addStyleName("sites-basicTab-fileLookupKeys");
        this.verticalPanel = new VerticalPanel();
        this.scrollPanel.add((Widget)this.verticalPanel);
        this.items = new ArrayList<Item<T>>();
        this.initWidget((Widget)this.scrollPanel);
    }

    public void clear() {
        this.verticalPanel.clear();
        this.items.clear();
    }

    public void addItem(Item<T> item) {
        this.verticalPanel.add((Widget)new CheckBoxWidget(item.getLabel()));
        this.items.add(item);
    }

    public void addItem(String label, T value) {
        this.addItem(new Item<T>(label, value));
    }

    public void setItems(List<Item<T>> items) {
        this.clear();
        for (Item<T> item : items) {
            this.addItem(item);
        }
    }

    public List<Item<T>> getItems() {
        return this.items;
    }

    public List<Item<T>> getSelectedItems() {
        ArrayList<Item<T>> selectedItems = new ArrayList<Item<T>>();
        int i = 0;
        while (i < this.verticalPanel.getWidgetCount()) {
            CheckBoxWidget cb = (CheckBoxWidget)this.verticalPanel.getWidget(i);
            if (cb.getValue().booleanValue()) {
                selectedItems.add(this.items.get(i));
            }
            ++i;
        }
        return selectedItems;
    }

    public void setItemSelected(Item<T> item, boolean selected) {
        int i = 0;
        while (i < this.items.size()) {
            if (this.items.get(i).equals(item)) {
                CheckBoxWidget cb = (CheckBoxWidget)this.verticalPanel.getWidget(i);
                cb.setValue(Boolean.valueOf(selected));
                break;
            }
            ++i;
        }
    }

    public void setEnabledItem(Item<T> item, boolean enabled) {
        int i = 0;
        while (i < this.items.size()) {
            if (this.items.get(i).equals(item)) {
                CheckBoxWidget cb = (CheckBoxWidget)this.verticalPanel.getWidget(i);
                cb.setEnabled(enabled);
                break;
            }
            ++i;
        }
    }

    public static class Item<T> {
        private String label;
        private T value;

        public Item(String label, T value) {
            this.label = label;
            this.value = value;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Item)) {
                return false;
            }
            return this.value.equals(((Item)other).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

