/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client;

import com.ericsson.cms.sites.ui.client.SitesTabContainer;
import com.ericsson.cms.sites.ui.client.entities.UISiteTreeNode;
import com.ericsson.cms.sites.ui.client.entities.UISiteType;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;

public class CreateSiteDialogBox
extends DialogBox {
    RadioButton strbl;
    RadioButton strbd;
    RadioButton strbm;
    RadioButton strbt;
    private SitesTabContainer detailView;
    private NeptuneSecurity security;
    private SitesConstants constants = (SitesConstants)GWT.create(SitesConstants.class);

    public CreateSiteDialogBox(NeptuneSecurity security, SitesTabContainer detailView) {
        this(security, true, true, detailView, null);
    }

    public CreateSiteDialogBox(NeptuneSecurity security, boolean autoHide, SitesTabContainer detailView) {
        this(security, autoHide, true, detailView, null);
    }

    public CreateSiteDialogBox(NeptuneSecurity security, boolean autoHide, boolean modal, SitesTabContainer detailView) {
        this(security, autoHide, modal, detailView, null);
    }

    public CreateSiteDialogBox(NeptuneSecurity security, boolean autoHide, boolean modal, SitesTabContainer detailView, UISiteTreeNode uiSiteTreeNode) {
        super(autoHide, modal);
        this.init(security, detailView, uiSiteTreeNode);
        String caption = null;
        if (uiSiteTreeNode != null) {
            String siteName = uiSiteTreeNode.getName();
            caption = String.valueOf(this.constants.captionCreateChildSite()) + " " + siteName;
            this.setText(caption);
            this.strbl.setEnabled(false);
            UISiteType siteType = uiSiteTreeNode.getType();
            if (siteType != null && UISiteType.LOGICAL.equals((Object)siteType)) {
                this.strbd.setEnabled(true);
                this.strbm.setEnabled(true);
                this.strbt.setEnabled(false);
                this.strbd.setValue(Boolean.valueOf(true));
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        CreateSiteDialogBox.this.strbd.setFocus(true);
                    }
                });
            }
        } else {
            this.strbt.setEnabled(false);
            this.strbl.setValue(Boolean.valueOf(true));
            Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                public void execute() {
                    CreateSiteDialogBox.this.strbl.setFocus(true);
                }
            });
        }
    }

    private void init(NeptuneSecurity security, SitesTabContainer detailView, UISiteTreeNode uiSiteTreeNode) {
        Integer parentSiteId = null;
        if (uiSiteTreeNode != null) {
            parentSiteId = uiSiteTreeNode.getId();
        }
        this.init(security, detailView, parentSiteId);
    }

    private void init(NeptuneSecurity security, final SitesTabContainer detailView, final Integer parentSiteId) {
        this.security = security;
        this.detailView = detailView;
        this.setText(this.constants.captionCreateTopLevelSite());
        this.setGlassEnabled(true);
        VerticalPanel mainPanel = new VerticalPanel();
        HorizontalPanel createInputsPanel = new HorizontalPanel();
        mainPanel.add((Widget)createInputsPanel);
        HorizontalPanel buttonsPanel = new HorizontalPanel();
        buttonsPanel.addStyleName("cms_button_container");
        mainPanel.add((Widget)buttonsPanel);
        VerticalPanel siteTypePanel = new VerticalPanel();
        createInputsPanel.add((Widget)siteTypePanel);
        siteTypePanel.add((Widget)new Label(this.constants.fieldLabelSiteType()));
        VerticalPanel siteTypeRadioButtonsPanel = new VerticalPanel();
        this.strbl = new RadioButton("siteType", this.constants.fieldValueSiteTypeLogical());
        this.strbd = new RadioButton("siteType", this.constants.fieldValueSiteTypeDistribution());
        this.strbm = new RadioButton("siteType", this.constants.fieldValueSiteTypeMediaPathDistribution());
        this.strbt = new RadioButton("siteType", this.constants.fieldValueSiteTypeTracking());
        siteTypeRadioButtonsPanel.add((Widget)this.strbl);
        siteTypeRadioButtonsPanel.add((Widget)this.strbd);
        siteTypeRadioButtonsPanel.add((Widget)this.strbm);
        siteTypeRadioButtonsPanel.add((Widget)this.strbt);
        siteTypePanel.add((Widget)siteTypeRadioButtonsPanel);
        this.strbt.setEnabled(false);
        Button okButton = new Button(this.constants.buttonLabelOk());
        buttonsPanel.add((Widget)okButton);
        okButton.removeStyleName("gwt-Button");
        okButton.addStyleName("ebBtn");
        okButton.addStyleName("ebBtn_color_darkBlue");
        okButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CreateSiteDialogBox.this.hide();
                if (CreateSiteDialogBox.this.strbl.getValue().booleanValue()) {
                    detailView.showCreateLogicalSite();
                } else if (CreateSiteDialogBox.this.strbd.getValue().booleanValue()) {
                    detailView.showCreateDistributionSite(parentSiteId);
                } else if (CreateSiteDialogBox.this.strbm.getValue().booleanValue()) {
                    detailView.showCreateMediaPathDistributionSite(parentSiteId);
                } else if (CreateSiteDialogBox.this.strbt.getValue().booleanValue()) {
                    detailView.showCreateTrackingSite(parentSiteId);
                }
            }
        });
        Button cancelButton = new Button(this.constants.buttonLabelCancel());
        buttonsPanel.add((Widget)cancelButton);
        cancelButton.removeStyleName("gwt-Button");
        cancelButton.addStyleName("ebBtn");
        cancelButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CreateSiteDialogBox.this.hide();
            }
        });
        this.setWidget((Widget)mainPanel);
    }
}

